/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.panes;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.controls.PredicateTextField;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.panes.PathClassPane;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.tools.PathObjectLabels;
import qupath.lib.images.ImageData;
import qupath.lib.objects.DefaultPathObjectComparator;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.interfaces.ROI;

public class AnnotationPane
implements PathObjectSelectionListener,
ChangeListener<ImageData<BufferedImage>>,
PathObjectHierarchyListener {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationPane.class);
    private final QuPathGUI qupath;
    private final ObservableValue<ImageData<BufferedImage>> imageDataProperty;
    private ImageData<BufferedImage> imageData;
    private PathObjectHierarchy hierarchy;
    private final BooleanProperty disableUpdates = new SimpleBooleanProperty(false);
    private final BooleanProperty hasImageData = new SimpleBooleanProperty(false);
    private final BorderPane pane = new BorderPane();
    private static boolean synchronizePrimarySelectionOnly = true;
    private final PathClassPane pathClassPane;
    private final PredicateTextField<PathObject> filter = new PredicateTextField(PathObject::getDisplayedName);
    private final ObservableList<PathObject> allAnnotations = FXCollections.observableArrayList();
    private final FilteredList<PathObject> filteredAnnotations = new FilteredList(this.allAnnotations);
    private final ContextMenu menuAnnotations = new ContextMenu();
    private final ListView<PathObject> listAnnotations = new ListView(this.filteredAnnotations);
    private boolean suppressSelectionChanges = false;
    static Comparator<PathObject> annotationListComparator = Comparator.nullsFirst(Comparator.comparing(AnnotationPane::getImagePlane).thenComparing(AnnotationPane::getClassificationString).thenComparingDouble(AnnotationPane::getBoundsY).thenComparingDouble(AnnotationPane::getBoundsX).thenComparing(PathObject::getID));

    public AnnotationPane(QuPathGUI qupath) {
        this(qupath, (ObservableValue<ImageData<BufferedImage>>)qupath.imageDataProperty());
    }

    public AnnotationPane(QuPathGUI qupath, ObservableValue<ImageData<BufferedImage>> imageDataProperty) {
        this.qupath = qupath;
        this.imageDataProperty = imageDataProperty;
        this.disableUpdates.addListener((v, o, n) -> {
            if (!n.booleanValue()) {
                this.enableUpdates();
            }
        });
        this.pathClassPane = new PathClassPane(qupath);
        this.setImageData((ImageData<BufferedImage>)((ImageData)imageDataProperty.getValue()));
        this.initializeFilter();
        this.initializeAnnotationList();
        GuiTools.populateAnnotationsMenu(qupath, this.menuAnnotations);
        TitledPane paneAnnotations = this.createAnnotationTitledPane();
        SplitPane paneColumns = new SplitPane(new Node[]{paneAnnotations, this.pathClassPane.getPane()});
        paneColumns.setDividerPositions(new double[]{0.5});
        this.pane.setCenter((Node)paneColumns);
        imageDataProperty.addListener((ChangeListener)this);
    }

    public BooleanProperty disableUpdatesProperty() {
        return this.disableUpdates;
    }

    private void enableUpdates() {
        if (this.hierarchy == null) {
            return;
        }
        this.hierarchyChanged(PathObjectHierarchyEvent.createStructureChangeEvent((Object)this, (PathObjectHierarchy)this.hierarchy, (PathObject)this.hierarchy.getRootObject()));
        this.selectedPathObjectChanged(this.hierarchy.getSelectionModel().getSelectedObject(), null, this.hierarchy.getSelectionModel().getSelectedObjects());
    }

    private void initializeFilter() {
        this.filter.setPromptText("Filter annotations");
        this.filter.setIgnoreCase(true);
        this.filteredAnnotations.predicateProperty().bind((ObservableValue)this.filter.predicateProperty());
    }

    private void initializeAnnotationList() {
        this.hierarchyChanged(null);
        this.listAnnotations.setCellFactory(v -> PathObjectLabels.createListCell());
        this.listAnnotations.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.listAnnotations.getSelectionModel().getSelectedItems().addListener(c -> this.synchronizeHierarchySelectionToListSelection());
        this.listAnnotations.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.synchronizeHierarchySelectionToListSelection());
        this.listAnnotations.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1) {
                PathObject pathObject = (PathObject)this.listAnnotations.getSelectionModel().getSelectedItem();
                if (pathObject == null || !pathObject.hasROI()) {
                    return;
                }
                this.qupath.getViewer().centerROI(pathObject.getROI());
            }
        });
        PathPrefs.colorDefaultObjectsProperty().addListener((v, o, n) -> this.listAnnotations.refresh());
        this.listAnnotations.setContextMenu(this.menuAnnotations);
    }

    private TitledPane createAnnotationTitledPane() {
        BorderPane panelObjects = new BorderPane();
        panelObjects.setCenter(this.listAnnotations);
        Button btnSelectAll = new Button("Select all");
        btnSelectAll.setOnAction(e -> this.listAnnotations.getSelectionModel().selectAll());
        btnSelectAll.setTooltip(new Tooltip("Select all annotations"));
        Button btnDelete = new Button("Delete");
        btnDelete.setOnAction(e -> GuiTools.promptToClearAllSelectedObjects(this.imageData));
        btnDelete.setTooltip(new Tooltip("Delete all selected objects"));
        Button btnMore = GuiTools.createMoreButton(this.menuAnnotations, Side.RIGHT);
        GridPane panelButtons = new GridPane();
        panelButtons.add((Node)btnSelectAll, 0, 0);
        panelButtons.add((Node)btnDelete, 1, 0);
        panelButtons.add((Node)btnMore, 2, 0);
        GridPane.setHgrow((Node)btnSelectAll, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)btnDelete, (Priority)Priority.ALWAYS);
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{btnSelectAll, btnDelete});
        BooleanBinding disableButtons = this.hasImageData.not();
        btnSelectAll.disableProperty().bind((ObservableValue)disableButtons);
        btnDelete.disableProperty().bind((ObservableValue)disableButtons);
        btnMore.disableProperty().bind((ObservableValue)disableButtons);
        this.listAnnotations.addEventFilter(KeyEvent.KEY_RELEASED, e -> {
            if (e.isConsumed()) {
                return;
            }
            if (e.getCode() == KeyCode.BACK_SPACE || e.getCode() == KeyCode.DELETE) {
                btnDelete.fire();
                e.consume();
            }
        });
        panelObjects.setBottom((Node)new VBox(new Node[]{this.filter, panelButtons}));
        Button btnProperties = new Button(null, IconFactory.createNode(FontAwesome.Glyph.PENCIL, 12));
        btnProperties.setTooltip(new Tooltip("Set selected annotation properties"));
        btnProperties.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.listAnnotations.getSelectionModel().getSelectedItems()));
        btnProperties.setOnAction(e -> {
            PathObjectHierarchy hierarchy = this.qupath.getViewer().getHierarchy();
            if (hierarchy != null) {
                GuiTools.promptToSetActiveAnnotationProperties(hierarchy);
                PathObjectSelectionModel model = hierarchy.getSelectionModel();
                this.selectedPathObjectChanged(model.getSelectedObject(), model.getSelectedObject(), model.getSelectedObjects());
            }
        });
        TitledPane titled = GuiTools.createLeftRightTitledPane("Annotation list", new Node[]{btnProperties});
        titled.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            int nAll = this.allAnnotations.size();
            int nFiltered = this.filteredAnnotations.size();
            if (nAll == 0) {
                return "Annotation list";
            }
            if (nAll == nFiltered) {
                return "Annotation list (" + nAll + ")";
            }
            return "Annotation list (" + nFiltered + "/" + nAll + ")";
        }, (Observable[])new Observable[]{this.allAnnotations, this.filteredAnnotations}));
        titled.setContent((Node)panelObjects);
        panelObjects.setPadding(Insets.EMPTY);
        titled.setCollapsible(false);
        titled.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return titled;
    }

    void synchronizeHierarchySelectionToListSelection() {
        PathObject selectedObject;
        if (this.hierarchy == null || this.suppressSelectionChanges) {
            return;
        }
        this.suppressSelectionChanges = true;
        HashSet selectedSet = new HashSet(this.listAnnotations.getSelectionModel().getSelectedItems());
        if (!selectedSet.contains(selectedObject = (PathObject)this.listAnnotations.getSelectionModel().getSelectedItem())) {
            selectedObject = null;
        }
        this.hierarchy.getSelectionModel().setSelectedObjects(selectedSet, selectedObject);
        this.suppressSelectionChanges = false;
    }

    public Pane getPane() {
        return this.pane;
    }

    void setImageData(ImageData<BufferedImage> imageData) {
        if (this.imageData == imageData) {
            return;
        }
        if (this.hierarchy != null) {
            this.hierarchy.removeListener((PathObjectHierarchyListener)this);
            this.hierarchy.getSelectionModel().removePathObjectSelectionListener((PathObjectSelectionListener)this);
        }
        this.imageData = imageData;
        if (this.imageData != null) {
            this.hierarchy = imageData.getHierarchy();
            this.hierarchy.getSelectionModel().addPathObjectSelectionListener((PathObjectSelectionListener)this);
            this.hierarchy.addListener((PathObjectHierarchyListener)this);
            PathObject selected = this.hierarchy.getSelectionModel().getSelectedObject();
            this.allAnnotations.setAll(this.hierarchy.getAnnotationObjects());
            this.hierarchy.getSelectionModel().setSelectedObject(selected);
        } else {
            this.allAnnotations.clear();
            this.hierarchy = null;
        }
        this.hasImageData.set(this.imageData != null);
        this.pathClassPane.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectedPathObjectChanged(PathObject pathObjectSelected, PathObject previousObject, Collection<PathObject> allSelected) {
        if (!Platform.isFxApplicationThread()) {
            return;
        }
        if (this.suppressSelectionChanges || this.disableUpdates.get()) {
            return;
        }
        this.suppressSelectionChanges = true;
        if (synchronizePrimarySelectionOnly) {
            try {
                MultipleSelectionModel listSelectionModel = this.listAnnotations.getSelectionModel();
                listSelectionModel.clearSelection();
                if (pathObjectSelected != null && pathObjectSelected.isAnnotation()) {
                    listSelectionModel.select((Object)pathObjectSelected);
                    this.listAnnotations.scrollTo((Object)pathObjectSelected);
                }
                return;
            }
            finally {
                this.suppressSelectionChanges = false;
            }
        }
        try {
            TreeSet<PathObject> hierarchySelected = new TreeSet<PathObject>(DefaultPathObjectComparator.getInstance());
            hierarchySelected.addAll(allSelected);
            MultipleSelectionModel model = this.listAnnotations.getSelectionModel();
            ArrayList<PathObject> selected = new ArrayList<PathObject>();
            for (PathObject pathObject : hierarchySelected) {
                if (pathObject == null) {
                    logger.warn("Selected object is null!");
                    continue;
                }
                if (!pathObject.isAnnotation()) continue;
                selected.add(pathObject);
            }
            if (selected.isEmpty()) {
                if (!model.isEmpty()) {
                    model.clearSelection();
                }
                return;
            }
            ObservableList currentlySelected = model.getSelectedItems();
            if (selected.size() == currentlySelected.size() && hierarchySelected.containsAll((Collection<?>)currentlySelected)) {
                this.listAnnotations.refresh();
                return;
            }
            if (hierarchySelected.containsAll((Collection<?>)this.listAnnotations.getItems())) {
                model.selectAll();
                return;
            }
            int[] inds = new int[selected.size()];
            int i = 0;
            model.clearSelection();
            boolean firstInd = true;
            for (PathObject temp : selected) {
                int idx = this.listAnnotations.getItems().indexOf((Object)temp);
                if (idx >= 0 && firstInd) {
                    Arrays.fill(inds, idx);
                    firstInd = false;
                }
                inds[i] = idx;
                ++i;
            }
            if (inds.length == 1 && pathObjectSelected instanceof PathAnnotationObject) {
                this.listAnnotations.scrollTo((Object)pathObjectSelected);
            }
            if (firstInd) {
                this.suppressSelectionChanges = false;
                return;
            }
            if (inds.length == 1) {
                model.select(inds[0]);
            } else if (inds.length > 1) {
                model.selectIndices(inds[0], inds);
            }
        }
        finally {
            this.suppressSelectionChanges = false;
        }
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        this.setImageData(imageDataNew);
    }

    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.hierarchyChanged(event));
            return;
        }
        if (this.hierarchy == null) {
            this.allAnnotations.clear();
            return;
        }
        if (this.disableUpdates.get()) {
            return;
        }
        this.pathClassPane.getListView().refresh();
        Collection annotationSet = this.hierarchy.getObjects(new HashSet(), PathAnnotationObject.class);
        if (event.isChanging() && annotationSet.size() == this.listAnnotations.getItems().size() && annotationSet.containsAll((Collection<?>)this.listAnnotations.getItems())) {
            return;
        }
        ArrayList<PathObject> newList = new ArrayList<PathObject>(annotationSet);
        newList.sort(annotationListComparator);
        if (newList.equals(this.allAnnotations)) {
            if (!event.isChanging()) {
                this.listAnnotations.refresh();
            }
            return;
        }
        boolean lastChanging = this.suppressSelectionChanges;
        this.suppressSelectionChanges = true;
        this.allAnnotations.setAll(newList);
        this.suppressSelectionChanges = lastChanging;
    }

    private static double getBoundsX(PathObject pathObject) {
        ROI roi = pathObject == null ? null : pathObject.getROI();
        return roi == null ? -1.0 : roi.getBoundsX();
    }

    private static double getBoundsY(PathObject pathObject) {
        ROI roi = pathObject == null ? null : pathObject.getROI();
        return roi == null ? -1.0 : roi.getBoundsY();
    }

    private static ImagePlane getImagePlane(PathObject pathObject) {
        ROI roi = pathObject == null ? null : pathObject.getROI();
        return roi == null ? ImagePlane.getDefaultPlane() : roi.getImagePlane();
    }

    private static String getClassificationString(PathObject pathObject) {
        String c = pathObject == null ? null : pathObject.getClassification();
        return c == null ? "" : c;
    }
}

