/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure.ui;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashSet;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;

class ViewerTableSynchronizer
implements QuPathViewerListener {
    private static final Logger logger = LoggerFactory.getLogger(ViewerTableSynchronizer.class);
    private final TableView<PathObject> table;
    private final PathObjectHierarchy hierarchy;
    private QuPathViewer viewer;
    private boolean synchronizingTableToModel = false;
    private boolean synchronizingModelToTable = false;
    private final ListChangeListener<PathObject> selectionChangeListener = this::handleSelectionChanged;

    ViewerTableSynchronizer(QuPathViewer viewer, PathObjectHierarchy hierarchy, TableView<PathObject> table) {
        this.viewer = viewer;
        this.table = table;
        this.hierarchy = hierarchy;
    }

    void attachListeners() {
        if (this.viewer != null) {
            this.viewer.addViewerListener(this);
        }
        this.table.getSelectionModel().getSelectedItems().addListener(this.selectionChangeListener);
    }

    void removeListeners() {
        if (this.viewer != null) {
            this.viewer.removeViewerListener(this);
        }
        this.table.getSelectionModel().getSelectedItems().removeListener(this.selectionChangeListener);
    }

    private void handleSelectionChanged(ListChangeListener.Change<? extends PathObject> c) {
        this.synchronizeSelectionModelToTable(this.hierarchy, c, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeSelectionModelToTable(PathObjectHierarchy hierarchy, ListChangeListener.Change<? extends PathObject> change, TableView<PathObject> table) {
        if (this.synchronizingTableToModel || hierarchy == null) {
            return;
        }
        PathObjectSelectionModel model = hierarchy.getSelectionModel();
        if (model == null) {
            return;
        }
        boolean wasSynchronizingToTree = this.synchronizingModelToTable;
        try {
            TableView.TableViewSelectionModel treeModel;
            ObservableList selectedItems;
            this.synchronizingModelToTable = true;
            boolean removed = false;
            if (change != null) {
                while (change.next()) {
                    removed |= change.wasRemoved();
                }
            }
            if ((selectedItems = (treeModel = table.getSelectionModel()).getSelectedItems()).isEmpty() && removed) {
                model.clearSelection();
                return;
            }
            if (selectedItems.size() == 1) {
                model.setSelectedObject((PathObject)selectedItems.get(0), false);
                return;
            }
            HashSet toSelect = new HashSet(treeModel.getSelectedItems());
            PathObject primary = (PathObject)treeModel.getSelectedItem();
            model.setSelectedObjects(toSelect, primary);
        }
        finally {
            this.synchronizingModelToTable = wasSynchronizingToTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeTableToSelectionModel(PathObjectHierarchy hierarchy, TableView<PathObject> table) {
        if (this.synchronizingModelToTable || hierarchy == null) {
            return;
        }
        boolean ownsChanges = !this.synchronizingTableToModel;
        try {
            this.synchronizingTableToModel = true;
            PathObjectSelectionModel model = hierarchy.getSelectionModel();
            TableView.TableViewSelectionModel tableModel = table.getSelectionModel();
            if (model == null || model.noSelection()) {
                tableModel.clearSelection();
                return;
            }
            if (model.singleSelection() || tableModel.getSelectionMode() == SelectionMode.SINGLE) {
                int ind = table.getItems().indexOf((Object)model.getSelectedObject());
                if (ind >= 0) {
                    if (tableModel.getSelectedItem() != model.getSelectedObject()) {
                        tableModel.clearAndSelect(ind);
                        table.scrollTo(ind);
                    }
                } else {
                    tableModel.clearSelection();
                }
                return;
            }
            int n = table.getItems().size();
            PathObject mainSelectedObject = model.getSelectedObject();
            int mainObjectInd = -1;
            int[] indsToSelect = new int[table.getItems().size()];
            int count = 0;
            for (int i = 0; i < n; ++i) {
                PathObject temp = (PathObject)table.getItems().get(i);
                if (temp == mainSelectedObject) {
                    mainObjectInd = i;
                }
                if (!model.isSelected(temp)) continue;
                indsToSelect[count] = i;
                ++count;
            }
            tableModel.clearSelection();
            if (count > 0) {
                int maxCount = 1000;
                if (count > maxCount) {
                    logger.warn("Only the first {} items will be selected in the table (out of {} total) - otherwise QuPath can grind to a halt, sorry", (Object)maxCount, (Object)count);
                    count = maxCount;
                }
                tableModel.selectIndices(indsToSelect[0], Arrays.copyOfRange(indsToSelect, 1, count));
            }
            if (mainObjectInd >= 0 && model.singleSelection()) {
                tableModel.select(mainObjectInd);
                table.scrollTo(mainObjectInd);
            }
        }
        finally {
            if (ownsChanges) {
                this.synchronizingTableToModel = false;
            }
        }
    }

    @Override
    public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        if (this.viewer == viewer && imageDataNew != imageDataOld) {
            viewer.removeViewerListener(this);
        }
    }

    @Override
    public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
    }

    @Override
    public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.selectedObjectChanged(viewer, pathObjectSelected));
            return;
        }
        this.synchronizeTableToSelectionModel(viewer.getHierarchy(), this.table);
    }

    @Override
    public void viewerClosed(QuPathViewer viewer) {
        viewer.removeViewerListener(this);
        this.viewer = null;
    }
}

