/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure.ui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.controlsfx.control.action.Action;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.controls.PredicateTextField;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.charts.HistogramDisplay;
import qupath.lib.gui.charts.ScatterPlotDisplay;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.measure.PathTableData;
import qupath.lib.gui.measure.ui.BasicTableCell;
import qupath.lib.gui.measure.ui.NumericTableCell;
import qupath.lib.gui.measure.ui.ViewerTableSynchronizer;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.tools.MenuTools;
import qupath.lib.gui.tools.PathObjectImageViewers;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.roi.interfaces.ROI;

public class SummaryMeasurementTable {
    private static final Logger logger = LoggerFactory.getLogger(SummaryMeasurementTable.class);
    private static final String PROPERTY_KEY = "summary.measurement.table.";
    private static final BooleanProperty PROP_USE_REGEX = PathPrefs.createPersistentPreference("summary.measurement.table.useRegex", false);
    private static final BooleanProperty PROP_SHOW_TOOLBAR = PathPrefs.createPersistentPreference("summary.measurement.table.showToolbar", true);
    private static final BooleanProperty PROP_SHOW_TOOLBAR_TEXT = PathPrefs.createPersistentPreference("summary.measurement.table.showToolbarText", true);
    private final BooleanProperty PROP_BIND_VISIBILITY = PathPrefs.createPersistentPreference("summary.measurement.table.bindVisibility", false);
    private final KeyCombination centerCode = new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[0]);
    private final ImageData<BufferedImage> imageData;
    private final PathObjectHierarchy hierarchy;
    private final BooleanProperty useRegexColumnFilter = SummaryMeasurementTable.createPartiallyBoundProperty(PROP_USE_REGEX);
    private final BooleanProperty showThumbnailsProperty = SummaryMeasurementTable.createPartiallyBoundProperty(PathPrefs.showMeasurementTableThumbnailsProperty());
    private final BooleanProperty showObjectIdsProperty = SummaryMeasurementTable.createPartiallyBoundProperty(PathPrefs.showMeasurementTableObjectIDsProperty());
    private final BooleanProperty showToolbar = SummaryMeasurementTable.createPartiallyBoundProperty(PROP_SHOW_TOOLBAR);
    private final BooleanProperty showToolbarText = SummaryMeasurementTable.createPartiallyBoundProperty(PROP_SHOW_TOOLBAR_TEXT);
    private final BooleanProperty bindToOverlayOptions = SummaryMeasurementTable.createPartiallyBoundProperty(this.PROP_BIND_VISIBILITY);
    private final ObjectBinding<ContentDisplay> toolbarContentDisplayBinding = this.createToolbarContentDisplayBinding();
    private ObjectBinding<Predicate<PathObject>> overlayVisibilityPredicate;
    private final ObservableMeasurementTableData model = new ObservableMeasurementTableData();
    private final Map<String, Tooltip> tooltips = new ConcurrentHashMap<String, Tooltip>();
    private BorderPane pane;
    private QuPathViewer viewer;
    private ViewerTableSynchronizer synchronizer;
    private final PathObjectHierarchyListener listener = this::handleHierarchyChange;
    private TableView<PathObject> table;
    private final SplitPane splitPane = new SplitPane();
    private final TabPane plotTabs = new TabPane();
    private HistogramDisplay histogramDisplay;
    private ScatterPlotDisplay scatterPlotDisplay;
    private final Predicate<PathObject> primaryFilter;
    private TableColumn<PathObject, PathObject> colThumbnails;
    private final double thumbnailPadding = 10.0;
    private Action actionShowPlots;
    private Action actionCopy;
    private Action actionSave;
    private Action actionThumbnails;
    private Action actionId;
    private Action actionShowToolbar;
    private Action actionToolbarText;
    private Action actionBindVisibility;
    private Action actionSelectAll;
    private Action actionSelectNone;

    public SummaryMeasurementTable(ImageData<BufferedImage> imageData, Predicate<PathObject> primaryFilter) {
        Objects.requireNonNull(imageData);
        Objects.requireNonNull(primaryFilter);
        this.imageData = imageData;
        this.hierarchy = imageData.getHierarchy();
        this.primaryFilter = primaryFilter;
    }

    private static BooleanProperty createPartiallyBoundProperty(BooleanProperty prop) {
        SimpleBooleanProperty prop2 = new SimpleBooleanProperty(prop.getValue().booleanValue());
        prop2.addListener((observable, oldValue, newValue) -> prop.setValue(newValue));
        return prop2;
    }

    private void init() {
        this.updateObjects();
        this.findViewer();
        this.initOverlayVisibilityBinding();
        this.initTable();
        this.synchronizer = new ViewerTableSynchronizer(this.viewer, this.hierarchy, this.table);
        this.initSplitPane();
        this.initTabPane();
        this.model.getItems().addListener(this::handleObjectsChanged);
        this.initActions();
        this.pane = new BorderPane();
        BorderPane centerPane = new BorderPane((Node)this.splitPane);
        ToolBar toolbar = this.createToolbar();
        centerPane.setTop((Node)toolbar);
        centerPane.topProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.showToolbar.get() ? toolbar : null, (Observable[])new Observable[]{this.showToolbar}));
        this.pane.setCenter((Node)centerPane);
        this.pane.setTop((Node)this.createMenuBar());
        this.pane.sceneProperty().flatMap(Scene::windowProperty).flatMap(Window::showingProperty).addListener(this::handleVisibilityChanged);
        this.table.setContextMenu(this.createContextMenu());
    }

    private void initOverlayVisibilityBinding() {
        if (this.viewer == null) {
            return;
        }
        OverlayOptions options = this.viewer.getOverlayOptions();
        this.overlayVisibilityPredicate = Bindings.createObjectBinding(() -> {
            if (this.bindToOverlayOptions.get()) {
                return p -> !options.isHidden((PathObject)p);
            }
            return null;
        }, (Observable[])new Observable[]{options.selectedClassesProperty(), options.useExactSelectedClassesProperty(), options.selectedClassVisibilityModeProperty(), this.bindToOverlayOptions});
        this.overlayVisibilityPredicate.addListener((v, o, n) -> this.model.setPredicate((Predicate<? super PathObject>)n));
        this.model.setPredicate((Predicate)this.overlayVisibilityPredicate.get());
    }

    private void handleObjectsChanged(ListChangeListener.Change<? extends PathObject> c) {
        this.histogramDisplay.refreshHistogram();
        this.scatterPlotDisplay.refreshScatterPlot();
    }

    private void updateObjects() {
        Collection list;
        Predicate<PathObject> predicate = this.primaryFilter;
        if (predicate instanceof PathObjectFilter) {
            PathObjectFilter f = (PathObjectFilter)predicate;
            list = switch (f) {
                case PathObjectFilter.DETECTIONS_ALL -> this.hierarchy.getDetectionObjects();
                case PathObjectFilter.ANNOTATIONS -> this.hierarchy.getAnnotationObjects();
                case PathObjectFilter.CELLS -> this.hierarchy.getCellObjects();
                case PathObjectFilter.TILES -> this.hierarchy.getTileObjects();
                default -> this.getAllObjectsFiltered();
            };
        } else {
            list = this.getAllObjectsFiltered();
        }
        this.model.setImageData(this.imageData, list);
    }

    private Collection<PathObject> getAllObjectsFiltered() {
        if (this.primaryFilter == null) {
            return this.hierarchy.getAllObjects(false);
        }
        return this.hierarchy.getAllObjects(true).stream().filter(this.primaryFilter).toList();
    }

    private void findViewer() {
        QuPathGUI qupath = QuPathGUI.getInstance();
        this.viewer = qupath == null ? null : (QuPathViewer)qupath.getAllViewers().stream().filter(v -> v.getImageData() == this.imageData).findFirst().orElse(null);
    }

    private void initTable() {
        this.table = new TableView();
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.setRowFactory(this::createTableRow);
        this.table.setOnKeyPressed(this::handleTableKeypress);
        if (this.viewer != null) {
            this.colThumbnails = this.createThumbnailColumn();
            this.table.getColumns().add(this.colThumbnails);
        }
        this.table.fixedCellSizeProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (this.colThumbnails.isVisible()) {
                return Math.max(24.0, this.colThumbnails.getWidth() + 10.0);
            }
            return 24.0;
        }, (Observable[])new Observable[]{this.colThumbnails.widthProperty(), this.colThumbnails.visibleProperty()}));
        boolean appendIdColumn = false;
        for (String columnName : this.model.getAllNames()) {
            Object col;
            if (ObservableMeasurementTableData.NAME_OBJECT_ID.equals(columnName)) {
                appendIdColumn = true;
                continue;
            }
            if (this.model.isNumericMeasurement(columnName)) {
                col = this.createNumericTableColumn(columnName);
                this.table.getColumns().add(col);
                continue;
            }
            col = this.createStringTableColumn(columnName);
            this.table.getColumns().add(col);
        }
        if (appendIdColumn) {
            TableColumn<PathObject, String> colObjectIDs = this.createStringTableColumn(ObservableMeasurementTableData.NAME_OBJECT_ID);
            colObjectIDs.visibleProperty().bind((ObservableValue)this.showObjectIdsProperty);
            this.table.getColumns().add(colObjectIDs);
        }
        SortedList items = new SortedList(this.model.getItems());
        items.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)items);
    }

    private Tooltip getTooltip(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return this.tooltips.computeIfAbsent(text, Tooltip::new);
    }

    private TableColumn<PathObject, Number> createNumericTableColumn(String name) {
        String tooltipText = this.model.getHelpText(name);
        TableColumn col = new TableColumn(name);
        col.setCellValueFactory(cellData -> this.createNumericMeasurement(this.model, (PathObject)cellData.getValue(), cellData.getTableColumn().getText()));
        col.setCellFactory(column -> new NumericTableCell(this.getTooltip(tooltipText), this.histogramDisplay));
        return col;
    }

    private TableColumn<PathObject, String> createStringTableColumn(String name) {
        String tooltipText = this.model.getHelpText(name);
        TableColumn col = new TableColumn(name);
        col.setCellValueFactory(column -> this.createStringMeasurement(this.model, (PathObject)column.getValue(), column.getTableColumn().getText()));
        col.setCellFactory(column -> new BasicTableCell(this.getTooltip(tooltipText)));
        return col;
    }

    private TableColumn<PathObject, PathObject> createThumbnailColumn() {
        TableColumn colThumbnails = new TableColumn("Thumbnail");
        colThumbnails.setCellValueFactory(val -> new SimpleObjectProperty((Object)((PathObject)val.getValue())));
        colThumbnails.visibleProperty().bind((ObservableValue)this.showThumbnailsProperty);
        colThumbnails.setCellFactory(column -> PathObjectImageViewers.createTableCell(this.viewer, (ImageServer<BufferedImage>)this.imageData.getServer(), true, 10.0));
        return colThumbnails;
    }

    private Pane createColumnFilterPane() {
        PredicateTextField tfColumnFilter = new PredicateTextField();
        tfColumnFilter.useRegexProperty().bindBidirectional((Property)this.useRegexColumnFilter);
        ReadOnlyObjectProperty columnFilter = tfColumnFilter.predicateProperty();
        columnFilter.addListener((v, o, n) -> {
            for (TableColumn col : this.table.getColumns()) {
                if (col == this.colThumbnails || col.visibleProperty().isBound()) continue;
                String name = col.getText();
                col.setVisible(n.test(name));
            }
        });
        GridPane paneFilter = new GridPane();
        paneFilter.add((Node)new Label("Column filter"), 0, 0);
        paneFilter.add((Node)tfColumnFilter, 1, 0);
        GridPane.setHgrow((Node)tfColumnFilter, (Priority)Priority.ALWAYS);
        paneFilter.setHgap(5.0);
        if (this.primaryFilter == PathObjectFilter.TMA_CORES) {
            CheckBox cbHideMissing = new CheckBox("Hide missing cores");
            paneFilter.add((Node)cbHideMissing, 2, 0);
            cbHideMissing.selectedProperty().addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.model.setPredicate(p -> !(p instanceof TMACoreObject) || !((TMACoreObject)p).isMissing());
                } else {
                    this.model.setPredicate(null);
                }
            });
            cbHideMissing.setSelected(true);
        }
        paneFilter.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        return paneFilter;
    }

    private Pane createTablePane() {
        BorderPane paneTable = new BorderPane();
        paneTable.setCenter(this.table);
        BorderPane paneBottom = new BorderPane((Node)this.createColumnFilterPane());
        paneBottom.setRight((Node)this.createObjectCountPane());
        paneTable.setBottom((Node)paneBottom);
        return paneTable;
    }

    private Pane createObjectCountPane() {
        Label label = new Label();
        label.textProperty().bind((ObservableValue)Bindings.createStringBinding(this::getObjectCountText, (Observable[])new Observable[]{this.table.getItems()}));
        label.setAlignment(Pos.CENTER_RIGHT);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        return new BorderPane((Node)label);
    }

    private String getObjectCountText() {
        int n = this.table.getItems().size();
        return n == 1 ? "1 object" : n + " objects";
    }

    private void initSplitPane() {
        this.splitPane.getItems().add((Object)this.createTablePane());
    }

    private void initTabPane() {
        this.histogramDisplay = new HistogramDisplay(this.model, true);
        this.scatterPlotDisplay = new ScatterPlotDisplay();
        Tab tabHistogram = new Tab("Histogram", (Node)this.histogramDisplay.getPane());
        tabHistogram.setClosable(false);
        this.plotTabs.getTabs().add((Object)tabHistogram);
        Tab tabScatter = new Tab("Scatter plot", (Node)this.scatterPlotDisplay.getPane());
        tabScatter.setClosable(false);
        this.plotTabs.getTabs().add((Object)tabScatter);
        this.plotTabs.getSelectionModel().selectFirst();
        tabScatter.selectedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.scatterPlotDisplay.setModel(this.model);
            }
        });
        FXUtils.makeTabUndockable((Tab)tabHistogram);
        FXUtils.makeTabUndockable((Tab)tabScatter);
    }

    private Action createShowPlotsAction() {
        Action action = new Action("Show plots");
        action.setGraphic(IconFactory.createNode(FontAwesome.Glyph.BAR_CHART));
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        action.selectedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.splitPane.getItems().add((Object)this.plotTabs);
            } else {
                this.splitPane.getItems().remove((Object)this.plotTabs);
            }
        });
        return action;
    }

    private Action createCopyAction() {
        Action action = new Action("Copy", e -> this.handleCopyButton());
        action.setLongText("Copy the table contents to the system clipboard");
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        action.setGraphic(IconFactory.createNode(FontAwesome.Glyph.CLIPBOARD));
        action.disabledProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.table.getSelectionModel().getSelectedItems()));
        return action;
    }

    private Action createSaveAction() {
        Action action = new Action("Save...", e -> this.handleSaveButton());
        action.setLongText("Save the table contents");
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        action.setGraphic(IconFactory.createNode(FontAwesome.Glyph.SAVE));
        return action;
    }

    private Action createShowThumbnailsAction() {
        Action action = new Action("Show images");
        action.setLongText("Show or hide object thumbnail image column (usually the first column in the table)");
        action.setGraphic(IconFactory.createNode(FontAwesome.Glyph.IMAGE));
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        action.selectedProperty().bindBidirectional((Property)this.showThumbnailsProperty);
        return action;
    }

    private Action createShowIdAction() {
        Action action = new Action("Show object IDs");
        action.setLongText("Show or hide object ID column (usually the last column in the table)");
        action.setGraphic(IconFactory.createFontAwesome('\uf2c2'));
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        action.selectedProperty().bindBidirectional((Property)this.showObjectIdsProperty);
        return action;
    }

    private Action createBindVisibilityAction() {
        Action action = new Action("Apply class visibility");
        action.setLongText("Use class visibility settings from the viewer to filter objects for display in the table");
        action.setGraphic(IconFactory.createNode(FontAwesome.Glyph.EYE));
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        action.selectedProperty().bindBidirectional((Property)this.bindToOverlayOptions);
        return action;
    }

    private Action createToolbarShowAction() {
        Action action = new Action("Show toolbar");
        action.setLongText("Show or hide the toolbar");
        action.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        action.selectedProperty().bindBidirectional((Property)this.showToolbar);
        return action;
    }

    private Action createToolbarTextAction() {
        Action action = new Action("Show button text");
        action.setLongText("Show the full text for toolbar buttons (requires more space)");
        action.selectedProperty().bindBidirectional((Property)this.showToolbarText);
        return action;
    }

    private Action createSelectAllAction() {
        Action action = new Action("Select all", e -> this.table.getSelectionModel().selectAll());
        action.setLongText("Select all rows in the title");
        return action;
    }

    private Action createSelectNoneAction() {
        Action action = new Action("Select none", e -> this.table.getSelectionModel().clearSelection());
        action.setLongText("Deselect all rows in the table");
        return action;
    }

    private void initActions() {
        this.actionShowPlots = this.createShowPlotsAction();
        this.actionCopy = this.createCopyAction();
        this.actionSave = this.createSaveAction();
        this.actionShowToolbar = this.createToolbarShowAction();
        this.actionToolbarText = this.createToolbarTextAction();
        this.actionSelectAll = this.createSelectAllAction();
        this.actionSelectNone = this.createSelectNoneAction();
        this.actionThumbnails = this.createShowThumbnailsAction();
        this.actionId = this.createShowIdAction();
        if (this.overlayVisibilityPredicate != null) {
            this.actionBindVisibility = this.createBindVisibilityAction();
        }
    }

    private ToolBar createToolbar() {
        ToggleButton btnPlots = ActionTools.createToggleButton(this.actionShowPlots);
        btnPlots.contentDisplayProperty().bind(this.toolbarContentDisplayBinding);
        Button btnCopy = ActionTools.createButton(this.actionCopy);
        btnCopy.contentDisplayProperty().bind(this.toolbarContentDisplayBinding);
        Button btnSave = ActionTools.createButton(this.actionSave);
        btnSave.contentDisplayProperty().bind(this.toolbarContentDisplayBinding);
        ToggleButton btnThumbnails = ActionTools.createToggleButton(this.actionThumbnails);
        btnThumbnails.contentDisplayProperty().bind(this.toolbarContentDisplayBinding);
        ToggleButton btnIds = ActionTools.createToggleButton(this.actionId);
        btnIds.contentDisplayProperty().bind(this.toolbarContentDisplayBinding);
        ToolBar toolbar = new ToolBar();
        toolbar.getItems().setAll((Object[])new Node[]{btnPlots, new Separator(), btnSave, new Separator(), btnCopy, new Separator(), btnThumbnails, btnIds});
        if (this.actionBindVisibility != null) {
            ToggleButton btnVisibility = ActionTools.createToggleButton(this.actionBindVisibility);
            btnVisibility.contentDisplayProperty().bind(this.toolbarContentDisplayBinding);
            toolbar.getItems().addAll((Object[])new Node[]{new Separator(), btnVisibility});
        }
        return toolbar;
    }

    private ObjectBinding<ContentDisplay> createToolbarContentDisplayBinding() {
        return Bindings.createObjectBinding(() -> {
            if (this.showToolbarText.get()) {
                return ContentDisplay.LEFT;
            }
            return ContentDisplay.GRAPHIC_ONLY;
        }, (Observable[])new Observable[]{this.showToolbarText});
    }

    private void handleCopyButton() {
        Set<String> excludeColumns = this.getExcludedColumns();
        ObservableList items = this.table.getSelectionModel().getSelectedItems();
        if (items.isEmpty()) {
            items = this.table.getItems();
        }
        List<String> strings = this.model.getRowStrings(new ArrayList(items), (String)PathPrefs.tableDelimiterProperty().get(), -1, c -> !excludeColumns.contains(c));
        try {
            ClipboardContent content = new ClipboardContent();
            content.putString(String.join((CharSequence)System.lineSeparator(), strings));
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
        catch (OutOfMemoryError e) {
            logger.error("Error attempting to copy measurements: {}", (Object)e.getMessage(), (Object)e);
            Dialogs.showErrorMessage((String)"Copy measurements", (String)"Measurement table is too long to copy - please select fewer items");
        }
    }

    private Set<String> getExcludedColumns() {
        HashSet<String> excludeColumns = new HashSet<String>();
        for (TableColumn col : this.table.getColumns()) {
            if (col.isVisible()) continue;
            excludeColumns.add(col.getText());
        }
        return excludeColumns;
    }

    private boolean hasProject() {
        QuPathGUI qupath = QuPathGUI.getInstance();
        return qupath != null && qupath.getProject() != null;
    }

    private void handleSaveButton() {
        Set<String> excludeColumns = this.getExcludedColumns();
        File fileOutput = SummaryMeasurementTable.promptForOutputFile();
        if (fileOutput == null) {
            return;
        }
        if (SummaryMeasurementTable.saveTableModel(this.model, fileOutput, excludeColumns)) {
            DefaultScriptableWorkflowStep step;
            String path;
            Object includeColumns;
            if (excludeColumns.isEmpty()) {
                includeColumns = "";
            } else {
                ArrayList<String> includeColumnList = new ArrayList<String>(this.model.getAllNames());
                includeColumnList.removeAll(excludeColumns);
                includeColumns = ", " + includeColumnList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
            }
            String string = path = !this.hasProject() ? fileOutput.toURI().getPath() : fileOutput.getParentFile().toURI().getPath();
            if (this.primaryFilter == PathObjectFilter.TMA_CORES) {
                step = new DefaultScriptableWorkflowStep("Save TMA measurements", String.format("saveTMAMeasurements('%s'%s)", path, includeColumns));
            } else if (this.primaryFilter == PathObjectFilter.ANNOTATIONS) {
                step = new DefaultScriptableWorkflowStep("Save annotation measurements", String.format("saveAnnotationMeasurements('%s'%s)", path, includeColumns));
            } else if (this.primaryFilter == PathObjectFilter.DETECTIONS_ALL) {
                step = new DefaultScriptableWorkflowStep("Save detection measurements", String.format("saveDetectionMeasurements('%s'%s)", path, includeColumns));
            } else if (this.primaryFilter == PathObjectFilter.CELLS) {
                step = new DefaultScriptableWorkflowStep("Save cell measurements", String.format("saveCellMeasurements('%s'%s)", path, includeColumns));
            } else if (this.primaryFilter == PathObjectFilter.TILES) {
                step = new DefaultScriptableWorkflowStep("Save tile measurements", String.format("saveTileMeasurements('%s'%s)", path, includeColumns));
            } else {
                logger.debug("Can't log measurement export for filter {}", this.primaryFilter);
                return;
            }
            this.imageData.getHistoryWorkflow().addStep((WorkflowStep)step);
        }
    }

    private ContextMenu createContextMenu() {
        ContextMenu menu = new ContextMenu();
        menu.getItems().setAll((Object[])new MenuItem[]{ActionTools.createMenuItem(this.actionSelectAll), ActionTools.createMenuItem(this.actionSelectNone)});
        return menu;
    }

    private void handleHierarchyChange(PathObjectHierarchyEvent event) {
        if (event.isChanging()) {
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.handleHierarchyChange(event));
            return;
        }
        if (event.isStructureChangeEvent()) {
            this.updateObjects();
        } else {
            this.table.refresh();
            this.histogramDisplay.refreshHistogram();
            this.scatterPlotDisplay.refreshScatterPlot();
        }
    }

    private TableRow<PathObject> createTableRow(TableView<PathObject> table) {
        TableRow row = new TableRow();
        row.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.maybeCenterROI((PathObject)row.getItem());
            }
        });
        return row;
    }

    private void handleTableKeypress(KeyEvent e) {
        PathObject selected;
        if (this.centerCode.match(e) && (selected = (PathObject)this.table.getSelectionModel().getSelectedItem()) != null) {
            this.maybeCenterROI(selected);
        }
    }

    public Pane getPane() {
        if (this.table == null) {
            this.init();
        }
        return this.pane;
    }

    private void handleVisibilityChanged(ObservableValue<? extends Boolean> obs, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            logger.debug("Attaching listeners");
            this.imageData.getHierarchy().addListener(this.listener);
            if (this.synchronizer != null) {
                this.synchronizer.attachListeners();
            }
        } else {
            logger.debug("Removing listeners");
            this.imageData.getHierarchy().removeListener(this.listener);
            if (this.synchronizer != null) {
                this.synchronizer.removeListeners();
            }
        }
    }

    private ObservableValue<Number> createNumericMeasurement(ObservableMeasurementTableData model, PathObject pathObject, String column) {
        return Bindings.createDoubleBinding(() -> model.getNumericValue(pathObject, column), (Observable[])new Observable[0]);
    }

    private ObservableValue<String> createStringMeasurement(ObservableMeasurementTableData model, PathObject pathObject, String column) {
        return Bindings.createStringBinding(() -> model.getStringValue(pathObject, column), (Observable[])new Observable[0]);
    }

    private void maybeCenterROI(PathObject pathObject) {
        if (pathObject == null || this.viewer == null || this.viewer.getHierarchy() != this.hierarchy) {
            return;
        }
        ROI roi = pathObject.getROI();
        if (roi != null && !this.viewer.getDisplayedRegionShape().contains(roi.getCentroidX(), roi.getCentroidY())) {
            this.viewer.centerROI(roi);
        }
    }

    public static <T> List<String> getTableModelStrings(PathTableData<T> model, String delim, Collection<String> excludeColumns) {
        Set<String> toExclude = Set.of((String[])excludeColumns.toArray(String[]::new));
        return model.getRowStrings(delim, Integer.MIN_VALUE, s -> !toExclude.contains(s));
    }

    public static <T> String getTableModelString(PathTableData<T> model, String delim, Collection<String> excludeColumns) throws IllegalArgumentException {
        List<String> rows = SummaryMeasurementTable.getTableModelStrings(model, delim, excludeColumns);
        int nSeparators = rows.size() * System.lineSeparator().length();
        long length = rows.stream().mapToLong(String::length).sum() + (long)nSeparators;
        long maxLength = 0x7FFFFFFEL;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Requested string is too long! Requires " + maxLength + " characters, but Java arrays limited to " + maxLength);
        }
        logger.debug("Getting table string (approx {} characters, {} % of maximum)", (Object)length, (Object)Math.round((double)length / (double)maxLength * 100.0));
        return String.join((CharSequence)System.lineSeparator(), rows);
    }

    public static void copyTableContentsToClipboard(PathTableData<?> model, Collection<String> excludeColumns) {
        if (model == null) {
            logger.warn("No table available to copy!");
            return;
        }
        String string = SummaryMeasurementTable.getTableModelString(model, (String)PathPrefs.tableDelimiterProperty().get(), excludeColumns);
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(string);
        clipboard.setContent((Map)content);
    }

    private static File promptForOutputFile() {
        String ext = ",".equals(PathPrefs.tableDelimiterProperty().get()) ? "csv" : "txt";
        return FileChoosers.promptToSaveFile((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"Results data", (String[])new String[]{ext})});
    }

    public static boolean saveTableModel(PathTableData<?> tableModel, File fileOutput, Collection<String> excludeColumns) {
        if (fileOutput == null && (fileOutput = SummaryMeasurementTable.promptForOutputFile()) == null) {
            return false;
        }
        PrintWriter writer = new PrintWriter(fileOutput, StandardCharsets.UTF_8);
        try {
            for (String row : SummaryMeasurementTable.getTableModelStrings(tableModel, (String)PathPrefs.tableDelimiterProperty().get(), excludeColumns)) {
                writer.println(row);
            }
            writer.close();
            boolean bl = true;
            writer.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("Error writing file to {}", (Object)fileOutput, (Object)e);
                return false;
            }
        }
    }

    private MenuBar createMenuBar() {
        Menu menuFile = MenuTools.createMenu("File", this.actionSave);
        Menu menuEdit = MenuTools.createMenu("Edit", this.actionCopy);
        Menu menuView = MenuTools.createMenu("View", ActionTools.createCheckMenuItem(this.actionShowPlots), null, ActionTools.createCheckMenuItem(this.actionShowToolbar), ActionTools.createCheckMenuItem(this.actionToolbarText));
        Menu menuTable = MenuTools.createMenu("Table", ActionTools.createMenuItem(this.actionSelectAll), ActionTools.createMenuItem(this.actionSelectNone), null, ActionTools.createCheckMenuItem(this.actionThumbnails), ActionTools.createCheckMenuItem(this.actionId));
        if (this.actionBindVisibility != null) {
            MenuTools.addMenuItems(menuTable, null, ActionTools.createCheckMenuItem(this.actionBindVisibility));
        }
        MenuBar menubar = new MenuBar(new Menu[]{menuFile, menuEdit, menuView, menuTable});
        SystemMenuBar.manageChildMenuBar(menubar);
        return menubar;
    }
}

