/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure.ui;

import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.charts.HistogramDisplay;

class NumericTableCell<T>
extends TableCell<T, Number> {
    private final HistogramDisplay histogramDisplay;

    public NumericTableCell(Tooltip tooltip, HistogramDisplay histogramDisplay) {
        this.histogramDisplay = histogramDisplay;
        this.setTooltip(tooltip);
        if (histogramDisplay != null) {
            this.setOnMouseClicked(this::handleMouseClick);
        }
    }

    protected void updateItem(Number item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item == null || empty) {
            this.setText(null);
            this.setStyle("");
        } else {
            this.setAlignment(Pos.CENTER);
            if (item instanceof Integer || item instanceof Long) {
                this.setText(item.toString());
            } else if (Double.isNaN(item.doubleValue())) {
                this.setText("-");
            } else {
                double value = item.doubleValue();
                if (value >= 1000.0) {
                    this.setText(GeneralTools.formatNumber((double)value, (int)1));
                } else if (value >= 10.0) {
                    this.setText(GeneralTools.formatNumber((double)value, (int)2));
                } else {
                    this.setText(GeneralTools.formatNumber((double)value, (int)3));
                }
            }
        }
    }

    private void handleMouseClick(MouseEvent event) {
        if (event.isAltDown() && this.histogramDisplay != null) {
            this.histogramDisplay.showHistogram(this.getTableColumn().getText());
            event.consume();
        }
    }
}

