/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import qupath.lib.gui.measure.PathObjectListWrapper;
import qupath.lib.gui.measure.PathObjectValueFactory;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.lazy.interfaces.LazyValue;
import qupath.lib.lazy.objects.PathObjectLazyValues;
import qupath.lib.objects.PathObject;
import qupath.lib.roi.interfaces.ROI;

class RoiPropertyValueFactory
implements PathObjectValueFactory {
    RoiPropertyValueFactory() {
    }

    @Override
    public List<LazyValue<PathObject, ?>> createValues(PathObjectListWrapper wrapper) {
        ImageServerMetadata serverMetadata;
        ArrayList measurements = new ArrayList();
        ImageData<?> imageData = wrapper.getImageData();
        if (wrapper.containsAnnotationsOrDetections()) {
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.ROI_TYPE);
        }
        if (!wrapper.containsRootOnly()) {
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createROICentroidX(imageData));
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createROICentroidY(imageData));
        }
        ImageServerMetadata imageServerMetadata = serverMetadata = imageData == null ? null : imageData.getServerMetadata();
        if (wrapper.containsMultiZ() || wrapper.containsROIs() && serverMetadata != null && serverMetadata.getSizeZ() > 1) {
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.ROI_Z_SLICE);
        }
        if (wrapper.containsMultiT() || wrapper.containsROIs() && serverMetadata != null && serverMetadata.getSizeT() > 1) {
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.ROI_TIMEPOINT);
        }
        if (wrapper.containsAnnotations()) {
            List<ROI> annotationRois = wrapper.getPathObjects().stream().filter(PathObject::isAnnotation).map(PathObject::getROI).filter(Objects::nonNull).toList();
            if (annotationRois.stream().anyMatch(ROI::isPoint)) {
                measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.ROI_NUM_POINTS);
            }
            if (annotationRois.stream().anyMatch(ROI::isArea)) {
                measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createROIAreaMeasurement(wrapper.getImageData()));
                measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createROIPerimeterMeasurement(wrapper.getImageData()));
            }
            if (annotationRois.stream().anyMatch(ROI::isLine)) {
                measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createROILengthMeasurement(wrapper.getImageData()));
            }
        }
        return measurements;
    }
}

