/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PathTableData<T> {
    public static final int DEFAULT_DECIMAL_PLACES = Integer.MIN_VALUE;
    public static final String DEFAULT_DELIMITER = "\t";

    public List<String> getAllNames();

    public String getStringValue(T var1, String var2);

    public String getStringValue(T var1, String var2, int var3);

    public List<String> getMeasurementNames();

    public double getNumericValue(T var1, String var2);

    public double[] getDoubleValues(String var1);

    public List<T> getItems();

    default public List<String> getRowStrings() {
        return this.getRowStrings(DEFAULT_DELIMITER, Integer.MIN_VALUE, null);
    }

    default public List<String> getRowStrings(String delim, int nDecimalPlaces, Predicate<String> columnFilter) {
        return this.getRowStrings(this.getItems(), delim, nDecimalPlaces, columnFilter);
    }

    default public List<String> getRowStrings(Collection<? extends T> items, String delim, int nDecimalPlaces, Predicate<String> columnFilter) {
        Logger logger = LoggerFactory.getLogger(PathTableData.class);
        ArrayList<String> rows = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        List<String> names = new ArrayList<String>(this.getAllNames());
        if (columnFilter != null) {
            names = names.stream().filter(columnFilter).toList();
        }
        int nColumns = names.size();
        for (int col = 0; col < nColumns; ++col) {
            if (names.get(col).chars().filter(e -> e == 34).count() % 2L != 0L) {
                logger.warn("Syntax is ambiguous (i.e. misuse of '\"'), which might result in inconsistencies/errors.");
            }
            if (names.get(col).contains(delim)) {
                sb.append("\"").append(names.get(col)).append("\"");
            } else {
                sb.append(names.get(col));
            }
            if (col >= nColumns - 1) continue;
            sb.append(delim);
        }
        rows.add(sb.toString());
        sb.setLength(0);
        for (T object : items) {
            for (int col = 0; col < nColumns; ++col) {
                String val = this.getStringValue(object, names.get(col), nDecimalPlaces);
                if (val != null) {
                    if (val.contains("\"")) {
                        logger.warn("Syntax is ambiguous (i.e. misuse of '\"'), which might result in inconsistencies/errors.");
                    }
                    if (val.contains(delim)) {
                        sb.append("\"").append(val).append("\"");
                    } else {
                        sb.append(val);
                    }
                }
                if (col >= nColumns - 1) continue;
                sb.append(delim);
            }
            rows.add(sb.toString());
            sb.setLength(0);
        }
        return rows;
    }
}

