/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.roi.interfaces.ROI;

public class PathObjectListWrapper {
    private final ImageData<?> imageData;
    private final List<PathObject> pathObjects;
    private final Set<String> featureNames;
    private final Set<String> metadataNames;
    private final boolean containsDetections;
    private final boolean containsAnnotations;
    private final boolean containsTMACores;
    private final boolean containsRoot;
    private final boolean containsMultiZ;
    private final boolean containsMultiT;
    private final boolean containsROIs;

    public static PathObjectListWrapper create(ImageData<?> imageData, Collection<? extends PathObject> pathObjects) {
        return new PathObjectListWrapper(imageData, pathObjects);
    }

    public static PathObjectListWrapper create(ImageData<?> imageData, Predicate<PathObject> predicate) {
        return PathObjectListWrapper.create(imageData, imageData.getHierarchy().getAllObjects(true).stream().filter(predicate).toList());
    }

    public static PathObjectListWrapper forRoot(ImageData<?> imageData) {
        return PathObjectListWrapper.create(imageData, List.of(imageData.getHierarchy().getRootObject()));
    }

    public static PathObjectListWrapper forAnnotations(ImageData<?> imageData) {
        return PathObjectListWrapper.create(imageData, imageData.getHierarchy().getAnnotationObjects());
    }

    public static PathObjectListWrapper forDetections(ImageData<?> imageData) {
        return PathObjectListWrapper.create(imageData, imageData.getHierarchy().getDetectionObjects());
    }

    public static PathObjectListWrapper forCells(ImageData<?> imageData) {
        return PathObjectListWrapper.create(imageData, imageData.getHierarchy().getCellObjects());
    }

    public static PathObjectListWrapper forTiles(ImageData<?> imageData) {
        return PathObjectListWrapper.create(imageData, imageData.getHierarchy().getTileObjects());
    }

    public static PathObjectListWrapper forTmaCores(ImageData<?> imageData) {
        TMAGrid grid = imageData.getHierarchy().getTMAGrid();
        return PathObjectListWrapper.create(imageData, grid == null ? Collections.emptyList() : grid.getTMACoreList());
    }

    private PathObjectListWrapper(ImageData<?> imageData, Collection<? extends PathObject> pathObjects) {
        this.imageData = imageData;
        this.pathObjects = List.copyOf(pathObjects);
        boolean containsDetections = false;
        boolean containsAnnotations = false;
        boolean containsTMACores = false;
        boolean containsRoot = false;
        boolean containsMultiZ = false;
        boolean containsMultiT = false;
        boolean containsROIs = false;
        LinkedHashSet featureNames = new LinkedHashSet();
        LinkedHashSet<Object> metadataNames = new LinkedHashSet<Object>();
        ArrayList<? extends PathObject> pathObjectListCopy = new ArrayList<PathObject>(pathObjects);
        for (PathObject pathObject : pathObjectListCopy) {
            ROI roi;
            featureNames.addAll(pathObject.getMeasurementList().getNames());
            if (pathObject.hasMetadata()) {
                metadataNames.addAll(pathObject.getMetadata().keySet());
            }
            if (pathObject.hasROI()) {
                containsROIs = true;
            }
            if (pathObject instanceof PathAnnotationObject) {
                containsAnnotations = true;
            } else if (pathObject instanceof TMACoreObject) {
                containsTMACores = true;
            } else if (pathObject instanceof PathDetectionObject) {
                containsDetections = true;
            } else if (pathObject.isRootObject()) {
                containsRoot = true;
            }
            if ((roi = pathObject.getROI()) == null) continue;
            if (roi.getZ() > 0) {
                containsMultiZ = true;
            }
            if (roi.getT() <= 0) continue;
            containsMultiT = true;
        }
        this.containsDetections = containsDetections;
        this.containsAnnotations = containsAnnotations;
        this.containsTMACores = containsTMACores;
        this.containsROIs = containsROIs;
        this.containsRoot = containsRoot;
        this.containsMultiT = containsMultiT;
        this.containsMultiZ = containsMultiZ;
        this.featureNames = Collections.unmodifiableSequencedSet(featureNames);
        metadataNames.removeIf(m -> m.startsWith("_"));
        this.metadataNames = Collections.unmodifiableSequencedSet(metadataNames);
    }

    ImageData<?> getImageData() {
        return this.imageData;
    }

    List<PathObject> getPathObjects() {
        return this.pathObjects;
    }

    Set<String> getFeatureNames() {
        return this.featureNames;
    }

    Set<String> getMetadataNames() {
        return this.metadataNames;
    }

    boolean containsDetections() {
        return this.containsDetections;
    }

    boolean containsAnnotations() {
        return this.containsAnnotations;
    }

    boolean containsAnnotationsOrDetections() {
        return this.containsAnnotations || this.containsDetections;
    }

    boolean containsAnnotationsTmaCores() {
        return this.containsAnnotations || this.containsTMACores;
    }

    boolean containsRootOnly() {
        return this.containsRoot && !this.containsAnnotations && !this.containsDetections && !this.containsTMACores && this.pathObjects.stream().allMatch(PathObject::isRootObject);
    }

    boolean containsTMACores() {
        return this.containsTMACores;
    }

    boolean containsROIs() {
        return this.containsROIs;
    }

    boolean containsRoot() {
        return this.containsRoot;
    }

    boolean containsMultiT() {
        return this.containsMultiT;
    }

    boolean containsMultiZ() {
        return this.containsMultiZ;
    }
}

