/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.measure.DefaultPathObjectValueFactoryBuilder;
import qupath.lib.gui.measure.PathObjectListWrapper;
import qupath.lib.gui.measure.PathObjectValueFactory;
import qupath.lib.gui.measure.PathTableData;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.lazy.interfaces.LazyValue;
import qupath.lib.lazy.objects.MeasurementListValue;
import qupath.lib.lazy.objects.PathObjectLazyValues;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;

public class ObservableMeasurementTableData
implements PathTableData<PathObject> {
    private static final Logger logger = LoggerFactory.getLogger(ObservableMeasurementTableData.class);
    public static final String NAME_OBJECT_ID = PathObjectLazyValues.OBJECT_ID.getName();
    private static final String KEY_PIXEL_LAYER = "PIXEL_LAYER";
    private ImageData<?> imageData;
    private final ObservableList<PathObject> backingList = FXCollections.observableArrayList();
    private final FilteredList<PathObject> filterList = new FilteredList(this.backingList);
    private final ObservableList<String> fullColumnList = FXCollections.observableArrayList();
    private final ObservableList<String> metadataColumnList = FXCollections.observableArrayList();
    private final ObservableList<String> measurementColumnList = FXCollections.observableArrayList();
    private final Map<String, LazyValue<PathObject, ?>> lazyValueMap = new LinkedHashMap();
    private PathObjectValueFactory factory;
    private static final ObservableList<PathObjectValueFactory> extraFactories = FXCollections.observableArrayList();

    static void addFactory(PathObjectValueFactory factory) {
        extraFactories.add((Object)factory);
    }

    static boolean removeFactory(PathObjectValueFactory factory) {
        return extraFactories.remove((Object)factory);
    }

    public synchronized void setImageData(ImageData<?> imageData, Collection<? extends PathObject> pathObjects) {
        this.imageData = imageData;
        this.backingList.setAll(pathObjects);
        if (!Platform.isFxApplicationThread()) {
            logger.debug("Image data is being set by thread {}", (Object)Thread.currentThread());
        }
        this.updateMeasurementList();
    }

    public static void setPixelLayer(ImageData<BufferedImage> imageData, ImageServer<BufferedImage> layerServer) {
        if (layerServer == null) {
            imageData.removeProperty(KEY_PIXEL_LAYER);
        } else {
            imageData.setProperty(KEY_PIXEL_LAYER, layerServer);
        }
    }

    public static ImageServer<BufferedImage> getPixelLayer(ImageData<?> imageData) {
        Object layer = imageData.getProperty(KEY_PIXEL_LAYER);
        if (layer instanceof ImageServer) {
            return (ImageServer)layer;
        }
        return null;
    }

    public synchronized void updateMeasurementList() {
        this.lazyValueMap.clear();
        PathObjectValueFactory factory = this.factory;
        if (factory == null) {
            factory = new DefaultPathObjectValueFactoryBuilder().includeImage(!PathPrefs.maskImageNamesProperty().get()).append((Collection<? extends PathObjectValueFactory>)extraFactories).build();
        } else if (!extraFactories.isEmpty()) {
            ArrayList<PathObjectValueFactory> allFactories = new ArrayList<PathObjectValueFactory>((Collection<PathObjectValueFactory>)extraFactories);
            allFactories.addFirst(factory);
            factory = PathObjectValueFactory.join(allFactories);
        }
        PathObjectListWrapper wrapper = PathObjectListWrapper.create(this.imageData, this.backingList);
        ArrayList<String> metadataNames = new ArrayList<String>();
        ArrayList<String> featureNames = new ArrayList<String>();
        ArrayList<String> allNames = new ArrayList<String>();
        for (LazyValue<PathObject, ?> measurement : factory.createValues(wrapper)) {
            String name = measurement.getName();
            if (this.lazyValueMap.containsKey(name)) {
                logger.warn("Duplicate measurement {} - entries will be dropped", (Object)name);
                continue;
            }
            this.lazyValueMap.put(measurement.getName(), measurement);
            if (measurement.isNumeric()) {
                featureNames.add(name);
            } else {
                metadataNames.add(name);
            }
            allNames.add(name);
        }
        boolean changes = false;
        if (!metadataNames.equals(this.metadataColumnList)) {
            changes = this.metadataColumnList.setAll(metadataNames);
        }
        if (!featureNames.equals(this.measurementColumnList)) {
            changes = this.measurementColumnList.setAll(featureNames);
        }
        if (changes) {
            this.fullColumnList.setAll(allNames);
        }
    }

    public void setPredicate(Predicate<? super PathObject> predicate) {
        this.filterList.setPredicate(predicate);
    }

    public boolean isStringMeasurement(String name) {
        LazyValue measurement = this.lazyValueMap.getOrDefault(name, null);
        return measurement != null && measurement.isString();
    }

    public boolean isNumericMeasurement(String name) {
        LazyValue measurement = this.lazyValueMap.getOrDefault(name, null);
        return measurement == null || measurement.isNumeric();
    }

    public ReadOnlyListWrapper<String> getMeasurementNames() {
        return new ReadOnlyListWrapper(this.measurementColumnList);
    }

    @Override
    public double[] getDoubleValues(String column) {
        double[] values = new double[this.filterList.size()];
        if (this.lazyValueMap.containsKey(column)) {
            for (int i = 0; i < this.filterList.size(); ++i) {
                values[i] = this.getNumericValue((PathObject)this.filterList.get(i), column);
            }
            return values;
        }
        for (int i = 0; i < this.filterList.size(); ++i) {
            values[i] = ((PathObject)this.filterList.get(i)).getMeasurementList().get(column);
        }
        return values;
    }

    @Override
    public double getNumericValue(PathObject pathObject, String column) {
        if (this.lazyValueMap.containsKey(column)) {
            TMACoreObject core;
            if (pathObject instanceof TMACoreObject && (core = (TMACoreObject)pathObject).isMissing()) {
                return Double.NaN;
            }
            LazyValue<PathObject, ?> builder = this.lazyValueMap.get(column);
            Object val = builder.getValue((Object)pathObject);
            if (val instanceof Number) {
                Number num = (Number)val;
                return num.doubleValue();
            }
            return Double.NaN;
        }
        return pathObject.getMeasurementList().get(column);
    }

    @Override
    public ObservableList<PathObject> getItems() {
        return this.filterList;
    }

    @Deprecated
    public ObservableList<PathObject> getBackingListEntries() {
        return this.getBackingList();
    }

    public ObservableList<PathObject> getBackingList() {
        return this.backingList;
    }

    @Override
    public List<String> getAllNames() {
        return new ArrayList<String>((Collection<String>)this.fullColumnList);
    }

    @Override
    public String getStringValue(PathObject pathObject, String column) {
        return this.getStringValue(pathObject, column, Integer.MIN_VALUE);
    }

    public String getHelpText(String column) {
        LazyValue<PathObject, ?> builder = this.lazyValueMap.get(column);
        if (builder != null) {
            return builder.getHelpText();
        }
        return "The measurement '" + column + "' from the object's measurement list, or NaN if the measurement is not found";
    }

    @Override
    public String getStringValue(PathObject pathObject, String column, int decimalPlaces) {
        LazyValue<PathObject, ?> builder = this.lazyValueMap.get(column);
        if (decimalPlaces == Integer.MIN_VALUE && builder instanceof MeasurementListValue) {
            decimalPlaces = -4;
        }
        if (builder != null) {
            return builder.getStringValue((Object)pathObject, decimalPlaces);
        }
        if (pathObject == null) {
            logger.warn("Requested measurement {} for null object! Returned empty String.", (Object)column);
            return "";
        }
        double val = pathObject.getMeasurementList().get(column);
        if (Double.isNaN(val)) {
            return "NaN";
        }
        return GeneralTools.formatNumber((double)val, (int)4);
    }

    public ReadOnlyListWrapper<String> getMetadataNames() {
        return new ReadOnlyListWrapper(this.metadataColumnList);
    }
}

