/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure;

import java.util.ArrayList;
import java.util.List;
import qupath.lib.gui.measure.PathObjectListWrapper;
import qupath.lib.gui.measure.PathObjectValueFactory;
import qupath.lib.images.ImageData;
import qupath.lib.lazy.interfaces.LazyValue;
import qupath.lib.lazy.objects.PathObjectLazyValues;
import qupath.lib.objects.PathObject;

class ObjectPropertyValueFactory
implements PathObjectValueFactory {
    ObjectPropertyValueFactory() {
    }

    @Override
    public List<LazyValue<PathObject, ?>> createValues(PathObjectListWrapper wrapper) {
        ArrayList measurements = new ArrayList();
        ImageData<?> imageData = wrapper.getImageData();
        if (!wrapper.containsRootOnly()) {
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.OBJECT_ID);
        }
        measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.OBJECT_TYPE);
        measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.OBJECT_NAME);
        if (!wrapper.containsRootOnly()) {
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.CLASSIFICATION);
            if (imageData != null && imageData.getHierarchy().getTMAGrid() != null) {
                measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.TMA_CORE_NAME);
            }
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.PARENT_DISPLAYED_NAME);
        }
        if (wrapper.containsTMACores()) {
            measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.TMA_CORE_MISSING);
        }
        return measurements;
    }
}

