/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javafx.beans.property.DoubleProperty;
import qupath.lib.gui.measure.PathObjectListWrapper;
import qupath.lib.gui.measure.PathObjectValueFactory;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.images.ImageData;
import qupath.lib.lazy.interfaces.LazyNumericValue;
import qupath.lib.lazy.interfaces.LazyValue;
import qupath.lib.lazy.objects.PathObjectLazyValues;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

class ObjectCountValueFactory
implements PathObjectValueFactory {
    private final Supplier<Double> allredMinPercentage;

    ObjectCountValueFactory(Supplier<Double> allredMinPercentagePositive) {
        this.allredMinPercentage = allredMinPercentagePositive;
    }

    ObjectCountValueFactory() {
        this(() -> ((DoubleProperty)PathPrefs.allredMinPercentagePositiveProperty()).get());
    }

    @Override
    public List<LazyValue<PathObject, ?>> createValues(PathObjectListWrapper wrapper) {
        ArrayList measurements = new ArrayList();
        if (wrapper.containsRoot() || wrapper.containsAnnotationsTmaCores()) {
            boolean detectionsAnywhere;
            ImageData<?> imageData = wrapper.getImageData();
            boolean bl = imageData == null ? wrapper.containsDetections() : (detectionsAnywhere = !imageData.getHierarchy().getDetectionObjects().isEmpty());
            if (detectionsAnywhere) {
                LazyNumericValue builder = PathObjectLazyValues.createDetectionCountMeasurement(wrapper.getImageData());
                measurements.add((LazyValue<PathObject, ?>)builder);
            }
            measurements.addAll(this.getDetectionCountsMeasurements(wrapper));
        }
        return measurements;
    }

    private List<LazyValue<PathObject, ?>> getDetectionCountsMeasurements(PathObjectListWrapper wrapper) {
        boolean includeDensityMeasurements;
        ArrayList pathClassList;
        ImageData<?> imageData = wrapper.getImageData();
        ArrayList builders = new ArrayList();
        if (imageData == null || imageData.getHierarchy() == null) {
            return builders;
        }
        Set pathClasses = PathObjectTools.getRepresentedPathClasses((PathObjectHierarchy)imageData.getHierarchy(), PathDetectionObject.class);
        pathClasses.remove(null);
        pathClasses.remove(PathClass.NULL_CLASS);
        LinkedHashSet<PathClass> parentIntensityClasses = new LinkedHashSet<PathClass>();
        LinkedHashSet<PathClass> parentPositiveNegativeClasses = new LinkedHashSet<PathClass>();
        for (Object pathClass : pathClasses) {
            if (PathClassTools.isGradedIntensityClass((PathClass)pathClass)) {
                parentIntensityClasses.add(pathClass.getParentClass());
                parentPositiveNegativeClasses.add(pathClass.getParentClass());
                continue;
            }
            if (!PathClassTools.isPositiveClass((PathClass)pathClass) && !PathClassTools.isNegativeClass((PathClass)pathClass)) continue;
            parentPositiveNegativeClasses.add(pathClass.getParentClass());
        }
        if (!parentPositiveNegativeClasses.isEmpty()) {
            pathClassList = new ArrayList(parentPositiveNegativeClasses);
            pathClassList.remove(null);
            pathClassList.remove(PathClass.NULL_CLASS);
            Collections.sort(pathClassList);
            for (PathClass pathClass : pathClassList) {
                builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createBaseClassCountsMeasurement(imageData, (PathClass)pathClass));
            }
        }
        pathClassList = new ArrayList(pathClasses);
        Collections.sort(pathClassList);
        for (PathClass pathClass : pathClassList) {
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createExactClassCountsMeasurement(imageData, (PathClass)pathClass));
        }
        for (PathClass pathClass : parentPositiveNegativeClasses) {
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createPositivePercentageMeasurement(imageData, (PathClass[])new PathClass[]{pathClass}));
        }
        if (parentPositiveNegativeClasses.size() > 1) {
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createPositivePercentageMeasurement(imageData, (PathClass[])parentPositiveNegativeClasses.toArray(new PathClass[0])));
        }
        for (PathClass pathClass : parentIntensityClasses) {
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createHScoreMeasurement(imageData, (PathClass[])new PathClass[]{pathClass}));
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createAllredProportionMeasurement(imageData, this.allredMinPercentage, (PathClass[])new PathClass[]{pathClass}));
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createAllredIntensityMeasurement(imageData, this.allredMinPercentage, (PathClass[])new PathClass[]{pathClass}));
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createAllredMeasurement(imageData, this.allredMinPercentage, (PathClass[])new PathClass[]{pathClass}));
        }
        if (parentIntensityClasses.size() > 1) {
            PathClass[] parentIntensityClassesArray = (PathClass[])parentIntensityClasses.toArray(PathClass[]::new);
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createHScoreMeasurement(imageData, (PathClass[])parentIntensityClassesArray));
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createAllredProportionMeasurement(imageData, this.allredMinPercentage, (PathClass[])parentIntensityClassesArray));
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createAllredIntensityMeasurement(imageData, this.allredMinPercentage, (PathClass[])parentIntensityClassesArray));
            builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createAllredMeasurement(imageData, this.allredMinPercentage, (PathClass[])parentIntensityClassesArray));
        }
        boolean bl = includeDensityMeasurements = wrapper.containsAnnotations() || wrapper.containsTMACores();
        if (includeDensityMeasurements) {
            for (PathClass pathClass : pathClassList) {
                if (!PathClassTools.isPositiveClass((PathClass)pathClass) || pathClass.getBaseClass() != pathClass) continue;
                builders.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createDetectionClassDensityMeasurement(imageData, (PathClass)pathClass));
            }
        }
        return builders;
    }
}

