/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.measure.PathObjectListWrapper;
import qupath.lib.gui.measure.PathObjectValueFactory;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.lazy.interfaces.LazyValue;
import qupath.lib.lazy.objects.PathObjectLazyValues;
import qupath.lib.objects.PathObject;
import qupath.opencv.ml.pixel.PixelClassificationMeasurementManager;

class LivePixelClassificationValueFactory
implements PathObjectValueFactory {
    LivePixelClassificationValueFactory() {
    }

    @Override
    public List<LazyValue<PathObject, ?>> createValues(PathObjectListWrapper wrapper) {
        ImageServer<BufferedImage> pixelClassifier;
        ArrayList measurements = new ArrayList();
        if ((wrapper.containsAnnotations() || wrapper.containsTMACores() || wrapper.containsRoot()) && (pixelClassifier = ObservableMeasurementTableData.getPixelLayer(wrapper.getImageData())) != null && (pixelClassifier.getMetadata().getChannelType() == ImageServerMetadata.ChannelType.CLASSIFICATION || pixelClassifier.getMetadata().getChannelType() == ImageServerMetadata.ChannelType.PROBABILITY)) {
            PixelClassificationMeasurementManager pixelManager = new PixelClassificationMeasurementManager(pixelClassifier);
            for (String name : pixelManager.getMeasurementNames()) {
                measurements.add((LazyValue<PathObject, ?>)PathObjectLazyValues.createLivePixelClassificationMeasurement((PixelClassificationMeasurementManager)pixelManager, (String)name));
            }
        }
        return measurements;
    }
}

