/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.measure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import qupath.lib.gui.measure.ImageNameValueFactory;
import qupath.lib.gui.measure.LivePixelClassificationValueFactory;
import qupath.lib.gui.measure.MeasurementListValueFactory;
import qupath.lib.gui.measure.MetadataValueFactory;
import qupath.lib.gui.measure.ObjectCountValueFactory;
import qupath.lib.gui.measure.ObjectPropertyValueFactory;
import qupath.lib.gui.measure.PathObjectValueFactory;
import qupath.lib.gui.measure.RoiPropertyValueFactory;

public class DefaultPathObjectValueFactoryBuilder {
    private boolean includeImage = true;
    private boolean includeObjectProperties = true;
    private boolean includeObjectCounts = true;
    private boolean includeRois = true;
    private boolean includeMetadata = true;
    private boolean includeMeasurementList = true;
    private boolean includePixelClassification = true;
    private List<PathObjectValueFactory> extras = new ArrayList<PathObjectValueFactory>();

    public DefaultPathObjectValueFactoryBuilder includeImage(boolean doInclude) {
        this.includeImage = doInclude;
        return this;
    }

    public DefaultPathObjectValueFactoryBuilder includeObjectProperties(boolean doInclude) {
        this.includeObjectProperties = doInclude;
        return this;
    }

    public DefaultPathObjectValueFactoryBuilder includeRoiProperties(boolean doInclude) {
        this.includeRois = doInclude;
        return this;
    }

    public DefaultPathObjectValueFactoryBuilder includeObjectMetadata(boolean doInclude) {
        this.includeMetadata = doInclude;
        return this;
    }

    public DefaultPathObjectValueFactoryBuilder includeObjectCounts(boolean doInclude) {
        this.includeObjectCounts = doInclude;
        return this;
    }

    public DefaultPathObjectValueFactoryBuilder includeMeasurementList(boolean doInclude) {
        this.includeMeasurementList = doInclude;
        return this;
    }

    public DefaultPathObjectValueFactoryBuilder includePixelClassification(boolean doInclude) {
        this.includePixelClassification = doInclude;
        return this;
    }

    public DefaultPathObjectValueFactoryBuilder append(Collection<? extends PathObjectValueFactory> factories) {
        this.extras.addAll(factories);
        return this;
    }

    public DefaultPathObjectValueFactoryBuilder append(PathObjectValueFactory ... factories) {
        return this.append(List.of(factories));
    }

    public PathObjectValueFactory build() {
        ArrayList<PathObjectValueFactory> factories = new ArrayList<PathObjectValueFactory>();
        if (this.includeImage) {
            factories.add(new ImageNameValueFactory());
        }
        if (this.includeObjectProperties) {
            factories.add(new ObjectPropertyValueFactory());
        }
        if (this.includeRois) {
            factories.add(new RoiPropertyValueFactory());
        }
        if (this.includeObjectCounts) {
            factories.add(new ObjectCountValueFactory());
        }
        if (this.includeMetadata) {
            factories.add(new MetadataValueFactory());
        }
        if (this.includeMeasurementList) {
            factories.add(new MeasurementListValueFactory());
        }
        if (this.includePixelClassification) {
            factories.add(new LivePixelClassificationValueFactory());
        }
        factories.addAll(this.extras);
        return PathObjectValueFactory.join(factories);
    }
}

