/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.logging.LogManager;
import qupath.lib.gui.logging.TextAppendable;

class LoggingAppender
extends AppenderBase<ILoggingEvent> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingAppender.class);
    private static LoggingAppender instance;
    private boolean isActive = false;
    private List<TextAppendable> textComponentsFX = Collections.synchronizedList(new ArrayList());
    private Level minLevel = Level.INFO;
    private boolean flushRequested = false;
    private StringBuffer buffer = new StringBuffer();

    private LoggingAppender() {
        LoggerContext context = LoggingAppender.getLoggerContext();
        if (context == null) {
            logger.warn("Cannot append logging info without logback!");
        } else {
            this.setName("GUI");
            this.setContext((Context)context);
            this.start();
            LoggingAppender.getRootLogger().addAppender((Appender)this);
        }
    }

    static Level getLevel(LogManager.LogLevel logLevel) {
        switch (logLevel) {
            case DEBUG: {
                return Level.DEBUG;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case INFO: {
                return Level.INFO;
            }
            case ALL: {
                return Level.ALL;
            }
            case OFF: {
                return Level.OFF;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case WARN: {
                return Level.WARN;
            }
        }
        return Level.INFO;
    }

    void setRootLogLevel(LogManager.LogLevel logLevel) {
        ch.qos.logback.classic.Logger root = LoggingAppender.getRootLogger();
        this.minLevel = LoggingAppender.getLevel(logLevel);
        if (root != null) {
            root.setLevel(this.minLevel);
        } else {
            logger.warn("Cannot get root logger!");
        }
    }

    static LoggerContext getLoggerContext() {
        if (LoggerFactory.getILoggerFactory() instanceof LoggerContext) {
            return (LoggerContext)LoggerFactory.getILoggerFactory();
        }
        return null;
    }

    static ch.qos.logback.classic.Logger getRootLogger() {
        LoggerContext context = LoggingAppender.getLoggerContext();
        return context == null ? null : context.getLogger("ROOT");
    }

    public void addFileAppender(File file) {
        LoggerContext context = LoggingAppender.getLoggerContext();
        if (context != null) {
            FileAppender appender = new FileAppender();
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)context);
            encoder.setPattern("%d{HH:mm:ss.SSS} [%thread] [%-5level] %logger{36} - %msg%n");
            encoder.start();
            appender.setFile(file.getAbsolutePath());
            appender.setContext((Context)context);
            appender.setEncoder((Encoder)encoder);
            appender.setName(file.getName());
            appender.start();
            context.getLogger("ROOT").addAppender((Appender)appender);
        } else {
            logger.warn("Cannot append logging info without logback!");
        }
    }

    public static synchronized LoggingAppender getInstance() {
        if (instance == null) {
            instance = new LoggingAppender();
        }
        return instance;
    }

    public synchronized void addTextAppendableFX(TextAppendable component) {
        this.textComponentsFX.add(component);
        this.isActive = true;
    }

    public synchronized void removeTextAppendableFX(TextAppendable component) {
        this.textComponentsFX.remove(component);
        this.isActive = !this.textComponentsFX.isEmpty();
    }

    protected void append(ILoggingEvent event) {
        if (this.isActive && event.getLevel().isGreaterOrEqual(this.minLevel)) {
            String message = String.valueOf(event.getLevel()) + ": " + event.getFormattedMessage() + "\n";
            if (event.getThrowableProxy() != null && event.getLevel().isGreaterOrEqual(Level.ERROR)) {
                message = message + event.getThrowableProxy().getClassName() + ": " + event.getThrowableProxy().getMessage() + "\n";
                for (StackTraceElementProxy element : event.getThrowableProxy().getStackTraceElementProxyArray()) {
                    message = message + "    " + element.getSTEAsString() + "\n";
                }
                if (event.getThrowableProxy().getCause() != null) {
                    message = message + "  Caused by " + event.getThrowableProxy().getCause().getMessage();
                    for (StackTraceElementProxy element : event.getThrowableProxy().getCause().getStackTraceElementProxyArray()) {
                        message = message + "        " + element.getSTEAsString() + "\n";
                    }
                }
            }
            this.buffer(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buffer(String message) {
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            this.buffer.append(message);
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushBuffer() {
        if (Platform.isFxApplicationThread()) {
            String message;
            StringBuffer stringBuffer = this.buffer;
            synchronized (stringBuffer) {
                this.flushRequested = false;
                message = this.buffer.toString();
                this.buffer.setLength(0);
            }
            if (!message.isEmpty()) {
                for (TextAppendable text : this.textComponentsFX) {
                    LoggingAppender.log(text, message);
                }
            }
        } else if (!this.flushRequested) {
            this.flushRequested = true;
            Platform.runLater(() -> this.flushBuffer());
        }
    }

    private static void log(TextAppendable component, String message) {
        component.appendText(message);
    }
}

