/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.logging;

import java.io.File;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import qupath.lib.gui.logging.LoggingAppender;
import qupath.lib.gui.logging.TextAppendable;

public class LogManager {
    private static ObjectProperty<LogLevel> logLevelProperty = new SimpleObjectProperty((Object)LogLevel.INFO);

    public static void logToFile(File file) {
        LoggingAppender.getInstance().addFileAppender(file);
    }

    public static void setRootLogLevel(LogLevel level) {
        logLevelProperty.set((Object)level);
    }

    public static LogLevel getRootLogLevel() {
        return (LogLevel)((Object)logLevelProperty.get());
    }

    public static ObjectProperty<LogLevel> rootLogLevelProperty() {
        return logLevelProperty;
    }

    public static void setDebug() {
        LogManager.setRootLogLevel(LogLevel.DEBUG);
    }

    public static void setInfo() {
        LogManager.setRootLogLevel(LogLevel.INFO);
    }

    public static void setWarn() {
        LogManager.setRootLogLevel(LogLevel.WARN);
    }

    public static void setError() {
        LogManager.setRootLogLevel(LogLevel.ERROR);
    }

    public static void setTrace() {
        LogManager.setRootLogLevel(LogLevel.TRACE);
    }

    public static void setAll() {
        LogManager.setRootLogLevel(LogLevel.ALL);
    }

    public static void setOff() {
        LogManager.setRootLogLevel(LogLevel.OFF);
    }

    public static void addTextAppendableFX(TextAppendable component) {
        LoggingAppender.getInstance().addTextAppendableFX(component);
    }

    public static void removeTextAppendableFX(TextAppendable component) {
        LoggingAppender.getInstance().removeTextAppendableFX(component);
    }

    static {
        logLevelProperty.addListener((v, o, n) -> {
            if (n != null) {
                LoggingAppender.getInstance().setRootLogLevel((LogLevel)((Object)n));
            }
        });
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        ALL,
        OFF;

    }
}

