/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.localization;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.lib.gui.UserDirectoryManager;

public class QuPathResources {
    private static final Logger logger = LoggerFactory.getLogger(QuPathResources.class);
    private static final QuPathResourceControl CONTROL = new QuPathResourceControl();
    private static final String DEFAULT_BUNDLE = "qupath/lib/gui/localization/qupath-gui-strings";
    private static final LocalizedResourceManager LOCALIZED_RESOURCE_MANAGER = LocalizedResourceManager.createInstance((String)"qupath/lib/gui/localization/qupath-gui-strings", (ResourceBundle.Control)new QuPathResourceControl());

    public static LocalizedResourceManager getLocalizedResourceManager() {
        return LOCALIZED_RESOURCE_MANAGER;
    }

    public static String getString(String key) {
        return QuPathResources.getString(DEFAULT_BUNDLE, key);
    }

    public static String getString(String bundle, String key) {
        return QuPathResources.getBundleOrNull(bundle).getString(key);
    }

    public static boolean hasString(String key) {
        return QuPathResources.hasString(DEFAULT_BUNDLE, key);
    }

    public static boolean hasString(String bundleName, String key) {
        ResourceBundle bundle = QuPathResources.getBundleOrNull(bundleName);
        if (bundle != null) {
            return bundle.containsKey(key);
        }
        return false;
    }

    public static boolean hasBundleForLocale(String bundle, Locale locale) {
        if (locale == Locale.US || locale == Locale.ENGLISH) {
            return true;
        }
        return CONTROL.hasBundle(bundle, locale, QuPathResources.class.getClassLoader());
    }

    public static boolean hasDefaultBundleForLocale(Locale locale) {
        return QuPathResources.hasBundleForLocale(DEFAULT_BUNDLE, locale);
    }

    private static ResourceBundle getBundleOrNull(String bundleName) {
        if (bundleName == null || bundleName.isEmpty()) {
            bundleName = DEFAULT_BUNDLE;
        }
        try {
            return ResourceBundle.getBundle(bundleName, Locale.getDefault(Locale.Category.DISPLAY), QuPathResources.class.getClassLoader(), CONTROL);
        }
        catch (MissingResourceException e) {
            logger.error("Missing resource bundle {}", (Object)bundleName);
            return null;
        }
    }

    static class QuPathResourceControl
    extends ResourceBundle.Control {
        private static final Logger logger = LoggerFactory.getLogger(QuPathResourceControl.class);
        private Path codePath;

        QuPathResourceControl() {
            try {
                this.codePath = Paths.get(QuPathResources.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
            }
            catch (Exception e) {
                logger.debug("Error identifying code directory: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            ResourceBundle bundle = super.newBundle(baseName, locale, format, loader, reload);
            if (bundle != null) {
                return bundle;
            }
            if (loader != QuPathResources.class.getClassLoader() && (bundle = super.newBundle(baseName, locale, format, QuPathResources.class.getClassLoader(), reload)) != null) {
                return bundle;
            }
            return this.searchForBundle(baseName, locale);
        }

        @Override
        public List<String> getFormats(String baseName) {
            return Collections.singletonList("java.properties");
        }

        private boolean hasBundle(String baseName, Locale locale, ClassLoader loader) {
            try {
                if (super.newBundle(baseName, locale, "java.properties", loader, false) != null) {
                    return true;
                }
            }
            catch (Exception e) {
                logger.debug(e.getLocalizedMessage(), (Throwable)e);
            }
            return this.searchForBundlePath(baseName, locale) != null;
        }

        private ResourceBundle searchForBundle(String baseName, Locale locale) {
            Path propertiesPath = this.searchForBundlePath(baseName, locale);
            if (propertiesPath != null) {
                PropertyResourceBundle propertyResourceBundle;
                block9: {
                    BufferedReader reader = Files.newBufferedReader(propertiesPath, StandardCharsets.UTF_8);
                    try {
                        logger.debug("Reading bundle from {}", (Object)propertiesPath);
                        propertyResourceBundle = new PropertyResourceBundle(reader);
                        if (reader == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            logger.debug(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    reader.close();
                }
                return propertyResourceBundle;
            }
            return null;
        }

        private Path searchForBundlePath(String baseName, Locale locale) {
            String propertiesName = this.getShortPropertyFileName(baseName, locale);
            for (Path localizationDirectory : this.getLocalizationDirectoryPaths()) {
                logger.debug("Searching for {} in {}", (Object)propertiesName, (Object)localizationDirectory);
                try {
                    Path propertiesPath = localizationDirectory.resolve(propertiesName);
                    if (!Files.isRegularFile(propertiesPath, new LinkOption[0])) continue;
                    return propertiesPath;
                }
                catch (Exception e) {
                    logger.debug(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return null;
        }

        private String getShortPropertyFileName(String baseName, Locale locale) {
            String bundleName = this.toBundleName(baseName, locale);
            int ind = bundleName.replace('.', '/').lastIndexOf(47);
            String propertiesBaseName = ind < 0 ? bundleName : bundleName.substring(ind + 1);
            return propertiesBaseName + ".properties";
        }

        private List<Path> getLocalizationDirectoryPaths() {
            Path codeSearchPath;
            ArrayList<Path> paths = new ArrayList<Path>();
            Path userSearchPath = this.getUserLocalizationDirectoryOrNull();
            if (userSearchPath != null) {
                paths.add(userSearchPath);
            }
            if ((codeSearchPath = this.getCodeLocalizationDirectoryOrNull()) != null) {
                paths.add(codeSearchPath);
            }
            return paths;
        }

        private static Path getDirectoryOrNull(Path path) {
            if (path != null && Files.isDirectory(path, new LinkOption[0])) {
                return path;
            }
            return null;
        }

        private Path getUserLocalizationDirectoryOrNull() {
            Path userPath = UserDirectoryManager.getInstance().getLocalizationDirectoryPath();
            if (userPath != null) {
                return QuPathResourceControl.getDirectoryOrNull(userPath);
            }
            return null;
        }

        private Path getCodeLocalizationDirectoryOrNull() {
            if (this.codePath == null) {
                return null;
            }
            return QuPathResourceControl.getDirectoryOrNull(this.codePath.resolve("localization"));
        }
    }
}

