/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.images.stores;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class ImageRegionStoreHelpers {
    static double distanceToCentroid(ImageRegion r, double x, double y) {
        double dx = x - ((double)r.getMinX() + (double)r.getWidth() / 2.0);
        double dy = y - ((double)r.getMinY() + (double)r.getHeight() / 2.0);
        return dx * dx + dy * dy;
    }

    public static List<RegionRequest> getTilesToRequest(ImageServer<?> server, Shape clipShape, double downsampleFactor, int zPosition, int tPosition, List<RegionRequest> regions) {
        if (server == null) {
            return Collections.emptyList();
        }
        RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsampleFactor, (ImageRegion)AwtTools.getImageRegion((Shape)clipShape, (int)zPosition, (int)tPosition));
        if (regions == null) {
            regions = new ArrayList<RegionRequest>();
        }
        for (TileRequest tile : server.getTileRequestManager().getTileRequests(request)) {
            regions.add(tile.getRegionRequest());
        }
        double x = (double)request.getX() + (double)request.getWidth() / 2.0;
        double y = (double)request.getY() + (double)request.getHeight() / 2.0;
        regions.sort((r1, r2) -> Double.compare(ImageRegionStoreHelpers.distanceToCentroid((ImageRegion)r1, x, y), ImageRegionStoreHelpers.distanceToCentroid((ImageRegion)r2, x, y)));
        return regions;
    }

    public static RegionRequest getTileRequest(ImageServer<BufferedImage> server, double x, double y, double downsampleFactor, int zPosition, int tPosition) {
        int tileHeightForLevel;
        int tileWidthForLevel;
        int serverWidth = server.getWidth();
        int serverHeight = server.getHeight();
        if (x < 0.0 || y < 0.0 || x >= (double)serverWidth || y >= (double)serverHeight) {
            return null;
        }
        double downsamplePreferred = ServerTools.getPreferredDownsampleFactor(server, (double)downsampleFactor);
        int tileWidth = server.getMetadata().getPreferredTileWidth();
        int tileHeight = server.getMetadata().getPreferredTileHeight();
        if (tileWidth < 0) {
            tileWidth = 256;
        }
        if (tileHeight < 0) {
            tileHeight = 256;
        }
        if (GeneralTools.almostTheSame((double)downsamplePreferred, (double)((int)(downsamplePreferred + 0.5)), (double)0.001)) {
            tileWidthForLevel = (int)((double)(tileWidth * (int)(downsamplePreferred + 0.5)) + 0.5);
            tileHeightForLevel = (int)((double)(tileHeight * (int)(downsamplePreferred + 0.5)) + 0.5);
        } else {
            tileWidthForLevel = (int)((double)tileWidth * downsamplePreferred + 0.5);
            tileHeightForLevel = (int)((double)tileHeight * downsamplePreferred + 0.5);
        }
        int xx = (int)(x / (double)tileWidthForLevel) * tileWidthForLevel;
        int yy = (int)(y / (double)tileHeightForLevel) * tileHeightForLevel;
        RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsamplePreferred, (int)xx, (int)yy, (int)(Math.min(serverWidth, xx + tileWidthForLevel) - xx), (int)(Math.min(serverHeight, yy + tileHeightForLevel) - yy), (int)zPosition, (int)tPosition);
        return request;
    }
}

