/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.images.stores;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.prefs.PathPrefs;

public class ImageRegionStoreFactory {
    private static final Logger logger = LoggerFactory.getLogger(ImageRegionStoreFactory.class);

    public static DefaultImageRegionStore createImageRegionStore(long tileCacheSizeBytes) {
        return new DefaultImageRegionStore(tileCacheSizeBytes);
    }

    public static DefaultImageRegionStore createImageRegionStore() {
        return ImageRegionStoreFactory.createImageRegionStore(ImageRegionStoreFactory.getTileCacheSizeBytes());
    }

    private static long getTileCacheSizeBytes() {
        double percentage;
        Runtime rt = Runtime.getRuntime();
        long maxAvailable = rt.maxMemory();
        if (maxAvailable == Long.MAX_VALUE) {
            logger.warn("No inherent maximum memory set - for caching purposes, will assume 64 GB");
            maxAvailable = 0x1000000000L;
        }
        if ((percentage = PathPrefs.tileCachePercentageProperty().get()) < 10.0) {
            logger.warn("At least 10% of available memory needs to be used for tile caching (you requested {}%)", (Object)percentage);
            percentage = 10.0;
        } else if (percentage > 90.0) {
            logger.warn("No more than 90% of available memory can be used for tile caching (you requested {}%)", (Object)percentage);
            percentage = 90.0;
        }
        long tileCacheSize = Math.round((double)maxAvailable * (percentage / 100.0));
        logger.info(String.format("Setting tile cache size to %.2f MB (%.1f%% max memory)", (double)tileCacheSize / 1048576.0, percentage));
        return tileCacheSize;
    }
}

