/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.images.stores;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import qupath.lib.gui.images.stores.SizeEstimator;
import qupath.lib.regions.RegionRequest;

class DefaultRegionCache<T>
implements Map<RegionRequest, T> {
    private Map<RegionRequest, T> map;
    private final SizeEstimator<T> sizeEstimator;
    private int maxCapacity;
    private int nonNullSize = 0;
    private long maxMemoryBytes;
    private long memoryBytes = 0L;

    DefaultRegionCache(final SizeEstimator<T> sizeEstimator, final int maxCapacity, long maxSizeBytes) {
        this.maxMemoryBytes = maxSizeBytes;
        this.sizeEstimator = sizeEstimator;
        this.maxCapacity = maxCapacity;
        this.map = new LinkedHashMap<RegionRequest, T>(maxCapacity + 1, 2.0f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected synchronized boolean removeEldestEntry(Map.Entry<RegionRequest, T> eldest) {
                boolean doRemove;
                boolean bl = doRemove = DefaultRegionCache.this.nonNullSize >= maxCapacity || DefaultRegionCache.this.memoryBytes > DefaultRegionCache.this.maxMemoryBytes;
                if (doRemove) {
                    DefaultRegionCache.this.memoryBytes -= sizeEstimator.getApproxImageSize(eldest.getValue());
                    if (eldest.getValue() != null) {
                        --DefaultRegionCache.this.nonNullSize;
                    }
                }
                return doRemove;
            }
        };
        this.map = Collections.synchronizedMap(this.map);
    }

    DefaultRegionCache(SizeEstimator<T> sizeEstimator, long maxSizeBytes) {
        this(sizeEstimator, Math.max(200, (int)(maxSizeBytes / 262144L + 10L)), maxSizeBytes);
    }

    @Override
    public synchronized T put(RegionRequest request, T img) {
        T imgPrevious = this.map.put(request, img);
        if (img != null) {
            this.memoryBytes += this.sizeEstimator.getApproxImageSize(img);
            ++this.nonNullSize;
        }
        if (imgPrevious != null) {
            this.memoryBytes -= this.sizeEstimator.getApproxImageSize(imgPrevious);
            --this.nonNullSize;
        }
        return imgPrevious;
    }

    @Override
    public synchronized void clear() {
        this.memoryBytes = 0L;
        this.nonNullSize = 0;
        this.map.clear();
    }

    public String toString() {
        return String.format("Cache: %d (%d/%d non-null), %s", this.map.size(), this.nonNullSize, this.maxCapacity, this.map.toString());
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public synchronized T get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized T remove(Object key) {
        T imgPrevious = this.map.remove(key);
        if (imgPrevious != null) {
            this.memoryBytes -= this.sizeEstimator.getApproxImageSize(imgPrevious);
            --this.nonNullSize;
        }
        return imgPrevious;
    }

    @Override
    public synchronized void putAll(Map<? extends RegionRequest, ? extends T> m) {
        for (Map.Entry<RegionRequest, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized Set<RegionRequest> keySet() {
        return this.map.keySet();
    }

    @Override
    public synchronized Collection<T> values() {
        return this.map.values();
    }

    @Override
    public synchronized Set<Map.Entry<RegionRequest, T>> entrySet() {
        return this.map.entrySet();
    }
}

