/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.images.stores;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.gui.images.stores.AbstractImageRegionStore;
import qupath.lib.gui.images.stores.BufferedImageSizeEstimator;
import qupath.lib.gui.images.stores.ImageRegionRenderer;
import qupath.lib.gui.images.stores.ImageRegionStoreHelpers;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.images.stores.TileWorker;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class DefaultImageRegionStore
extends AbstractImageRegionStore<BufferedImage>
implements ImageRegionRenderer {
    private static final int DEFAULT_THUMBNAIL_WIDTH = 1000;
    private static final Logger logger = LoggerFactory.getLogger(DefaultImageRegionStore.class);
    private static boolean DEBUG_TILES = false;

    DefaultImageRegionStore(int thumbnailWidth, long tileCacheSize) {
        super(new BufferedImageSizeEstimator(), thumbnailWidth, tileCacheSize);
    }

    DefaultImageRegionStore(long tileCacheSize) {
        this(1000, tileCacheSize);
    }

    @Override
    public void paintRegionCompletely(ImageServer<BufferedImage> server, Graphics g, Shape clipShapeVisible, int zPosition, int tPosition, double downsampleFactor, ImageObserver observer, ImageRenderer imageDisplay, long timeoutMilliseconds) {
        ArrayList<TileWorker> workers = new ArrayList<TileWorker>();
        BufferedImage imgTemp = null;
        for (RegionRequest request : ImageRegionStoreHelpers.getTilesToRequest(server, clipShapeVisible, downsampleFactor, zPosition, tPosition, null)) {
            Object result = this.requestImageTile(server, request, this.cache, true);
            if (result instanceof BufferedImage) {
                if (imageDisplay != null) {
                    imgTemp = imageDisplay.applyTransforms((BufferedImage)result, imgTemp);
                    g.drawImage(imgTemp, request.getX(), request.getY(), request.getWidth(), request.getHeight(), observer);
                    continue;
                }
                g.drawImage((BufferedImage)result, request.getX(), request.getY(), request.getWidth(), request.getHeight(), observer);
                continue;
            }
            if (!(result instanceof TileWorker)) continue;
            workers.add((TileWorker)result);
        }
        for (TileWorker worker : workers) {
            BufferedImage imgTile = null;
            try {
                imgTile = (BufferedImage)worker.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException e) {
                logger.debug("Repaint skipped...");
                continue;
            }
            catch (InterruptedException e) {
                logger.debug("Tile request interrupted in 'paintRegionCompletely': {}", (Object)e.getLocalizedMessage());
                return;
            }
            catch (ExecutionException e) {
                logger.error("Execution exception in 'paintRegionCompletely'", (Throwable)e);
                return;
            }
            catch (TimeoutException e) {
                logger.warn("Timed out requesting region ({} ms)... {}", (Object)timeoutMilliseconds, (Object)worker.getRequest());
                RegionRequest request = worker.getRequest();
                if (server.isEmptyRegion(request)) {
                    imgTile = null;
                }
                if (worker.cancel(false)) {
                    try {
                        imgTile = (BufferedImage)server.readRegion(request);
                        if (imgTile != null) {
                            this.cache.put(request, imgTile);
                        }
                    }
                    catch (IOException e1) {
                        logger.warn("Unable to read tile for " + String.valueOf(request), (Throwable)e1);
                    }
                }
                try {
                    imgTile = (BufferedImage)worker.get();
                }
                catch (InterruptedException e1) {
                    logger.warn("Tile request interrupted; {}", (Object)e1.getLocalizedMessage());
                }
                catch (ExecutionException e1) {
                    logger.warn("Execution exception during tile request: {}", (Object)e1.getLocalizedMessage());
                }
                catch (CancellationException e1) {
                    logger.warn("Tile request cancelled: {}", (Object)e1.getLocalizedMessage());
                }
            }
            if (imgTile == null) continue;
            RegionRequest request = worker.getRequest();
            if (imageDisplay != null) {
                imgTemp = imageDisplay.applyTransforms(imgTile, imgTemp);
                g.drawImage(imgTemp, request.getX(), request.getY(), request.getWidth(), request.getHeight(), observer);
                continue;
            }
            g.drawImage(imgTile, request.getX(), request.getY(), request.getWidth(), request.getHeight(), observer);
        }
    }

    @Override
    public void paintRegion(ImageServer<BufferedImage> server, Graphics g, Shape clipShapeVisible, int zPosition, int tPosition, double downsampleFactor, BufferedImage imgThumbnail, ImageObserver observer, ImageRenderer imageDisplay) {
        this.registerRequest(null, server, clipShapeVisible, downsampleFactor, zPosition, tPosition);
        this.paintRegionInternal(server, g, clipShapeVisible, zPosition, tPosition, downsampleFactor, imgThumbnail, observer, imageDisplay);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void paintRegionInternal(ImageServer<BufferedImage> server, Graphics g, Shape clipShapeVisible, int zPosition, int tPosition, double downsampleFactor, BufferedImage imgThumbnail, ImageObserver observer, ImageRenderer imageDisplay) {
        BufferedImage imgTemp;
        List<RegionRequest> requests = ImageRegionStoreHelpers.getTilesToRequest(server, clipShapeVisible, downsampleFactor, zPosition, tPosition, null);
        if (imgThumbnail != null) {
            Rectangle missingBounds = null;
            for (RegionRequest request : requests) {
                BufferedImage img = (BufferedImage)this.getCachedTile((ImageServer)server, request);
                if (img != null || this.cache.containsKey(request)) continue;
                if (missingBounds == null) {
                    missingBounds = AwtTools.getBounds((ImageRegion)request);
                    continue;
                }
                missingBounds = missingBounds.union(AwtTools.getBounds((ImageRegion)request));
            }
            if (missingBounds != null) {
                double[] preferredDownsamples = server.getPreferredDownsamples();
                Arrays.sort(preferredDownsamples);
                double nextDownsample = -1.0;
                for (double d : preferredDownsamples) {
                    if (!(d > Math.max(downsampleFactor, 1.0))) continue;
                    nextDownsample = d;
                    break;
                }
                if (nextDownsample > 0.0) {
                    this.paintRegionInternal(server, g, missingBounds, zPosition, tPosition, nextDownsample, imgThumbnail, observer, imageDisplay);
                } else if (imgThumbnail != null) {
                    if (imageDisplay != null) {
                        imgThumbnail = imgTemp = imageDisplay.applyTransforms(imgThumbnail, null);
                    }
                    g.drawImage(imgThumbnail, 0, 0, server.getWidth(), server.getHeight(), observer);
                }
            }
        }
        boolean useDisplayCache = server != null && !server.isRGB() && server.getMetadata().getChannelType() != ImageServerMetadata.ChannelType.CLASSIFICATION && (server.nChannels() > 1 || server.getPixelType() != PixelType.UINT8);
        long displayTimestamp = imageDisplay == null ? 0L : imageDisplay.getLastChangeTimestamp();
        String displayCachePath = null;
        if (useDisplayCache) {
            if (imageDisplay == null) {
                displayCachePath = "RGB::" + server.getPath();
            } else if (server != null) {
                displayCachePath = server.getPath() + imageDisplay.getUniqueID();
            }
        }
        imgTemp = null;
        for (RegionRequest request : requests) {
            BufferedImage img = this.getCachedRegion(server, request);
            if (img == null) continue;
            if (imageDisplay != null || useDisplayCache) {
                if (imageDisplay != null && displayTimestamp != imageDisplay.getLastChangeTimestamp()) {
                    return;
                }
                if (useDisplayCache) {
                    RegionRequest requestCache = RegionRequest.createInstance((String)displayCachePath, (double)request.getDownsample(), (ImageRegion)request);
                    imgTemp = (BufferedImage)this.cache.get(requestCache);
                    if (imgTemp == null) {
                        if (imageDisplay != null) {
                            imgTemp = imageDisplay.applyTransforms(img, null);
                        } else {
                            imgTemp = new BufferedImage(img.getWidth(), img.getHeight(), 2);
                            Graphics2D g2d = imgTemp.createGraphics();
                            g2d.drawImage((Image)img, 0, 0, null);
                            g2d.dispose();
                        }
                        if (imgTemp == null || imageDisplay != null && displayTimestamp != imageDisplay.getLastChangeTimestamp()) return;
                        this.cache.put(requestCache, imgTemp);
                    }
                } else {
                    if (imgTemp != null && (imgTemp.getWidth() != img.getWidth() || imgTemp.getHeight() != img.getHeight())) {
                        imgTemp = null;
                    }
                    imgTemp = imageDisplay != null ? imageDisplay.applyTransforms(img, imgTemp) : img;
                }
                img = imgTemp;
            }
            g.drawImage(img, request.getX(), request.getY(), request.getWidth(), request.getHeight(), observer);
            if (!DEBUG_TILES) continue;
            g.setColor(Color.RED);
            g.drawRect(request.getX(), request.getY(), request.getWidth(), request.getHeight());
        }
    }

    @Override
    public void close() {
        super.close();
    }
}

