/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.images.stores;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import qupath.lib.gui.images.stores.ImageRenderer;

public class ColorModelRenderer
implements ImageRenderer {
    private ColorModel colorModel;
    private final String id = UUID.randomUUID().toString();
    private final AtomicLong counter = new AtomicLong();

    public ColorModelRenderer(ColorModel colorModel) {
        this.setColorModel(colorModel);
    }

    @Override
    public BufferedImage applyTransforms(BufferedImage imgInput, BufferedImage imgOutput) {
        if (imgOutput == null) {
            imgOutput = new BufferedImage(imgInput.getWidth(), imgInput.getHeight(), 2);
        }
        Graphics2D g2d = imgOutput.createGraphics();
        if (this.colorModel != null && imgInput.getColorModel() != this.colorModel) {
            imgInput = new BufferedImage(this.colorModel, imgInput.getRaster(), this.colorModel.isAlphaPremultiplied(), null);
        }
        g2d.drawImage((Image)imgInput, 0, 0, null);
        g2d.dispose();
        return imgOutput;
    }

    public void setColorModel(ColorModel model) {
        this.colorModel = model;
        this.counter.incrementAndGet();
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public long getLastChangeTimestamp() {
        return this.counter.get();
    }

    @Override
    public String getUniqueID() {
        return this.id;
    }
}

