/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.images.servers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.display.ImageDisplay;
import qupath.lib.display.settings.DisplaySettingUtils;
import qupath.lib.display.settings.ImageDisplaySettings;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.images.stores.ImageRegionStoreFactory;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.GeneratingImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class RenderedImageServer
extends AbstractTileableImageServer
implements GeneratingImageServer<BufferedImage> {
    private final DefaultImageRegionStore store;
    private final ImageData<BufferedImage> imageData;
    private final List<PathOverlay> overlayLayers = new ArrayList<PathOverlay>();
    private final ImageRenderer renderer;
    private final double overlayOpacity;
    private final Color backgroundColor;
    private final ImageServerMetadata metadata;
    private final boolean dedicatedStore;
    private final LookupOp gammaOp;

    private RenderedImageServer(DefaultImageRegionStore store, ImageData<BufferedImage> imageData, List<? extends PathOverlay> overlayLayers, ImageRenderer renderer, double[] downsamples, Color backgroundColor, double overlayOpacity, LookupOp gammaOp) {
        if (store == null) {
            this.store = ImageRegionStoreFactory.createImageRegionStore(Runtime.getRuntime().maxMemory() / 4L);
            this.dedicatedStore = true;
        } else {
            this.store = store;
            this.dedicatedStore = false;
        }
        this.overlayOpacity = overlayOpacity;
        if (overlayLayers != null) {
            this.overlayLayers.addAll(overlayLayers);
        }
        this.renderer = renderer;
        this.imageData = imageData;
        this.backgroundColor = backgroundColor;
        this.gammaOp = gammaOp;
        ImageServerMetadata.Builder builder = new ImageServerMetadata.Builder(imageData.getServerMetadata()).rgb(true).channels((Collection)ImageChannel.getDefaultRGBChannels()).pixelType(PixelType.UINT8).channelType(ImageServerMetadata.ChannelType.DEFAULT);
        if (downsamples != null && downsamples.length > 0) {
            builder = builder.levelsFromDownsamples(downsamples);
        }
        this.metadata = builder.build();
    }

    public static ImageServer<BufferedImage> createRenderedServer(QuPathViewer viewer) throws IOException {
        return new Builder(viewer).build();
    }

    public static ImageServer<BufferedImage> createRenderedServer(ImageServer<BufferedImage> server, ImageRenderer renderer) throws IOException {
        return new Builder((ImageData<BufferedImage>)new ImageData(server)).renderer(renderer).backgroundColor(new Color(0, true)).build();
    }

    public Collection<URI> getURIs() {
        return this.imageData.getServer().getURIs();
    }

    public String getServerType() {
        return "Rendered image server";
    }

    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        BufferedImage img = new BufferedImage(tileRequest.getTileWidth(), tileRequest.getTileHeight(), 2);
        RegionRequest region = tileRequest.getRegionRequest();
        double downsample = region.getDownsample();
        Graphics2D g2d = img.createGraphics();
        if (this.backgroundColor != null) {
            g2d.setBackground(this.backgroundColor);
            g2d.clearRect(0, 0, img.getWidth(), img.getHeight());
        }
        g2d.setClip(0, 0, img.getWidth(), img.getHeight());
        g2d.scale(1.0 / downsample, 1.0 / downsample);
        g2d.translate(-region.getX(), -region.getY());
        this.store.paintRegionCompletely((ImageServer<BufferedImage>)this.imageData.getServer(), g2d, g2d.getClip(), tileRequest.getZ(), tileRequest.getT(), downsample, null, this.renderer, Integer.MAX_VALUE);
        if (this.gammaOp != null) {
            this.gammaOp.filter(img.getRaster(), img.getRaster());
        }
        if (this.overlayOpacity > 0.0) {
            if (this.overlayOpacity < 1.0) {
                g2d.setComposite(AlphaComposite.getInstance(3, (float)this.overlayOpacity));
            }
            for (PathOverlay overlay : this.overlayLayers) {
                overlay.paintOverlay(g2d, (ImageRegion)region, downsample, this.imageData, true);
            }
        }
        g2d.dispose();
        return img;
    }

    protected boolean hasAlpha() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() != 1;
    }

    protected BufferedImage createDefaultRGBImage(int width, int height) {
        if (this.hasAlpha()) {
            return new BufferedImage(width, height, 2);
        }
        return new BufferedImage(width, height, 1);
    }

    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        throw new UnsupportedOperationException("Unable to create builder for " + String.valueOf(((Object)((Object)this)).getClass()));
    }

    protected String createID() {
        return UUID.randomUUID().toString();
    }

    public void close() throws Exception {
        super.close();
        if (this.dedicatedStore) {
            this.store.close();
        }
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private DefaultImageRegionStore store;
        private final ImageData<BufferedImage> imageData;
        private final List<PathOverlay> overlayLayers = new ArrayList<PathOverlay>();
        private ImageRenderer renderer;
        private ImageDisplaySettings settings;
        private double overlayOpacity = 1.0;
        private Color backgroundColor;
        private double[] downsamples;
        private LookupOp gammaOp = null;

        public Builder(QuPathViewer viewer) {
            this(viewer.getImageData());
            this.store = viewer.getImageRegionStore();
            this.overlayLayers.addAll(viewer.getOverlayLayers());
            this.renderer = viewer.getImageDisplay();
            this.overlayOpacity = viewer.getOverlayOptions().getOpacity();
            this.gammaOp = viewer.getGammaOp();
        }

        public Builder(ImageData<BufferedImage> imageData) {
            this.imageData = imageData;
        }

        public Builder downsamples(double ... downsamples) {
            this.downsamples = downsamples;
            return this;
        }

        @Deprecated
        public Builder display(ImageDisplay display) {
            return this.renderer(display);
        }

        public Builder settings(ImageDisplaySettings settings) {
            this.settings = settings;
            return this;
        }

        public Builder renderer(ImageRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder overlayOpacity(double opacity) {
            this.overlayOpacity = GeneralTools.clipValue((double)opacity, (double)0.0, (double)1.0);
            return this;
        }

        public Builder layers(PathOverlay ... layers) {
            return this.layers(Arrays.asList(layers));
        }

        public Builder layers(Collection<PathOverlay> layers) {
            this.overlayLayers.addAll(layers);
            return this;
        }

        public Builder store(DefaultImageRegionStore store) {
            this.store = store;
            return this;
        }

        public Builder backgroundColor(Color color) {
            this.backgroundColor = color;
            return this;
        }

        public Builder backgroundColor(int rgb, boolean keepAlpha) {
            return this.backgroundColor(new Color(rgb, keepAlpha));
        }

        public ImageServer<BufferedImage> build() throws IOException {
            DefaultImageRegionStore store = this.getStore();
            ImageRenderer renderer = this.getRenderer();
            return new RenderedImageServer(store, this.imageData, this.overlayLayers, renderer, this.downsamples, this.backgroundColor, this.overlayOpacity, this.gammaOp);
        }

        private ImageRenderer getRenderer() throws IOException {
            QuPathViewer viewer;
            if (this.renderer != null) {
                return this.renderer;
            }
            if (this.settings != null) {
                ImageDisplay display = ImageDisplay.create(this.imageData);
                if (DisplaySettingUtils.applySettingsToDisplay(display, this.settings)) {
                    return display;
                }
                logger.warn("Display settings are not compatible with this image");
            }
            if ((viewer = this.findViewer(this.imageData)) == null) {
                return ImageDisplay.create(this.imageData);
            }
            return viewer.getImageDisplay();
        }

        private DefaultImageRegionStore getStore() {
            if (this.store != null) {
                return this.store;
            }
            QuPathViewer viewer = this.findViewer(this.imageData);
            if (viewer == null) {
                return null;
            }
            return viewer.getImageRegionStore();
        }

        private QuPathViewer findViewer(ImageData<?> imageData) {
            QuPathGUI qupath = QuPathGUI.getInstance();
            if (qupath != null) {
                return qupath.getAllViewers().stream().filter(v -> v.getImageData() == imageData).findFirst().orElse(null);
            }
            return null;
        }
    }
}

