/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.images.servers;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import qupath.lib.analysis.DelaunayTools;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.PathObjectPainter;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.GeneratingImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectConnections;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class PathHierarchyImageServer
extends AbstractTileableImageServer
implements GeneratingImageServer<BufferedImage> {
    static long counter = 0L;
    public static String DEFAULT_PREFIX = "OVERLAY::";
    private ImageServerMetadata originalMetadata;
    private String prefix;
    private ImageData<BufferedImage> imageData;
    private ImageServer<BufferedImage> server;
    private OverlayOptions options;
    private PathObjectHierarchy hierarchy;

    public PathHierarchyImageServer(ImageData<BufferedImage> imageData, OverlayOptions options) {
        this(DEFAULT_PREFIX + " " + counter + "::", imageData, options);
    }

    private PathHierarchyImageServer(String prefix, ImageData<BufferedImage> imageData, OverlayOptions options) {
        this.imageData = imageData;
        this.prefix = prefix;
        this.server = imageData.getServer();
        this.hierarchy = imageData.getHierarchy();
        this.options = options;
        double minDim = Math.min(this.server.getWidth(), this.server.getHeight());
        double nextDownsample = 1.0;
        ImageServerMetadata.ImageResolutionLevel.Builder levelBuilder = new ImageServerMetadata.ImageResolutionLevel.Builder(this.server.getWidth(), this.server.getHeight());
        do {
            levelBuilder.addLevelByDownsample(nextDownsample);
        } while (minDim / (nextDownsample *= 4.0) >= 2048.0);
        this.originalMetadata = new ImageServerMetadata.Builder(this.server.getOriginalMetadata()).preferredTileSize(256, 256).levels((Collection)levelBuilder.build()).pixelType(PixelType.UINT8).channels((Collection)ImageChannel.getDefaultRGBChannels()).rgb(true).build();
    }

    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return null;
    }

    public Collection<URI> getURIs() {
        return Collections.emptyList();
    }

    protected String createID() {
        return UUID.randomUUID().toString();
    }

    private Collection<PathObject> getObjectsToPaint(RegionRequest request) {
        return this.hierarchy.getAllDetectionsForRegion((ImageRegion)request, null);
    }

    public boolean isEmptyRegion(RegionRequest request) {
        if (this.hierarchy.hasObjectsForRegion(PathDetectionObject.class, (ImageRegion)request)) {
            return false;
        }
        if (!this.options.getShowConnections()) {
            return true;
        }
        if (this.imageData.getProperty("OBJECT_CONNECTIONS") != null) {
            return false;
        }
        return this.hierarchy.getCellSubdivision(request.getImagePlane()).getObjectsForRegion((ImageRegion)request).isEmpty() && this.hierarchy.getDetectionSubdivision(request.getImagePlane()).getObjectsForRegion((ImageRegion)request).isEmpty();
    }

    public String getServerType() {
        return "Overlay";
    }

    public ImageServerMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    public void setMetadata(ImageServerMetadata metadata) {
        throw new IllegalArgumentException("Metadata cannot be set for a hierarchy image server!");
    }

    protected BufferedImage createDefaultRGBImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        ArrayList<PathObject> pathObjects;
        RegionRequest request = tileRequest.getRegionRequest();
        Object o = this.options.getShowConnections() ? this.imageData.getProperty("OBJECT_CONNECTIONS") : null;
        PathObjectConnections connections = o instanceof PathObjectConnections ? (PathObjectConnections)o : null;
        DelaunayTools.Subdivision subdivision = null;
        if (this.options.getShowConnections() && (subdivision = this.hierarchy.getCellSubdivision(tileRequest.getImagePlane())).isEmpty()) {
            subdivision = this.hierarchy.getDetectionSubdivision(tileRequest.getImagePlane());
        }
        if ((pathObjects = new ArrayList<PathObject>(this.getObjectsToPaint(request))).isEmpty()) {
            if (!this.options.getShowConnections()) {
                return null;
            }
            if (connections == null && (subdivision == null || subdivision.isEmpty())) {
                return null;
            }
        }
        Map<PathObject, Integer> levels = pathObjects.stream().collect(Collectors.toMap(p -> p, p -> p.getLevel()));
        Comparator<PathObject> comparator = Comparator.comparingInt(p -> (Integer)levels.get(p)).thenComparing(p -> p.getID());
        Collections.sort(pathObjects, comparator);
        double downsampleFactor = request.getDownsample();
        int width = tileRequest.getTileWidth();
        int height = tileRequest.getTileHeight();
        BufferedImage img = this.createDefaultRGBImage(width, height);
        Graphics2D g2d = img.createGraphics();
        g2d.setClip(0, 0, width, height);
        double scale = 1.0 / downsampleFactor;
        g2d.scale(scale, scale);
        g2d.translate(-request.getX(), -request.getY());
        if (pathObjects != null && !pathObjects.isEmpty()) {
            g2d.setClip(AwtTools.getBounds((ImageRegion)request));
            PathObjectPainter.paintSpecifiedObjects(g2d, pathObjects, this.options, null, downsampleFactor);
        }
        if (connections != null) {
            PathObjectPainter.paintConnections(connections, this.hierarchy, g2d, this.imageData.isFluorescence() ? ColorToolsAwt.TRANSLUCENT_WHITE : ColorToolsAwt.TRANSLUCENT_BLACK, downsampleFactor, tileRequest.getImagePlane());
        } else if (subdivision != null) {
            PathObjectPainter.paintConnections(subdivision, this.hierarchy, g2d, this.imageData.isFluorescence() ? ColorToolsAwt.TRANSLUCENT_WHITE : ColorToolsAwt.TRANSLUCENT_BLACK, downsampleFactor, tileRequest.getImagePlane());
        }
        g2d.dispose();
        return img;
    }
}

