/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.images.servers;

import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.SingleChannelDisplayInfo;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.io.GsonTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectReader;
import qupath.lib.regions.RegionRequest;

public class ChannelDisplayTransformServer
extends TransformingImageServer<BufferedImage>
implements PathObjectReader {
    private static Logger logger = LoggerFactory.getLogger(ChannelDisplayTransformServer.class);
    private List<ChannelDisplayInfo> channels;
    private ImageServerMetadata metadata;
    private ColorModel colorModel;

    public static ImageServer<BufferedImage> createColorTransformServer(ImageServer<BufferedImage> server, List<ChannelDisplayInfo> channels) {
        return new ChannelDisplayTransformServer(server, channels);
    }

    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return null;
    }

    private ChannelDisplayTransformServer(ImageServer<BufferedImage> server, List<ChannelDisplayInfo> channels) {
        super(server);
        this.channels = channels;
        if (channels.size() == 1 && !(channels.get(0) instanceof SingleChannelDisplayInfo)) {
            this.metadata = new ImageServerMetadata.Builder(server.getMetadata()).channels((Collection)ImageChannel.getDefaultRGBChannels()).rgb(true).pixelType(PixelType.UINT8).build();
        } else {
            PixelType pixelType = server.getPixelType();
            for (ChannelDisplayInfo c2 : channels) {
                if (c2 instanceof DirectServerChannelInfo) continue;
                pixelType = PixelType.FLOAT32;
                break;
            }
            this.metadata = new ImageServerMetadata.Builder(server.getMetadata()).channels(channels.stream().map(c -> ImageChannel.getInstance((String)c.getName(), (Integer)c.getColor())).toList()).rgb(false).pixelType(pixelType).build();
        }
    }

    protected String createID() {
        return ((Object)((Object)this)).getClass().getName() + ": + " + this.getWrappedServer().getPath() + " " + GsonTools.getInstance().toJson(this.channels);
    }

    public BufferedImage readRegion(RegionRequest request) throws IOException {
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(request);
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = null;
        float[] pxFloat = null;
        int b = 0;
        for (ChannelDisplayInfo channel : this.channels) {
            if (channel instanceof SingleChannelDisplayInfo) {
                if (raster == null) {
                    BandedSampleModel model = new BandedSampleModel(switch (this.getPixelType()) {
                        case PixelType.FLOAT32 -> 4;
                        case PixelType.FLOAT64 -> 5;
                        case PixelType.INT16 -> 2;
                        case PixelType.INT32 -> 3;
                        case PixelType.UINT16 -> 1;
                        case PixelType.UINT8 -> 0;
                        default -> throw new IllegalArgumentException("Unsupported pixel type " + String.valueOf(this.getPixelType()));
                    }, width, height, this.nChannels());
                    raster = Raster.createWritableRaster(model, null);
                }
                pxFloat = ((SingleChannelDisplayInfo)channel).getValues(img, 0, 0, width, height, pxFloat);
                raster.setSamples(0, 0, width, height, b, pxFloat);
                ++b;
                continue;
            }
            if (this.channels.size() == 1) {
                int[] rgb = channel.getRGB(img, null, ChannelDisplayMode.COLOR);
                img.setRGB(0, 0, width, height, rgb, 0, width);
                return img;
            }
            logger.error("Cannot apply requested color transforms! Must either be a single RGB transform, or one or more single-channel transforms");
        }
        if (this.colorModel == null) {
            this.colorModel = ColorModelFactory.createColorModel((PixelType)PixelType.FLOAT32, (int)this.channels.size(), (boolean)false, (int[])this.channels.stream().mapToInt(c -> {
                Integer color = c.getColor();
                if (color == null) {
                    color = ColorTools.packRGB((int)255, (int)255, (int)255);
                }
                return color;
            }).toArray());
        }
        return new BufferedImage(this.colorModel, raster, false, null);
    }

    public String getServerType() {
        String name = String.join((CharSequence)", ", this.channels.stream().map(c -> c.getName()).toList());
        return super.getWrappedServer().getServerType() + " (" + name + ")";
    }

    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    public Collection<PathObject> readPathObjects() throws IOException {
        ImageServer server = this.getWrappedServer();
        if (server instanceof PathObjectReader) {
            return ((PathObjectReader)server).readPathObjects();
        }
        return Collections.emptyList();
    }
}

