/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.extensions;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.Version;
import qupath.lib.gui.extensions.GitHubProject;
import qupath.lib.io.GsonTools;

public class UpdateChecker {
    private static final Logger logger = LoggerFactory.getLogger(UpdateChecker.class);
    private static Map<URI, String> etagMap = new HashMap<URI, String>();
    private static Map<URI, String> lastModifiedMap = new HashMap<URI, String>();
    private static Map<URI, ReleaseVersion> latestVersionMap = new HashMap<URI, ReleaseVersion>();
    private static Map<URI, String> allReleasesEtagMap = new HashMap<URI, String>();
    private static Map<URI, List<Version>> allVersionsMap = new HashMap<URI, List<Version>>();

    private static synchronized List<Version> listAllReleases() {
        return UpdateChecker.listAllReleases(GitHubProject.GitHubRepo.create("QuPath", "qupath", "qupath"));
    }

    private static synchronized List<Version> listAllReleases(GitHubProject.GitHubRepo repository) {
        String owner = repository.getOwner();
        String repo = repository.getRepo();
        if (!UpdateChecker.isValidOwnerOrRepo(owner) || !UpdateChecker.isValidOwnerOrRepo(repo)) {
            logger.warn("Cannot check for releases with owner={}, repo={}", (Object)owner, (Object)repo);
            return Collections.emptyList();
        }
        try {
            URI uri = new URI("https://api.github.com/repos/" + owner + "/" + repo + "/releases");
            HttpRequest.Builder builder = HttpRequest.newBuilder(uri).header("Accept", "application/vnd.github.v3+json").GET();
            String allReleasesEtag = allReleasesEtagMap.get(uri);
            if (allReleasesEtag != null) {
                builder.header("If-None-Match", allReleasesEtag);
            }
            HttpRequest request = builder.build();
            HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            HttpHeaders headers = response.headers();
            int code = response.statusCode();
            List<Version> allVersions = allVersionsMap.getOrDefault(uri, null);
            if (code == 200) {
                String json = response.body();
                List allReleases = (List)GsonTools.getInstance().fromJson(json, new TypeToken<List<ReleaseGH>>(){}.getType());
                allReleasesEtag = headers.firstValue("ETag").orElse(null);
                allVersions = allReleases.stream().map(r -> r.getVersion()).toList();
                allReleasesEtagMap.put(uri, allReleasesEtag);
                allVersionsMap.put(uri, allVersions);
                return allVersions;
            }
            if (code == 304) {
                return allVersions;
            }
        }
        catch (Exception e) {
            logger.error("Error requesting all releases: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public static synchronized ReleaseVersion checkForUpdate() throws URISyntaxException, IOException, InterruptedException {
        return UpdateChecker.checkForUpdate(GitHubProject.GitHubRepo.create("QuPath", "qupath", "qupath"));
    }

    public static synchronized ReleaseVersion checkForUpdate(GitHubProject.GitHubRepo repository) throws URISyntaxException, IOException, InterruptedException {
        String name = repository.getName();
        String owner = repository.getOwner();
        String repo = repository.getRepo();
        if (!UpdateChecker.isValidOwnerOrRepo(owner) || !UpdateChecker.isValidOwnerOrRepo(repo)) {
            logger.warn("Cannot check for updates with owner={}, repo={}", (Object)owner, (Object)repo);
            return null;
        }
        URI uri = new URI("https://api.github.com/repos/" + owner + "/" + repo + "/releases/latest");
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).header("Accept", "application/vnd.github.v3+json").GET();
        String etag = etagMap.getOrDefault(uri, null);
        ReleaseVersion latestVersion = latestVersionMap.getOrDefault(uri, null);
        String lastModified = lastModifiedMap.getOrDefault(uri, null);
        if (etag != null) {
            builder.header("If-None-Match", etag);
        }
        if (lastModified != null) {
            builder.header("If-Modified-Since", lastModified);
        }
        HttpRequest request = builder.build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        HttpHeaders headers = response.headers();
        int code = response.statusCode();
        switch (code) {
            case 200: {
                String json = response.body();
                ReleaseGH release = (ReleaseGH)GsonTools.getInstance().fromJson(json, ReleaseGH.class);
                etag = headers.firstValue("ETag").orElse(null);
                lastModified = headers.firstValue("Last-Modified").orElse(null);
                latestVersion = ReleaseVersion.create(name, release.getVersion(), release.getURI());
                etagMap.put(uri, etag);
                lastModifiedMap.put(uri, lastModified);
                latestVersionMap.put(uri, latestVersion);
                return latestVersion;
            }
            case 304: {
                logger.debug("Nothing changed since last update check (code 304), latest version {}", (Object)latestVersion);
                return latestVersion;
            }
            case 301: 
            case 302: 
            case 307: {
                logger.warn("Attempted redirect to {}, but I don't want to follow redirects", headers.firstValue("Location"));
                return null;
            }
            case 404: {
                logger.warn("Update check failed (code {}). This may mean there are no stable releases available.", (Object)code);
                return null;
            }
        }
        logger.warn("Update check failed (code {})", (Object)code);
        return null;
    }

    private static boolean isValidOwnerOrRepo(String name) {
        return name != null && !name.isBlank() && GeneralTools.isValidFilename((String)name);
    }

    public static class ReleaseVersion {
        private final String name;
        private final Version version;
        private final URI uri;

        private ReleaseVersion(String name, Version version, URI uri) {
            this.name = name;
            this.version = version;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }

        public URI getUri() {
            return this.uri;
        }

        public static ReleaseVersion create(String name, Version version, URI uri) {
            return new ReleaseVersion(name, version, uri);
        }

        public String toString() {
            if (this.uri == null) {
                return String.format("%s %s (no URI)", this.name, this.version);
            }
            return String.format("%s %s (%s)", this.name, this.version, this.uri);
        }
    }

    private static class ReleaseGH {
        private URL html_url;
        private String tag_name;
        private String name;
        private boolean prerelease;
        private String created_at;
        private transient Version version;

        private ReleaseGH() {
        }

        public synchronized Version getVersion() {
            if (this.version == null) {
                this.version = ReleaseGH.tryToParseVersion(this.name);
                if (this.version == null) {
                    this.version = ReleaseGH.tryToParseVersion(this.tag_name);
                }
                if (this.version == null) {
                    this.version = Version.UNKNOWN;
                }
            }
            return this.version;
        }

        public synchronized URI getURI() {
            try {
                return this.html_url == null ? null : this.html_url.toURI();
            }
            catch (URISyntaxException e) {
                logger.error("Cannot parse URI: " + e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }

        private static Version tryToParseVersion(String name) {
            try {
                return Version.parse((String)name);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            return String.format("%s (name=%s, tag=%s)", this.getVersion(), this.name, this.tag_name);
        }
    }
}

