/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.extensions;

import java.util.Objects;

public interface GitHubProject {
    public GitHubRepo getRepository();

    public static class GitHubRepo {
        private final String name;
        private final String owner;
        private final String repo;

        private GitHubRepo(String name, String owner, String repo) {
            this.name = name;
            this.owner = owner;
            this.repo = repo;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getRepo() {
            return this.repo;
        }

        public String getName() {
            return this.name;
        }

        public String getUrlString() {
            return "https://github.com/" + this.owner + "/" + this.repo;
        }

        public String toString() {
            return this.name + " (owner=" + this.owner + ", repo=" + this.repo + ")";
        }

        public static GitHubRepo create(String name, String owner, String repo) {
            return new GitHubRepo(name, owner, repo);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.owner, this.repo);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GitHubRepo other = (GitHubRepo)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.owner, other.owner) && Objects.equals(this.repo, other.repo);
        }
    }
}

