/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.dialogs.QuPathChooser;

@Deprecated
class QuPathChooserFX
implements QuPathChooser {
    private static final Logger logger = LoggerFactory.getLogger(QuPathChooserFX.class);
    private Window ownerWindow = null;
    private FileChooser fileChooser = new FileChooser();
    private DirectoryChooser directoryChooser = new DirectoryChooser();
    private FileChooser.ExtensionFilter allFiles = new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"});
    private File lastDir;

    public QuPathChooserFX(Window ownerWindow) {
        this.ownerWindow = ownerWindow;
    }

    @Override
    public void setLastDirectory(File dir) {
        if (dir == null) {
            this.lastDir = null;
        } else {
            if (dir.isDirectory()) {
                if (dir.exists()) {
                    this.lastDir = dir;
                }
                return;
            }
            this.setLastDirectory(dir.getParentFile());
        }
    }

    @Override
    public File getLastDirectory() {
        if (this.lastDir != null && this.lastDir.isDirectory()) {
            return this.lastDir;
        }
        return null;
    }

    private File getUsefulBaseDirectory(File dirBase) {
        if (dirBase == null || !dirBase.isDirectory()) {
            return this.getLastDirectory();
        }
        return dirBase;
    }

    @Override
    public File promptForDirectory(String title, File dirBase) {
        if (!Platform.isFxApplicationThread()) {
            return (File)FXUtils.callOnApplicationThread(() -> this.promptForDirectory(title, dirBase));
        }
        File lastDir = this.getLastDirectory();
        this.directoryChooser.setTitle(title);
        this.directoryChooser.setInitialDirectory(this.getUsefulBaseDirectory(dirBase));
        File dirSelected = this.directoryChooser.showDialog(this.ownerWindow);
        if (dirSelected != null) {
            if (dirBase == null) {
                this.setLastDirectory(dirSelected);
            } else {
                this.fileChooser.setInitialDirectory(lastDir);
            }
        }
        logger.trace("Returning directory: {}", (Object)dirSelected);
        return dirSelected;
    }

    @Override
    public List<File> promptForMultipleFiles(String title, File dirBase, String filterDescription, String ... exts) {
        if (!Platform.isFxApplicationThread()) {
            return (List)FXUtils.callOnApplicationThread(() -> this.promptForMultipleFiles(title, dirBase, filterDescription, exts));
        }
        File lastDir = this.getLastDirectory();
        this.fileChooser.setInitialDirectory(this.getUsefulBaseDirectory(dirBase));
        if (title != null) {
            this.fileChooser.setTitle(title);
        } else {
            this.fileChooser.setTitle("Choose file");
        }
        if (filterDescription != null && exts != null && exts.length > 0) {
            FileChooser.ExtensionFilter filter = QuPathChooserFX.getExtensionFilter(filterDescription, exts);
            this.fileChooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{filter, this.allFiles});
            this.fileChooser.setSelectedExtensionFilter(filter);
        } else {
            this.fileChooser.getExtensionFilters().clear();
            this.fileChooser.setSelectedExtensionFilter(null);
        }
        List filesSelected = this.fileChooser.showOpenMultipleDialog(this.ownerWindow);
        if (filesSelected != null && !filesSelected.isEmpty()) {
            if (dirBase == null) {
                this.setLastDirectory((File)filesSelected.get(0));
            } else {
                this.fileChooser.setInitialDirectory(lastDir);
            }
        }
        logger.trace("Returning files: {}", (Object)filesSelected);
        return filesSelected;
    }

    /*
     * WARNING - void declaration
     */
    static FileChooser.ExtensionFilter getExtensionFilter(String description, String ... extensions) {
        ArrayList<void> ext = new ArrayList<void>();
        for (String string : extensions) {
            void var6_6;
            if (string.startsWith(".")) {
                String string2 = "*" + string;
            } else if (!string.startsWith("*")) {
                String string3 = "*." + string;
            }
            ext.add(var6_6);
        }
        return new FileChooser.ExtensionFilter(description, ext);
    }

    @Override
    public File promptForFile(String title, File dirBase, String filterDescription, String ... exts) {
        return this.promptForFile(this.ownerWindow, title, dirBase, filterDescription, exts);
    }

    private File promptForFile(Window owner, String title, File dirBase, String filterDescription, String ... exts) {
        if (!Platform.isFxApplicationThread()) {
            return (File)FXUtils.callOnApplicationThread(() -> this.promptForFile(title, dirBase, filterDescription, exts));
        }
        File lastDir = this.getLastDirectory();
        this.fileChooser.setInitialDirectory(this.getUsefulBaseDirectory(dirBase));
        if (title != null) {
            this.fileChooser.setTitle(title);
        } else {
            this.fileChooser.setTitle("Choose file");
        }
        if (filterDescription != null && exts != null && exts.length > 0) {
            FileChooser.ExtensionFilter filter = QuPathChooserFX.getExtensionFilter(filterDescription, exts);
            this.fileChooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{filter, this.allFiles});
            this.fileChooser.setSelectedExtensionFilter(filter);
        } else {
            this.fileChooser.getExtensionFilters().clear();
            this.fileChooser.setSelectedExtensionFilter(null);
        }
        File fileSelected = this.fileChooser.showOpenDialog(owner);
        if (fileSelected != null) {
            if (dirBase == null) {
                this.setLastDirectory(fileSelected);
            } else {
                this.fileChooser.setInitialDirectory(lastDir);
            }
        }
        logger.trace("Returning file: {}", (Object)fileSelected);
        return fileSelected;
    }

    @Override
    public File promptForFile(File dirBase) {
        return this.promptForFile(null, dirBase, null, new String[0]);
    }

    @Override
    public File promptToSaveFile(String title, File dirBase, String defaultName, Map<String, String> filters) {
        if (!Platform.isFxApplicationThread()) {
            return (File)FXUtils.callOnApplicationThread(() -> this.promptToSaveFile(title, dirBase, defaultName, filters));
        }
        File lastDir = this.getLastDirectory();
        this.fileChooser.setInitialDirectory(this.getUsefulBaseDirectory(dirBase));
        if (title != null) {
            this.fileChooser.setTitle(title);
        } else {
            this.fileChooser.setTitle("Save");
        }
        String providedExt = defaultName == null ? null : (String)GeneralTools.getExtension((String)defaultName).orElse(null);
        String defaultExt = null;
        boolean useExtFilter = filters != null && !filters.isEmpty();
        HashMap<FileChooser.ExtensionFilter, String> extFilterMap = new HashMap<FileChooser.ExtensionFilter, String>();
        this.fileChooser.getExtensionFilters().clear();
        this.fileChooser.setSelectedExtensionFilter(null);
        if (useExtFilter) {
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                String filterName = entry.getKey();
                String ext = entry.getValue();
                if (filterName == null || ext == null) continue;
                FileChooser.ExtensionFilter filter = QuPathChooserFX.getExtensionFilter(filterName, ext);
                if (!filter.getExtensions().isEmpty()) {
                    String currentExt = ((String)filter.getExtensions().get(0)).substring(1);
                    if (Objects.equals(currentExt, providedExt)) {
                        defaultExt = providedExt;
                    } else if (defaultExt == null && !filter.getExtensions().isEmpty()) {
                        defaultExt = currentExt;
                    }
                }
                extFilterMap.put(filter, ext);
                this.fileChooser.getExtensionFilters().add((Object)filter);
                if (!Objects.equals(ext, defaultExt)) continue;
                this.fileChooser.setSelectedExtensionFilter(filter);
            }
        } else {
            defaultExt = providedExt;
        }
        if (defaultName != null) {
            if (defaultExt != null && GeneralTools.isMultipartExtension((String)defaultExt) && !defaultName.toLowerCase().endsWith(defaultExt.toLowerCase())) {
                this.fileChooser.setInitialFileName(defaultName + defaultExt);
            } else {
                this.fileChooser.setInitialFileName(defaultName);
            }
        } else {
            this.fileChooser.setInitialFileName(null);
        }
        File fileSelected = this.fileChooser.showSaveDialog(this.ownerWindow);
        if (fileSelected != null) {
            if (dirBase == null) {
                this.setLastDirectory(fileSelected);
            } else {
                this.fileChooser.setInitialDirectory(lastDir);
            }
            Object name = fileSelected.getName();
            String selectedExt = null;
            if (useExtFilter) {
                selectedExt = extFilterMap.getOrDefault(this.fileChooser.getSelectedExtensionFilter(), filters.values().iterator().next());
            }
            if (selectedExt != null && !((String)name).toLowerCase().endsWith(selectedExt.toLowerCase())) {
                String previousName = name;
                if (GeneralTools.isMultipartExtension((String)selectedExt)) {
                    String lastExtPart = selectedExt.substring(selectedExt.lastIndexOf("."));
                    if (((String)name).toLowerCase().endsWith(lastExtPart.toLowerCase())) {
                        name = ((String)name).substring(0, ((String)name).length() - lastExtPart.length());
                    }
                }
                if (((String)name).endsWith(".")) {
                    name = ((String)name).substring(0, ((String)name).length() - 1);
                }
                name = selectedExt.startsWith(".") ? (String)name + selectedExt : (String)name + "." + selectedExt;
                fileSelected = new File(fileSelected.getParentFile(), (String)name);
                logger.warn("Updating name from {} to {}", (Object)previousName, name);
            }
        }
        logger.trace("Returning file to save: {}", (Object)fileSelected);
        return fileSelected;
    }

    @Override
    public String promptForFilePathOrURL(String title, String defaultPath, final File dirBase, final String filterDescription, final String ... exts) {
        if (!Platform.isFxApplicationThread()) {
            return (String)FXUtils.callOnApplicationThread(() -> this.promptForFilePathOrURL(title, defaultPath, dirBase, filterDescription, exts));
        }
        GridPane pane = new GridPane();
        Label label = new Label("Enter URL");
        final TextField tf = new TextField();
        tf.setPrefWidth(400.0);
        final Button button = new Button("Choose file");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Window owner = FXUtils.getWindow((Node)button);
                File file = QuPathChooserFX.this.promptForFile(owner, null, dirBase, filterDescription, exts);
                if (file != null) {
                    tf.setText(file.getAbsolutePath());
                }
            }
        });
        GridPaneUtils.addGridRow((GridPane)pane, (int)0, (int)0, (String)"Input URL or choose file", (Node[])new Node[]{label, tf, button});
        pane.setHgap(5.0);
        if (defaultPath == null) {
            tf.setText("");
        } else {
            tf.setText(defaultPath);
        }
        Alert alert = new Alert(Alert.AlertType.NONE, "Enter image path (file or URL)", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        if (title == null) {
            alert.setTitle("Enter file path or URL");
        } else {
            alert.setTitle(title);
        }
        alert.getDialogPane().setContent((Node)pane);
        String path = null;
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            path = tf.getText().trim();
        }
        logger.trace("Returning path: {}", path);
        return path;
    }

    @Override
    public File promptToSaveFile(String title, File dirBase, String defaultName, String filterName, String ext) {
        if (filterName != null && !filterName.isEmpty() && ext != null && !ext.isEmpty()) {
            return this.promptToSaveFile(title, dirBase, defaultName, Map.of(filterName, ext));
        }
        return this.promptToSaveFile(title, dirBase, defaultName, Collections.emptyMap());
    }
}

