/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.dialogs;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import org.controlsfx.control.ListSelectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.projects.ProjectImageEntry;

public class ProjectDialogs {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDialogs.class);

    public static ListSelectionView<ProjectImageEntry<BufferedImage>> createImageChoicePane(QuPathGUI qupath, List<ProjectImageEntry<BufferedImage>> availableImages, List<ProjectImageEntry<BufferedImage>> selectedImages, String openImageWarning) {
        ListSelectionView listSelectionView = GuiTools.createListSelectionView();
        listSelectionView.getSourceItems().setAll(availableImages);
        listSelectionView.setCellFactory(c -> new ProjectEntryListCell());
        TextField tfFilter = new TextField();
        CheckBox cbWithData = new CheckBox("With data file only");
        tfFilter.setTooltip(new Tooltip("Enter text to filter image list"));
        cbWithData.setTooltip(new Tooltip("Filter image list to only images with associated data files"));
        tfFilter.textProperty().addListener((v, o, n) -> ProjectDialogs.updateImageList((ListSelectionView<ProjectImageEntry<BufferedImage>>)listSelectionView, availableImages, n, cbWithData.selectedProperty().get()));
        cbWithData.selectedProperty().addListener((v, o, n) -> ProjectDialogs.updateImageList((ListSelectionView<ProjectImageEntry<BufferedImage>>)listSelectionView, availableImages, tfFilter.getText(), cbWithData.selectedProperty().get()));
        GridPane paneFooter = new GridPane();
        paneFooter.setMaxWidth(Double.MAX_VALUE);
        cbWithData.setMaxWidth(Double.MAX_VALUE);
        paneFooter.add((Node)tfFilter, 0, 0);
        paneFooter.add((Node)cbWithData, 0, 1);
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{tfFilter, cbWithData});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{tfFilter, cbWithData});
        cbWithData.setMinWidth(Double.NEGATIVE_INFINITY);
        paneFooter.setVgap(5.0);
        listSelectionView.setSourceFooter((Node)paneFooter);
        Label labelSameImageWarning = new Label(openImageWarning);
        Label labelSelected = new Label();
        labelSelected.setTextAlignment(TextAlignment.CENTER);
        labelSelected.setAlignment(Pos.CENTER);
        labelSelected.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)labelSelected, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)labelSelected, (Boolean)Boolean.TRUE);
        ObservableList targetItems = listSelectionView.getTargetItems();
        targetItems.addListener(e -> {
            labelSelected.setText(e.getList().size() + " selected");
            Collection<ProjectImageEntry<BufferedImage>> currentImages = ProjectDialogs.getCurrentImages(qupath);
            if (labelSameImageWarning != null && currentImages != null) {
                boolean visible = false;
                ObservableList targets = e.getList();
                for (ProjectImageEntry<BufferedImage> current : currentImages) {
                    if (!targets.contains(current)) continue;
                    visible = true;
                    break;
                }
                labelSameImageWarning.setVisible(visible);
            }
        });
        GridPane paneSelected = new GridPane();
        GridPaneUtils.addGridRow((GridPane)paneSelected, (int)0, (int)0, (String)"Selected images", (Node[])new Node[]{labelSelected});
        if (openImageWarning != null) {
            labelSameImageWarning.setTextFill((Paint)Color.RED);
            labelSameImageWarning.setMaxWidth(Double.MAX_VALUE);
            labelSameImageWarning.setMinHeight(Double.NEGATIVE_INFINITY);
            labelSameImageWarning.setTextAlignment(TextAlignment.CENTER);
            labelSameImageWarning.setAlignment(Pos.CENTER);
            labelSameImageWarning.setVisible(false);
            GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{labelSameImageWarning});
            GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{labelSameImageWarning});
            GridPaneUtils.addGridRow((GridPane)paneSelected, (int)1, (int)0, (String)openImageWarning, (Node[])new Node[]{labelSameImageWarning});
        }
        listSelectionView.setTargetFooter((Node)paneSelected);
        if (selectedImages != null && !selectedImages.isEmpty()) {
            listSelectionView.getSourceItems().removeAll(selectedImages);
            listSelectionView.getTargetItems().addAll(selectedImages);
        }
        return listSelectionView;
    }

    public static Collection<ProjectImageEntry<BufferedImage>> getCurrentImages(QuPathGUI qupath) {
        return qupath.getAllViewers().stream().map(v -> {
            ImageData<BufferedImage> imageData = v.getImageData();
            return imageData == null ? null : qupath.getProject().getEntry(imageData);
        }).filter(d -> d != null).collect(Collectors.toSet());
    }

    private static void updateImageList(ListSelectionView<ProjectImageEntry<BufferedImage>> listSelectionView, List<ProjectImageEntry<BufferedImage>> availableImages, String filterText, boolean withDataOnly) {
        boolean ignoreCase = true;
        String text = filterText.trim();
        if (ignoreCase) {
            text = text.toLowerCase();
        }
        ArrayList<ProjectImageEntry<BufferedImage>> sourceItems = new ArrayList<ProjectImageEntry<BufferedImage>>(availableImages);
        ObservableList targetItems = listSelectionView.getTargetItems();
        sourceItems.removeAll((Collection<?>)targetItems);
        if (withDataOnly) {
            sourceItems.removeIf(p -> !p.hasImageData());
            targetItems.removeIf(p -> !p.hasImageData());
        }
        if (text.length() > 0 && text.replaceAll("|", "").length() > 0 && !sourceItems.isEmpty()) {
            int indSplit = filterText.indexOf("|");
            List<Object> filterTokens = indSplit >= 0 ? Arrays.stream(filterText.split("\\|")).filter(t -> !t.isBlank()).toList() : Collections.emptyList();
            Iterator iter = sourceItems.iterator();
            block0: while (iter.hasNext()) {
                ProjectImageEntry entry = (ProjectImageEntry)iter.next();
                String imageName = entry.getImageName();
                if (ignoreCase) {
                    imageName = imageName.toLowerCase();
                }
                if (imageName.contains(text)) continue;
                if (filterTokens.isEmpty()) {
                    iter.remove();
                    continue;
                }
                List<String> metadataStrings = entry.getMetadataMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).map(t -> ignoreCase ? t.toLowerCase() : t).toList();
                for (String string : filterTokens) {
                    boolean foundMatch = imageName.contains(string);
                    if (!foundMatch) {
                        for (String m : metadataStrings) {
                            if (!m.contains(string)) continue;
                            foundMatch = true;
                            break;
                        }
                    }
                    if (foundMatch) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
        if (listSelectionView.getSourceItems().equals(sourceItems)) {
            return;
        }
        listSelectionView.getSourceItems().setAll(sourceItems);
    }

    private static class ProjectEntryListCell
    extends ListCell<ProjectImageEntry<BufferedImage>> {
        private Tooltip tooltip = new Tooltip();
        private ImageView imageView = new ImageView();

        private ProjectEntryListCell() {
            this.imageView.setFitWidth(250.0);
            this.imageView.setFitHeight(250.0);
            this.imageView.setPreserveRatio(true);
        }

        protected void updateItem(ProjectImageEntry<BufferedImage> item, boolean empty) {
            super.updateItem(item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
                return;
            }
            this.setText(item.getImageName());
            ImageView tooltipGraphic = null;
            BufferedImage img = null;
            try {
                img = (BufferedImage)item.getThumbnail();
                if (img != null) {
                    this.imageView.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)img, null));
                    tooltipGraphic = this.imageView;
                }
            }
            catch (Exception e) {
                logger.debug("Unable to read thumbnail for {} ({})" + item.getImageName(), (Object)e.getLocalizedMessage());
            }
            this.tooltip.setText(item.getSummary());
            if (tooltipGraphic != null) {
                this.tooltip.setGraphic((Node)tooltipGraphic);
            } else {
                this.tooltip.setGraphic(null);
            }
            this.setTooltip(this.tooltip);
        }
    }
}

