/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.dialogs;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.plugins.parameters.BooleanParameter;
import qupath.lib.plugins.parameters.ChoiceParameter;
import qupath.lib.plugins.parameters.DoubleParameter;
import qupath.lib.plugins.parameters.EmptyParameter;
import qupath.lib.plugins.parameters.IntParameter;
import qupath.lib.plugins.parameters.NumericParameter;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterChangeListener;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.parameters.StringParameter;

public class ParameterPanelFX {
    private final List<ParameterChangeListener> listeners = Collections.synchronizedList(new ArrayList());
    private static final Logger logger = LoggerFactory.getLogger(ParameterPanelFX.class);
    private static int DEFAULT_NUMERIC_TEXT_COLS = 8;
    private final GridPane pane;
    private final ParameterList params;
    private final Map<Parameter<?>, Node> map = new HashMap();
    private int currentRow = 0;

    public ParameterPanelFX(ParameterList params) {
        this(params, new GridPane());
    }

    private ParameterPanelFX(ParameterList params, GridPane gridPane) {
        this.params = params;
        this.pane = gridPane == null ? new GridPane() : gridPane;
        this.initialize();
        this.pane.setVgap(4.0);
        this.pane.setHgap(4.0);
    }

    public ParameterList getParameters() {
        return this.params;
    }

    public Pane getPane() {
        return this.pane;
    }

    private void initialize() {
        block8: for (Map.Entry entry : this.params.getParameters().entrySet()) {
            Parameter parameter;
            String key = (String)entry.getKey();
            Parameter p = (Parameter)entry.getValue();
            if (p.isHidden()) continue;
            Objects.requireNonNull(p);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DoubleParameter.class, IntParameter.class, StringParameter.class, EmptyParameter.class, ChoiceParameter.class, BooleanParameter.class}, (Object)parameter, n)) {
                case 0: {
                    DoubleParameter doubleParameter = (DoubleParameter)parameter;
                    this.addDoubleParameter(key, doubleParameter);
                    continue block8;
                }
                case 1: {
                    IntParameter intParameter = (IntParameter)parameter;
                    this.addIntParameter(key, intParameter);
                    continue block8;
                }
                case 2: {
                    StringParameter stringParameter = (StringParameter)parameter;
                    this.addStringParameter(key, stringParameter);
                    continue block8;
                }
                case 3: {
                    EmptyParameter emptyParameter = (EmptyParameter)parameter;
                    this.addEmptyParameter(emptyParameter);
                    continue block8;
                }
                case 4: {
                    ChoiceParameter choiceParameter = (ChoiceParameter)parameter;
                    this.addChoiceParameter(key, (ChoiceParameter<Object>)choiceParameter);
                    continue block8;
                }
                case 5: {
                    BooleanParameter booleanParameter = (BooleanParameter)parameter;
                    this.addBooleanParameter(key, booleanParameter);
                    continue block8;
                }
            }
            logger.warn("Unknown parameter type: {}", (Object)p.getClass().getName());
        }
    }

    public void addParameterChangeListener(ParameterChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeParameterChangeListener(ParameterChangeListener listener) {
        this.listeners.remove(listener);
    }

    private String getKey(Parameter<?> param) {
        for (Map.Entry entry : this.params.getParameters().entrySet()) {
            if (!((Parameter)entry.getValue()).equals(param)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private void fireParameterChangedEvent(Parameter<?> param, boolean isAdjusting) {
        String key = this.getKey(param);
        if (key != null) {
            for (ParameterChangeListener listener : this.listeners) {
                listener.parameterChanged(this.params, key, isAdjusting);
            }
        }
    }

    private void addBooleanParameter(String key, BooleanParameter param) {
        this.addCheckBoxParameter(key, param);
    }

    private void addDoubleParameter(String key, DoubleParameter param) {
        if (param.hasLowerAndUpperBounds()) {
            this.addSliderParameter(key, param);
        } else {
            this.addNumericTextField(key, (NumericParameter<? extends Number>)param);
        }
    }

    private void addIntParameter(String key, IntParameter param) {
        if (param.hasLowerAndUpperBounds()) {
            this.addSliderParameter(key, param);
        } else {
            this.addNumericTextField(key, (NumericParameter<? extends Number>)param);
        }
    }

    private void addNumericTextField(String key, NumericParameter<? extends Number> param) {
        TextField tf = this.getTextField((Parameter<?>)param, DEFAULT_NUMERIC_TEXT_COLS, key);
        if (param.getUnit() != null) {
            HBox panel = new HBox();
            panel.getChildren().add((Object)tf);
            Label label = new Label(param.getUnit());
            label.setPadding(new Insets(0.0, 0.0, 0.0, 4.0));
            panel.getChildren().add((Object)label);
            this.addParamComponent((Parameter<?>)param, param.getPrompt(), (Node)panel);
        } else {
            Pane panel = new Pane();
            panel.getChildren().add((Object)tf);
            this.addParamComponent((Parameter<?>)param, param.getPrompt(), (Node)panel);
        }
    }

    private void addStringParameter(String key, StringParameter param) {
        this.addParamComponent((Parameter<?>)param, param.getPrompt(), (Node)this.getTextField((Parameter<?>)param, 25, key));
    }

    private void addEmptyParameter(EmptyParameter param) {
        Label label = new Label(param.getPrompt());
        if (param.isTitle()) {
            label.setStyle("-fx-font-weight: bold;");
            if (!this.map.isEmpty()) {
                label.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
            }
        }
        this.addParamComponent((Parameter<?>)param, null, (Node)label);
    }

    private void addChoiceParameter(String key, ChoiceParameter<Object> param) {
        ComboBox combo = new ComboBox();
        combo.getItems().setAll((Collection)param.getChoices());
        combo.getSelectionModel().select(param.getValueOrDefault());
        combo.setOnAction(e -> {
            if (param.setValue(combo.getSelectionModel().getSelectedItem())) {
                this.fireParameterChangedEvent((Parameter<?>)param, false);
            }
        });
        combo.setMaxWidth(Double.MAX_VALUE);
        if (key != null) {
            combo.setId(key);
        }
        this.addParamComponent((Parameter<?>)param, param.getPrompt(), (Node)combo);
    }

    private void addCheckBoxParameter(String key, BooleanParameter param) {
        CheckBox cb = new CheckBox(param.getPrompt());
        cb.setSelected(((Boolean)param.getValueOrDefault()).booleanValue());
        cb.setMinWidth(-1.0);
        cb.setMaxWidth(Double.MAX_VALUE);
        cb.selectedProperty().addListener((v, o, n) -> {
            if (param.setValue((Object)cb.isSelected())) {
                this.fireParameterChangedEvent((Parameter<?>)param, false);
            }
        });
        if (key != null) {
            cb.setId(key);
        }
        this.addParamComponent((Parameter<?>)param, null, (Node)cb);
    }

    private void addSliderParameter(String key, IntParameter param) {
        int min = (int)param.getLowerBound();
        int max = (int)(param.getUpperBound() + 0.5);
        Slider slider = new Slider((double)min, (double)max, (double)((Integer)param.getValueOrDefault()).intValue());
        TextField tf = new TextField();
        if (key != null) {
            tf.setId(key);
        }
        tf.setEditable(false);
        tf.setText("" + slider.getValue());
        tf.setPrefColumnCount(DEFAULT_NUMERIC_TEXT_COLS);
        ParameterSliderChangeListener listener = new ParameterSliderChangeListener(slider, (NumericParameter<?>)param, tf);
        slider.valueProperty().addListener((v, o, n) -> listener.handleSliderUpdate());
        BorderPane panel = new BorderPane();
        panel.setCenter((Node)slider);
        panel.setRight((Node)tf);
        this.addParamComponent((Parameter<?>)param, param.getPrompt(), (Node)panel);
    }

    private void addSliderParameter(String key, DoubleParameter param) {
        Slider slider = new Slider(param.getLowerBound(), param.getUpperBound(), ((Double)param.getValueOrDefault()).doubleValue());
        TextField tf = new TextField();
        if (key != null) {
            tf.setId(key);
        }
        tf.setPrefColumnCount(DEFAULT_NUMERIC_TEXT_COLS);
        ParameterPanelFX.setTextFieldFromNumber(tf, (Number)param.getValueOrDefault(), param.getUnit());
        tf.setEditable(false);
        ParameterSliderChangeListener listener = new ParameterSliderChangeListener(slider, (NumericParameter<?>)param, tf);
        slider.valueProperty().addListener((v, o, n) -> listener.handleSliderUpdate());
        BorderPane panel = new BorderPane();
        panel.setCenter((Node)slider);
        panel.setRight((Node)tf);
        this.addParamComponent((Parameter<?>)param, param.getPrompt(), (Node)panel);
    }

    protected static void setTextFieldFromNumber(TextField text, Number value, String unit) {
        Object s;
        if (value == null) {
            s = "";
        } else {
            if (value instanceof Long || value instanceof BigInteger) {
                s = String.format("%d", value.longValue());
            } else {
                double v = value.doubleValue();
                double log10 = Math.round(Math.log10(v));
                int ndp = (int)Math.max(4.0, -log10 + 2.0);
                s = GeneralTools.formatNumber((double)v, (int)ndp);
            }
            if (unit != null) {
                s = (String)s + " " + unit;
            }
        }
        if (!text.getText().equals(s)) {
            text.setText((String)s);
        }
    }

    protected TextField getTextField(Parameter<?> param, int cols, String key) {
        TextField tf = new TextField();
        Object defaultVal = param.getValueOrDefault();
        if (defaultVal instanceof Number) {
            tf.setText(NumberFormat.getInstance().format(defaultVal));
        } else if (defaultVal != null) {
            tf.setText(defaultVal.toString());
        }
        if (cols > 0) {
            tf.setPrefColumnCount(cols);
        }
        if (key != null) {
            tf.setId(key);
        }
        tf.textProperty().addListener((v, o, n) -> {
            if (n != null && param.setStringLastValue(Locale.getDefault(Locale.Category.FORMAT), n)) {
                this.fireParameterChangedEvent(param, false);
            }
        });
        return tf;
    }

    private void addParamComponent(Parameter<?> parameter, String text, Node component) {
        this.map.put(parameter, component);
        String help = parameter.getHelpText();
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{component});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{component});
        if (text == null) {
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)this.currentRow++, (int)0, (String)help, (Node[])new Node[]{component, component});
        } else {
            Label label = new Label(text);
            label.setMaxWidth(Double.MAX_VALUE);
            label.setMinWidth(Double.NEGATIVE_INFINITY);
            label.setLabelFor(component);
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)this.currentRow++, (int)0, (String)help, (Node[])new Node[]{label, component});
        }
    }

    public boolean getParameterEnabled(String key) {
        return this.getParameterEnabled((Parameter)this.params.getParameters().get(key));
    }

    public boolean getParameterEnabled(Parameter<?> param) {
        Node comp = this.map.get(param);
        return comp != null && !comp.isDisabled();
    }

    public void setParameterEnabled(String key, boolean enabled) {
        this.setParameterEnabled((Parameter)this.params.getParameters().get(key), enabled);
    }

    public void setParameterEnabled(Parameter<?> param, boolean enabled) {
        Node comp = this.map.get(param);
        if (comp != null) {
            ParameterPanelFX.setEnabledRecursively(comp, enabled);
        }
    }

    private static void setEnabledRecursively(Node comp, boolean enabled) {
        comp.setDisable(!enabled);
    }

    public boolean setNumericParameterValue(String key, Number value) {
        Parameter parameterOrig = (Parameter)this.params.getParameters().get(key);
        if (parameterOrig == null || !(parameterOrig instanceof NumericParameter)) {
            logger.warn("Unable to set parameter {} with value {} - no numeric parameter found with that key", (Object)key, (Object)value);
            return false;
        }
        NumericParameter parameter = (NumericParameter)parameterOrig;
        Node component = this.map.get(parameter);
        if (component == null) {
            parameter.setDoubleLastValue(value.doubleValue());
            return true;
        }
        if (component instanceof Parent) {
            for (Node comp : ((Parent)component).getChildrenUnmodifiable()) {
                if (!(comp instanceof TextField)) continue;
                TextField textField = (TextField)comp;
                ParameterPanelFX.setTextFieldFromNumber(textField, value, parameter.getUnit());
                return true;
            }
        }
        logger.warn("Unable to set parameter {} with value {} - no component found", (Object)key, (Object)value);
        return false;
    }

    public boolean setNumericParameterValueRange(String key, double minValue, double maxValue) {
        Parameter parameterOrig = (Parameter)this.params.getParameters().get(key);
        if (parameterOrig == null || !(parameterOrig instanceof NumericParameter)) {
            logger.warn("Unable to set range for {} - no numeric parameter found with that key", (Object)key);
            return false;
        }
        NumericParameter parameter = (NumericParameter)parameterOrig;
        try {
            parameter.setRange(minValue, maxValue);
            Node component = this.map.get(parameter);
            if (component instanceof Parent) {
                for (Node comp : ((Parent)component).getChildrenUnmodifiable()) {
                    if (!(comp instanceof Slider)) continue;
                    Slider slider = (Slider)comp;
                    slider.setMin(minValue);
                    slider.setMax(maxValue);
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to set range for {}: {}", (Object)parameter, (Object)e.getLocalizedMessage());
        }
        return false;
    }

    static void demoParameterPanel() {
        new JFXPanel();
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(ParameterPanelFX::demoParameterPanel);
            return;
        }
        Stage frame = new Stage();
        frame.setTitle("Testing parameter panel");
        int k = 0;
        ParameterList params = new ParameterList().addTitleParameter("Parameter list").addEmptyParameter("Here is a list of parameters that I am testing out").addIntParameter(Integer.toString(k++), "Enter an int", 5, "px", "Unbounded int").addDoubleParameter(Integer.toString(k++), "Enter a double", 5.2, "microns", "Unbounded double").addDoubleParameter(Integer.toString(k++), "Enter a double in range", 5.2, null, 1.0, 10.0, "Bounded double").addIntParameter(Integer.toString(k++), "Enter an int in range", 5, null, 1.0, 10.0, "Bounded int").addStringParameter(Integer.toString(k++), "Enter a string", "Default here").addChoiceParameter(Integer.toString(k++), "Choose a choice", (Object)"Two", Arrays.asList("One", "Two", "Three"), "Simple choice").addChoiceParameter(Integer.toString(k++), "Choose a number choice", (Object)2, Arrays.asList(1, 2, 3), "Numeric choice").addBooleanParameter(Integer.toString(k++), "Check me out", true);
        BorderPane borderPane = new BorderPane();
        ParameterPanelFX panel = new ParameterPanelFX(params);
        final TextArea textArea = new TextArea();
        for (Parameter p : params.getParameters().values()) {
            textArea.setText(textArea.getText() + String.valueOf(p) + "\n");
        }
        panel.addParameterChangeListener(new ParameterChangeListener(){

            public void parameterChanged(ParameterList params, String key, boolean isAdjusting) {
                textArea.setText("");
                for (Parameter p : params.getParameters().values()) {
                    textArea.setText(textArea.getText() + String.valueOf(p) + "\n");
                }
            }
        });
        borderPane.setCenter((Node)panel.getPane());
        borderPane.setBottom((Node)textArea);
        frame.setScene(new Scene((Parent)borderPane));
        frame.show();
    }

    class ParameterSliderChangeListener {
        private Slider slider;
        private NumericParameter<?> param;
        private TextField text;
        private boolean sliderChanging = false;
        private boolean textChanging = false;

        public ParameterSliderChangeListener(Slider slider, NumericParameter<?> param, TextField text) {
            this.slider = slider;
            this.param = param;
            this.text = text;
            this.text.setEditable(true);
            this.text.textProperty().addListener((v, o, n) -> this.handleTextUpdate());
        }

        public void handleSliderUpdate() {
            if (this.textChanging) {
                return;
            }
            this.sliderChanging = true;
            double val = this.slider.getValue();
            if (this.param.setDoubleLastValue(val)) {
                if (this.text != null) {
                    ParameterPanelFX.setTextFieldFromNumber(this.text, (Number)this.param.getValueOrDefault(), this.param.getUnit());
                }
                ParameterPanelFX.this.fireParameterChangedEvent((Parameter<?>)this.param, this.slider.isValueChanging());
            }
            this.sliderChanging = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleTextUpdate() {
            if (this.sliderChanging) {
                return;
            }
            String s = this.text.getText();
            if (s == null || s.trim().length() == 0) {
                return;
            }
            try {
                String unit = this.param.getUnit();
                if (unit != null) {
                    s = s.toLowerCase().replace(unit.toLowerCase(), "").trim();
                }
                if (s.length() == 0) {
                    return;
                }
                double val = NumberFormat.getInstance().parse(s).doubleValue();
                double previousValue = ((Number)this.param.getValueOrDefault()).doubleValue();
                if (Double.isNaN(val) || val == previousValue) {
                    return;
                }
                this.textChanging = true;
                this.param.setDoubleLastValue(val);
                this.slider.setValue(val);
                ParameterPanelFX.this.fireParameterChangedEvent((Parameter<?>)this.param, this.slider.isValueChanging());
                this.textChanging = false;
            }
            catch (Exception e) {
                logger.debug("Cannot parse number from {} - will keep default of {}", (Object)s, this.param.getValueOrDefault());
            }
            finally {
                this.textChanging = false;
            }
        }
    }
}

