/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javafx.application.ColorScheme;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.controlsfx.control.Notifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.LogTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.dialogs.QuPathChooser;
import qupath.lib.gui.dialogs.QuPathChooserFX;
import qupath.lib.gui.prefs.QuPathStyleManager;
import qupath.lib.plugins.parameters.ParameterList;

@Deprecated
public class Dialogs {
    private static final Logger logger = LoggerFactory.getLogger(Dialogs.class);
    private static QuPathChooser defaultFileChooser = new QuPathChooserFX(null);
    private static Map<Window, QuPathChooser> fileChooserMap = new WeakHashMap<Window, QuPathChooser>();

    public static boolean showConfirmDialog(String title, String text) {
        return Dialogs.showConfirmDialog(title, (Node)Dialogs.createContentLabel(text));
    }

    private static void logDeprecated() {
        LogTools.warnOnce((Logger)logger, (String)"qupath.lib.gui.dialogs.Dialogs is deprecated and will be removed in the next QuPath release - please use qupath.fx.dialogs.Dialogs for dialogs instead");
    }

    private static void logDeprecatedChoosers() {
        LogTools.warnOnce((Logger)logger, (String)"qupath.lib.gui.dialogs.Dialogs is deprecated and will be removed in the next QuPath release - please use qupath.fx.dialogs.FileChoosers for file/directory choosers instead");
    }

    public static boolean showMessageDialog(String title, Node node) {
        return new Builder().buttons(ButtonType.OK).title(title).content(node).resizable().showAndWait().orElse(ButtonType.CANCEL) == ButtonType.OK;
    }

    public static boolean showMessageDialog(String title, String message) {
        return Dialogs.showMessageDialog(title, (Node)Dialogs.createContentLabel(message));
    }

    public static boolean showConfirmDialog(String title, Node node) {
        Dialogs.logDeprecated();
        return qupath.fx.dialogs.Dialogs.showConfirmDialog((String)title, (Node)node);
    }

    public static boolean showYesNoDialog(String title, String text) {
        Dialogs.logDeprecated();
        return new Builder().alertType(Alert.AlertType.NONE).buttons(ButtonType.YES, ButtonType.NO).title(title).content((Node)Dialogs.createContentLabel(text)).showAndWait().orElse(ButtonType.NO) == ButtonType.YES;
    }

    private static Label createContentLabel(String text) {
        Label label = new Label(text);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public static DialogButton showYesNoCancelDialog(String title, String text) {
        Dialogs.logDeprecated();
        ButtonType result = new Builder().alertType(Alert.AlertType.NONE).buttons(ButtonType.YES, ButtonType.NO, ButtonType.CANCEL).title(title).content((Node)Dialogs.createContentLabel(text)).resizable().showAndWait().orElse(ButtonType.CANCEL);
        return Dialogs.getJavaFXPaneYesNoCancel(result);
    }

    private static DialogButton getJavaFXPaneYesNoCancel(ButtonType buttonType) {
        if (buttonType == ButtonType.YES) {
            return DialogButton.YES;
        }
        if (buttonType == ButtonType.NO) {
            return DialogButton.NO;
        }
        if (buttonType == ButtonType.CANCEL) {
            return DialogButton.CANCEL;
        }
        return null;
    }

    public static boolean showParameterDialog(String title, ParameterList params) {
        return Dialogs.showConfirmDialog(title, (Node)new ParameterPanelFX(params).getPane());
    }

    public static Double showInputDialog(String title, String message, Double initialInput) {
        if (Platform.isFxApplicationThread()) {
            Dialogs.logDeprecated();
            TextInputDialog dialog = new TextInputDialog(initialInput.toString());
            FXUtils.restrictTextFieldInputToNumber((TextField)dialog.getEditor(), (boolean)true);
            dialog.setTitle(title);
            if (QuPathGUI.getInstance() != null) {
                dialog.initOwner(Dialogs.getDefaultOwner());
            }
            dialog.setHeaderText(null);
            dialog.setContentText(message);
            dialog.setResizable(true);
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                try {
                    return Double.parseDouble((String)result.get());
                }
                catch (Exception e) {
                    logger.error("Unable to parse numeric value from {}", (Object)result);
                    return Double.NaN;
                }
            }
        } else {
            return (Double)FXUtils.callOnApplicationThread(() -> Dialogs.showInputDialog(title, message, initialInput));
        }
        return null;
    }

    public static String showInputDialog(String title, String message, String initialInput) {
        Dialogs.logDeprecated();
        if (Platform.isFxApplicationThread()) {
            Dialogs.logDeprecated();
            TextInputDialog dialog = new TextInputDialog(initialInput);
            dialog.setTitle(title);
            if (QuPathGUI.getInstance() != null) {
                dialog.initOwner(Dialogs.getDefaultOwner());
            }
            dialog.setHeaderText(null);
            dialog.setContentText(message);
            dialog.setResizable(true);
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                return (String)result.get();
            }
        } else {
            return (String)FXUtils.callOnApplicationThread(() -> Dialogs.showInputDialog(title, message, initialInput));
        }
        return null;
    }

    public static <T> T showChoiceDialog(String title, String message, T[] choices, T defaultChoice) {
        return Dialogs.showChoiceDialog(title, message, Arrays.asList(choices), defaultChoice);
    }

    public static <T> T showChoiceDialog(String title, String message, Collection<T> choices, T defaultChoice) {
        if (Platform.isFxApplicationThread()) {
            Optional result;
            Dialogs.logDeprecated();
            ChoiceDialog dialog = new ChoiceDialog(defaultChoice, choices);
            dialog.setTitle(title);
            if (QuPathGUI.getInstance() != null) {
                dialog.initOwner(Dialogs.getDefaultOwner());
            }
            dialog.getDialogPane().setHeaderText(null);
            if (message != null) {
                dialog.getDialogPane().setContentText(message);
            }
            if ((result = dialog.showAndWait()).isPresent()) {
                return result.get();
            }
            return null;
        }
        return (T)FXUtils.callOnApplicationThread(() -> Dialogs.showChoiceDialog(title, message, choices, defaultChoice));
    }

    public static void showErrorMessage(String title, Throwable e) {
        Object message = e.getLocalizedMessage();
        if (message == null) {
            message = "QuPath has encountered a problem, sorry.\nIf you can replicate it, please report it with 'Help -> Report bug (web)'.\n\n" + String.valueOf(e);
        }
        Dialogs.showErrorMessage(title, (String)message);
        logger.error(title, e);
    }

    public static void showErrorNotification(String title, Throwable e) {
        Object message = e.getLocalizedMessage();
        if (message != null && !((String)message).isBlank() && !((String)message).equals(title)) {
            logger.error(title + ": " + e.getLocalizedMessage(), e);
        } else {
            logger.error(title, e);
        }
        if (message == null) {
            message = "QuPath has encountered a problem, sorry.\nIf you can replicate it, please report it with 'Help > Report bug'.\n\n" + String.valueOf(e);
        }
        if (!Dialogs.isHeadless()) {
            Dialogs.showNotifications(Dialogs.createNotifications().title(title).text((String)message), Alert.AlertType.ERROR);
        }
    }

    public static void showErrorNotification(String title, String message) {
        logger.error(title + ": " + message);
        if (!Dialogs.isHeadless()) {
            Dialogs.showNotifications(Dialogs.createNotifications().title(title).text(message), Alert.AlertType.ERROR);
        }
    }

    public static void showWarningNotification(String title, String message) {
        logger.warn(title + ": " + message);
        if (!Dialogs.isHeadless()) {
            Dialogs.showNotifications(Dialogs.createNotifications().title(title).text(message), Alert.AlertType.WARNING);
        }
    }

    public static void showInfoNotification(String title, String message) {
        logger.info(title + ": " + message);
        if (!Dialogs.isHeadless()) {
            Dialogs.showNotifications(Dialogs.createNotifications().title(title).text(message), Alert.AlertType.INFORMATION);
        }
    }

    public static void showPlainNotification(String title, String message) {
        logger.info(title + ": " + message);
        if (!Dialogs.isHeadless()) {
            Dialogs.showNotifications(Dialogs.createNotifications().title(title).text(message), Alert.AlertType.NONE);
        }
    }

    private static void showNotifications(Notifications notification, Alert.AlertType type) {
        Dialogs.logDeprecated();
        if (Dialogs.isHeadless()) {
            logger.warn("Cannot show notifications in headless mode!");
            return;
        }
        if (Platform.isFxApplicationThread()) {
            switch (type) {
                case CONFIRMATION: {
                    notification.showConfirm();
                    break;
                }
                case ERROR: {
                    notification.showError();
                    break;
                }
                case INFORMATION: {
                    notification.showInformation();
                    break;
                }
                case WARNING: {
                    notification.showWarning();
                    break;
                }
                default: {
                    notification.show();
                    break;
                }
            }
        } else {
            Platform.runLater(() -> Dialogs.showNotifications(notification, type));
        }
    }

    private static Notifications createNotifications() {
        Stage stage = QuPathGUI.getInstance() == null ? null : QuPathGUI.getInstance().getStage();
        Notifications notifications = Notifications.create();
        if (stage == null) {
            return notifications;
        }
        if (QuPathStyleManager.getStyleColorScheme() == ColorScheme.DARK) {
            notifications = notifications.darkStyle();
        }
        return notifications.owner((Object)stage);
    }

    public static void showNoImageError(String title) {
        Dialogs.showErrorMessage(title, "No image is available!");
    }

    public static void showNoProjectError(String title) {
        Dialogs.showErrorMessage(title, "No project is available!");
    }

    public static void showErrorMessage(String title, String message) {
        logger.error(title + ": " + message);
        if (!Dialogs.isHeadless()) {
            Dialogs.showErrorMessage(title, (Node)Dialogs.createContentLabel(message));
        }
    }

    public static void showErrorMessage(String title, Node node) {
        Dialogs.logDeprecated();
        new Builder().alertType(Alert.AlertType.ERROR).title(title).content(node).show();
    }

    public static void showPlainMessage(String title, String message) {
        Dialogs.logDeprecated();
        logger.info(title + ": " + message);
        if (!Dialogs.isHeadless()) {
            new Builder().alertType(Alert.AlertType.INFORMATION).title(title).content((Node)Dialogs.createContentLabel(message)).show();
        }
    }

    public static void showTextWindow(Window owner, String title, String contents, Modality modality, boolean isEditable) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> Dialogs.showTextWindow(owner, title, contents, modality, isEditable));
            return;
        }
        Dialogs.logDeprecated();
        logger.info("{}\n{}", (Object)title, (Object)contents);
        Stage dialog = new Stage();
        if (owner == null) {
            dialog.initOwner(Dialogs.getDefaultOwner());
        } else {
            dialog.initOwner(owner);
        }
        dialog.initModality(modality);
        dialog.setTitle(title);
        TextArea textArea = new TextArea();
        textArea.setPrefColumnCount(60);
        textArea.setPrefRowCount(25);
        textArea.setText(contents);
        textArea.setWrapText(true);
        textArea.positionCaret(0);
        textArea.setEditable(isEditable);
        dialog.setScene(new Scene((Parent)textArea));
        dialog.show();
    }

    public static List<File> promptForMultipleFiles(String title, File dirBase, String filterDescription, String ... exts) {
        return Dialogs.getSharedChooser().promptForMultipleFiles(title, dirBase, filterDescription, exts);
    }

    public static File promptForDirectory(File dirBase) {
        return Dialogs.getSharedChooser().promptForDirectory(dirBase);
    }

    public static File promptForDirectory(String title, File dirBase) {
        return Dialogs.getSharedChooser().promptForDirectory(title, dirBase);
    }

    public static File promptForFile(String title, File dirBase, String filterDescription, String ... exts) {
        return Dialogs.getSharedChooser().promptForFile(title, dirBase, filterDescription, exts);
    }

    public static File promptForFile(File dirBase) {
        return Dialogs.getSharedChooser().promptForFile(dirBase);
    }

    public static File promptToSaveFile(String title, File dirBase, String defaultName, String filterName, String ext) {
        return Dialogs.getSharedChooser().promptToSaveFile(title, dirBase, defaultName, filterName, ext);
    }

    public static File promptToSaveFile(String title, File dirBase, String defaultName, Map<String, String> filters) {
        return Dialogs.getSharedChooser().promptToSaveFile(title, dirBase, defaultName, filters);
    }

    public static String promptForFilePathOrURL(String title, String defaultPath, File dirBase, String filterDescription, String ... exts) {
        return Dialogs.getSharedChooser().promptForFilePathOrURL(title, defaultPath, dirBase, filterDescription, exts);
    }

    private static Window getDefaultOwner() {
        List modalStages = Window.getWindows().stream().filter(w -> w.isShowing() && w instanceof Stage).map(w -> (Stage)w).filter(s -> s.getModality() != Modality.NONE).collect(Collectors.toList());
        if (modalStages.isEmpty()) {
            QuPathGUI qupath = QuPathGUI.getInstance();
            if (qupath != null) {
                return qupath.getStage();
            }
            return null;
        }
        List focussedStages = modalStages.stream().filter(s -> s.isFocused()).collect(Collectors.toList());
        if (focussedStages.size() == 1) {
            return (Window)focussedStages.get(0);
        }
        return null;
    }

    public static QuPathChooser getChooser(Window window) {
        Dialogs.logDeprecatedChoosers();
        if (window == null) {
            return defaultFileChooser;
        }
        return fileChooserMap.computeIfAbsent(window, w -> new QuPathChooserFX((Window)w));
    }

    private static QuPathChooser getSharedChooser() {
        return Dialogs.getChooser(Dialogs.getDefaultOwner());
    }

    public static Builder builder() {
        return new Builder();
    }

    private static boolean isHeadless() {
        return QuPathGUI.getInstance() == null;
    }

    @Deprecated
    public static class Builder {
        private Alert.AlertType alertType;
        private Window owner = null;
        private String title = "";
        private String header = null;
        private String contentText = null;
        private Node expandableContent = null;
        private Node content = null;
        private boolean resizable = false;
        private double width = -1.0;
        private double height = -1.0;
        private double prefWidth = -1.0;
        private double prefHeight = -1.0;
        private List<ButtonType> buttons = null;
        private Modality modality = Modality.APPLICATION_MODAL;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder headerText(String header) {
            this.header = header;
            return this;
        }

        public Builder contentText(String content) {
            this.contentText = content;
            return this;
        }

        public Builder content(Node content) {
            this.content = content;
            return this;
        }

        public Builder expandableContent(Node content) {
            this.expandableContent = content;
            return this;
        }

        public Builder owner(Window owner) {
            this.owner = owner;
            return this;
        }

        public Builder resizable() {
            this.resizable = true;
            return this;
        }

        public Builder nonModal() {
            this.modality = Modality.NONE;
            return this;
        }

        public Builder modality(Modality modality) {
            this.modality = modality;
            return this;
        }

        public Builder alertType(Alert.AlertType type) {
            this.alertType = type;
            return this;
        }

        public Builder warning() {
            return this.alertType(Alert.AlertType.WARNING);
        }

        public Builder error() {
            return this.alertType(Alert.AlertType.ERROR);
        }

        public Builder information() {
            return this.alertType(Alert.AlertType.INFORMATION);
        }

        public Builder confirmation() {
            return this.alertType(Alert.AlertType.CONFIRMATION);
        }

        public Builder buttons(ButtonType ... buttonTypes) {
            this.buttons = Arrays.asList(buttonTypes);
            return this;
        }

        public Builder buttons(String ... buttonNames) {
            ArrayList<ButtonType> list = new ArrayList<ButtonType>();
            for (String name : buttonNames) {
                list.add(switch (name.toLowerCase()) {
                    case "ok" -> ButtonType.OK;
                    case "yes" -> ButtonType.YES;
                    case "no" -> ButtonType.NO;
                    case "cancel" -> ButtonType.CANCEL;
                    case "apply" -> ButtonType.APPLY;
                    case "close" -> ButtonType.CLOSE;
                    case "finish" -> ButtonType.FINISH;
                    case "next" -> ButtonType.NEXT;
                    case "previous" -> ButtonType.PREVIOUS;
                    default -> new ButtonType(name);
                });
            }
            this.buttons = list;
            return this;
        }

        public Builder width(double width) {
            this.width = width;
            return this;
        }

        public Builder height(double height) {
            this.height = height;
            return this;
        }

        public Builder prefWidth(double prefWidth) {
            this.prefWidth = prefWidth;
            return this;
        }

        public Builder prefHeight(double prefHeight) {
            this.prefHeight = prefHeight;
            return this;
        }

        public Builder size(double width, double height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Dialog<ButtonType> build() {
            Object dialog = this.alertType == null ? new Dialog() : new Alert(this.alertType);
            if (this.owner == null) {
                dialog.initOwner(Dialogs.getDefaultOwner());
            } else {
                dialog.initOwner(this.owner);
            }
            dialog.setTitle(this.title);
            if (this.header != null) {
                dialog.setHeaderText(this.header);
            } else {
                dialog.setHeaderText(null);
            }
            if (this.contentText != null) {
                dialog.setContentText(this.contentText);
            }
            if (this.content != null) {
                dialog.getDialogPane().setContent(this.content);
            }
            if (this.expandableContent != null) {
                dialog.getDialogPane().setExpandableContent(this.expandableContent);
            }
            if (this.width > 0.0) {
                dialog.setWidth(this.width);
            }
            if (this.height > 0.0) {
                dialog.setHeight(this.height);
            }
            if (this.prefWidth > 0.0) {
                dialog.getDialogPane().setPrefWidth(this.prefWidth);
            }
            if (this.prefHeight > 0.0) {
                dialog.getDialogPane().setPrefHeight(this.prefHeight);
            }
            if (this.buttons != null) {
                dialog.getDialogPane().getButtonTypes().setAll(this.buttons);
            }
            if (dialog.getDialogPane().getButtonTypes().isEmpty()) {
                dialog.getDialogPane().getScene().getWindow().setOnCloseRequest(arg_0 -> Builder.lambda$build$0((Dialog)dialog, arg_0));
            }
            dialog.setResizable(this.resizable);
            dialog.initModality(this.modality);
            if (Insets.EMPTY.equals((Object)dialog.getDialogPane().getPadding())) {
                dialog.getDialogPane().setStyle("-fx-background-insets: -1; -fx-padding: 1px;");
            }
            return dialog;
        }

        public void show() {
            if (Dialogs.isHeadless()) {
                logger.warn("Cannot show dialog in headless mode!");
                return;
            }
            FXUtils.runOnApplicationThread(() -> this.build().show());
        }

        public Optional<ButtonType> showAndWait() {
            return (Optional)FXUtils.callOnApplicationThread(() -> this.build().showAndWait());
        }

        private static /* synthetic */ void lambda$build$0(Dialog dialog, WindowEvent e) {
            dialog.hide();
        }
    }

    public static enum DialogButton {
        YES,
        NO,
        CANCEL;

    }
}

