/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands.objects;

import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.scripting.QP;

public class SplitAnnotationsByLineCommand {
    private static final Logger logger = LoggerFactory.getLogger(SplitAnnotationsByLineCommand.class);
    private static final String title = "Split annotations by lines";
    private double buffer = 0.0;
    private boolean removeLines = true;
    private boolean selectedOnly = false;

    public void run(ImageData<?> imageData) {
        String script;
        String scriptName;
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return;
        }
        ParameterList params = new ParameterList().addDoubleParameter("buffer", "Line thickness", this.buffer, "px", "Optionally increase the thickness of the lines before splitting").addBooleanParameter("removeLines", "Remove lines", this.removeLines, "Remove the lines after they have been used for splitting").addBooleanParameter("selectedOnly", "Selected annotations only", this.selectedOnly, "Use only the selected annotations for splitting (both as lines and areas). If unchecked, all annotations will be used.");
        Pane pane = new ParameterPanelFX(params).getPane();
        boolean result = Dialogs.showConfirmDialog((String)title, (Node)pane);
        if (!result) {
            logger.debug("Split annotations by line cancelled");
            return;
        }
        double doBuffer = params.getDoubleParameterValue("buffer");
        boolean doRemove = params.getBooleanParameterValue("removeLines");
        boolean doSelectedOnly = params.getBooleanParameterValue("selectedOnly");
        logger.debug("Requested split annotations by line with buffer = {}, removeLines = {}, allAnnotations = {}", new Object[]{doBuffer, doRemove, doSelectedOnly});
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        if (doSelectedOnly) {
            QP.splitSelectedAnnotationAreasByLines((PathObjectHierarchy)hierarchy, (double)doBuffer, (boolean)doRemove);
            scriptName = "Split selected annotations by line";
            script = String.format("splitSelectedAnnotationAreasByLines(" + doBuffer + ", " + doRemove + ")", new Object[0]);
        } else {
            QP.splitAllAnnotationAreasByLines((PathObjectHierarchy)hierarchy, (double)doBuffer, (boolean)doRemove);
            scriptName = "Split all annotations by line";
            script = String.format("splitAllAnnotationAreasByLines(" + doBuffer + ", " + doRemove + ")", new Object[0]);
        }
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep(scriptName, params.getParameters(), script));
        this.buffer = doBuffer;
        this.removeLines = doRemove;
        this.selectedOnly = doSelectedOnly;
    }
}

