/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands.display;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.common.GeneralTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.prefs.PathPrefs;

public class BrightnessContrastSliderPane
extends GridPane {
    private ObjectProperty<ImageDisplay> imageDisplayProperty = new SimpleObjectProperty();
    private ObjectProperty<ChannelDisplayInfo> selectedChannel = new SimpleObjectProperty();
    private Slider sliderMin;
    private Slider sliderMax;
    private Slider sliderGamma;
    private BooleanProperty disableMinMaxAdjustment = new SimpleBooleanProperty(false);
    private BooleanProperty disableGammaAdjustment = new SimpleBooleanProperty(false);
    private boolean slidersUpdating = false;

    public BrightnessContrastSliderPane() {
        this.createSliders();
        this.populatePane();
    }

    private void createSliders() {
        this.sliderMin = new Slider(0.0, 255.0, 0.0);
        this.sliderMax = new Slider(0.0, 255.0, 255.0);
        this.sliderMin.valueProperty().addListener(this::handleMinMaxSliderValueChange);
        this.sliderMax.valueProperty().addListener(this::handleMinMaxSliderValueChange);
        this.sliderGamma = new Slider(0.01, 5.0, 0.01);
        this.sliderGamma.valueProperty().bindBidirectional((Property)PathPrefs.viewerGammaProperty());
        this.sliderGamma.disableProperty().bind((ObservableValue)this.disableGammaAdjustment);
        this.sliderMin.disableProperty().bind((ObservableValue)this.disableMinMaxAdjustment);
        this.sliderMax.disableProperty().bind((ObservableValue)this.disableMinMaxAdjustment);
        this.selectedChannel.addListener((v, o, n) -> this.refreshSliders());
    }

    private void populatePane() {
        String blank = "      ";
        Label labelMin = new Label("Channel min");
        Tooltip tooltipMin = new Tooltip("Set minimum lookup table value - double-click the value to edit manually");
        Label labelMinValue = new Label(blank);
        labelMinValue.setTooltip(tooltipMin);
        labelMin.setTooltip(tooltipMin);
        this.sliderMin.setTooltip(tooltipMin);
        labelMin.setLabelFor((Node)this.sliderMin);
        labelMinValue.textProperty().bind(this.createSliderTextBinding(this.sliderMin));
        this.add((Node)labelMin, 0, 0);
        this.add((Node)this.sliderMin, 1, 0);
        this.add((Node)labelMinValue, 2, 0);
        Label labelMax = new Label("Channel max");
        Tooltip tooltipMax = new Tooltip("Set maximum lookup table value - double-click the value to edit manually");
        labelMax.setTooltip(tooltipMax);
        Label labelMaxValue = new Label(blank);
        labelMaxValue.setTooltip(tooltipMax);
        this.sliderMax.setTooltip(tooltipMax);
        labelMax.setLabelFor((Node)this.sliderMax);
        labelMaxValue.textProperty().bind(this.createSliderTextBinding(this.sliderMax));
        this.add((Node)labelMax, 0, 1);
        this.add((Node)this.sliderMax, 1, 1);
        this.add((Node)labelMaxValue, 2, 1);
        this.setVgap(5.0);
        this.setHgap(4.0);
        Label labelGamma = new Label("Viewer gamma");
        Label labelGammaValue = new Label(blank);
        Tooltip tooltipGamma = new Tooltip("Set gamma value, for all viewers & all channels.\nDouble-click the value to edit manually, shift-click to reset to 1.\nIt is recommended to leave this value at 1, to avoid unnecessary nonlinear contrast adjustment.");
        labelGammaValue.setTooltip(tooltipGamma);
        labelGammaValue.textProperty().bind(BrightnessContrastSliderPane.createGammaLabelBinding((ObservableValue<? extends Number>)this.sliderGamma.valueProperty()));
        this.sliderGamma.setTooltip(tooltipGamma);
        labelGamma.setLabelFor((Node)this.sliderGamma);
        labelGamma.setTooltip(tooltipGamma);
        labelGammaValue.setOnMouseClicked(this::handleGammaLabelClicked);
        this.sliderGamma.valueProperty().addListener((v, o, n) -> {
            if (n != null && n.doubleValue() == 1.0) {
                labelGammaValue.getStyleClass().remove((Object)"warn-label-text");
            } else {
                labelGammaValue.getStyleClass().add((Object)"warn-label-text");
            }
        });
        ObjectBinding bindingMinMax = Bindings.createObjectBinding(() -> {
            if (this.disableMinMaxAdjustment.get()) {
                return Cursor.DEFAULT;
            }
            return Cursor.HAND;
        }, (Observable[])new Observable[]{this.disableMinMaxAdjustment});
        labelMinValue.cursorProperty().bind((ObservableValue)bindingMinMax);
        labelMaxValue.cursorProperty().bind((ObservableValue)bindingMinMax);
        ObjectBinding bindingGamma = Bindings.createObjectBinding(() -> {
            if (this.disableMinMaxAdjustment.get()) {
                return Cursor.DEFAULT;
            }
            return Cursor.HAND;
        }, (Observable[])new Observable[]{this.disableMinMaxAdjustment});
        labelGammaValue.cursorProperty().bind((ObservableValue)bindingGamma);
        labelMinValue.disableProperty().bind((ObservableValue)this.disableMinMaxAdjustment);
        labelMaxValue.disableProperty().bind((ObservableValue)this.disableMinMaxAdjustment);
        labelGammaValue.disableProperty().bind((ObservableValue)this.disableGammaAdjustment);
        this.add((Node)labelGamma, 0, 2);
        this.add((Node)this.sliderGamma, 1, 2);
        this.add((Node)labelGammaValue, 2, 2);
        labelMinValue.setPrefWidth(40.0);
        GridPane.setFillWidth((Node)this.sliderMin, (Boolean)Boolean.TRUE);
        GridPane.setFillWidth((Node)this.sliderMax, (Boolean)Boolean.TRUE);
        GridPane.setHgrow((Node)this.sliderMin, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.sliderMax, (Priority)Priority.ALWAYS);
        labelMinValue.setOnMouseClicked(this::handleMinLabelClick);
        labelMaxValue.setOnMouseClicked(this::handleMaxLabelClick);
    }

    public ObjectProperty<ImageDisplay> imageDisplayProperty() {
        return this.imageDisplayProperty;
    }

    public BooleanProperty disableMinMaxAdjustmentProperty() {
        return this.disableMinMaxAdjustment;
    }

    public BooleanProperty disableGammaAdjustmentProperty() {
        return this.disableGammaAdjustment;
    }

    private void handleMinMaxSliderValueChange(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.applyMinMaxSliderChanges();
    }

    public ObjectProperty<ChannelDisplayInfo> selectedChannelProperty() {
        return this.selectedChannel;
    }

    private ChannelDisplayInfo getCurrentChannel() {
        return (ChannelDisplayInfo)this.selectedChannel.get();
    }

    void applyMinMaxSliderChanges() {
        if (this.slidersUpdating) {
            return;
        }
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty.getValue();
        ChannelDisplayInfo infoVisible = this.getCurrentChannel();
        if (infoVisible == null || imageDisplay == null) {
            return;
        }
        double minValue = this.sliderMin.getValue();
        double maxValue = this.sliderMax.getValue();
        imageDisplay.setMinMaxDisplay(infoVisible, (float)minValue, (float)maxValue);
    }

    private ObservableValue<String> createSliderTextBinding(Slider slider) {
        return Bindings.createStringBinding(() -> {
            double value = slider.getValue();
            if (value == (double)((int)value)) {
                return String.format("%d", (int)value);
            }
            if (value < 1.0) {
                return String.format("%.3f", value);
            }
            if (value < 10.0) {
                return String.format("%.2f", value);
            }
            return String.format("%.1f", value);
        }, (Observable[])new Observable[]{slider.valueProperty()});
    }

    private static ObservableValue<String> createGammaLabelBinding(ObservableValue<? extends Number> gammaValue) {
        return Bindings.createStringBinding(() -> GeneralTools.formatNumber((double)((Number)gammaValue.getValue()).doubleValue(), (int)2), (Observable[])new Observable[]{gammaValue});
    }

    public void resetAllSliders() {
        this.sliderMin.setValue(this.sliderMin.getMin());
        this.sliderMax.setValue(this.sliderMax.getMax());
        this.sliderGamma.setValue(1.0);
    }

    public DoubleProperty maxValueProperty() {
        return this.sliderMax.valueProperty();
    }

    public DoubleProperty minValueProperty() {
        return this.sliderMin.valueProperty();
    }

    public DoubleProperty gammaValueProperty() {
        return this.sliderGamma.valueProperty();
    }

    private void handleGammaLabelClicked(MouseEvent event) {
        if (event.getClickCount() >= 3 || event.isShiftDown()) {
            this.sliderGamma.setValue(1.0);
        } else {
            Double newGamma = Dialogs.showInputDialog((String)"Gamma", (String)"Set gamma value", (Double)this.sliderGamma.getValue());
            if (newGamma != null) {
                this.sliderGamma.setValue(newGamma.doubleValue());
            }
        }
    }

    private void handleMaxLabelClick(MouseEvent event) {
        ChannelDisplayInfo infoVisible = this.getCurrentChannel();
        if (infoVisible == null) {
            return;
        }
        Double value = Dialogs.showInputDialog((String)"Display range", (String)"Set display range maximum", (Double)Double.valueOf(infoVisible.getMaxDisplay()));
        if (value != null && !Double.isNaN(value)) {
            this.sliderMax.setValue(value.doubleValue());
            ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty.getValue();
            if (value < this.sliderMax.getMin() || value > this.sliderMax.getMax()) {
                imageDisplay.setMinMaxDisplay(infoVisible, infoVisible.getMinDisplay(), value.floatValue());
                this.refreshSliders();
            }
        }
    }

    public void refreshSliders() {
        boolean is8Bit;
        ChannelDisplayInfo channel = this.getCurrentChannel();
        if (channel == null) {
            return;
        }
        float range = channel.getMaxAllowed() - channel.getMinAllowed();
        int n = (int)range;
        boolean bl = is8Bit = range == 255.0f && channel.getMinAllowed() == 0.0f && channel.getMaxAllowed() == 255.0f;
        if (is8Bit) {
            n = 256;
        } else if (n <= 20) {
            n = (int)((double)range / 0.001);
        } else if (n <= 200) {
            n = (int)((double)range / 0.01);
        }
        this.slidersUpdating = true;
        double maxDisplay = Math.max(channel.getMaxDisplay(), channel.getMinDisplay());
        double minDisplay = Math.min(channel.getMaxDisplay(), channel.getMinDisplay());
        double minSlider = Math.min((double)channel.getMinAllowed(), minDisplay);
        double maxSlider = Math.max((double)channel.getMaxAllowed(), maxDisplay);
        this.sliderMin.setMin(minSlider);
        this.sliderMin.setMax(maxSlider);
        this.sliderMin.setValue((double)channel.getMinDisplay());
        this.sliderMax.setMin(minSlider);
        this.sliderMax.setMax(maxSlider);
        this.sliderMax.setValue((double)channel.getMaxDisplay());
        this.sliderMin.setMajorTickUnit(1.0);
        this.sliderMax.setMajorTickUnit(1.0);
        this.sliderMin.setMinorTickCount(n);
        this.sliderMax.setMinorTickCount(n);
        this.slidersUpdating = false;
        this.applyMinMaxSliderChanges();
    }

    private void handleMinLabelClick(MouseEvent event) {
        ChannelDisplayInfo infoVisible = this.getCurrentChannel();
        if (infoVisible == null) {
            return;
        }
        Double value = Dialogs.showInputDialog((String)"Display range", (String)"Set display range minimum", (Double)Double.valueOf(infoVisible.getMinDisplay()));
        if (value != null && !Double.isNaN(value)) {
            this.sliderMin.setValue(value.doubleValue());
            ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty.getValue();
            if (value < this.sliderMin.getMin() || value > this.sliderMin.getMax()) {
                imageDisplay.setMinMaxDisplay(infoVisible, value.floatValue(), infoVisible.getMaxDisplay());
                this.refreshSliders();
            }
        }
    }
}

