/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands.display;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.StringConverter;
import org.controlsfx.control.SearchableComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.display.ImageDisplay;
import qupath.lib.display.settings.DisplaySettingUtils;
import qupath.lib.display.settings.ImageDisplaySettings;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.projects.ResourceManager;

public class BrightnessContrastSettingsPane
extends GridPane {
    private static final Logger logger = LoggerFactory.getLogger(BrightnessContrastSettingsPane.class);
    private ObjectProperty<ResourceManager.Manager<ImageDisplaySettings>> resourceManagerProperty = new SimpleObjectProperty();
    private ObjectProperty<ImageDisplay> imageDisplayProperty = new SimpleObjectProperty();
    private ComboBox<ImageDisplaySettings> comboSettings = new SearchableComboBox();
    private StringProperty defaultName = null;
    private BooleanProperty settingsChanged = new SimpleBooleanProperty(false);
    private ObservableValue<Number> lastChangeTimestamp;

    public BrightnessContrastSettingsPane() {
        this.comboSettings.setOnShowing(e -> this.refreshResources());
        this.initializePane();
        this.tryToKeepSearchText();
        this.lastChangeTimestamp = this.imageDisplayProperty.flatMap(ImageDisplay::eventCountProperty);
        this.lastChangeTimestamp.addListener(this::timestampInvalidated);
        this.settingsChanged.addListener((v, o, n) -> {
            if (!n.booleanValue()) {
                this.lastChangeTimestamp.getValue();
            }
        });
    }

    private void timestampInvalidated(Observable observable) {
        this.settingsChanged.set(true);
    }

    private void initializePane() {
        this.setHgap(5.0);
        Label label = new Label("Settings");
        label.setLabelFor(this.comboSettings);
        this.comboSettings.setTooltip(new Tooltip("Compatible display settings saved in the project"));
        this.comboSettings.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            if (n != null) {
                this.tryToApplySettings((ImageDisplaySettings)n);
            }
        });
        this.comboSettings.setConverter((StringConverter)new StringConverter<ImageDisplaySettings>(){

            public String toString(ImageDisplaySettings object) {
                return object == null ? null : object.getName();
            }

            public ImageDisplaySettings fromString(String string) {
                if (string == null) {
                    return null;
                }
                return BrightnessContrastSettingsPane.this.comboSettings.getItems().stream().filter(s -> Objects.equals(s.getName(), string)).findFirst().orElse(null);
            }
        });
        this.comboSettings.setCellFactory(c -> FXUtils.createCustomListCell(ImageDisplaySettings::getName));
        this.comboSettings.setButtonCell((ListCell)new SettingListCell(this.settingsChanged));
        this.comboSettings.setPlaceholder((Node)GuiTools.createPlaceholderText("No compatible settings"));
        this.resourceManagerProperty.addListener((v, o, n) -> this.refreshResources());
        Button btnSave = new Button("Save");
        btnSave.setTooltip(new Tooltip("Save the current display settings in the project"));
        btnSave.disableProperty().bind((ObservableValue)this.resourceManagerProperty.isNull());
        btnSave.setOnAction(e -> this.promptToSaveSettings());
        int col = 0;
        this.add((Node)label, col++, 0);
        this.add((Node)this.comboSettings, col++, 0);
        this.add((Node)btnSave, col, 0);
        label.setMinWidth(Double.NEGATIVE_INFINITY);
        btnSave.setMinWidth(Double.NEGATIVE_INFINITY);
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{this.comboSettings});
    }

    public ObjectProperty<ImageDisplay> imageDisplayObjectProperty() {
        return this.imageDisplayProperty;
    }

    public ObjectProperty<ResourceManager.Manager<ImageDisplaySettings>> resourceManagerProperty() {
        return this.resourceManagerProperty;
    }

    private void tryToKeepSearchText() {
        this.comboSettings.sceneProperty().flatMap(Scene::windowProperty).flatMap(Window::showingProperty).addListener((v, o, n) -> {
            if (n.booleanValue() && this.defaultName == null) {
                this.handleComboShowing();
            }
        });
    }

    private void handleComboShowing() {
        Node node = this.comboSettings.lookup("#search");
        if (node instanceof TextField) {
            TextField tf = (TextField)node;
            this.defaultName = new SimpleStringProperty();
            tf.textProperty().addListener((v, o, n) -> {
                if (tf.isVisible()) {
                    this.defaultName.set(n);
                }
            });
        }
    }

    private String tryToGetDefaultName() {
        ImageDisplaySettings selected = (ImageDisplaySettings)this.comboSettings.getSelectionModel().getSelectedItem();
        if (selected != null) {
            return selected.getName();
        }
        return this.defaultName == null ? null : (String)this.defaultName.get();
    }

    private void promptToSaveSettings() {
        ResourceManager.Manager manager = (ResourceManager.Manager)this.resourceManagerProperty.get();
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty.get();
        if (manager == null) {
            logger.warn("No resource manager available!");
        } else if (imageDisplay == null) {
            logger.warn("No image display available!");
        } else {
            String name = this.promptForName();
            if (name == null || name.isEmpty()) {
                return;
            }
            try {
                ImageDisplaySettings settings = DisplaySettingUtils.displayToSettings(imageDisplay, name);
                manager.put(name, (Object)settings);
                this.refreshResources();
                this.settingsChanged.set(false);
                this.comboSettings.getSelectionModel().select((Object)settings);
            }
            catch (IOException e) {
                Dialogs.showErrorMessage((String)"Save display settings", (String)("Can't save settings " + name));
                logger.error("Error saving display settings", (Throwable)e);
            }
        }
    }

    private String promptForName() {
        String defaultName = this.tryToGetDefaultName();
        TextField tf = new TextField(defaultName);
        tf.setPromptText("Name of settings");
        tf.setPrefColumnCount(16);
        Label labelWarning = new Label("Settings with the same name will be overwritten!");
        List<String> allNames = this.getAllNames();
        labelWarning.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> allNames.contains(tf.getText()), (Observable[])new Observable[]{tf.textProperty()}));
        labelWarning.getStyleClass().addAll((Object[])new String[]{"warn-label-text"});
        Label labelPrompt = new Label("Enter a name for the display settings");
        VBox pane = new VBox();
        pane.setSpacing(5.0);
        pane.getChildren().addAll((Object[])new Node[]{labelPrompt, tf, labelWarning});
        Platform.runLater(() -> ((TextField)tf).requestFocus());
        if (Dialogs.builder().title("Save display settings").content((Node)pane).owner(FXUtils.getWindow((Node)this)).buttons(new ButtonType[]{ButtonType.OK, ButtonType.CANCEL}).showAndWait().orElse(ButtonType.CANCEL).equals(ButtonType.OK)) {
            return tf.getText();
        }
        return null;
    }

    private List<String> getAllNames() {
        ResourceManager.Manager manager = (ResourceManager.Manager)this.resourceManagerProperty.get();
        if (manager == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<String> names = new ArrayList<String>(manager.getNames());
            Collections.sort(names);
            return names;
        }
        catch (IOException e) {
            logger.error("Error loading display settings", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void refreshResources() {
        logger.trace("Refreshing resources");
        ResourceManager.Manager manager = (ResourceManager.Manager)this.resourceManagerProperty.get();
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty.get();
        if (manager == null || imageDisplay == null || imageDisplay.availableChannels().isEmpty()) {
            this.comboSettings.setItems(FXCollections.observableArrayList());
        } else {
            try {
                List<String> names = this.getAllNames();
                ObservableList compatibleSettings = FXCollections.observableArrayList();
                for (String name : names) {
                    ImageDisplaySettings settings = (ImageDisplaySettings)manager.get(name);
                    if (!DisplaySettingUtils.settingsCompatibleWithDisplay(imageDisplay, settings)) continue;
                    compatibleSettings.add((Object)settings);
                }
                this.comboSettings.setItems(compatibleSettings);
            }
            catch (IOException e) {
                logger.error("Error loading display settings", (Throwable)e);
            }
        }
    }

    private void tryToApplySettings(ImageDisplaySettings settings) {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty.get();
        if (settings == null || imageDisplay == null) {
            return;
        }
        try {
            DisplaySettingUtils.applySettingsToDisplay(imageDisplay, settings);
            PathPrefs.viewerGammaProperty().set(settings.getGamma());
            this.settingsChanged.set(false);
        }
        catch (Exception e) {
            Dialogs.showErrorMessage((String)"Apply display settings", (String)("Can't apply settings " + settings.getName()));
            logger.error("Error applying display settings", (Throwable)e);
        }
    }

    private static class SettingListCell
    extends ListCell<ImageDisplaySettings> {
        private BooleanProperty settingsChanged;

        private SettingListCell(BooleanProperty settingsChanged) {
            this.settingsChanged = settingsChanged;
            this.settingsChanged.addListener((v, o, n) -> this.updateTextAndStyle());
        }

        protected void updateItem(ImageDisplaySettings item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.updateTextAndStyle();
            }
        }

        private void updateTextAndStyle() {
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(this::updateTextAndStyle);
                return;
            }
            ImageDisplaySettings item = (ImageDisplaySettings)this.getItem();
            if (item == null) {
                this.setText(null);
                this.setStyle(null);
            } else if (this.settingsChanged.get()) {
                this.setText(item.getName() + "*");
                this.setStyle("-fx-font-style: italic;");
            } else {
                this.setText(item.getName());
                this.setStyle(null);
            }
        }
    }
}

