/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands.display;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.ColorTools;
import qupath.lib.display.AdditiveChannelInfo;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.charts.ChartThresholdPane;
import qupath.lib.gui.charts.HistogramChart;
import qupath.lib.gui.commands.display.BrightnessContrastChannelPane;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;

public class BrightnessContrastHistogramPane
extends BorderPane {
    private static final Logger logger = LoggerFactory.getLogger(BrightnessContrastChannelPane.class);
    private static final DecimalFormat df = new DecimalFormat("#.###");
    private final HistogramChart histogramChart = new HistogramChart();
    private final ChartThresholdPane chartPane = new ChartThresholdPane((XYChart<Number, Number>)this.histogramChart);
    private final BooleanProperty doLogCounts = PathPrefs.createPersistentPreference("brightnessContrastLogCounts", false);
    private final Tooltip chartTooltip = new Tooltip();
    private final DoubleProperty minValueProperty = new SimpleDoubleProperty(Double.NEGATIVE_INFINITY);
    private final DoubleProperty maxValueProperty = new SimpleDoubleProperty(Double.NEGATIVE_INFINITY);

    public BrightnessContrastHistogramPane() {
        logger.trace("Creating histogram pane");
        this.initialize();
    }

    private void initialize() {
        this.initializeHistogram();
        this.chartPane.setPrefWidth(200.0);
        this.chartPane.setPrefHeight(150.0);
        this.chartPane.getThresholds().setAll((Object[])new ObservableNumberValue[]{this.minValueProperty, this.maxValueProperty});
        this.chartPane.setIsInteractive(true);
        Label labelPlaceholder = new Label();
        labelPlaceholder.prefWidthProperty().bind((ObservableValue)this.chartPane.prefWidthProperty());
        labelPlaceholder.prefHeightProperty().bind((ObservableValue)this.chartPane.prefHeightProperty());
        labelPlaceholder.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        labelPlaceholder.minWidthProperty().bind((ObservableValue)this.chartPane.prefWidthProperty());
        labelPlaceholder.minHeightProperty().bind((ObservableValue)this.chartPane.prefHeightProperty());
        labelPlaceholder.setText("No histogram available");
        labelPlaceholder.setContentDisplay(ContentDisplay.CENTER);
        labelPlaceholder.setAlignment(Pos.CENTER);
        this.centerProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (!this.histogramChart.getHistogramData().isEmpty()) {
                return this.chartPane;
            }
            return labelPlaceholder;
        }, (Observable[])new Observable[]{this.histogramChart.getHistogramData()}));
    }

    private void initializeHistogram() {
        this.doLogCountsProperty().addListener(this::handleDoLogCountsChange);
        this.handleDoLogCountsChange((ObservableValue<? extends Boolean>)this.doLogCounts, null, this.doLogCounts.get());
        this.histogramChart.setDisplayMode(HistogramChart.DisplayMode.AREA);
        this.histogramChart.setShowTickLabels(false);
        this.histogramChart.setAnimated(false);
        this.histogramChart.setHideIfEmpty(true);
        this.histogramChart.getXAxis().setAutoRanging(false);
        this.histogramChart.getXAxis().setTickLabelsVisible(true);
        this.histogramChart.getYAxis().setAutoRanging(false);
        this.histogramChart.getYAxis().setTickLabelsVisible(false);
    }

    private void handleDoLogCountsChange(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            this.histogramChart.countsTransformProperty().set((Object)HistogramChart.CountsTransformMode.LOGARITHM);
        } else {
            this.histogramChart.countsTransformProperty().set((Object)HistogramChart.CountsTransformMode.RAW);
        }
        this.updateYAxis();
    }

    public BooleanProperty doLogCountsProperty() {
        return this.doLogCounts;
    }

    public DoubleProperty minValueProperty() {
        return this.minValueProperty;
    }

    public DoubleProperty maxValueProperty() {
        return this.maxValueProperty;
    }

    public void updateHistogram(ImageDisplay imageDisplay, ChannelDisplayInfo channelSelected) {
        Histogram histogram = imageDisplay == null || channelSelected == null ? null : imageDisplay.getHistogram(channelSelected);
        if (histogram == null) {
            if (channelSelected != null && imageDisplay != null && imageDisplay.getImageData() != null && imageDisplay.getImageData().getServer().isRGB() && "original".equalsIgnoreCase(channelSelected.getName())) {
                List<HistogramChart.HistogramData> allHistograms = BrightnessContrastHistogramPane.getRGBHistograms(imageDisplay);
                this.histogramChart.getHistogramData().setAll(allHistograms);
            } else if (channelSelected instanceof AdditiveChannelInfo) {
                AdditiveChannelInfo additive = (AdditiveChannelInfo)channelSelected;
                this.histogramChart.getHistogramData().clear();
            } else {
                this.histogramChart.getHistogramData().clear();
            }
        } else {
            HistogramChart.HistogramData histogramData = HistogramChart.createHistogramData(histogram, BrightnessContrastHistogramPane.getColor(channelSelected));
            this.histogramChart.getHistogramData().setAll((Object[])new HistogramChart.HistogramData[]{histogramData});
        }
        this.updateAxes(channelSelected);
        this.updateTooltip(histogram);
    }

    private void updateAxes(ChannelDisplayInfo channelSelected) {
        NumberAxis xAxis = (NumberAxis)this.histogramChart.getXAxis();
        if (channelSelected != null && channelSelected.getMaxAllowed() == 255.0f && channelSelected.getMinAllowed() == 0.0f) {
            if (!xAxis.lowerBoundProperty().isBound()) {
                xAxis.setLowerBound(0.0);
            }
            if (!xAxis.upperBoundProperty().isBound()) {
                xAxis.setUpperBound(255.0);
            }
        } else if (channelSelected != null) {
            if (!xAxis.lowerBoundProperty().isBound()) {
                xAxis.setLowerBound((double)channelSelected.getMinAllowed());
            }
            if (!xAxis.upperBoundProperty().isBound()) {
                xAxis.setUpperBound((double)channelSelected.getMaxAllowed());
            }
        }
        if (channelSelected != null) {
            if (!xAxis.tickLabelsVisibleProperty().isBound()) {
                xAxis.setTickUnit((double)(channelSelected.getMaxAllowed() - channelSelected.getMinAllowed()));
            }
            this.updateYAxis();
        }
    }

    private void updateYAxis() {
        NumberAxis yAxis = (NumberAxis)this.histogramChart.getYAxis();
        double maxCount = this.histogramChart.getHistogramData().stream().mapToDouble(h -> h.getHistogram().getMaxCount()).max().orElse(1.0);
        double yMax = this.doLogCounts.get() ? Math.log(maxCount) : maxCount;
        if (!yAxis.lowerBoundProperty().isBound()) {
            yAxis.setLowerBound(0.0);
        }
        if (!yAxis.upperBoundProperty().isBound()) {
            yAxis.setUpperBound(yMax);
        }
        if (!yAxis.tickLabelsVisibleProperty().isBound()) {
            yAxis.setTickLabelsVisible(false);
        }
        if (!yAxis.tickUnitProperty().isBound()) {
            yAxis.setTickUnit(yMax);
        }
        if (!yAxis.minorTickCountProperty().isBound()) {
            if (this.doLogCounts.get()) {
                yAxis.setMinorTickCount(0);
            } else {
                yAxis.setMinorTickCount(5);
            }
        }
    }

    private void updateTooltip(Histogram histogram) {
        GridPane pane = new GridPane();
        pane.setHgap(4.0);
        pane.setVgap(2.0);
        int row = 0;
        if (histogram != null) {
            pane.add((Node)new Label("Min"), 0, row);
            pane.add((Node)new Label(df.format(histogram.getMinValue())), 1, row);
            pane.add((Node)new Label("Max"), 0, ++row);
            pane.add((Node)new Label(df.format(histogram.getMaxValue())), 1, row);
            pane.add((Node)new Label("Mean"), 0, ++row);
            pane.add((Node)new Label(df.format(histogram.getMeanValue())), 1, row);
            pane.add((Node)new Label("Std.dev"), 0, ++row);
            pane.add((Node)new Label(df.format(histogram.getStdDev())), 1, row);
            ++row;
        }
        this.chartTooltip.setGraphic((Node)pane);
        if (row == 0) {
            Tooltip.uninstall((Node)this.histogramChart, (Tooltip)this.chartTooltip);
        } else {
            Tooltip.install((Node)this.histogramChart, (Tooltip)this.chartTooltip);
        }
    }

    private static List<HistogramChart.HistogramData> getRGBHistograms(ImageDisplay imageDisplay) {
        ArrayList<HistogramChart.HistogramData> data = new ArrayList<HistogramChart.HistogramData>();
        for (ChannelDisplayInfo c : imageDisplay.availableChannels()) {
            ColorTransformer.ColorTransformMethod method = c.getMethod();
            if (method == null) continue;
            switch (method) {
                case Red: 
                case Green: 
                case Blue: {
                    Histogram hist = imageDisplay.getHistogram(c);
                    if (hist == null) break;
                    HistogramChart.HistogramData histogramData = HistogramChart.createHistogramData(hist, BrightnessContrastHistogramPane.getColor(c));
                    data.add(histogramData);
                    break;
                }
            }
        }
        return data;
    }

    private static Color getColor(ChannelDisplayInfo channel) {
        if (channel == null) {
            return null;
        }
        Integer color = channel.getColor();
        if (color == null || Objects.equals(ColorTools.BLACK, color) || Objects.equals(ColorTools.WHITE, color)) {
            return null;
        }
        return ColorToolsFX.getCachedColor(color);
    }
}

