/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands.display;

import java.awt.image.BufferedImage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.controls.PredicateTextField;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;

public class BrightnessContrastChannelPane
extends BorderPane {
    private static final Logger logger = LoggerFactory.getLogger(BrightnessContrastChannelPane.class);
    private final ObjectProperty<ImageDisplay> imageDisplayObjectProperty = new SimpleObjectProperty();
    private final TableView<ChannelDisplayInfo> table = new TableView();
    private final PredicateTextField<ChannelDisplayInfo> filter;
    private final BooleanProperty useRegex = PathPrefs.createPersistentPreference("brightnessContrastFilterRegex", false);
    private final BooleanProperty ignoreCase = PathPrefs.createPersistentPreference("brightnessContrastFilterDoIgnoreCase", true);
    private final SelectedChannelsChangeListener selectedChannelsChangeListener = new SelectedChannelsChangeListener();
    private final ColorPicker picker = new ColorPicker();
    private final ContextMenu popup = new ContextMenu();
    private final ReadOnlyBooleanWrapper activeChannelVisible = new ReadOnlyBooleanWrapper(false);
    private final BooleanProperty disableToggleMenuItems = new SimpleBooleanProperty(false);
    private final CheckBox cbShowAll = new CheckBox();
    private ListChangeListener<ChannelDisplayInfo> availableChannelsChangeListener = this::handleAvailableChannelsChange;
    private ObservableList<ChannelDisplayInfo> channelList = FXCollections.observableArrayList();
    private FilteredList<ChannelDisplayInfo> filteredChannels = new FilteredList(this.channelList);

    public BrightnessContrastChannelPane() {
        this.imageDisplayProperty().addListener(this::handleImageDisplayChanged);
        this.filter = this.createFilter();
        this.createChannelDisplayTable();
        this.filteredChannels.predicateProperty().bind((ObservableValue)this.filter.predicateProperty());
        this.table.setItems(this.filteredChannels);
        this.table.sceneProperty().flatMap(Scene::windowProperty).flatMap(Window::showingProperty).addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.updateShowTableColumnHeader();
            }
        });
        this.initializeShowAllCheckbox();
        this.initializeColorPicker();
        this.initializeShowAllCheckbox();
        this.initializePopup();
        this.initialize();
    }

    private void initialize() {
        this.setCenter((Node)this.table);
        this.setBottom((Node)this.filter);
        BorderPane.setMargin(this.filter, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
    }

    private PredicateTextField<ChannelDisplayInfo> createFilter() {
        PredicateTextField filter = new PredicateTextField(ChannelDisplayInfo::getName);
        filter.useRegexProperty().bindBidirectional((Property)this.useRegex);
        filter.ignoreCaseProperty().bindBidirectional((Property)this.ignoreCase);
        filter.promptTextProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (this.useRegex.get()) {
                return "Filter channels by regular expression";
            }
            return "Filter channels by name";
        }, (Observable[])new Observable[]{this.useRegex}));
        filter.setSpacing(5.0);
        Tooltip tooltip = new Tooltip("Enter text to find specific channels by name");
        Tooltip.install((Node)filter, (Tooltip)tooltip);
        return filter;
    }

    public BooleanProperty disableToggleMenuItemsProperty() {
        return this.disableToggleMenuItems;
    }

    private void initializePopup() {
        MenuItem miTurnOn = new MenuItem("Show channels");
        miTurnOn.setOnAction(e -> this.setTableSelectedChannels(true));
        miTurnOn.disableProperty().bind((ObservableValue)this.disableToggleMenuItems);
        MenuItem miTurnOff = new MenuItem("Hide channels");
        miTurnOff.setOnAction(e -> this.setTableSelectedChannels(false));
        miTurnOff.disableProperty().bind((ObservableValue)this.disableToggleMenuItems);
        MenuItem miToggle = new MenuItem("Toggle channels");
        miToggle.setOnAction(e -> this.toggleTableSelectedChannels());
        miToggle.disableProperty().bind((ObservableValue)this.disableToggleMenuItems);
        this.popup.getItems().addAll((Object[])new MenuItem[]{miTurnOn, miTurnOff, miToggle});
    }

    private void setTableSelectedChannels(boolean showChannels) {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty().getValue();
        if (imageDisplay == null) {
            return;
        }
        for (ChannelDisplayInfo info : this.table.getSelectionModel().getSelectedItems()) {
            imageDisplay.setChannelSelected(info, showChannels);
        }
        this.table.refresh();
    }

    private void toggleTableSelectedChannels() {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty().getValue();
        if (imageDisplay == null) {
            return;
        }
        HashSet<ChannelDisplayInfo> selected = new HashSet<ChannelDisplayInfo>((Collection<ChannelDisplayInfo>)imageDisplay.selectedChannels());
        Iterator iterator = this.table.getSelectionModel().getSelectedItems().iterator();
        while (iterator.hasNext()) {
            ChannelDisplayInfo info;
            imageDisplay.setChannelSelected(info, !selected.contains(info = (ChannelDisplayInfo)iterator.next()));
        }
        this.table.refresh();
    }

    private void initializeColorPicker() {
        this.picker.getCustomColors().setAll((Object[])new Color[]{ColorToolsFX.getCachedColor(255, 0, 0), ColorToolsFX.getCachedColor(0, 255, 0), ColorToolsFX.getCachedColor(0, 0, 255), ColorToolsFX.getCachedColor(255, 255, 0), ColorToolsFX.getCachedColor(0, 255, 255), ColorToolsFX.getCachedColor(255, 0, 255)});
    }

    private void createChannelDisplayTable() {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayObjectProperty.getValue();
        if (imageDisplay != null) {
            this.channelList.setAll(imageDisplay.availableChannels());
        }
        this.table.setPlaceholder((Node)GuiTools.createPlaceholderText("No channels available"));
        this.table.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new ChannelTableKeypressedListener());
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.getSelectionModel().selectedItemProperty().addListener(this::handleSelectedChannelChanged);
        this.table.setMinHeight(100.0);
        this.table.setPrefHeight(250.0);
        TableColumn col1 = new TableColumn("Channel");
        col1.setId("channel-column");
        col1.setCellValueFactory(this::channelCellValueFactory);
        col1.setCellFactory(column -> new ChannelDisplayTableCell());
        col1.setSortable(false);
        TableColumn col2 = new TableColumn("Show");
        col2.setId("show-column");
        col2.setCellValueFactory(this::showChannelCellValueFactory);
        col2.setCellFactory(column -> new ShowChannelDisplayTableCell());
        col2.setSortable(false);
        col2.setEditable(true);
        col2.setResizable(false);
        this.table.setRowFactory(this::createTableRow);
        this.table.getColumns().add((Object)col1);
        this.table.getColumns().add((Object)col2);
        this.table.setEditable(true);
        this.table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        col1.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().subtract((ObservableNumberValue)col2.widthProperty()).subtract(25));
    }

    private void handleImageDisplayChanged(ObservableValue<? extends ImageDisplay> source, ImageDisplay oldValue, ImageDisplay newValue) {
        if (oldValue != null) {
            oldValue.selectedChannels().removeListener((ListChangeListener)this.selectedChannelsChangeListener);
            oldValue.availableChannels().removeListener(this.availableChannelsChangeListener);
        }
        if (newValue != null) {
            newValue.availableChannels().addListener(this.availableChannelsChangeListener);
            newValue.selectedChannels().addListener((ListChangeListener)this.selectedChannelsChangeListener);
        }
        this.refreshAvailableChannels();
        this.updateTable();
    }

    private ObservableValue<ChannelDisplayInfo> channelCellValueFactory(TableColumn.CellDataFeatures<ChannelDisplayInfo, ChannelDisplayInfo> features) {
        return new SimpleObjectProperty((Object)((ChannelDisplayInfo)features.getValue()));
    }

    private ObservableValue<Boolean> showChannelCellValueFactory(TableColumn.CellDataFeatures<ChannelDisplayInfo, Boolean> features) {
        SimpleBooleanProperty property = new SimpleBooleanProperty(this.isChannelShowing((ChannelDisplayInfo)features.getValue()));
        property.addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.setShowChannel((ChannelDisplayInfo)features.getValue());
            } else {
                this.setHideChannel((ChannelDisplayInfo)features.getValue());
            }
        });
        return property;
    }

    public ReadOnlyBooleanProperty currentChannelVisible() {
        return this.activeChannelVisible.getReadOnlyProperty();
    }

    private boolean isChannelShowing(ChannelDisplayInfo channel) {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty().getValue();
        return imageDisplay != null && imageDisplay.selectedChannels().contains((Object)channel);
    }

    private void initializeShowAllCheckbox() {
        this.cbShowAll.setTooltip(new Tooltip("Show/hide all channels"));
        this.cbShowAll.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.cbShowAll.setIndeterminate(true);
        this.cbShowAll.setOnAction(e -> this.syncShowAllToCheckbox());
        this.refreshShowAllCheckbox();
    }

    private void syncShowAllToCheckbox() {
        if (this.cbShowAll.isIndeterminate()) {
            return;
        }
        if (this.cbShowAll.isSelected()) {
            this.setShowChannels((Collection<? extends ChannelDisplayInfo>)this.table.getItems());
        } else {
            this.setHideChannels((Collection<? extends ChannelDisplayInfo>)this.table.getItems());
        }
    }

    public void setShowChannel(ChannelDisplayInfo channel) {
        if (channel != null) {
            this.setShowChannels(Collections.singleton(channel));
        }
    }

    private void setShowChannels(Collection<? extends ChannelDisplayInfo> channels) {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty().getValue();
        if (imageDisplay == null || channels.isEmpty()) {
            return;
        }
        for (ChannelDisplayInfo channelDisplayInfo : channels) {
            imageDisplay.setChannelSelected(channelDisplayInfo, true);
        }
        this.table.refresh();
    }

    public void setHideChannel(ChannelDisplayInfo channel) {
        if (channel != null) {
            this.setHideChannels(Collections.singleton(channel));
        }
    }

    private void setHideChannels(Collection<? extends ChannelDisplayInfo> channels) {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty().getValue();
        if (imageDisplay == null || channels.isEmpty()) {
            return;
        }
        for (ChannelDisplayInfo channelDisplayInfo : channels) {
            imageDisplay.setChannelSelected(channelDisplayInfo, false);
        }
        this.table.refresh();
    }

    public void toggleShowHideChannel(ChannelDisplayInfo channel) {
        if (channel == null) {
            this.table.refresh();
        } else {
            this.toggleShowHideChannels(Collections.singletonList(channel));
        }
    }

    private void toggleShowHideChannels(Collection<? extends ChannelDisplayInfo> channels) {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty().getValue();
        if (imageDisplay == null || channels.isEmpty()) {
            return;
        }
        for (ChannelDisplayInfo channelDisplayInfo : channels) {
            imageDisplay.setChannelSelected(channelDisplayInfo, !this.isChannelShowing(channelDisplayInfo));
        }
        this.table.refresh();
    }

    public void updateTable() {
        this.table.refresh();
    }

    private TableRow<ChannelDisplayInfo> createTableRow(TableView<ChannelDisplayInfo> table) {
        TableRow row = new TableRow();
        row.setOnMouseClicked(e -> this.handleTableRowMouseClick((TableRow<ChannelDisplayInfo>)row, (MouseEvent)e));
        return row;
    }

    private ImageData<BufferedImage> getImageData() {
        ImageDisplay display = (ImageDisplay)this.imageDisplayProperty().get();
        if (display == null) {
            return null;
        }
        return display.getImageData();
    }

    private void handleTableRowMouseClick(TableRow<ChannelDisplayInfo> row, MouseEvent event) {
        if (event.getClickCount() != 2) {
            return;
        }
        ChannelDisplayInfo info = (ChannelDisplayInfo)row.getItem();
        ImageData<BufferedImage> imageData = this.getImageData();
        if (imageData == null) {
            return;
        }
        if (info instanceof DirectServerChannelInfo) {
            DirectServerChannelInfo multiInfo = (DirectServerChannelInfo)info;
            int c = multiInfo.getChannel();
            ImageChannel channel = imageData.getServerMetadata().getChannel(c);
            Color color = ColorToolsFX.getCachedColor(multiInfo.getColor());
            this.picker.setValue((Object)color);
            Dialog colorDialog = new Dialog();
            colorDialog.setTitle("Channel properties");
            colorDialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
            GridPane paneColor = new GridPane();
            int r = 0;
            Label labelName = new Label("Channel name");
            TextField tfName = new TextField(channel.getName());
            labelName.setLabelFor((Node)tfName);
            GridPaneUtils.addGridRow((GridPane)paneColor, (int)r++, (int)0, (String)"Enter a name for the current channel", (Node[])new Node[]{labelName, tfName});
            Label labelColor = new Label("Channel color");
            labelColor.setLabelFor((Node)this.picker);
            String colorTooltipText = "Choose the color for the current channel";
            GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{this.picker, tfName});
            GridPaneUtils.addGridRow((GridPane)paneColor, (int)r++, (int)0, (String)colorTooltipText, (Node[])new Node[]{labelColor, this.picker});
            paneColor.setVgap(5.0);
            paneColor.setHgap(5.0);
            colorDialog.getDialogPane().setContent((Node)paneColor);
            Platform.runLater(() -> ((TextField)tfName).requestFocus());
            Optional result = colorDialog.showAndWait();
            if (result.orElse(ButtonType.CANCEL) == ButtonType.APPLY) {
                String name = tfName.getText().trim();
                if (name.isEmpty()) {
                    Dialogs.showErrorMessage((String)"Set channel name", (String)"The channel name must not be empty!");
                    return;
                }
                Color color2 = (Color)this.picker.getValue();
                if (color == color2 && name.equals(channel.getName())) {
                    return;
                }
                this.updateChannelColor(multiInfo, name, color2);
            }
        }
    }

    private void updateChannelColor(DirectServerChannelInfo channel, String newName, Color newColor) {
        ImageData<BufferedImage> imageData = this.getImageData();
        if (imageData == null) {
            logger.warn("Cannot update channel color: no image data");
            return;
        }
        ImageServer server = imageData.getServer();
        Objects.requireNonNull(channel, "Channel cannot be null");
        Objects.requireNonNull(newName, "Channel name cannot be null");
        Objects.requireNonNull(newColor, "Channel color cannot be null");
        int channelIndex = channel.getChannel();
        ImageServerMetadata metadata = server.getMetadata();
        ArrayList<ImageChannel> channels = new ArrayList<ImageChannel>(metadata.getChannels());
        channels.set(channelIndex, ImageChannel.getInstance((String)newName, (Integer)ColorToolsFX.getRGB(newColor)));
        ImageServerMetadata metadata2 = new ImageServerMetadata.Builder(metadata).channels(channels).build();
        channel.setLUTColor((int)(newColor.getRed() * 255.0), (int)(newColor.getGreen() * 255.0), (int)(newColor.getBlue() * 255.0));
        imageData.updateServerMetadata(metadata2);
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty().getValue();
        if (imageDisplay != null) {
            imageDisplay.saveChannelColorProperties();
        }
        this.table.refresh();
    }

    public ReadOnlyObjectProperty<ChannelDisplayInfo> currentChannelProperty() {
        return this.table.getSelectionModel().selectedItemProperty();
    }

    public boolean isEmpty() {
        return this.table.getItems().isEmpty();
    }

    public MultipleSelectionModel<ChannelDisplayInfo> getSelectionModel() {
        return this.table.getSelectionModel();
    }

    private void handleAvailableChannelsChange(ListChangeListener.Change<? extends ChannelDisplayInfo> change) {
        this.refreshAvailableChannels();
    }

    private void refreshAvailableChannels() {
        ImageDisplay display = (ImageDisplay)this.imageDisplayProperty().get();
        ObservableList<ChannelDisplayInfo> items = display == null ? FXCollections.emptyObservableList() : display.availableChannels();
        ChannelDisplayInfo selected = (ChannelDisplayInfo)this.table.getSelectionModel().getSelectedItem();
        if (selected == null && this.imageDisplayProperty().get() != null) {
            selected = (ChannelDisplayInfo)((ImageDisplay)this.imageDisplayProperty().get()).switchToGrayscaleChannelProperty().get();
        }
        this.channelList.setAll(items);
        if (items.isEmpty()) {
            this.table.getSelectionModel().clearSelection();
        } else if (selected != null) {
            if (items.contains(selected)) {
                this.table.getSelectionModel().select((Object)selected);
            } else {
                String selectedName = selected.getName();
                ChannelDisplayInfo match = items.stream().filter(info -> Objects.equals(info.getName(), selectedName)).findFirst().orElse(null);
                if (match == null) {
                    this.table.getSelectionModel().selectFirst();
                } else {
                    this.table.getSelectionModel().select((Object)match);
                }
            }
        } else {
            this.table.getSelectionModel().selectFirst();
        }
        this.refreshShowAllCheckbox();
    }

    private void refreshShowAllCheckbox() {
        if (!this.channelList.isEmpty() && this.channelList.stream().allMatch(ChannelDisplayInfo::isAdditive)) {
            this.table.setContextMenu(this.popup);
            this.cbShowAll.setVisible(true);
        } else {
            this.table.setContextMenu(null);
            this.cbShowAll.setVisible(false);
        }
    }

    public ObjectProperty<ImageDisplay> imageDisplayProperty() {
        return this.imageDisplayObjectProperty;
    }

    private void updateShowTableColumnHeader() {
        Node header = this.table.lookup("#show-column > .label");
        if (header instanceof Label) {
            Label label = (Label)header;
            label.setContentDisplay(ContentDisplay.RIGHT);
            label.setGraphicTextGap(5.0);
            if (this.cbShowAll.isVisible()) {
                label.setGraphic((Node)this.cbShowAll);
            }
            this.cbShowAll.visibleProperty().addListener((v, o, n) -> label.setGraphic((Node)(n != false ? this.cbShowAll : null)));
        }
    }

    private void handleSelectedChannelChanged(ObservableValue<? extends ChannelDisplayInfo> observableValue, ChannelDisplayInfo oldValue, ChannelDisplayInfo newValue) {
        this.activeChannelVisible.set(newValue != null && this.isChannelShowing(newValue));
    }

    class SelectedChannelsChangeListener
    implements ListChangeListener<ChannelDisplayInfo> {
        SelectedChannelsChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends ChannelDisplayInfo> c) {
            ImageDisplay imageDisplay = (ImageDisplay)BrightnessContrastChannelPane.this.imageDisplayProperty().getValue();
            if (imageDisplay == null) {
                BrightnessContrastChannelPane.this.activeChannelVisible.set(false);
                return;
            }
            if (imageDisplay.availableChannels().size() == imageDisplay.selectedChannels().size()) {
                BrightnessContrastChannelPane.this.cbShowAll.setIndeterminate(false);
                BrightnessContrastChannelPane.this.cbShowAll.setSelected(true);
            } else if (imageDisplay.selectedChannels().isEmpty()) {
                BrightnessContrastChannelPane.this.cbShowAll.setIndeterminate(false);
                BrightnessContrastChannelPane.this.cbShowAll.setSelected(false);
            } else {
                BrightnessContrastChannelPane.this.cbShowAll.setIndeterminate(true);
            }
            BrightnessContrastChannelPane.this.table.refresh();
            ChannelDisplayInfo current = (ChannelDisplayInfo)BrightnessContrastChannelPane.this.currentChannelProperty().get();
            BrightnessContrastChannelPane.this.activeChannelVisible.set(current != null && BrightnessContrastChannelPane.this.isChannelShowing(current));
        }
    }

    private class ChannelTableKeypressedListener
    implements EventHandler<KeyEvent> {
        private final KeyCombination copyCombo = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        private final KeyCombination pasteCombo = new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        private final KeyCombination showCombo = new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
        private final KeyCombination hideCombo = new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
        private final KeyCombination toggleCombo = new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
        private final KeyCombination spaceCombo = new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
        private final KeyCombination enterCombo = new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});
        private final KeyCombination backspaceCombo = new KeyCodeCombination(KeyCode.BACK_SPACE, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY});

        private ChannelTableKeypressedListener() {
        }

        public void handle(KeyEvent event) {
            if (event.getEventType() != KeyEvent.KEY_PRESSED) {
                return;
            }
            if (this.copyCombo.match(event)) {
                this.doCopy(event);
                event.consume();
            } else if (this.pasteCombo.match(event)) {
                this.doPaste(event);
                event.consume();
            } else if (BrightnessContrastChannelPane.this.imageDisplayProperty().getValue() != null) {
                if (this.isToggleChannelsEvent(event)) {
                    BrightnessContrastChannelPane.this.toggleShowHideChannels(this.getSelectedChannelsToUpdate());
                    event.consume();
                } else if (this.isShowChannelsEvent(event)) {
                    BrightnessContrastChannelPane.this.setShowChannels(this.getSelectedChannelsToUpdate());
                    event.consume();
                } else if (this.isHideChannelsEvent(event)) {
                    BrightnessContrastChannelPane.this.setHideChannels(this.getSelectedChannelsToUpdate());
                    event.consume();
                }
            }
        }

        private boolean isToggleChannelsEvent(KeyEvent event) {
            return this.spaceCombo.match(event) || this.toggleCombo.match(event);
        }

        private boolean isShowChannelsEvent(KeyEvent event) {
            return this.enterCombo.match(event) || this.showCombo.match(event);
        }

        private boolean isHideChannelsEvent(KeyEvent event) {
            return this.backspaceCombo.match(event) || this.hideCombo.match(event);
        }

        private Collection<ChannelDisplayInfo> getSelectedChannelsToUpdate() {
            ChannelDisplayInfo mainSelectedChannel = (ChannelDisplayInfo)BrightnessContrastChannelPane.this.table.getSelectionModel().getSelectedItem();
            ImageDisplay imageDisplay = (ImageDisplay)BrightnessContrastChannelPane.this.imageDisplayProperty().getValue();
            if (mainSelectedChannel != null && imageDisplay != null && (imageDisplay.useGrayscaleLuts() || mainSelectedChannel != null && !mainSelectedChannel.isAdditive())) {
                return Collections.singletonList(mainSelectedChannel);
            }
            return BrightnessContrastChannelPane.this.table.getSelectionModel().getSelectedItems();
        }

        private void doCopy(KeyEvent event) {
            List<String> names = BrightnessContrastChannelPane.this.table.getSelectionModel().getSelectedItems().stream().map(ChannelDisplayInfo::getName).toList();
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(String.join((CharSequence)System.lineSeparator(), names));
            clipboard.setContent((Map)content);
        }

        private void doPaste(KeyEvent event) {
            ImageData<BufferedImage> imageData = BrightnessContrastChannelPane.this.getImageData();
            if (imageData == null) {
                return;
            }
            ImageServer server = imageData.getServer();
            Clipboard clipboard = Clipboard.getSystemClipboard();
            String string = clipboard.getString();
            if (string == null) {
                return;
            }
            ArrayList selected = new ArrayList(BrightnessContrastChannelPane.this.table.getSelectionModel().getSelectedItems());
            if (selected.isEmpty()) {
                return;
            }
            if (server.isRGB()) {
                logger.warn("Cannot set channel names for RGB images");
            }
            List<String> names = string.lines().toList();
            if (selected.size() != names.size()) {
                Dialogs.showErrorNotification((String)"Paste channel names", (String)"The number of lines on the clipboard doesn't match the number of channel names to replace!");
                return;
            }
            if (names.size() != new HashSet<String>(names).size()) {
                Dialogs.showErrorNotification((String)"Paste channel names", (String)"Channel names should be unique!");
                return;
            }
            ImageServerMetadata metadata = server.getMetadata();
            ArrayList<ImageChannel> channels = new ArrayList<ImageChannel>(metadata.getChannels());
            ArrayList<CallSite> changes = new ArrayList<CallSite>();
            for (int i = 0; i < selected.size(); ++i) {
                DirectServerChannelInfo info;
                if (!(selected.get(i) instanceof DirectServerChannelInfo) || (info = (DirectServerChannelInfo)selected.get(i)).getName().equals(names.get(i))) continue;
                int c = info.getChannel();
                ImageChannel oldChannel = (ImageChannel)channels.get(c);
                ImageChannel newChannel = ImageChannel.getInstance((String)names.get(i), (Integer)((ImageChannel)channels.get(c)).getColor());
                changes.add((CallSite)((Object)(oldChannel.getName() + " -> " + newChannel.getName())));
                channels.set(c, newChannel);
            }
            List allNewNames = channels.stream().map(ImageChannel::getName).collect(Collectors.toCollection(ArrayList::new));
            LinkedHashSet allNewNamesSet = new LinkedHashSet(allNewNames);
            if (allNewNames.size() != allNewNamesSet.size()) {
                Dialogs.showErrorMessage((String)"Channel", (String)"Cannot paste channels - names would not be unique \n(check log for details)");
                for (String n : allNewNamesSet) {
                    allNewNames.remove(n);
                }
                logger.warn("Requested channel names would result in duplicates: " + String.join((CharSequence)", ", allNewNames));
                return;
            }
            if (changes.isEmpty()) {
                logger.debug("Channel names pasted, but no changes to make");
            } else {
                Dialog dialog = new Dialog();
                dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
                dialog.setTitle("Channels");
                dialog.setHeaderText("Confirm new channel names?");
                dialog.getDialogPane().setContent((Node)new TextArea(String.join((CharSequence)"\n", changes)));
                if (dialog.showAndWait().orElse(ButtonType.CANCEL) == ButtonType.APPLY) {
                    ImageServerMetadata newMetadata = new ImageServerMetadata.Builder(metadata).channels(channels).build();
                    imageData.updateServerMetadata(newMetadata);
                }
            }
        }
    }

    private class ShowChannelDisplayTableCell
    extends CheckBoxTableCell<ChannelDisplayInfo, Boolean> {
        public ShowChannelDisplayTableCell() {
            this.addEventFilter(MouseEvent.MOUSE_CLICKED, this::filterMouseClicks);
        }

        private void filterMouseClicks(MouseEvent event) {
            TableView tableView;
            if (event.isPopupTrigger()) {
                return;
            }
            int ind = this.getIndex();
            if (ind < (tableView = this.getTableView()).getItems().size()) {
                if (event.isShiftDown()) {
                    tableView.getSelectionModel().select(ind);
                } else {
                    tableView.getSelectionModel().clearAndSelect(ind);
                }
                ChannelDisplayInfo channel = (ChannelDisplayInfo)this.getTableRow().getItem();
                if (event.getTarget() == this && channel != null) {
                    BrightnessContrastChannelPane.this.toggleShowHideChannel(channel);
                }
                event.consume();
            }
        }
    }

    private class ChannelDisplayTableCell
    extends TableCell<ChannelDisplayInfo, ChannelDisplayInfo> {
        private static final int MAX_CUSTOM_COLORS = 60;
        private final ColorPicker colorPicker;
        private final ObservableList<Color> customColors;
        private boolean updatingTableCell = false;
        private final Comparator<Color> comparator = Comparator.comparingDouble(Color::getHue).thenComparingDouble(Color::getSaturation).thenComparingDouble(Color::getBrightness).thenComparingDouble(Color::getOpacity).thenComparingDouble(Color::getRed).thenComparingDouble(Color::getGreen).thenComparingDouble(Color::getBrightness);

        private ChannelDisplayTableCell(ObservableList<Color> customColors) {
            this.customColors = customColors;
            this.colorPicker = new ColorPicker();
            this.colorPicker.getStyleClass().addAll((Object[])new String[]{"button", "minimal-color-picker", "always-opaque"});
            this.colorPicker.setOnHiding(e -> this.handleColorChange((Color)this.colorPicker.getValue()));
            this.setGraphic((Node)this.colorPicker);
            this.setEditable(true);
        }

        private ChannelDisplayTableCell() {
            this(null);
            brightnessContrastChannelPane.currentChannelProperty().addListener((observable, oldValue, newValue) -> this.updateStyle());
            this.updateStyle();
        }

        private void updateStyle() {
            if (this.getItem() == BrightnessContrastChannelPane.this.currentChannelProperty().get()) {
                this.setStyle("-fx-font-weight: bold");
            } else {
                this.setStyle("");
            }
        }

        protected void updateItem(ChannelDisplayInfo item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            this.setText(item.getName());
            this.setGraphic((Node)this.colorPicker);
            this.updateStyle();
            ImageData<BufferedImage> imageData = BrightnessContrastChannelPane.this.getImageData();
            boolean isRGB = imageData != null && imageData.getServerMetadata().isRGB();
            Integer channelRGB = item.getColor();
            boolean canChangeColor = channelRGB != null && item instanceof DirectServerChannelInfo;
            this.colorPicker.setDisable(!canChangeColor);
            this.colorPicker.setOnShowing(null);
            if (channelRGB == null) {
                this.colorPicker.setValue((Object)Color.TRANSPARENT);
            } else {
                Color color = ColorToolsFX.getCachedColor(channelRGB);
                this.setColorQuietly(color);
                this.colorPicker.setOnShowing(e -> {
                    if (this.customColors == null) {
                        this.colorPicker.getCustomColors().setAll((Object[])new Color[]{color});
                    } else {
                        if (!this.customColors.contains((Object)color)) {
                            if (this.customColors.size() > 60) {
                                this.customColors.clear();
                            }
                            this.customColors.add((Object)color);
                            Collections.sort(this.customColors, this.comparator);
                        }
                        this.colorPicker.getCustomColors().setAll(this.customColors);
                    }
                });
            }
        }

        private void setColorQuietly(Color color) {
            this.updatingTableCell = true;
            this.colorPicker.setValue((Object)color);
            this.updatingTableCell = false;
        }

        private void handleColorChange(Color newValue) {
            if (this.updatingTableCell) {
                return;
            }
            if (newValue == null) {
                logger.warn("Can't set channel color to null!");
                return;
            }
            ChannelDisplayInfo item = (ChannelDisplayInfo)this.getItem();
            if (item instanceof DirectServerChannelInfo) {
                DirectServerChannelInfo directInfo = (DirectServerChannelInfo)item;
                String name = directInfo.getOriginalChannelName();
                if (name == null) {
                    name = item.getName();
                }
                BrightnessContrastChannelPane.this.updateChannelColor(directInfo, name, newValue);
            } else {
                logger.debug("Invalid channel type - cannot set color for {}", (Object)item);
            }
        }
    }
}

