/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.util.Duration;
import qupath.lib.gui.viewer.QuPathViewer;

class ZoomCommand
implements Runnable {
    private ObservableValue<? extends QuPathViewer> viewerValue;
    private int zoomAmount;
    private Timeline timer;

    public ZoomCommand(ObservableValue<? extends QuPathViewer> viewerValue, int zoomAmount) {
        this.viewerValue = viewerValue;
        this.zoomAmount = zoomAmount;
    }

    @Override
    public void run() {
        QuPathViewer viewer = (QuPathViewer)this.viewerValue.getValue();
        if (viewer != null) {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, actionEvent -> viewer.zoomIn((int)((double)this.zoomAmount / (this.timer.getCurrentTime().toMillis() / 10.0 + 1.0))), new KeyValue[0]), new KeyFrame(Duration.millis((double)20.0), new KeyValue[0])});
            this.timer.setCycleCount(15);
            this.timer.playFromStart();
        }
    }

    public static ZoomCommand createZoomInCommand(ObservableValue<? extends QuPathViewer> viewerValue) {
        return new ZoomCommand(viewerValue, -10);
    }

    public static ZoomCommand createZoomOutCommand(ObservableValue<? extends QuPathViewer> viewerValue) {
        return new ZoomCommand(viewerValue, 10);
    }
}

