/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.FilteredList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.io.UriResource;
import qupath.lib.io.UriUpdater;

public class UpdateUrisCommand<T extends UriResource> {
    private static final Logger logger = LoggerFactory.getLogger(UpdateUrisCommand.class);
    private static int maxRecursiveSearchDepth = 8;
    private final UriUpdater<T> updater;
    private final ObservableMap<UriUpdater.SingleUriItem, UriUpdater.SingleUriItem> replacements = FXCollections.observableMap(new HashMap());
    private GridPane pane;
    private final TableView<UriUpdater.SingleUriItem> table = new TableView();
    private final ObservableList<UriUpdater.SingleUriItem> allItems = FXCollections.observableArrayList();
    private final BooleanProperty showMissing = new SimpleBooleanProperty(true);
    private final BooleanProperty showValid = new SimpleBooleanProperty(true);
    private final BooleanProperty showUnknown = new SimpleBooleanProperty(true);

    private UpdateUrisCommand(Collection<T> resources) throws IOException {
        this.updater = UriUpdater.create(resources, this.allItems, this.replacements);
        this.updater.searchDepth(maxRecursiveSearchDepth);
    }

    Pane getPane() {
        if (this.pane == null) {
            this.pane = new GridPane();
            this.initialize();
        }
        return this.pane;
    }

    UriUpdater<T> getUpdater() {
        return this.updater;
    }

    public static <T extends UriResource> int promptToUpdateUris(Collection<T> items, URI basePrevious, URI baseCurrent, boolean onlyPromptIfMissing) throws IOException {
        UpdateUrisCommand<T> manager = new UpdateUrisCommand<T>(items);
        UriUpdater<T> updater = manager.getUpdater();
        int nMissing = updater.countMissing();
        if (onlyPromptIfMissing && nMissing == 0) {
            return 0;
        }
        if (basePrevious != null && baseCurrent != null) {
            updater.relative(basePrevious, baseCurrent);
            int nReplacements = updater.countReplacements();
            Map replacements = updater.getReplacements();
            if (onlyPromptIfMissing && nReplacements == nMissing && replacements.values().stream().allMatch(u -> u.getPath() != null && u.getPath().startsWith(baseCurrent.getPath()))) {
                if (nReplacements == 1) {
                    logger.info("Updated 1 relative URI");
                } else {
                    logger.info("Updated {} relative URIs", (Object)nReplacements);
                }
                updater.applyReplacements();
                return nReplacements;
            }
        }
        Dialog dialog = new Dialog();
        dialog.setHeaderText("Files may have been deleted or moved!\nFix broken paths here by double-clicking on red entries and/or accepting QuPath's suggestions.");
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
        ((Button)dialog.getDialogPane().lookupButton(ButtonType.YES)).setText("Apply changes");
        ((Button)dialog.getDialogPane().lookupButton(ButtonType.NO)).setText("Ignore");
        dialog.getDialogPane().setContent((Node)manager.getPane());
        dialog.setTitle("Update URIs");
        dialog.setResizable(true);
        ButtonType btn = dialog.showAndWait().orElse(ButtonType.CANCEL);
        if (btn.equals(ButtonType.CANCEL)) {
            return -1;
        }
        if (btn.equals(ButtonType.NO)) {
            return 0;
        }
        int n = 0;
        try {
            n = updater.applyReplacements();
            if (n <= 0) {
                Dialogs.showInfoNotification((String)"Update URIs", (String)"No URIs updated!");
            } else if (n == 1) {
                Dialogs.showInfoNotification((String)"Update URIs", (String)"1 URI updated");
            } else {
                Dialogs.showInfoNotification((String)"Update URIs", (String)(n + " URIs updated"));
            }
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Update URIs", (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
        }
        return n;
    }

    private void initialize() {
        TableColumn colOriginal = new TableColumn("Original URI");
        colOriginal.setCellValueFactory(item -> Bindings.createObjectBinding(() -> ((TableColumn.CellDataFeatures)item).getValue(), (Observable[])new Observable[0]));
        colOriginal.setCellFactory(col -> new UriCell());
        this.table.getColumns().add((Object)colOriginal);
        TableColumn colReplacement = new TableColumn("Replacement URI");
        colReplacement.setCellValueFactory(item -> Bindings.createObjectBinding(() -> (UriUpdater.SingleUriItem)this.replacements.get(item.getValue()), (Observable[])new Observable[]{this.replacements}));
        colReplacement.setCellFactory(col -> new UriCell());
        this.table.getColumns().add((Object)colReplacement);
        FilteredList filteredList = this.allItems.filtered((Predicate)new TableFilter());
        this.table.setItems((ObservableList)filteredList);
        this.showMissing.addListener((v, o, n) -> filteredList.setPredicate((Predicate)new TableFilter()));
        this.showUnknown.addListener((v, o, n) -> filteredList.setPredicate((Predicate)new TableFilter()));
        this.showValid.addListener((v, o, n) -> filteredList.setPredicate((Predicate)new TableFilter()));
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table.setPrefSize(600.0, 400.0);
        long nMissing = this.countOriginalItems(UriUpdater.UriStatus.MISSING);
        long nExists = this.countOriginalItems(UriUpdater.UriStatus.EXISTS);
        long nUnknown = this.countOriginalItems(UriUpdater.UriStatus.UNKNOWN);
        CheckBox cbMissing = new CheckBox(String.format("Show missing (%d)", nMissing));
        cbMissing.selectedProperty().bindBidirectional((Property)this.showMissing);
        CheckBox cbValid = new CheckBox(String.format("Show valid (%d)", nExists));
        cbValid.selectedProperty().bindBidirectional((Property)this.showValid);
        CheckBox cbUnknown = new CheckBox(String.format("Show unknown (%d)", nUnknown));
        cbUnknown.selectedProperty().bindBidirectional((Property)this.showUnknown);
        Label labelReplacements = new Label();
        labelReplacements.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "Number of replacements: " + this.replacements.size(), (Observable[])new Observable[]{this.replacements}));
        Button btnSearch = new Button("Search...");
        btnSearch.setTooltip(new Tooltip("Choose a directory & search recursively for images inside"));
        btnSearch.setOnAction(e -> {
            File dir = FileChoosers.promptForDirectory((Window)FXUtils.getWindow((Node)btnSearch), (String)"Search directory", null);
            if (dir == null) {
                logger.debug("Search for URIs cancelled!");
                return;
            }
            this.updater.searchPath(dir.toPath());
        });
        int row = 0;
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, null, (Node[])new Node[]{this.table, this.table, this.table});
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, null, (Node[])new Node[]{labelReplacements, labelReplacements, btnSearch});
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row, (int)0, null, (Node[])new Node[]{cbValid});
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row, (int)1, null, (Node[])new Node[]{cbMissing});
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)2, null, (Node[])new Node[]{cbUnknown});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{cbValid, cbMissing, cbUnknown, labelReplacements, this.table});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{cbValid, cbMissing, cbUnknown, labelReplacements, this.table});
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{cbValid, cbMissing, cbUnknown, labelReplacements, this.table});
        GridPane.setHalignment((Node)btnSearch, (HPos)HPos.RIGHT);
        this.pane.setHgap(5.0);
        this.pane.setVgap(5.0);
        this.table.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new TableCopyPasteHandler());
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    private int countOriginalItems(UriUpdater.UriStatus status) {
        int n = 0;
        for (UriUpdater.SingleUriItem item : this.allItems) {
            if (item.getStatus() != status) continue;
            ++n;
        }
        return n;
    }

    boolean handleCopy() {
        StringBuilder sb = new StringBuilder();
        for (UriUpdater.SingleUriItem uriItem : this.table.getSelectionModel().getSelectedItems()) {
            URI uri = uriItem.getURI();
            if (!sb.isEmpty()) {
                sb.append(System.lineSeparator());
            }
            sb.append(uri.toString());
            sb.append("\t");
            UriUpdater.SingleUriItem uri2 = (UriUpdater.SingleUriItem)this.replacements.get((Object)uriItem);
            if (uri2 == null) continue;
            sb.append(uri2.getURI().toString());
        }
        if (sb.isEmpty()) {
            return false;
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(sb.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
        return true;
    }

    boolean handlePaste() {
        block10: {
            String s = Clipboard.getSystemClipboard().getString();
            if (s == null) {
                return false;
            }
            Scanner scanner = new Scanner(s);
            block7: while (true) {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] split = line.split("\t");
                    if (split.length <= 1) continue;
                    try {
                        URI uri1 = GeneralTools.toURI((String)split[0]);
                        URI uri2 = GeneralTools.toURI((String)split[1]);
                        if (uri1 == null || uri2 == null) continue block7;
                        this.updater.makeReplacement(uri1, uri2);
                        this.table.refresh();
                        continue block7;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to parse URIs from {} ({})", (Object)line, (Object)e.getLocalizedMessage());
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                scanner.close();
            }
        }
        return true;
    }

    class TableFilter
    implements Predicate<UriUpdater.SingleUriItem> {
        TableFilter() {
        }

        @Override
        public boolean test(UriUpdater.SingleUriItem item) {
            return switch (item.getStatus()) {
                case UriUpdater.UriStatus.EXISTS -> UpdateUrisCommand.this.showValid.get();
                case UriUpdater.UriStatus.MISSING -> UpdateUrisCommand.this.showMissing.get();
                default -> UpdateUrisCommand.this.showUnknown.get();
            };
        }
    }

    class TableCopyPasteHandler
    implements EventHandler<KeyEvent> {
        private final KeyCombination copyCombo = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        private final KeyCombination pasteCombo = new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});

        TableCopyPasteHandler() {
        }

        public void handle(KeyEvent event) {
            if (this.copyCombo.match(event)) {
                UpdateUrisCommand.this.handleCopy();
            } else if (this.pasteCombo.match(event)) {
                UpdateUrisCommand.this.handlePaste();
            }
        }
    }

    class UriCell
    extends TableCell<UriUpdater.SingleUriItem, UriUpdater.SingleUriItem>
    implements EventHandler<MouseEvent> {
        private Tooltip tooltip = new Tooltip();

        UriCell() {
            this.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, this);
        }

        protected void updateItem(UriUpdater.SingleUriItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setTooltip(null);
                this.setText("");
                return;
            }
            String displayableText = URLDecoder.decode(item.toString(), StandardCharsets.UTF_8);
            this.setText(displayableText);
            this.tooltip.setText(displayableText);
            this.setTooltip(this.tooltip);
            switch (item.getStatus()) {
                case EXISTS: {
                    this.setStyle(null);
                    break;
                }
                case MISSING: {
                    this.setStyle("-fx-text-fill: red");
                    break;
                }
                default: {
                    this.setStyle("-fx-text-fill: gray");
                }
            }
        }

        public void handle(MouseEvent event) {
            if (event.getClickCount() != 2) {
                return;
            }
            TableRow row = this.getTableRow();
            UriUpdater.SingleUriItem uriOriginal = (UriUpdater.SingleUriItem)row.getItem();
            if (uriOriginal == null) {
                return;
            }
            UriUpdater.SingleUriItem uriReplacement = (UriUpdater.SingleUriItem)UpdateUrisCommand.this.replacements.get((Object)uriOriginal);
            String defaultPath = uriReplacement == null ? uriOriginal.getURI().toString() : uriReplacement.getURI().toString();
            String path = FileChoosers.promptForFilePathOrURI((Window)FXUtils.getWindow((Node)this), (String)"Change URI", (String)defaultPath, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[0]);
            if (path != null && !path.isBlank()) {
                URI uri = null;
                try {
                    uri = GeneralTools.toURI((String)path);
                }
                catch (URISyntaxException e) {
                    logger.error("Error parsing URI", (Throwable)e);
                }
                if (uri == null) {
                    Dialogs.showErrorMessage((String)"Change URI", (String)("Unable to parse URI from " + path));
                } else {
                    UpdateUrisCommand.this.updater.makeReplacement(uriOriginal.getURI(), uri);
                }
            } else {
                UpdateUrisCommand.this.updater.makeReplacement(uriOriginal.getURI(), null);
            }
            UpdateUrisCommand.this.table.refresh();
        }
    }
}

