/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.analysis.stats.RunningStatistics;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.commands.TMADataImporter;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tma.TMADataIO;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.DefaultTMAGrid;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.scripting.QP;

public class TMACommands {
    private static final Logger logger = LoggerFactory.getLogger(TMACommands.class);
    private static final String NOTE_NAME = "Note";
    private static StringProperty rowLabelsProperty = PathPrefs.createPersistentPreference("tmaRowLabels", "A-J");
    private static StringProperty columnLabelsProperty = PathPrefs.createPersistentPreference("tmaColumnLabels", "1-16");
    private static BooleanProperty rowFirstProperty = PathPrefs.createPersistentPreference("tmaLabelRowFirst", true);
    private static DoubleProperty coreDiameterProperty = PathPrefs.createPersistentPreference("tmaCoreDiameter", 1000.0);

    public static void promptToAddNoteToSelectedCores(ImageData<?> imageData) {
        Object prompt;
        String title = "Add TMA note";
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return;
        }
        List<TMACoreObject> selectedCores = imageData.getHierarchy().getSelectionModel().getSelectedObjects().stream().filter(p -> p.isTMACore()).map(c -> (TMACoreObject)c).toList();
        if (selectedCores.isEmpty()) {
            Dialogs.showErrorMessage((String)title, (String)"No TMA cores are selected!  No note will be added.");
            return;
        }
        String currentText = null;
        if (selectedCores.size() == 1) {
            TMACoreObject core = selectedCores.get(0);
            prompt = core.getName() == null || core.getName().trim().isEmpty() ? "Core" : core.getName();
            currentText = (String)core.getMetadata().get(NOTE_NAME);
        } else {
            prompt = selectedCores.size() + " cores";
        }
        String inputText = Dialogs.showInputDialog((String)title, (String)prompt, (String)(currentText == null ? "" : currentText));
        if (inputText != null) {
            for (TMACoreObject core : selectedCores) {
                core.putMetadataValue(NOTE_NAME, inputText);
            }
            imageData.getHierarchy().fireObjectsChangedEvent((Object)imageData.getHierarchy(), selectedCores);
        }
    }

    public static void promptToExportTMAData(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        PathObjectHierarchy hierarchy;
        String title = "Export TMA data";
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return;
        }
        PathObjectHierarchy pathObjectHierarchy = hierarchy = imageData == null ? null : imageData.getHierarchy();
        if (hierarchy == null || hierarchy.isEmpty() || hierarchy.getTMAGrid() == null || hierarchy.getTMAGrid().nCores() == 0) {
            Dialogs.showErrorMessage((String)title, (String)"No TMA data available!");
            return;
        }
        OverlayOptions overlayOptions = qupath.getAllViewers().stream().filter(v -> v.getImageData() == imageData).map(v -> v.getOverlayOptions()).findFirst().orElse(qupath.getOverlayOptions());
        String defaultName = ServerTools.getDisplayableImageName((ImageServer)imageData.getServer());
        File file = FileChoosers.promptToSaveFile(null, (File)new File(defaultName), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"TMA data", (String[])new String[]{".qptma"})});
        if (file != null) {
            if (!file.getName().endsWith(".qptma")) {
                file = new File(file.getParentFile(), file.getName() + ".qptma");
            }
            double downsample = PathPrefs.tmaExportDownsampleProperty().get();
            try {
                TMADataIO.writeTMAData(file, imageData, overlayOptions, downsample);
                DefaultScriptableWorkflowStep step = new DefaultScriptableWorkflowStep("Export TMA data", "exportTMAData(\"" + GeneralTools.escapeFilePath((String)file.getParentFile().getAbsolutePath()) + "\", " + downsample + ")");
                imageData.getHistoryWorkflow().addStep((WorkflowStep)step);
            }
            catch (IOException e) {
                Dialogs.showErrorMessage((String)title, (Throwable)e);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static synchronized void installDragAndDropHandler(QuPathGUI qupath) {
        TMADataImporter.installDragAndDropHandler(qupath);
    }

    public static void promptToImportTMAData(ImageData<?> imageData) {
        TMADataImporter.importTMAData(imageData);
    }

    public static void promptToRelabelTMAGrid(ImageData<?> imageData) {
        String title = "Relabel TMA grid";
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return;
        }
        if (imageData.getHierarchy().getTMAGrid() == null) {
            Dialogs.showErrorMessage((String)title, (String)"No TMA grid selected!");
            return;
        }
        ParameterList params = new ParameterList();
        params.addStringParameter("labelsHorizontal", "Column labels", (String)columnLabelsProperty.get(), "Enter column labels.\nThis can be a continuous range of letters or numbers (e.g. 1-10 or A-J),\nor a discontinuous list separated by spaces (e.g. A B C E F G).");
        params.addStringParameter("labelsVertical", "Row labels", (String)rowLabelsProperty.get(), "Enter row labels.\nThis can be a continuous range of letters or numbers (e.g. 1-10 or A-J),\nor a discontinuous list separated by spaces (e.g. A B C E F G).");
        params.addChoiceParameter("labelOrder", "Label order", (Object)(rowFirstProperty.get() ? "Row first" : "Column first"), Arrays.asList("Column first", "Row first"), "Create TMA labels either in the form Row-Column or Column-Row");
        if (!GuiTools.showParameterDialog(title, params)) {
            return;
        }
        String labelsHorizontal = params.getStringParameterValue("labelsHorizontal");
        String labelsVertical = params.getStringParameterValue("labelsVertical");
        boolean rowFirst = "Row first".equals(params.getChoiceParameterValue("labelOrder"));
        TMAGrid grid = imageData.getHierarchy().getTMAGrid();
        String[] columnLabels = PathObjectTools.parseTMALabelString((String)labelsHorizontal);
        String[] rowLabels = PathObjectTools.parseTMALabelString((String)labelsVertical);
        if (columnLabels.length < grid.getGridWidth()) {
            Dialogs.showErrorMessage((String)title, (String)"Not enough column labels specified!");
            return;
        }
        if (rowLabels.length < grid.getGridHeight()) {
            Dialogs.showErrorMessage((String)title, (String)"Not enough row labels specified!");
            return;
        }
        QP.relabelTMAGrid((PathObjectHierarchy)imageData.getHierarchy(), (String)labelsHorizontal, (String)labelsVertical, (boolean)rowFirst);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Relabel TMA grid", String.format("relabelTMAGrid(\"%s\", \"%s\", %s)", GeneralTools.escapeFilePath((String)labelsHorizontal), GeneralTools.escapeFilePath((String)labelsVertical), Boolean.toString(rowFirst))));
        rowLabelsProperty.set((Object)labelsVertical);
        columnLabelsProperty.set((Object)labelsHorizontal);
        rowFirstProperty.set(rowFirst);
    }

    public static boolean promptToDeleteTMAGridRow(ImageData<?> imageData) {
        return TMACommands.promptToDeleteTMAGridRowOrColumn(imageData, TMARemoveType.ROW);
    }

    public static boolean promptToDeleteTMAGridColumn(ImageData<?> imageData) {
        return TMACommands.promptToDeleteTMAGridRowOrColumn(imageData, TMARemoveType.COLUMN);
    }

    private static boolean promptToDeleteTMAGridRowOrColumn(ImageData<?> imageData, TMARemoveType type) {
        int num;
        boolean removeRow;
        String typeString = type.toString();
        String title = "Delete TMA " + typeString;
        boolean bl = removeRow = type == TMARemoveType.ROW;
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return false;
        }
        if (imageData.getHierarchy().getTMAGrid() == null) {
            Dialogs.showErrorMessage((String)title, (String)"No image with dearrayed TMA cores selected!");
            return false;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        TMACoreObject selectedCore = null;
        if (selected != null) {
            selectedCore = PathObjectTools.getAncestorTMACore((PathObject)selected);
        }
        TMAGrid grid = hierarchy.getTMAGrid();
        int row = -1;
        int col = -1;
        if (selectedCore != null) {
            block0: for (int y = 0; y < grid.getGridHeight(); ++y) {
                for (int x = 0; x < grid.getGridWidth(); ++x) {
                    if (grid.getTMACore(y, x) != selectedCore) continue;
                    row = y;
                    col = x;
                    continue block0;
                }
            }
        }
        if (row < 0 || col < 0) {
            Dialogs.showErrorMessage((String)title, (String)("Please select a TMA core to indicate which " + typeString + " to remove"));
            return false;
        }
        if (removeRow && grid.getGridHeight() <= 1 || !removeRow && grid.getGridWidth() <= 1) {
            if (Dialogs.showConfirmDialog((String)title, (String)"Are you sure you want to delete the entire TMA grid?")) {
                hierarchy.setTMAGrid(null);
                if (selected instanceof TMACoreObject || hierarchy.getSelectionModel().getSelectedObjects().stream().anyMatch(p -> p.isTMACore())) {
                    hierarchy.getSelectionModel().clearSelection();
                }
            }
            return false;
        }
        int n = num = removeRow ? row : col;
        if (!Dialogs.showConfirmDialog((String)title, (String)("Are you sure you want to delete " + typeString + " " + (num + 1) + " from TMA grid?"))) {
            return false;
        }
        ArrayList<TMACoreObject> coresNew = new ArrayList<TMACoreObject>();
        for (int r = 0; r < grid.getGridHeight(); ++r) {
            if (removeRow && row == r) continue;
            for (int c = 0; c < grid.getGridWidth(); ++c) {
                if (!removeRow && col == c) continue;
                coresNew.add(grid.getTMACore(r, c));
            }
        }
        int newWidth = removeRow ? grid.getGridWidth() : grid.getGridWidth() - 1;
        TMAGrid gridNew = DefaultTMAGrid.create(coresNew, (int)newWidth);
        hierarchy.setTMAGrid(gridNew);
        hierarchy.getSelectionModel().clearSelection();
        TMACommands.promptToRelabelTMAGrid(imageData);
        return true;
    }

    public static boolean promptToCreateTMAGrid(ImageData<?> imageData) {
        String title = "Create TMA grid";
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return false;
        }
        if (imageData.getHierarchy().getTMAGrid() != null && !Dialogs.showConfirmDialog((String)title, (String)"Existing TMA grid will be removed - are you sure?")) {
            return false;
        }
        String units = imageData.getServer().getPixelCalibration().getPixelWidthUnit();
        ParameterList params = new ParameterList();
        params.addStringParameter("labelsHorizontal", "Column labels", (String)columnLabelsProperty.get(), "Enter column labels.\nThis can be a continuous range of letters or numbers (e.g. 1-10 or A-J),\nor a discontinuous list separated by spaces (e.g. A B C E F G).");
        params.addStringParameter("labelsVertical", "Row labels", (String)rowLabelsProperty.get(), "Enter row labels.\nThis can be a continuous range of letters or numbers (e.g. 1-10 or A-J),\nor a discontinuous list separated by spaces (e.g. A B C E F G).");
        params.addChoiceParameter("labelOrder", "Label order", (Object)(rowFirstProperty.get() ? "Row first" : "Column first"), Arrays.asList("Column first", "Row first"), "Create TMA labels either in the form Row-Column or Column-Row");
        params.addDoubleParameter("coreDiameter", "Core diameter", coreDiameterProperty.get(), units, "Diameter of each individual TMA core");
        params.addEmptyParameter("Tip: You can control the size of the grid by drawing a rectangle annotation");
        if (!GuiTools.showParameterDialog(title, params)) {
            return false;
        }
        String labelsHorizontal = params.getStringParameterValue("labelsHorizontal");
        String labelsVertical = params.getStringParameterValue("labelsVertical");
        boolean rowFirst = "Row first".equals(params.getChoiceParameterValue("labelOrder"));
        double diameter = params.getDoubleParameterValue("coreDiameter");
        if (diameter <= 0.0) {
            Dialogs.showErrorMessage((String)title, (String)"Core diameter must be > 0!");
            return false;
        }
        PathObjectTools.addTMAGrid(imageData, (String)labelsHorizontal, (String)labelsVertical, (boolean)rowFirst, (double)diameter);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Relabel TMA grid", String.format("createTMAGrid(\"%s\", \"%s\", %s, %s)", GeneralTools.escapeFilePath((String)labelsHorizontal), GeneralTools.escapeFilePath((String)labelsVertical), Boolean.toString(rowFirst), diameter)));
        rowLabelsProperty.set((Object)labelsVertical);
        columnLabelsProperty.set((Object)labelsHorizontal);
        rowFirstProperty.set(rowFirst);
        coreDiameterProperty.set(diameter);
        return false;
    }

    public static boolean promptToAddRowAfterSelected(ImageData<?> imageData) {
        return TMACommands.promptToAddTMARowOrColumn(imageData, TMAAddType.ROW_AFTER);
    }

    public static boolean promptToAddRowBeforeSelected(ImageData<?> imageData) {
        return TMACommands.promptToAddTMARowOrColumn(imageData, TMAAddType.ROW_BEFORE);
    }

    public static boolean promptToAddColumnAfterSelected(ImageData<?> imageData) {
        return TMACommands.promptToAddTMARowOrColumn(imageData, TMAAddType.COLUMN_AFTER);
    }

    public static boolean promptToAddColumnBeforeSelected(ImageData<?> imageData) {
        return TMACommands.promptToAddTMARowOrColumn(imageData, TMAAddType.COLUMN_BEFORE);
    }

    private static boolean promptToAddTMARowOrColumn(ImageData<?> imageData, TMAAddType type) {
        String NAME = type.commandName();
        if (imageData == null) {
            GuiTools.showNoImageError(NAME);
            return false;
        }
        if (imageData.getHierarchy().getTMAGrid() == null) {
            Dialogs.showErrorMessage((String)NAME, (String)"No image with dearrayed TMA cores selected!");
            return false;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        TMACoreObject selectedCore = null;
        if (selected != null) {
            selectedCore = PathObjectTools.getAncestorTMACore((PathObject)selected);
        }
        TMAGrid gridNew = TMACommands.createAugmentedTMAGrid(hierarchy, selectedCore, type);
        double w = imageData.getServer().getWidth();
        double h = imageData.getServer().getHeight();
        int outsideCores = 0;
        for (TMACoreObject core : gridNew.getTMACoreList()) {
            if (!core.hasROI()) continue;
            double x = core.getROI().getCentroidX();
            double y = core.getROI().getCentroidY();
            if (!(x < 0.0 || x >= w || y < 0.0) && !(y >= h) || hierarchy.getTMAGrid().getTMACoreList().contains(core)) continue;
            ++outsideCores;
        }
        if (outsideCores > 0) {
            String label;
            String string = label = outsideCores == 1 ? "core" : "cores";
            if (!Dialogs.showConfirmDialog((String)"Add to TMA Grid", (String)("Not enough space within image to store " + outsideCores + " new " + label + " - proceed anyway?"))) {
                return false;
            }
        }
        hierarchy.setTMAGrid(gridNew);
        TMACommands.promptToRelabelTMAGrid(imageData);
        return true;
    }

    private static TMAGrid createAugmentedTMAGrid(PathObjectHierarchy hierarchy, TMACoreObject selectedCore, TMAAddType type) {
        TMAGrid grid = hierarchy.getTMAGrid();
        boolean addAfter = type == TMAAddType.COLUMN_AFTER || type == TMAAddType.ROW_AFTER;
        boolean addColumn = type == TMAAddType.COLUMN_AFTER || type == TMAAddType.COLUMN_BEFORE;
        int row = -1;
        int col = -1;
        if (selectedCore != null) {
            block6: for (int y = 0; y < grid.getGridHeight(); ++y) {
                for (int x = 0; x < grid.getGridWidth(); ++x) {
                    if (grid.getTMACore(y, x) != selectedCore) continue;
                    if (addAfter) {
                        row = y + 1;
                        col = x + 1;
                        continue block6;
                    }
                    row = y;
                    col = x;
                    continue block6;
                }
            }
        }
        if (row < 0) {
            switch (type.ordinal()) {
                case 2: {
                    col = grid.getGridWidth();
                    break;
                }
                case 3: {
                    col = 0;
                    break;
                }
                case 0: {
                    row = grid.getGridHeight();
                    break;
                }
                case 1: {
                    row = 0;
                    break;
                }
            }
        }
        int newWidth = addColumn ? grid.getGridWidth() + 1 : grid.getGridWidth();
        int newHeight = addColumn ? grid.getGridHeight() : grid.getGridHeight() + 1;
        RunningStatistics statsWidth = new RunningStatistics();
        RunningStatistics statsHeight = new RunningStatistics();
        RunningStatistics statsDx = new RunningStatistics();
        RunningStatistics statsDy = new RunningStatistics();
        for (int r = 0; r < grid.getGridHeight(); ++r) {
            TMACoreObject coreColBefore = null;
            for (int c = 0; c < grid.getGridWidth(); ++c) {
                TMACoreObject coreRowBefore;
                TMACoreObject core = grid.getTMACore(r, c);
                if (!core.hasROI()) continue;
                statsWidth.addValue(core.getROI().getBoundsWidth());
                statsHeight.addValue(core.getROI().getBoundsHeight());
                if (coreColBefore != null && coreColBefore.hasROI()) {
                    statsDx.addValue(core.getROI().getCentroidX() - coreColBefore.getROI().getCentroidX());
                }
                if (r > 0 && (coreRowBefore = grid.getTMACore(r - 1, c)) != null && coreRowBefore.hasROI()) {
                    statsDy.addValue(core.getROI().getCentroidY() - coreRowBefore.getROI().getCentroidY());
                }
                coreColBefore = core;
            }
        }
        double meanWidth = statsWidth.getMean();
        double meanHeight = statsHeight.getMean();
        double meanDx = statsDx.getMean();
        double meanDy = statsDy.getMean();
        double diameter = (meanWidth + meanHeight) / 2.0;
        if (!Double.isFinite(meanDx)) {
            meanDx = meanWidth * 1.25;
        }
        if (!Double.isFinite(meanDy)) {
            meanDy = meanHeight * 1.25;
        }
        ArrayList<TMACoreObject> coresNew = new ArrayList<TMACoreObject>();
        for (int r = 0; r < newHeight; ++r) {
            for (int c = 0; c < newWidth; ++c) {
                double x;
                double y1;
                double y2;
                TMACoreObject coreNew;
                if (addColumn) {
                    double y;
                    double x1;
                    double x2;
                    if (c < col) {
                        coresNew.add(grid.getTMACore(r, c));
                        continue;
                    }
                    if (c > col) {
                        coresNew.add(grid.getTMACore(r, c - 1));
                        continue;
                    }
                    if (c != col) continue;
                    if (col == 0) {
                        x2 = grid.getTMACore(r, c).getROI().getCentroidX();
                        x1 = x2 - meanDx * 2.0;
                        y = grid.getTMACore(r, c).getROI().getCentroidY();
                    } else if (col == grid.getGridWidth()) {
                        x1 = grid.getTMACore(r, c - 1).getROI().getCentroidX();
                        x2 = x1 + meanDx * 2.0;
                        y = grid.getTMACore(r, c - 1).getROI().getCentroidY();
                    } else {
                        x1 = grid.getTMACore(r, c - 1).getROI().getCentroidX();
                        x2 = grid.getTMACore(r, c).getROI().getCentroidX();
                        y = (grid.getTMACore(r, c - 1).getROI().getCentroidY() + grid.getTMACore(r, c).getROI().getCentroidY()) / 2.0;
                    }
                    coreNew = PathObjects.createTMACoreObject((double)((x1 + x2) / 2.0), (double)y, (double)diameter, (boolean)true);
                    coresNew.add(coreNew);
                    continue;
                }
                if (r < row) {
                    coresNew.add(grid.getTMACore(r, c));
                    continue;
                }
                if (r > row) {
                    coresNew.add(grid.getTMACore(r - 1, c));
                    continue;
                }
                if (r != row) continue;
                if (row == 0) {
                    y2 = grid.getTMACore(r, c).getROI().getCentroidY();
                    y1 = y2 - meanDy * 2.0;
                    x = grid.getTMACore(r, c).getROI().getCentroidX();
                } else if (row == grid.getGridHeight()) {
                    y1 = grid.getTMACore(r - 1, c).getROI().getCentroidY();
                    y2 = y1 + meanDy * 2.0;
                    x = grid.getTMACore(r - 1, c).getROI().getCentroidX();
                } else {
                    y1 = grid.getTMACore(r - 1, c).getROI().getCentroidY();
                    y2 = grid.getTMACore(r, c).getROI().getCentroidY();
                    x = (grid.getTMACore(r - 1, c).getROI().getCentroidX() + grid.getTMACore(r, c).getROI().getCentroidX()) / 2.0;
                }
                coreNew = PathObjects.createTMACoreObject((double)x, (double)((y1 + y2) / 2.0), (double)diameter, (boolean)true);
                coresNew.add(coreNew);
            }
        }
        return DefaultTMAGrid.create(coresNew, (int)newWidth);
    }

    private static enum TMARemoveType {
        ROW,
        COLUMN;


        public String toString() {
            switch (this.ordinal()) {
                case 1: {
                    return "column";
                }
                case 0: {
                    return "row";
                }
            }
            return "unknown";
        }
    }

    private static enum TMAAddType {
        ROW_AFTER,
        ROW_BEFORE,
        COLUMN_AFTER,
        COLUMN_BEFORE;


        private String commandName() {
            switch (this.ordinal()) {
                case 2: {
                    return "Add TMA column after";
                }
                case 3: {
                    return "Add TMA column before";
                }
                case 0: {
                    return "Add TMA row after";
                }
                case 1: {
                    return "Add TMA row before";
                }
            }
            throw new IllegalArgumentException("Unknown enum value: " + String.valueOf((Object)this));
        }
    }
}

