/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.measure.ui.SummaryMeasurementTable;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;

public class SummaryMeasurementTableCommand {
    private static final Logger logger = LoggerFactory.getLogger(SummaryMeasurementTableCommand.class);
    private final QuPathGUI qupath;

    public SummaryMeasurementTableCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public void showTable(ImageData<BufferedImage> imageData, Predicate<PathObject> filter) {
        if (imageData == null) {
            logger.debug("Show table called with no image");
            GuiTools.showNoImageError("Show measurement table");
            return;
        }
        logger.debug("Show table called for {} and object filter {}", imageData, filter);
        this.showForFilter(imageData, filter);
    }

    private Stage showForFilter(ImageData<BufferedImage> imageData, Predicate<PathObject> filter) {
        SummaryMeasurementTable table = new SummaryMeasurementTable(imageData, filter);
        Stage stage = new Stage();
        stage.initOwner((Window)this.qupath.getStage());
        String name = null;
        if (filter instanceof PathObjectFilter) {
            PathObjectFilter f = (PathObjectFilter)filter;
            name = SummaryMeasurementTableCommand.filterToName(f);
        }
        String prefix = name == null || name.isBlank() ? "Measurements" : name;
        StringBinding title = this.createImageNameBinding(prefix + ": ", imageData);
        stage.titleProperty().bind((ObservableValue)title);
        Pane pane = table.getPane();
        Screen screen = FXUtils.getScreenOrPrimary((Window)stage.getOwner());
        Scene scene = new Scene((Parent)pane, Math.min(screen.getBounds().getWidth(), 800.0), Math.min(screen.getBounds().getHeight(), 600.0));
        stage.setScene(scene);
        stage.show();
        return stage;
    }

    private static String filterToName(PathObjectFilter filter) {
        return switch (filter) {
            case PathObjectFilter.TILES -> "Tiles";
            case PathObjectFilter.CELLS -> "Cells";
            case PathObjectFilter.DETECTIONS_ALL -> "Detections";
            case PathObjectFilter.ANNOTATIONS -> "Annotations";
            case PathObjectFilter.TMA_CORES -> "TMA cores";
            default -> null;
        };
    }

    private StringBinding createImageNameBinding(String prefix, ImageData<BufferedImage> imageData) {
        ProjectImageEntry<BufferedImage> entry = this.getEntry(imageData);
        if (entry == null) {
            return Bindings.createStringBinding(() -> prefix + imageData.getServerMetadata().getName(), (Observable[])new Observable[0]);
        }
        return Bindings.createStringBinding(() -> prefix + entry.getImageName(), (Observable[])new Observable[]{PathPrefs.maskImageNamesProperty()});
    }

    private ProjectImageEntry<BufferedImage> getEntry(ImageData<BufferedImage> imageData) {
        Project<BufferedImage> project;
        Project<BufferedImage> project2 = project = this.qupath == null ? null : this.qupath.getProject();
        if (project == null) {
            return null;
        }
        return project.getEntry(imageData);
    }
}

