/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.PathClassListCell;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

class SpecifyAnnotationCommand {
    private QuPathGUI qupath;
    private GridPane pane;

    public SpecifyAnnotationCommand(QuPathGUI qupath) {
        this.qupath = qupath;
        this.init();
    }

    public static Label createLabelFor(Node node, String text) {
        return SpecifyAnnotationCommand.createLabelFor(node, text, null);
    }

    public static Label createLabelFor(Node node, String text, Tooltip tooltip) {
        Label label = new Label(text);
        label.setLabelFor(node);
        label.setMaxWidth(Double.MAX_VALUE);
        if (tooltip != null) {
            label.setTooltip(tooltip);
            Tooltip.install((Node)node, (Tooltip)tooltip);
        }
        return label;
    }

    public static Label createBoundLabel(StringBinding binding) {
        Label label = new Label();
        label.textProperty().bind((ObservableValue)binding);
        return label;
    }

    private void init() {
        this.pane = new GridPane();
        int row = 0;
        CheckBox cbMicrons = new CheckBox("Use " + GeneralTools.micrometerSymbol());
        StringBinding units = Bindings.createStringBinding(() -> {
            if (cbMicrons.isSelected()) {
                return GeneralTools.micrometerSymbol();
            }
            return "px";
        }, (Observable[])new Observable[]{cbMicrons.selectedProperty()});
        ComboBox comboType = new ComboBox(FXCollections.observableArrayList((Object[])ROI_TYPE.values()));
        comboType.setMaxWidth(Double.MAX_VALUE);
        comboType.getSelectionModel().select((Object)ROI_TYPE.RECTANGLE);
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Type of ROI to create", (Node[])new Node[]{SpecifyAnnotationCommand.createLabelFor((Node)comboType, "Type"), comboType, comboType});
        ComboBox comboClassification = new ComboBox(this.qupath.getAvailablePathClasses());
        comboClassification.setMaxWidth(Double.MAX_VALUE);
        comboClassification.setCellFactory(o -> new PathClassListCell());
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Classification for the annotation (may be empty if annotation should be unclassified)", (Node[])new Node[]{SpecifyAnnotationCommand.createLabelFor((Node)comboClassification, "Classification"), comboClassification, comboClassification});
        TextField tfX = new TextField("");
        TextField tfY = new TextField("");
        TextField tfWidth = new TextField("1000");
        TextField tfHeight = new TextField("1000");
        tfX.setPrefColumnCount(10);
        tfY.setPrefColumnCount(10);
        tfWidth.setPrefColumnCount(10);
        tfHeight.setPrefColumnCount(10);
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"X-coordinate of top left of annotation bounding box (if missing or < 0, annotation will be centered in current viewer)", (Node[])new Node[]{SpecifyAnnotationCommand.createLabelFor((Node)tfX, "X origin"), tfX, SpecifyAnnotationCommand.createBoundLabel(units)});
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Y-coordinate of top left of annotation bounding box (if missing or < 0, annotation will be centered in current viewer)", (Node[])new Node[]{SpecifyAnnotationCommand.createLabelFor((Node)tfY, "Y origin"), tfY, SpecifyAnnotationCommand.createBoundLabel(units)});
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Width of annotation bounding box (must be > 0)", (Node[])new Node[]{SpecifyAnnotationCommand.createLabelFor((Node)tfWidth, "Width"), tfWidth, SpecifyAnnotationCommand.createBoundLabel(units)});
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Height of annotation bounding box (must be > 0)", (Node[])new Node[]{SpecifyAnnotationCommand.createLabelFor((Node)tfHeight, "Height"), tfHeight, SpecifyAnnotationCommand.createBoundLabel(units)});
        cbMicrons.setMaxWidth(Double.MAX_VALUE);
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)("Specify coordinates in " + GeneralTools.micrometerSymbol() + " - pixel calibration information must be available"), (Node[])new Node[]{cbMicrons, cbMicrons, cbMicrons});
        CheckBox cbLock = new CheckBox("Set locked");
        cbLock.setMaxWidth(Double.MAX_VALUE);
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Set annotation as locked, so that it can't be immediately edited", (Node[])new Node[]{cbLock, cbLock, cbLock});
        TextField tfName = new TextField("");
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Name of annotation (can be empty)", (Node[])new Node[]{SpecifyAnnotationCommand.createLabelFor((Node)tfName, "Name"), tfName, tfName});
        Button btnAdd = new Button("Add annotation");
        btnAdd.setOnAction(e -> {
            ImageData<BufferedImage> imageData;
            QuPathViewer viewer = this.qupath.getViewer();
            ImageData<BufferedImage> imageData2 = imageData = viewer == null ? null : viewer.getImageData();
            if (imageData == null) {
                GuiTools.showNoImageError("Create annotation");
                return;
            }
            ImageServer server = imageData.getServer();
            PathObjectHierarchy hierarchy = imageData.getHierarchy();
            double xScale = 1.0;
            double yScale = 1.0;
            PixelCalibration cal = server.getPixelCalibration();
            if (cbMicrons.isSelected()) {
                if (!cal.hasPixelSizeMicrons()) {
                    Dialogs.showErrorMessage((String)"Create annotation", (String)"No pixel size information available! Try again using pixel units.");
                    return;
                }
                xScale = 1.0 / cal.getPixelWidthMicrons();
                yScale = 1.0 / cal.getPixelHeightMicrons();
            }
            Number xOrig = SpecifyAnnotationCommand.tryToParse(tfX.getText());
            Number yOrig = SpecifyAnnotationCommand.tryToParse(tfY.getText());
            Number width = SpecifyAnnotationCommand.tryToParse(tfWidth.getText());
            Number height = SpecifyAnnotationCommand.tryToParse(tfHeight.getText());
            if (width == null || width.doubleValue() <= 0.0 || height == null || height.doubleValue() <= 0.0) {
                Dialogs.showErrorMessage((String)"Create annotation", (String)"Width and height must be specified, and > 0!");
                return;
            }
            double w = width.doubleValue() * xScale;
            double h = height.doubleValue() * yScale;
            double x = xOrig == null || xOrig.doubleValue() < 0.0 ? (double)((int)Math.max(0.0, viewer.getCenterPixelX() - w / 2.0)) : xOrig.doubleValue() * xScale;
            double y = yOrig == null || yOrig.doubleValue() < 0.0 ? (double)((int)Math.max(viewer.getCenterPixelY() - h / 2.0, 0.0)) : yOrig.doubleValue() * yScale;
            if (x + w > (double)server.getWidth() || y + h > (double)server.getHeight()) {
                Dialogs.showErrorMessage((String)"Create annotation", (String)"Specified annotation is too large for the image bounds!");
                return;
            }
            int z = viewer.getZPosition();
            int t = viewer.getTPosition();
            ROI roi = null;
            switch (((ROI_TYPE)((Object)((Object)comboType.getSelectionModel().getSelectedItem()))).ordinal()) {
                case 1: {
                    roi = ROIs.createEllipseROI((double)x, (double)y, (double)w, (double)h, (ImagePlane)ImagePlane.getPlane((int)z, (int)t));
                    break;
                }
                case 0: {
                    roi = ROIs.createRectangleROI((double)x, (double)y, (double)w, (double)h, (ImagePlane)ImagePlane.getPlane((int)z, (int)t));
                    break;
                }
                default: {
                    Dialogs.showErrorMessage((String)"Create annotation", (String)"No ROI type selected!");
                    return;
                }
            }
            PathClass pathClass = (PathClass)comboClassification.getSelectionModel().getSelectedItem();
            if (pathClass != null && !pathClass.isValid()) {
                pathClass = null;
            }
            PathObject annotation = PathObjects.createAnnotationObject((ROI)roi, (PathClass)pathClass);
            String name = tfName.getText();
            if (name != null && !name.isEmpty()) {
                annotation.setName(name);
            }
            if (cbLock.isSelected()) {
                ((PathAnnotationObject)annotation).setLocked(true);
            }
            hierarchy.addObject(annotation);
        });
        btnAdd.setMaxWidth(Double.MAX_VALUE);
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Create annotation with specified options & add to object hierarchy", (Node[])new Node[]{btnAdd, btnAdd, btnAdd});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{tfX, tfY, tfWidth, tfHeight, btnAdd, comboType});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{tfX, tfY, tfWidth, tfHeight, btnAdd, comboType});
        this.pane.setHgap(5.0);
        this.pane.setVgap(5.0);
        this.pane.setPadding(new Insets(10.0));
    }

    static Number tryToParse(String text) {
        if (text == null || text.isBlank()) {
            return null;
        }
        try {
            return NumberFormat.getInstance().parse(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Pane getPane() {
        return this.pane;
    }

    private static enum ROI_TYPE {
        RECTANGLE,
        ELLIPSE;


        public String toString() {
            switch (this.ordinal()) {
                case 1: {
                    return "Ellipse";
                }
                case 0: {
                    return "Rectangle";
                }
            }
            return "Unknown";
        }
    }
}

