/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.io.File;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;

class ShowSystemInfoCommand {
    private static final Logger logger = LoggerFactory.getLogger(ShowSystemInfoCommand.class);

    ShowSystemInfoCommand() {
    }

    public static Stage createShowSystemInfoDialog(QuPathGUI qupath) {
        Stage dialog = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)dialog);
        dialog.initOwner((Window)qupath.getStage());
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.setTitle("System info");
        TextArea textArea = new TextArea();
        textArea.setPrefColumnCount(40);
        textArea.setPrefRowCount(25);
        textArea.setEditable(false);
        dialog.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                ShowSystemInfoCommand.updateText(qupath, textArea);
            }
        });
        BorderPane pane = new BorderPane();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.setCenter((Node)textArea);
        dialog.setScene(new Scene((Parent)pane));
        return dialog;
    }

    public static String getInfoString() {
        StringBuilder sb = new StringBuilder();
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        sb.append("Java version:\t\t").append(System.getProperty("java.version")).append("\n");
        sb.append("Java vendor: \t\t").append(System.getProperty("java.vendor")).append("  -  ").append(System.getProperty("java.vendor.url")).append("\n");
        sb.append("Java home:   \t\t").append(System.getProperty("java.home")).append("\n");
        sb.append("\n");
        sb.append("Operating system:\t\t").append(System.getProperty("os.name")).append("  -  ").append(System.getProperty("os.version")).append("\n");
        sb.append("Architecture:    \t\t").append(System.getProperty("os.arch")).append("\n");
        sb.append("\n");
        sb.append("Number of available processors:\t\t").append(rt.availableProcessors()).append("\n");
        sb.append("\n");
        int toMB = 0x100000;
        long usedBytes = rt.totalMemory() - rt.freeMemory();
        sb.append("Memory already used by JVM:  \t\t").append(usedBytes / (long)toMB).append(" MB").append("\n");
        sb.append("Total memory currently available:\t\t").append(rt.totalMemory() / (long)toMB).append(" MB").append("\n");
        sb.append("Max memory JVM may try to use:\t\t").append(rt.maxMemory() / (long)toMB).append(" MB").append("\n");
        if (rt.maxMemory() / (long)toMB < 4096L) {
            sb.append("--- WARNING: Max memory is quite low (< 4GB)  - may not be enough to run full whole slide analysis.").append("\n");
        }
        if ((rt.maxMemory() - usedBytes) / (long)toMB < 1024L) {
            sb.append("--- WARNING: Memory almost all in use (< 1GB remaining).").append("\n");
        }
        sb.append("\n");
        sb.append("Library path:");
        for (String p : System.getProperty("java.library.path", "").split(File.pathSeparator)) {
            sb.append("\n      ").append(p);
        }
        sb.append("\n\n");
        String modulePath = System.getProperty("jdk.module.path", null);
        if (modulePath != null) {
            sb.append("Module path:");
            for (String p : modulePath.split(File.pathSeparator)) {
                sb.append("\n      ").append(p);
            }
            sb.append("\n\n");
        }
        sb.append("Class path:");
        for (String p : System.getProperty("java.class.path", "").split(File.pathSeparator)) {
            sb.append("\n      ").append(p);
        }
        logger.trace("Creating system info string:\n{}", (Object)sb);
        return sb.toString();
    }

    private static void updateText(QuPathGUI qupath, TextArea textArea) {
        String buildString = QuPathGUI.getBuildString();
        if (buildString == null || buildString.isBlank()) {
            buildString = GeneralTools.getVersion();
        }
        if (buildString == null || buildString.isBlank()) {
            buildString = "Unknown QuPath version!";
        }
        textArea.setText(buildString + "\n\n" + ShowSystemInfoCommand.getInfoString());
    }
}

