/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.Urls;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.tools.GuiTools;

class ShowLicensesCommand {
    private static final Logger logger = LoggerFactory.getLogger(ShowLicensesCommand.class);

    ShowLicensesCommand() {
    }

    public static Stage createLicensesDialog(QuPathGUI qupath) {
        StringBuilder sbQuPath = new StringBuilder();
        String buildString = QuPathGUI.getBuildString();
        if (buildString != null && !buildString.trim().isEmpty()) {
            sbQuPath.append("QuPath").append("\n");
            sbQuPath.append(buildString).append("\n\n");
        }
        try {
            String licenseText = GeneralTools.readInputStreamAsString((InputStream)ShowLicensesCommand.class.getResourceAsStream("/license/QuPathLicenseDescription.txt"));
            sbQuPath.append(licenseText);
        }
        catch (Exception e) {
            sbQuPath.append("Error reading license information!\n\n");
            sbQuPath.append("For the most up-to-date QuPath license information, see ").append(Urls.getGitHubRepoUrl());
            logger.error("Cannot read license information", (Throwable)e);
        }
        File currentFile = null;
        try {
            currentFile = Paths.get(ShowLicensesCommand.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toFile();
            logger.info("Running file: {}", (Object)currentFile);
        }
        catch (URISyntaxException e) {
            logger.error("Error identifying running file", (Throwable)e);
        }
        File fileLicenses = null;
        if (currentFile != null && currentFile.getName().toLowerCase().endsWith(".jar")) {
            File dirBase = currentFile;
            if (new File(dirBase, "licenses").isDirectory()) {
                fileLicenses = new File(dirBase, "THIRD-PARTY.txt");
            } else if (new File(dirBase.getParentFile(), "licenses").isDirectory()) {
                fileLicenses = new File(new File(dirBase.getParentFile(), "licenses"), "THIRD-PARTY.txt");
            }
            logger.debug("License file: {}", (Object)fileLicenses);
        }
        TextArea textAreaQuPath = ShowLicensesCommand.getTextArea(sbQuPath.toString());
        Tab tabQuPath = new Tab("QuPath", (Node)textAreaQuPath);
        TabPane tabPane = new TabPane(new Tab[]{tabQuPath});
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        if (fileLicenses == null) {
            tabPane.getTabs().add((Object)new Tab("Third party", (Node)new TextArea("No license information could be found for third party dependencies.")));
        } else {
            File filePrimaryLicense = new File(new File(fileLicenses.getParentFile(), "QuPath"), "LICENSE.txt");
            if (filePrimaryLicense.isFile()) {
                try {
                    tabPane.getTabs().add((Object)new Tab("License", (Node)new TextArea(GeneralTools.readFileAsString((String)filePrimaryLicense.getAbsolutePath()))));
                }
                catch (Exception e) {
                    logger.error("Could not show QuPath's primary license file");
                }
            }
            tabPane.getTabs().add((Object)new Tab("Third party", (Node)ShowLicensesCommand.createLicenseTreePane(fileLicenses.getParentFile())));
        }
        BorderPane pane = new BorderPane((Node)tabPane);
        Label labelUse = new Label(QuPathResources.getString("Startup.use"));
        labelUse.setAlignment(Pos.CENTER);
        labelUse.setMaxWidth(Double.MAX_VALUE);
        labelUse.setPadding(new Insets(5.0));
        labelUse.setStyle("-fx-font-weight: bold;");
        pane.setBottom((Node)labelUse);
        Stage dialog = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)dialog);
        dialog.initOwner((Window)qupath.getStage());
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.setTitle("Licenses");
        dialog.setScene(new Scene((Parent)pane));
        return dialog;
    }

    private static TextArea getTextArea(String contents) {
        TextArea textArea = new TextArea();
        textArea.setPrefColumnCount(60);
        textArea.setPrefRowCount(25);
        textArea.setText(contents);
        textArea.setWrapText(true);
        textArea.positionCaret(0);
        textArea.setEditable(false);
        return textArea;
    }

    private static Pane createLicenseTreePane(File dirBase) {
        TreeView tree = new TreeView();
        tree.setRoot((TreeItem)new LicenseFileTreeItem(dirBase));
        tree.setShowRoot(false);
        TextArea textArea = new TextArea();
        textArea.setStyle("-fx-font-family: monospace");
        textArea.setWrapText(true);
        tree.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            if (n instanceof LicenseFileTreeItem) {
                textArea.setText(((LicenseFileTreeItem)((Object)n)).getContents());
            }
        });
        tree.setCellFactory(n -> new FileTreeCell());
        Button btnThirdParty = new Button("Open licenses directory");
        File dirLicenses = dirBase;
        btnThirdParty.setOnAction(e -> GuiTools.openFile(dirLicenses));
        btnThirdParty.setMaxWidth(Double.MAX_VALUE);
        BorderPane pane = new BorderPane();
        pane.setLeft((Node)tree);
        pane.setCenter((Node)textArea);
        pane.setBottom((Node)btnThirdParty);
        return pane;
    }

    static class LicenseFileTreeItem
    extends TreeItem<File> {
        private static FileFirstComparator comparator = new FileFirstComparator();
        private boolean isDirectory;
        private boolean hasCheckedChildren;
        private String contents;

        LicenseFileTreeItem(File file) {
            super((Object)file);
            this.isDirectory = file.isDirectory();
            this.hasCheckedChildren = !this.isDirectory;
        }

        public ObservableList<TreeItem<File>> getChildren() {
            if (!this.hasCheckedChildren) {
                this.hasCheckedChildren = true;
                super.getChildren().setAll(Arrays.stream(((File)this.getValue()).listFiles()).filter(f -> !f.isHidden()).sorted(comparator).map(f -> new LicenseFileTreeItem((File)f)).toList());
            }
            return super.getChildren();
        }

        public String getName() {
            return ((File)this.getValue()).getName();
        }

        public String getContents() {
            if (this.contents == null) {
                if (this.isDirectory) {
                    StringBuilder sb = new StringBuilder();
                    for (TreeItem child : this.getChildren()) {
                        if (!(child instanceof LicenseFileTreeItem)) continue;
                        LicenseFileTreeItem item = (LicenseFileTreeItem)child;
                        sb.append(item.getName());
                        sb.append("\n");
                        sb.append("=".repeat(item.getName().length()));
                        sb.append("\n\n");
                        sb.append(item.getContents());
                        if (item.isDirectory) continue;
                        sb.append("\n\n\n");
                        sb.append("==========================");
                        sb.append("END");
                        sb.append("==========================");
                        sb.append("\n\n");
                    }
                    this.contents = sb.toString();
                } else {
                    try {
                        this.contents = GeneralTools.readFileAsString((String)((File)this.getValue()).getAbsolutePath());
                    }
                    catch (IOException e) {
                        this.contents = "Unable to read from " + String.valueOf(this.getValue());
                    }
                }
            }
            return this.contents;
        }

        public boolean isLeaf() {
            return !this.isDirectory;
        }

        public String toString() {
            return this.getName();
        }
    }

    static class FileTreeCell
    extends TreeCell<File> {
        FileTreeCell() {
        }

        public void updateItem(File item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                String name = item.getName();
                if ("THIRD-PARTY.txt".equals(name)) {
                    name = "Summary";
                }
                this.setText(name);
                this.setGraphic(null);
            }
        }
    }

    static class FileFirstComparator
    implements Comparator<File> {
        FileFirstComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1.isFile()) {
                if (!f2.isFile()) {
                    return -1;
                }
            } else if (f2.isFile()) {
                return 1;
            }
            return f1.compareTo(f2);
        }
    }
}

