/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.gui.ExtensionManager;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.localization.QuPathResources;

class ShowInstalledExtensionsCommand {
    private static final Logger logger = LoggerFactory.getLogger(ShowInstalledExtensionsCommand.class);
    private static final Map<QuPathGUI, ShowInstalledExtensionsCommand> instances = new WeakHashMap<QuPathGUI, ShowInstalledExtensionsCommand>();
    private final QuPathGUI qupath;
    private Stage dialog;

    private ShowInstalledExtensionsCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public static void showInstalledExtensions(QuPathGUI qupath) {
        ShowInstalledExtensionsCommand.getInstance(qupath).showInstalledExtensions();
    }

    private static ShowInstalledExtensionsCommand getInstance(QuPathGUI qupath) {
        return instances.computeIfAbsent(qupath, ShowInstalledExtensionsCommand::new);
    }

    private void showInstalledExtensions() {
        if (this.dialog == null) {
            this.dialog = ShowInstalledExtensionsCommand.createAndShowDialog(this.qupath);
        } else {
            this.dialog.show();
            this.dialog.requestFocus();
        }
    }

    private static Stage createAndShowDialog(QuPathGUI qupath) {
        ExtensionManager dialog = null;
        try {
            dialog = new ExtensionManager(QuPathGUI.getExtensionCatalogManager(), () -> Commands.requestUserDirectory(true));
            FXUtils.addCloseWindowShortcuts((Stage)dialog);
            dialog.initOwner((Window)qupath.getStage());
            dialog.show();
        }
        catch (IOException e) {
            logger.error("Unable to open extension control pane", (Throwable)e);
            Dialogs.showErrorMessage((String)QuPathResources.getString("ShowInstalledExtensionsCommand.extensionManager"), (String)QuPathResources.getString("ShowInstalledExtensionsCommand.unableToOpen"));
        }
        return dialog;
    }
}

