/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import jfxtras.scene.layout.GridPane;
import org.controlsfx.control.MasterDetailPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.panes.ObjectTreeBrowser;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.gui.scripting.QPEx;
import qupath.lib.gui.tools.WebViews;
import qupath.lib.images.ImageData;

class ScriptInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(ScriptInterpreter.class);
    private QuPathGUI qupath;
    private Stage stage;
    private ScriptEngineManager manager;
    private ScriptContext preferredContext = new SimpleScriptContext();
    private ScriptContext context;
    private ScriptEngine engine;
    private String defaultImageDataName = "imageData";
    private String defaultHierarchyName = "hierarchy";
    private String defaultSelectionModelName = "selectionModel";
    private String defaultImageServerName = "server";
    private String defaultProjectName = "project";
    private String defaultScriptingHelperName = "QP";
    private Font font = Font.font((String)"Courier");
    private ObservableList<String> historyList = FXCollections.observableArrayList();
    private StringProperty historyText = new SimpleStringProperty("");
    private StringProperty currentText = new SimpleStringProperty("");
    private TableView<String> tableVariables = new TableView();
    private ListView<String> listHistory = new ListView(this.historyList);
    private TextArea textAreaInput = new TextArea();
    private ContextMenu menuAutocomplete = new ContextMenu();

    ScriptInterpreter(QuPathGUI qupath, ClassLoader classLoader) {
        this.qupath = qupath;
        this.manager = new ScriptEngineManager(classLoader);
        this.setWriters(this.preferredContext);
        this.stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        this.stage.setTitle("QuPath Interpreter");
        this.initialize();
    }

    private void initialize() {
        MenuBar menuBar = new MenuBar();
        Menu menuLanguages = new Menu("Language");
        menuBar.getMenus().add((Object)menuLanguages);
        ToggleGroup group = new ToggleGroup();
        for (ScriptEngineFactory factory : this.manager.getEngineFactories()) {
            logger.info("{}", factory.getNames());
            List<String> allNames = factory.getNames();
            String name = allNames.contains("groovy") ? "Groovy" : (allNames.contains("jython") ? "Jython" : (allNames.contains("python") ? "Python" : (allNames.contains("r") ? "R" : (allNames.contains("ruby") ? "Ruby" : (allNames.contains("javascript") ? "JavaScript" : factory.getLanguageName())))));
            RadioMenuItem menuItem = new RadioMenuItem(name);
            menuItem.setToggleGroup(group);
            menuItem.selectedProperty().addListener((o, v, n) -> {
                if (n.booleanValue()) {
                    this.engine = factory.getScriptEngine();
                    try {
                        this.engine.setContext(this.preferredContext);
                        this.context = this.preferredContext;
                    }
                    catch (Exception e) {
                        logger.warn("Could not set preferred script context for {}: {}", (Object)this.engine, (Object)e.getLocalizedMessage());
                        this.context = this.engine.getContext();
                        this.setWriters(this.context);
                    }
                    this.updateVariableTable();
                }
            });
            if (group.getSelectedToggle() == null || "Groovy".equals(name)) {
                group.selectToggle((Toggle)menuItem);
            }
            menuLanguages.getItems().add((Object)menuItem);
        }
        FXCollections.sort((ObservableList)menuLanguages.getItems(), (m1, m2) -> m1.getText().compareTo(m2.getText()));
        Menu menuScript = new Menu("Script");
        MenuItem miGenerateScript = new MenuItem("Generate script");
        miGenerateScript.setOnAction(e -> {
            String script = String.join((CharSequence)"\n", this.historyList);
            this.qupath.getScriptEditor().showScript("From interpreter", script);
        });
        menuScript.getItems().add((Object)miGenerateScript);
        menuBar.getMenus().add((Object)menuScript);
        WebView textArea = WebViews.create(true);
        this.historyText.addListener((v, o, n) -> {
            String styleAll = "* {\n  font-family: \"Courier New\", Courier, monospace;\nfont-size: 0.95em;\n }";
            String styleError = ".error {\n  color: red;\n}";
            String styleWarning = ".warning {\n  color: orange;\n}";
            String styleOther = ".other {\n  color: gray;\n}";
            String styleVariable = ".variable {\n  color: purple;\n}";
            StringBuilder sb = new StringBuilder();
            sb.append("<html>").append("\n");
            sb.append("<head>").append("\n");
            sb.append("<script language=\"javascript\" type=\"text/javascript\">").append("\n");
            sb.append("function scrollToEnd(){").append("\n");
            sb.append("window.scrollTo(0, document.body.scrollHeight);").append("\n");
            sb.append("}").append("\n");
            sb.append("</script>").append("\n");
            sb.append("<style>").append("\n");
            sb.append(styleAll).append("\n");
            sb.append(styleError).append("\n");
            sb.append(styleWarning).append("\n");
            sb.append(styleOther).append("\n");
            sb.append(styleVariable).append("\n");
            sb.append("</style>").append("\n");
            sb.append("</head>").append("\n");
            sb.append("<body onload='scrollToEnd()'>").append("\n");
            sb.append(n.replace("\n", "<br/>"));
            sb.append("</body>");
            textArea.getEngine().loadContent(sb.toString());
            textArea.pageFillProperty().unbind();
            textArea.setPageFill(Color.TRANSPARENT);
        });
        this.textAreaInput = new TextArea();
        this.textAreaInput.setPrefRowCount(4);
        this.textAreaInput.textProperty().bindBidirectional((Property)this.currentText);
        this.textAreaInput.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.runLine();
                e.consume();
            }
        });
        this.textAreaInput.addEventFilter(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.ENTER) {
                return;
            }
            if (e.getCode() == KeyCode.UP || e.getCode() == KeyCode.DOWN) {
                if (this.menuAutocomplete.isShowing()) {
                    return;
                }
                if (e.getCode() == KeyCode.UP) {
                    if (!this.decrementHistoryPointer()) {
                        e.consume();
                        return;
                    }
                } else if (!this.incrementHistoryPointer()) {
                    e.consume();
                    return;
                }
                e.consume();
                return;
            }
            if (this.menuAutocomplete.isShowing() || e.isControlDown() && e.getCode() == KeyCode.SPACE) {
                this.updateAutocompleteMenu();
                Skin skin = this.textAreaInput.getSkin();
                Bounds b = null;
                try {
                    b = (Bounds)skin.getClass().getMethod("getCaretBounds", new Class[0]).invoke((Object)skin, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                    logger.error("Error requesting caret bounds - cannot display autocomplete menu", (Throwable)e1);
                }
                if (!this.menuAutocomplete.isShowing() && this.menuAutocomplete.getItems().size() == 1) {
                    ((MenuItem)this.menuAutocomplete.getItems().get(0)).fire();
                    e.consume();
                    return;
                }
                if (b != null && !this.menuAutocomplete.getItems().isEmpty()) {
                    this.menuAutocomplete.show((Node)this.textAreaInput, Side.TOP, b.getMaxX() + 5.0, b.getMaxY() + 5.0);
                }
            } else if (this.menuAutocomplete.isShowing() && e.getCode() == KeyCode.TAB) {
                this.menuAutocomplete.hide();
                e.consume();
            }
        });
        this.textAreaInput.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            if (!e.isConsumed()) {
                this.updateLastHistoryListEntry();
            }
        });
        this.historyList.add((Object)"");
        this.textAreaInput.setFont(this.font);
        TableColumn colKeys = new TableColumn("Name");
        colKeys.setCellValueFactory(c -> new SimpleStringProperty((String)c.getValue()));
        colKeys.setCellFactory(c -> new VariableTableCell(VariableInfoType.NAME));
        TableColumn colClasses = new TableColumn("Class");
        colClasses.setCellValueFactory(c -> new SimpleStringProperty((String)c.getValue()));
        colClasses.setCellFactory(c -> new VariableTableCell(VariableInfoType.CLASS));
        TableColumn colValues = new TableColumn("Value");
        colValues.setCellValueFactory(c -> new SimpleStringProperty((String)c.getValue()));
        colValues.setCellFactory(c -> new VariableTableCell(VariableInfoType.VALUE));
        this.tableVariables.setPlaceholder((Node)new Label("No variables set"));
        this.tableVariables.getColumns().add((Object)colKeys);
        this.tableVariables.getColumns().add((Object)colClasses);
        this.tableVariables.getColumns().add((Object)colValues);
        this.tableVariables.setTableMenuButtonVisible(true);
        this.tableVariables.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        Button btnClear = new Button("Clear variables");
        btnClear.setOnAction(e -> {
            javax.script.Bindings bindings = this.context.getBindings(100);
            ObservableList<String> variables = this.getSelectedVariableNames();
            if (variables.isEmpty()) {
                variables = this.getCurrentVariableNames();
            }
            if (variables.isEmpty()) {
                return;
            }
            if (variables.size() == 1 ? !Dialogs.showConfirmDialog((String)"Clear variables", (String)("Clear variable '" + (String)variables.get(0) + "'?")) : !Dialogs.showConfirmDialog((String)"Clear variables", (String)("Clear " + variables.size() + " variables?"))) {
                return;
            }
            for (String v : variables) {
                bindings.remove(v);
            }
            logger.info("Removed variables from interpreter workspace: {}", variables);
            this.updateVariableTable();
        });
        btnClear.setMaxWidth(Double.MAX_VALUE);
        btnClear.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.tableVariables.getItems().isEmpty(), (Observable[])new Observable[]{this.tableVariables.getItems()}));
        Button btnAdd = new Button("Add...");
        ContextMenu menuAdd = new ContextMenu();
        MenuItem miAddImageData = new MenuItem("Image data");
        miAddImageData.setOnAction(e -> {
            ImageData<BufferedImage> imageData = this.qupath.getImageData();
            this.engine.put(this.defaultImageDataName, imageData);
            this.updateVariableTable();
        });
        MenuItem miAddHierarchy = new MenuItem("Hierarchy");
        miAddHierarchy.setOnAction(e -> {
            ImageData<BufferedImage> imageData = this.qupath.getImageData();
            this.engine.put(this.defaultHierarchyName, imageData == null ? null : imageData.getHierarchy());
            this.updateVariableTable();
        });
        MenuItem miAddSelectionModel = new MenuItem("Selection model");
        miAddSelectionModel.setOnAction(e -> {
            ImageData<BufferedImage> imageData = this.qupath.getImageData();
            this.engine.put(this.defaultSelectionModelName, imageData == null ? null : imageData.getHierarchy().getSelectionModel());
            this.updateVariableTable();
        });
        MenuItem miAddServer = new MenuItem("Image server");
        miAddServer.setOnAction(e -> {
            ImageData<BufferedImage> imageData = this.qupath.getImageData();
            this.engine.put(this.defaultImageServerName, imageData == null ? null : imageData.getServer());
            this.updateVariableTable();
        });
        MenuItem miAddProject = new MenuItem("Project");
        miAddProject.setOnAction(e -> {
            this.engine.put(this.defaultProjectName, this.qupath.getProject());
            this.updateVariableTable();
        });
        MenuItem miAddScriptingHelpers = new MenuItem("Scripting helpers");
        miAddScriptingHelpers.setOnAction(e -> {
            this.engine.put(this.defaultScriptingHelperName, (Object)new QPEx());
            this.updateVariableTable();
        });
        menuAdd.getItems().addAll((Object[])new MenuItem[]{miAddImageData, miAddHierarchy, miAddSelectionModel, miAddServer, miAddProject, miAddScriptingHelpers});
        btnAdd.setOnMouseClicked(e -> menuAdd.show((Node)btnAdd, e.getScreenX(), e.getScreenY()));
        btnAdd.setMaxWidth(Double.MAX_VALUE);
        GridPane paneTable = new GridPane();
        paneTable.add(this.tableVariables, 0, 0, 2, 1);
        paneTable.add((Node)btnAdd, 0, 1, 1, 1);
        paneTable.add((Node)btnClear, 1, 1, 1, 1);
        GridPane.setVgrow(this.tableVariables, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.tableVariables, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)btnAdd, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)btnClear, (Priority)Priority.ALWAYS);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(50.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(50.0);
        paneTable.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.listHistory.setEditable(false);
        this.listHistory.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.listHistory.setStyle("-fx-font-family: \"Courier New\", Courier, monospace;");
        this.listHistory.getSelectionModel().selectedIndexProperty().addListener((v, o, n) -> {
            if (o.intValue() < 0 || n.intValue() < 0) {
                return;
            }
            this.textAreaInput.setText((String)this.listHistory.getSelectionModel().getSelectedItem());
            this.textAreaInput.appendText("");
        });
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.getTabs().add((Object)new Tab("Variables", (Node)paneTable));
        tabPane.getTabs().add((Object)new Tab("History", this.listHistory));
        BorderPane pane = new BorderPane();
        MasterDetailPane paneMasterDetail = new MasterDetailPane(Side.LEFT);
        BorderPane paneInner = new BorderPane();
        paneInner.setCenter((Node)textArea);
        paneInner.setBottom((Node)this.textAreaInput);
        paneMasterDetail.setMasterNode((Node)paneInner);
        paneMasterDetail.setDetailNode((Node)tabPane);
        pane.setTop((Node)menuBar);
        pane.setCenter((Node)paneMasterDetail);
        SystemMenuBar.manageChildMenuBar(menuBar);
        this.stage.setScene(new Scene((Parent)pane, 800.0, 600.0));
        this.textAreaInput.requestFocus();
    }

    private void setWriters(ScriptContext context) {
        context.setWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                ScriptInterpreter.this.addToCommandWindow(String.copyValueOf(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
        context.setErrorWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                ScriptInterpreter.this.addToCommandWindow("Error: " + String.copyValueOf(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
    }

    private void addToCommandWindow(String newText) {
        String lower = newText.toLowerCase();
        if (lower.startsWith("error:")) {
            this.historyText.set((Object)((String)this.historyText.get() + "<pre class=\"error\">" + newText + "</pre>"));
        } else if (lower.startsWith("warn")) {
            this.historyText.set((Object)((String)this.historyText.get() + "<pre class=\"warning\">" + newText + "</pre>"));
        } else if (lower.startsWith("-------")) {
            this.historyText.set((Object)((String)this.historyText.get() + "<pre class=\"variable\">" + newText + "</pre>"));
        } else if (lower.startsWith("> ")) {
            this.historyText.set((Object)((String)this.historyText.get() + "<pre class=\"command\">" + newText + "</pre>"));
        } else {
            this.historyText.set((Object)((String)this.historyText.get() + "<pre class=\"other\">" + newText + "</pre>"));
        }
    }

    private void updateLastHistoryListEntry() {
        this.historyList.set(this.historyList.size() - 1, (Object)this.textAreaInput.getText());
    }

    private ObservableList<String> getSelectedVariableNames() {
        return this.tableVariables.getSelectionModel().getSelectedItems();
    }

    private ObservableList<String> getCurrentVariableNames() {
        return this.tableVariables.getItems();
    }

    private void updateVariableTable() {
        javax.script.Bindings bindings = this.engine.getBindings(100);
        List variableNames = bindings.keySet().stream().filter(v -> !v.equals("__builtins__")).collect(Collectors.toCollection(ArrayList::new));
        try {
            bindings = this.engine.getBindings(200);
            if (bindings != null) {
                variableNames.addAll(bindings.keySet());
            }
        }
        catch (Exception e) {
            logger.debug("Unable to obtain global variables for {}", (Object)this.engine);
        }
        Collections.sort(variableNames);
        this.tableVariables.getItems().setAll((Collection)variableNames);
    }

    private Object getVariable(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return this.engine == null ? null : this.engine.get(name);
    }

    private void updateAutocompleteMenu() {
        int ind;
        this.menuAutocomplete.setStyle("-fx-font-size: 0.8em");
        this.menuAutocomplete.setOpacity(0.9);
        this.menuAutocomplete.setMaxHeight(200.0);
        this.menuAutocomplete.hide();
        this.menuAutocomplete.getItems().clear();
        String text = (String)this.currentText.get();
        if (text.trim().isEmpty()) {
            return;
        }
        boolean breakAtDot = false;
        String delimiters = " \t;:(){}";
        for (ind = text.length() - 1; ind >= 0; --ind) {
            char c = text.charAt(ind);
            if (c == '.') {
                breakAtDot = true;
                break;
            }
            if (delimiters.indexOf(c) >= 0) break;
        }
        int startInd = ind + 1;
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        StringBuilder sb = new StringBuilder();
        if (breakAtDot) {
            char c;
            String current = text.substring(startInd);
            if (ind == 0) {
                return;
            }
            --ind;
            while (ind >= 0 && delimiters.indexOf(c = text.charAt(ind)) < 0) {
                --ind;
            }
            String lastName = text.substring(ind + 1, startInd - 1);
            Object o = this.getVariable(lastName);
            if (o != null) {
                for (Field field : o.getClass().getFields()) {
                    String fieldName = field.getName();
                    if (!fieldName.startsWith(current)) continue;
                    items.add(this.getCompletionMenuItem(fieldName, text, startInd, fieldName, null));
                }
                for (AccessibleObject accessibleObject : o.getClass().getMethods()) {
                    String methodName = ((Method)accessibleObject).getName();
                    if (!methodName.startsWith(current)) continue;
                    sb.setLength(0);
                    sb.append(methodName).append("(");
                    int count = 0;
                    int n = ((Method)accessibleObject).getParameterCount();
                    for (Parameter p : ((Executable)accessibleObject).getParameters()) {
                        ++count;
                        sb.append(p.getType().getSimpleName());
                        sb.append(" ");
                        sb.append(p.getName());
                        if (count >= n) continue;
                        sb.append(", ");
                    }
                    sb.append(")");
                    String completion = n == 0 ? methodName + "()" : methodName + "(";
                    items.add(this.getCompletionMenuItem(sb.toString(), text, startInd, completion, (Node)new Text(((Method)accessibleObject).getReturnType().getSimpleName())));
                }
            }
        } else {
            String current = text.substring(startInd);
            for (String v : this.getCurrentVariableNames()) {
                if (!v.startsWith(current)) continue;
                items.add(this.getCompletionMenuItem(v, text, startInd, v, null));
            }
        }
        if (items.isEmpty()) {
            return;
        }
        this.menuAutocomplete.getItems().setAll(items);
    }

    private MenuItem getCompletionMenuItem(String name, String oldText, int startInd, String completion, Node graphic) {
        Label label = new Label(name);
        label.setMaxWidth(Double.POSITIVE_INFINITY);
        CustomMenuItem item = new CustomMenuItem((Node)label);
        item.setOnAction(e -> {
            this.currentText.set((Object)(oldText.substring(0, startInd) + completion));
            this.textAreaInput.appendText("");
            this.updateLastHistoryListEntry();
        });
        if (graphic != null) {
            label.setContentDisplay(ContentDisplay.RIGHT);
            label.setGraphic(graphic);
        }
        return item;
    }

    private boolean incrementHistoryPointer() {
        int historyPointer = this.listHistory.getSelectionModel().getSelectedIndex();
        if (historyPointer < this.historyList.size() - 1) {
            this.listHistory.getSelectionModel().select(historyPointer + 1);
            return true;
        }
        return false;
    }

    private boolean decrementHistoryPointer() {
        int historyPointer = this.listHistory.getSelectionModel().getSelectedIndex();
        if (historyPointer > 0) {
            this.listHistory.getSelectionModel().select(historyPointer - 1);
            return true;
        }
        return false;
    }

    private void resetHistoryPointer() {
        this.listHistory.getSelectionModel().select(this.historyList.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLine() {
        String text = (String)this.currentText.get();
        if (text != null && text.length() > 0) {
            this.addToCommandWindow("> " + text);
            String lastHistory = (String)this.historyList.get(this.historyList.size() - 1);
            if (lastHistory != null && !lastHistory.isEmpty()) {
                this.historyList.add((Object)"");
            }
            this.resetHistoryPointer();
            try {
                Object result = this.engine.eval(text, this.context);
                if (result == null) {
                    this.addToCommandWindow("");
                } else {
                    this.addToCommandWindow(String.valueOf(result) + "\n");
                }
            }
            catch (Exception e) {
                logger.error("Script error", (Throwable)e);
                this.addToCommandWindow("Error: " + e.getLocalizedMessage() + "\n");
            }
            finally {
                this.currentText.set((Object)"");
                this.updateVariableTable();
            }
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    class VariableTableCell
    extends TableCell<String, String> {
        private VariableInfoType type;
        private Tooltip tooltip = new Tooltip();
        private StringBuilder sb = new StringBuilder();

        VariableTableCell(VariableInfoType type) {
            this.type = type;
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setTooltip(null);
            } else {
                Object value = ScriptInterpreter.this.getVariable(item);
                switch (this.type.ordinal()) {
                    case 1: {
                        this.setText(value == null ? "-" : value.getClass().getSimpleName());
                        break;
                    }
                    case 0: {
                        this.setText(item);
                        break;
                    }
                    case 2: {
                        this.setText(String.valueOf(value));
                        break;
                    }
                    default: {
                        this.setText(item);
                    }
                }
                String text = item;
                if (value != null) {
                    this.sb.setLength(0);
                    this.sb.append("Name:\t").append(item).append("\n");
                    this.sb.append("Class:\t").append(value.getClass().getName()).append("\n");
                    this.sb.append("Value:\t").append(value);
                    text = this.sb.toString();
                    this.setOnMouseClicked(e -> {
                        if (e.getClickCount() == 2) {
                            TreeTableView<Object> treeView = ObjectTreeBrowser.createObjectTreeBrowser(item, value);
                            Stage stage = new Stage();
                            stage.setTitle("Object Inspector: " + item);
                            stage.initOwner((Window)ScriptInterpreter.this.qupath.getStage());
                            stage.setScene(new Scene((Parent)new BorderPane(treeView), 400.0, 400.0));
                            stage.show();
                            this.sb.setLength(0);
                            this.sb.append("---------------------------------------------\n");
                            this.sb.append("NAME: \t").append(item);
                            this.sb.append("\n");
                            this.sb.append("VALUE: \t").append(String.valueOf(value));
                            this.sb.append("\n");
                            this.sb.append("CLASS: \t").append(value.getClass().getName());
                            this.sb.append("\n");
                            Field[] fields = value.getClass().getFields();
                            if (fields.length > 0) {
                                this.sb.append("FIELDS:\n");
                                for (AccessibleObject accessibleObject : value.getClass().getFields()) {
                                    try {
                                        Object innerValue = ((Field)accessibleObject).get(value);
                                        this.sb.append("  ");
                                        this.sb.append(((Field)accessibleObject).getName());
                                        this.sb.append(": ");
                                        this.sb.append("\t");
                                        this.sb.append(String.valueOf(innerValue));
                                        this.sb.append("\n");
                                    }
                                    catch (Exception e1) {
                                        logger.trace("Could not find value for field {}", (Object)((Field)accessibleObject).getName());
                                    }
                                }
                            }
                            this.sb.append("METHODS:\n");
                            for (AccessibleObject accessibleObject : value.getClass().getMethods()) {
                                this.sb.append("  ");
                                this.sb.append(((Method)accessibleObject).getReturnType().getSimpleName());
                                this.sb.append("  ");
                                this.sb.append(((Method)accessibleObject).getName());
                                this.sb.append("(");
                                int count = 0;
                                int n = ((Method)accessibleObject).getParameterCount();
                                for (Parameter p : ((Executable)accessibleObject).getParameters()) {
                                    ++count;
                                    this.sb.append(p.getType().getSimpleName());
                                    this.sb.append(" ");
                                    this.sb.append(p.getName());
                                    if (count >= n) continue;
                                    this.sb.append(", ");
                                }
                                this.sb.append(")\n");
                            }
                            this.sb.append("---------------------------------------------\n");
                            ScriptInterpreter.this.addToCommandWindow(this.sb.toString());
                        }
                    });
                } else {
                    this.setOnMouseClicked(null);
                }
                this.tooltip.setText(text);
                this.setTooltip(this.tooltip);
            }
        }
    }

    private static enum VariableInfoType {
        NAME,
        CLASS,
        VALUE;

    }
}

