/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import javafx.animation.FadeTransition;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import qupath.fx.controls.CircularSlider;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.viewer.QuPathViewer;

final class RotateImageCommand
implements ChangeListener<QuPathViewer> {
    private QuPathGUI qupath;
    private CircularSlider slider;
    private Stage dialog;

    RotateImageCommand(QuPathGUI qupath) {
        this.qupath = qupath;
        qupath.viewerProperty().addListener((ChangeListener)this);
    }

    Stage createDialog() {
        QuPathViewer viewerTemp = this.qupath.getViewer();
        if (this.dialog == null) {
            this.dialog = new Stage();
            FXUtils.addCloseWindowShortcuts((Stage)this.dialog);
            this.dialog.initOwner((Window)this.qupath.getStage());
            this.dialog.initStyle(StageStyle.TRANSPARENT);
            this.dialog.setTitle("Rotate view");
            StackPane pane = new StackPane();
            pane.setPadding(new Insets(5.0));
            this.slider = new CircularSlider();
            this.slider.setPrefSize(150.0, 150.0);
            this.slider.setValue(viewerTemp == null ? 0.0 : Math.toDegrees(viewerTemp.getRotation()));
            this.slider.setTickSpacing(10.0);
            this.slider.setShowValue(true);
            this.slider.setSnapToTicks(false);
            this.slider.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.SHIFT) {
                    this.slider.setSnapToTicks(true);
                    this.slider.setShowTickMarks(true);
                }
            });
            this.slider.setOnKeyReleased(e -> {
                if (e.getCode() == KeyCode.SHIFT) {
                    this.slider.setSnapToTicks(false);
                    this.slider.setShowTickMarks(false);
                }
            });
            this.slider.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
            this.slider.setTooltip(new Tooltip("Double-click to manually set the rotation"));
            DropShadow shadow = new DropShadow();
            shadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
            this.slider.setEffect((Effect)shadow);
            Button button = new Button("x");
            button.setTooltip(new Tooltip("Close image rotation slider"));
            button.setOnMouseClicked(e -> this.dialog.close());
            pane.getChildren().addAll((Object[])new Node[]{this.slider, button});
            double[] delta = new double[2];
            this.slider.getTextArea().setOnMousePressed(e -> {
                delta[0] = this.dialog.getX() - e.getScreenX();
                delta[1] = this.dialog.getY() - e.getScreenY();
            });
            this.slider.getTextArea().setOnMouseDragged(e -> {
                this.dialog.setX(e.getScreenX() + delta[0]);
                this.dialog.setY(e.getScreenY() + delta[1]);
            });
            StackPane.setAlignment((Node)button, (Pos)Pos.TOP_RIGHT);
            pane.setStyle("-fx-background-color: transparent; -fx-background-radius: 10;");
            double outOpacity = 0.2;
            button.setOpacity(0.2);
            FadeTransition fade = new FadeTransition();
            fade.setDuration(Duration.millis((double)150.0));
            fade.setNode((Node)button);
            pane.setOnMouseEntered(e -> {
                fade.stop();
                fade.setFromValue(button.getOpacity());
                fade.setToValue(1.0);
                fade.play();
            });
            pane.setOnMouseExited(e -> {
                fade.stop();
                fade.setFromValue(button.getOpacity());
                fade.setToValue(0.2);
                fade.play();
            });
            Scene scene = new Scene((Parent)pane);
            scene.setFill((Paint)Color.TRANSPARENT);
            this.dialog.setOnHiding(e -> {
                this.qupath.viewerProperty().removeListener((ChangeListener)this);
                this.dialog = null;
            });
            this.dialog.setScene(scene);
            this.dialog.setResizable(true);
        }
        if (viewerTemp != null) {
            this.slider.rotationProperty().bindBidirectional((Property)viewerTemp.rotationProperty());
        }
        return this.dialog;
    }

    public void changed(ObservableValue<? extends QuPathViewer> v, QuPathViewer o, QuPathViewer n) {
        o.rotationProperty().unbindBidirectional((Property)this.slider.rotationProperty());
        if (n != null) {
            this.slider.rotationProperty().bindBidirectional((Property)n.rotationProperty());
        }
    }
}

