/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.ToolManager;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.PathObjectPainter;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.gui.viewer.overlays.AbstractOverlay;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.tools.PathTools;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathROIObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;
import qupath.lib.scripting.QP;

class RigidObjectEditorCommand
implements Runnable,
ChangeListener<ImageData<BufferedImage>>,
QuPathViewerListener {
    private static final Logger logger = LoggerFactory.getLogger(RigidObjectEditorCommand.class);
    private static final String TITLE = "Transform annotations";
    private QuPathGUI qupath;
    private QuPathViewer viewer = null;
    private PathOverlay overlay = null;
    private PathObject originalObject = null;
    private Map<PathObject, ROI> originalObjectROIs = new HashMap<PathObject, ROI>();
    private RoiAffineTransformer transformer = null;
    private RigidMouseListener mouseListener = new RigidMouseListener();
    private KeyHandler keyListener = new KeyHandler();

    public RigidObjectEditorCommand(QuPathGUI qupath) {
        this.qupath = qupath;
        this.qupath.imageDataProperty().addListener((ChangeListener)this);
    }

    PathObject getSelectedObject(QuPathViewer viewer) {
        return viewer.getSelectedObject();
    }

    @Override
    public void run() {
        ButtonType response;
        if (this.originalObject != null) {
            return;
        }
        this.viewer = this.qupath.getViewer();
        PathObjectHierarchy hierarchy = this.viewer.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        PathObject pathObject = hierarchy.getSelectionModel().getSelectedObject();
        List allSelected = hierarchy.getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation()).collect(Collectors.toCollection(ArrayList::new));
        if (pathObject == null || !pathObject.isAnnotation()) {
            Dialogs.showErrorNotification((String)TITLE, (String)"Please select an annotation!");
            return;
        }
        if ((pathObject.isLocked() || allSelected.stream().anyMatch(p -> p.isLocked())) && (response = Dialogs.builder().title(TITLE).contentText("Selection includes at least one locked annotation - do you want to transform them anyway?").buttons(new ButtonType[]{ButtonType.YES, ButtonType.NO}).showAndWait().orElse(ButtonType.NO)) == ButtonType.NO) {
            return;
        }
        if (!allSelected.contains(pathObject)) {
            allSelected.add(0, pathObject);
        }
        ImageRegion bounds = this.viewer.getServerBounds();
        for (PathObject pathObject2 : allSelected) {
            this.originalObjectROIs.put(pathObject2, pathObject2.getROI());
        }
        this.originalObject = pathObject;
        this.viewer.setActiveTool(PathTools.MOVE);
        this.qupath.getToolManager().setToolSwitchingEnabled(false);
        this.viewer.addViewerListener(this);
        this.viewer.getView().addEventFilter(MouseEvent.ANY, (EventHandler)this.mouseListener);
        this.viewer.getView().addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this.keyListener);
        this.transformer = new RoiAffineTransformer(bounds, this.originalObject.getROI());
        this.overlay = new AffineEditOverlay(this.viewer.getOverlayOptions());
        this.viewer.getCustomOverlayLayers().add((Object)this.overlay);
        PathPrefs.paintSelectedBoundsProperty().set(false);
        for (Map.Entry entry : this.originalObjectROIs.entrySet()) {
            ((PathROIObject)entry.getKey()).setROI(this.transformer.getTransformedROI((ROI)entry.getValue(), false));
        }
        this.viewer.getROIEditor().setROI(null);
        this.viewer.repaint();
    }

    private void commitChanges(boolean ignoreChanges) {
        if (this.originalObject == null) {
            return;
        }
        AffineTransformation transform = this.transformer.transform;
        ImageData<BufferedImage> imageData = this.viewer.getImageData();
        PathObjectHierarchy hierarchy = this.viewer.getHierarchy();
        ButtonType option = ButtonType.CANCEL;
        ButtonType btSelected = this.originalObjectROIs.size() == 1 ? new ButtonType("Selected object") : new ButtonType("Selected objects");
        ButtonType btAll = new ButtonType("All objects");
        if (!ignoreChanges && !transform.isIdentity()) {
            option = Dialogs.builder().title(TITLE).contentText("Confirm object changes?").buttons(new ButtonType[]{btSelected, btAll, ButtonType.CANCEL}).showAndWait().orElse(ButtonType.CANCEL);
        }
        ToolManager toolManager = this.qupath.getToolManager();
        toolManager.setToolSwitchingEnabled(true);
        if (this.viewer == this.qupath.getViewer()) {
            this.viewer.setActiveTool(toolManager.getSelectedTool());
        }
        this.viewer.getView().removeEventFilter(MouseEvent.ANY, (EventHandler)this.mouseListener);
        this.viewer.getView().removeEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this.keyListener);
        this.viewer.getCustomOverlayLayers().remove((Object)this.overlay);
        this.viewer.removeViewerListener(this);
        this.viewer = null;
        this.overlay = null;
        this.originalObject = null;
        this.transformer = null;
        for (Map.Entry<PathObject, ROI> entry : this.originalObjectROIs.entrySet()) {
            ((PathROIObject)entry.getKey()).setROI(entry.getValue());
        }
        this.originalObjectROIs.clear();
        if (option != ButtonType.CANCEL) {
            double[] values = transform.getMatrixEntries();
            String transformString = String.format("[[%f, %f, %f], [%f, %f, %f]]", values[0], values[1], values[2], values[3], values[4], values[5]);
            logger.info("Applied annotation transform: {}", (Object)transformString);
            if (option == btAll) {
                QP.transformAllObjects((PathObjectHierarchy)hierarchy, (AffineTransform)GeometryTools.convertTransform((AffineTransformation)transform));
                String scriptString = String.format("transformAllObjects(AffineTransforms.fromRows(%f, %f, %f, %f, %f, %f))", values[0], values[1], values[2], values[3], values[4], values[5]);
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Transform all objects", scriptString));
            } else {
                QP.transformSelectedObjects((PathObjectHierarchy)hierarchy, (AffineTransform)GeometryTools.convertTransform((AffineTransformation)transform));
                String scriptString = String.format("transformSelectedObjects(AffineTransforms.fromRows(%f, %f, %f, %f, %f, %f))", values[0], values[1], values[2], values[3], values[4], values[5]);
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Transform selected objects", scriptString));
            }
        }
    }

    PathObject createTransformedObject() {
        ROI roi = this.originalObject.getROI();
        ROI shape = GeometryTools.geometryToROI((Geometry)this.transformer.getTransformedShape(), (ImagePlane)roi.getImagePlane());
        return PathObjects.createAnnotationObject((ROI)shape, (PathClass)this.originalObject.getPathClass());
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        this.commitChanges(false);
    }

    @Override
    public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        this.commitChanges(true);
    }

    @Override
    public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
    }

    @Override
    public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
        if (this.originalObject != pathObjectSelected) {
            this.commitChanges(false);
        }
    }

    @Override
    public void viewerClosed(QuPathViewer viewer) {
        this.commitChanges(true);
    }

    static class RoiAffineTransformer {
        private ROI roiBounds;
        private double anchorX;
        private double anchorY;
        private Geometry shapeOrig;
        private Geometry boundsOrig;
        private Geometry shapeTransformed;
        private Geometry boundsTransformed;
        private double dx = 0.0;
        private double dy = 0.0;
        private double theta = 0.0;
        private AffineTransformation transform;

        RoiAffineTransformer(ImageRegion bounds, ROI roi) {
            if (bounds != null) {
                this.roiBounds = ROIs.createRectangleROI((double)bounds.getX(), (double)bounds.getY(), (double)bounds.getWidth(), (double)bounds.getHeight(), (ImagePlane)ImagePlane.getPlane((ImageRegion)bounds));
            }
            this.shapeOrig = roi.getGeometry();
            this.boundsOrig = this.shapeOrig.getEnvelope();
            this.transform = new AffineTransformation();
            Point centroid = this.boundsOrig.getCentroid();
            this.anchorX = centroid.getX();
            this.anchorY = centroid.getY();
        }

        void resetCachedShapes() {
            this.shapeTransformed = null;
            this.boundsTransformed = null;
        }

        public ROI getTransformedROI(ROI roi, boolean clipToBounds) {
            Geometry geom = roi.getGeometry();
            this.updateTransform();
            geom = this.transform.transform(geom);
            if (clipToBounds && this.roiBounds != null) {
                geom = geom.intersection(this.roiBounds.getGeometry());
            }
            return GeometryTools.geometryToROI((Geometry)geom, (ImagePlane)roi.getImagePlane());
        }

        public ROI getUnclippedTransformedROI(ROI roi) {
            Geometry shape = roi.getGeometry();
            this.updateTransform();
            shape = this.transform.transform(shape);
            return GeometryTools.geometryToROI((Geometry)shape, (ImagePlane)roi.getImagePlane());
        }

        public Geometry getTransformedShape() {
            if (this.shapeTransformed == null) {
                this.updateTransform();
                this.shapeTransformed = this.transform.transform(this.shapeOrig);
            }
            return this.shapeTransformed;
        }

        public Geometry getTransformedBounds() {
            if (this.boundsTransformed == null) {
                this.updateTransform();
                this.boundsTransformed = this.transform.transform(this.boundsOrig);
            }
            return this.boundsTransformed;
        }

        public void setRotationByVector(double x, double y) {
            double vecY = this.anchorY + this.dy - y;
            double vecX = x - (this.anchorX + this.dx);
            this.theta = Math.atan2(vecX, vecY);
            this.resetCachedShapes();
        }

        public void translate(double dx, double dy) {
            this.dx += dx;
            this.dy += dy;
            this.resetCachedShapes();
        }

        void updateTransform() {
            this.transform.setToRotation(this.theta, this.anchorX, this.anchorY);
            this.transform.translate(this.dx, this.dy);
        }

        double getDisplacement(double downsampleFactor) {
            return downsampleFactor * 10.0;
        }

        Line2D getRotationHandleLine(double downsampleFactor) {
            double displacement = this.getDisplacement(downsampleFactor);
            Envelope env = this.boundsOrig.getEnvelopeInternal();
            Coordinate p1 = new Coordinate((env.getMinX() + env.getMaxX()) / 2.0, env.getMinY());
            Coordinate p2 = new Coordinate((env.getMinX() + env.getMaxX()) / 2.0, env.getMinY() - displacement);
            this.transform.transform(p1, p1);
            this.transform.transform(p2, p2);
            return new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        }

        Shape getRotationHandle(double downsampleFactor) {
            double radius = 5.0 * downsampleFactor;
            double displacement = this.getDisplacement(downsampleFactor);
            Envelope env = this.boundsOrig.getEnvelopeInternal();
            Coordinate c = new Coordinate((env.getMinX() + env.getMaxX()) / 2.0, env.getMinY() - displacement - radius);
            this.transform.transform(c, c);
            return new Ellipse2D.Double(c.getX() - radius, c.getY() - radius, radius * 2.0, radius * 2.0);
        }
    }

    class RigidMouseListener
    implements EventHandler<MouseEvent> {
        private Point2D lastPoint;
        private boolean isRotating = false;
        private boolean isTranslating = false;

        RigidMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            Point2D p;
            if (RigidObjectEditorCommand.this.transformer == null) {
                return;
            }
            if (e.getClickCount() > 1) {
                p = RigidObjectEditorCommand.this.viewer.componentPointToImagePoint(e.getX(), e.getY(), new Point2D.Double(), false);
                if (!this.contains(RigidObjectEditorCommand.this.transformer.getTransformedBounds(), p.getX(), p.getY())) {
                    RigidObjectEditorCommand.this.commitChanges(false);
                    e.consume();
                    return;
                }
            }
            p = RigidObjectEditorCommand.this.viewer.componentPointToImagePoint(e.getX(), e.getY(), new Point2D.Double(), false);
            if (RigidObjectEditorCommand.this.transformer.getRotationHandle(RigidObjectEditorCommand.this.viewer.getDownsampleFactor()).contains(p)) {
                this.isRotating = true;
                this.lastPoint = p;
                e.consume();
            } else if (this.contains(RigidObjectEditorCommand.this.transformer.getTransformedBounds(), p.getX(), p.getY())) {
                this.isTranslating = true;
                this.lastPoint = p;
                e.consume();
            }
        }

        boolean contains(Geometry geometry, double x, double y) {
            return SimplePointInAreaLocator.isContained((Coordinate)new Coordinate(x, y), (Geometry)geometry);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.lastPoint != null) {
                this.isRotating = false;
                this.isTranslating = false;
                this.lastPoint = null;
                e.consume();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.lastPoint == null) {
                return;
            }
            Point2D p = RigidObjectEditorCommand.this.viewer.componentPointToImagePoint(e.getX(), e.getY(), new Point2D.Double(), false);
            if (this.isTranslating) {
                double dx = p.getX() - this.lastPoint.getX();
                double dy = p.getY() - this.lastPoint.getY();
                RigidObjectEditorCommand.this.transformer.translate(dx, dy);
            }
            if (this.isRotating) {
                RigidObjectEditorCommand.this.transformer.setRotationByVector(p.getX(), p.getY());
            }
            this.lastPoint = p;
            for (Map.Entry<PathObject, ROI> entry : RigidObjectEditorCommand.this.originalObjectROIs.entrySet()) {
                ROI roiTransformed = RigidObjectEditorCommand.this.transformer.getTransformedROI(entry.getValue(), false);
                ((PathROIObject)entry.getKey()).setROI(roiTransformed);
            }
            RigidObjectEditorCommand.this.viewer.repaint();
            e.consume();
        }

        public void handle(MouseEvent e) {
            if (e.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                this.mouseDragged(e);
            } else if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
                this.mousePressed(e);
            } else if (e.getEventType() == MouseEvent.MOUSE_RELEASED) {
                this.mouseReleased(e);
            }
        }
    }

    class KeyHandler
    implements EventHandler<KeyEvent> {
        KeyHandler() {
        }

        public void handle(KeyEvent event) {
            KeyCode code = event.getCode();
            if (code == KeyCode.ENTER) {
                RigidObjectEditorCommand.this.commitChanges(false);
                event.consume();
            } else if (event.isShortcutDown()) {
                double downsample = RigidObjectEditorCommand.this.viewer.getDownsampleFactor();
                if (event.isShiftDown()) {
                    double thetaIncrement = 0.0031415926535897933;
                    if (code == KeyCode.RIGHT) {
                        RigidObjectEditorCommand.this.transformer.theta += thetaIncrement;
                        event.consume();
                    } else if (code == KeyCode.LEFT) {
                        RigidObjectEditorCommand.this.transformer.theta -= thetaIncrement;
                        event.consume();
                    } else if (code == KeyCode.UP) {
                        RigidObjectEditorCommand.this.transformer.theta -= thetaIncrement / 10.0;
                        event.consume();
                    } else if (code == KeyCode.DOWN) {
                        RigidObjectEditorCommand.this.transformer.theta += thetaIncrement / 10.0;
                        event.consume();
                    }
                } else if (code == KeyCode.RIGHT) {
                    RigidObjectEditorCommand.this.transformer.translate(downsample, 0.0);
                    event.consume();
                } else if (code == KeyCode.LEFT) {
                    RigidObjectEditorCommand.this.transformer.translate(-downsample, 0.0);
                    event.consume();
                } else if (code == KeyCode.UP) {
                    RigidObjectEditorCommand.this.transformer.translate(0.0, -downsample);
                    event.consume();
                } else if (code == KeyCode.DOWN) {
                    RigidObjectEditorCommand.this.transformer.translate(0.0, downsample);
                    event.consume();
                }
                RigidObjectEditorCommand.this.transformer.resetCachedShapes();
                if (event.isConsumed()) {
                    for (Map.Entry<PathObject, ROI> entry : RigidObjectEditorCommand.this.originalObjectROIs.entrySet()) {
                        ROI roiTransformed = RigidObjectEditorCommand.this.transformer.getTransformedROI(entry.getValue(), false);
                        ((PathROIObject)entry.getKey()).setROI(roiTransformed);
                    }
                    RigidObjectEditorCommand.this.viewer.repaint();
                }
            }
        }
    }

    class AffineEditOverlay
    extends AbstractOverlay {
        AffineEditOverlay(OverlayOptions overlayOptions) {
            super(overlayOptions);
        }

        @Override
        public void paintOverlay(Graphics2D g2d, ImageRegion imageRegion, double downsampleFactor, ImageData<BufferedImage> imageData, boolean paintCompletely) {
            if (RigidObjectEditorCommand.this.transformer == null) {
                return;
            }
            Stroke stroke = PathObjectPainter.getCachedStroke(PathPrefs.annotationStrokeThicknessProperty().get() * downsampleFactor);
            Color color = ColorToolsAwt.getCachedColor((int)0, (int)0, (int)0, (int)96);
            PathObjectPainter.paintShape(GeometryTools.geometryToShape((Geometry)RigidObjectEditorCommand.this.transformer.getTransformedBounds()), g2d, color, stroke, null);
            Line2D line = RigidObjectEditorCommand.this.transformer.getRotationHandleLine(downsampleFactor);
            PathObjectPainter.paintShape(line, g2d, color, stroke, null);
            Shape ellipse = RigidObjectEditorCommand.this.transformer.getRotationHandle(downsampleFactor);
            Color color2 = ColorToolsAwt.getCachedColor((int)255, (int)255, (int)255, (int)96);
            PathObjectPainter.paintShape(ellipse, g2d, color, stroke, color2);
            for (PathObject pathObject : RigidObjectEditorCommand.this.originalObjectROIs.keySet()) {
                PathObjectPainter.paintObject(pathObject, g2d, this.getOverlayOptions(), RigidObjectEditorCommand.this.viewer.getHierarchy().getSelectionModel(), downsampleFactor);
            }
        }
    }
}

