/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.panes.ProjectBrowser;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;

class ProjectMetadataEditorCommand {
    private static final Logger logger = LoggerFactory.getLogger(ProjectMetadataEditorCommand.class);
    private static final String IMAGE_NAME = "Image name";

    ProjectMetadataEditorCommand() {
    }

    public static void showProjectMetadataEditor(Project<?> project) {
        if (project == null) {
            logger.warn("No project available!");
            return;
        }
        TreeSet metadataNameSet = new TreeSet();
        ArrayList<ImageEntryWrapper> entries = new ArrayList<ImageEntryWrapper>();
        for (ProjectImageEntry entry : project.getImageList()) {
            entries.add(new ImageEntryWrapper(entry));
            metadataNameSet.addAll(entry.getMetadataKeys());
        }
        TableView table = new TableView();
        TableColumn colName = new TableColumn(IMAGE_NAME);
        colName.setCellValueFactory(v -> ((ImageEntryWrapper)v.getValue()).getNameBinding());
        table.getColumns().add((Object)colName);
        table.setEditable(true);
        for (String metadataName : metadataNameSet) {
            TableColumn col = new TableColumn(metadataName);
            col.setCellFactory(TextFieldTableCell.forTableColumn());
            col.setOnEditCommit(e -> {
                ImageEntryWrapper entry = (ImageEntryWrapper)e.getRowValue();
                String n = (String)e.getNewValue();
                if (n == null || n.isEmpty()) {
                    entry.removeMetadataValue(e.getTableColumn().getText());
                } else {
                    entry.putMetadataValue(e.getTableColumn().getText(), n);
                }
            });
            col.setCellValueFactory(v -> ((ImageEntryWrapper)v.getValue()).getProperty(metadataName));
            col.setEditable(true);
            table.getColumns().add((Object)col);
        }
        table.getItems().setAll(entries);
        table.getSelectionModel().setCellSelectionEnabled(true);
        table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        table.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.BACK_SPACE || e.getCode() == KeyCode.DELETE) {
                List<TablePosition> positions = table.getSelectionModel().getSelectedCells().stream().filter(p -> !IMAGE_NAME.equals(p.getTableColumn().getText())).toList();
                if (positions.isEmpty()) {
                    return;
                }
                if (positions.size() == 1) {
                    ProjectMetadataEditorCommand.setTextForSelectedCells(positions, null);
                } else if (Dialogs.showConfirmDialog((String)"Project metadata", (String)("Clear metadata for " + positions.size() + " selected cells?"))) {
                    ProjectMetadataEditorCommand.setTextForSelectedCells(positions, null);
                }
                table.refresh();
            }
        });
        BooleanBinding selectedCells = Bindings.createBooleanBinding(() -> table.getSelectionModel().selectedItemProperty() == null, (Observable[])new Observable[]{table.getSelectionModel().selectedItemProperty()});
        MenuBar menubar = new MenuBar();
        Menu menuEdit = new Menu("Edit");
        MenuItem miCopy = new MenuItem("Copy selected cells");
        miCopy.disableProperty().bind((ObservableValue)selectedCells);
        miCopy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        miCopy.setOnAction(e -> ProjectMetadataEditorCommand.copySelectedCellsToClipboard(table, true));
        MenuItem miCopyFull = new MenuItem("Copy full table");
        miCopyFull.setOnAction(e -> ProjectMetadataEditorCommand.copyEntireTableToClipboard(table));
        MenuItem miPaste = new MenuItem("Paste");
        miPaste.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        miPaste.disableProperty().bind((ObservableValue)selectedCells);
        miPaste.setOnAction(e -> ProjectMetadataEditorCommand.pasteClipboardContentsToTable(table));
        MenuItem miSet = new MenuItem("Set cell contents");
        miSet.disableProperty().bind((ObservableValue)selectedCells);
        miSet.setOnAction(e -> {
            String input = Dialogs.showInputDialog((String)"Set metadata cells", (String)"Metadata text", (String)"");
            if (input == null) {
                return;
            }
            ProjectMetadataEditorCommand.setTextForSelectedCells((List<TablePosition>)table.getSelectionModel().getSelectedCells(), input);
            table.refresh();
        });
        menuEdit.getItems().addAll((Object[])new MenuItem[]{miCopy, miCopyFull, miPaste, miSet});
        menubar.getMenus().add((Object)menuEdit);
        BorderPane pane = new BorderPane();
        pane.setTop((Node)menubar);
        pane.setCenter((Node)table);
        SystemMenuBar.manageChildMenuBar(menubar);
        Dialog dialog = new Dialog();
        QuPathGUI qupath = QuPathGUI.getInstance();
        if (qupath != null) {
            dialog.initOwner((Window)qupath.getStage());
        }
        dialog.setTitle("Project metadata");
        dialog.setHeaderText(null);
        dialog.setResizable(true);
        dialog.getDialogPane().setContent((Node)pane);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialog.getDialogPane().setPrefWidth(500.0);
        Optional result = dialog.showAndWait();
        if (result.isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE) {
            for (ImageEntryWrapper wrapper : entries) {
                wrapper.commitChanges();
            }
            ProjectBrowser.syncProject(project);
        }
    }

    private static void copySelectedCellsToClipboard(TableView<?> table, boolean warnIfDiscontinuous) {
        int[] cols;
        boolean isContinuous;
        ObservableList positions = table.getSelectionModel().getSelectedCells();
        if (positions.isEmpty()) {
            return;
        }
        int[] rows = positions.stream().mapToInt(tp -> tp.getRow()).sorted().toArray();
        boolean bl = isContinuous = (rows[rows.length - 1] - rows[0] + 1) * ((cols = positions.stream().mapToInt(tp -> tp.getColumn()).sorted().toArray())[cols.length - 1] - cols[0] + 1) == positions.size();
        if (!isContinuous) {
            if (warnIfDiscontinuous) {
                Dialogs.showWarningNotification((String)"Copy table selection", (String)"Cannot copy discontinuous selection, sorry");
            }
            return;
        }
        ProjectMetadataEditorCommand.copyToClipboard((List<TablePosition>)positions);
    }

    private static <T> void copyEntireTableToClipboard(TableView<T> table) {
        ArrayList<TablePosition> positions = new ArrayList<TablePosition>();
        for (TableColumn column : table.getColumns()) {
            for (int row = 0; row < table.getItems().size(); ++row) {
                positions.add(new TablePosition(table, row, column));
            }
        }
        ProjectMetadataEditorCommand.copyToClipboard(positions);
    }

    private static void copyToClipboard(List<TablePosition> positions) {
        positions = new ArrayList<TablePosition>(positions);
        positions.sort((p1, p2) -> {
            int row = Integer.compare(p1.getRow(), p2.getRow());
            if (row == 0) {
                return Integer.compare(p1.getColumn(), p2.getColumn());
            }
            return row;
        });
        StringBuilder sb = new StringBuilder();
        int lastRow = -1;
        for (TablePosition tp : positions) {
            String dataString;
            int row = tp.getRow();
            Object data = tp.getTableColumn().getCellData(row);
            String string = dataString = data == null ? "" : data.toString();
            if (row == lastRow) {
                sb.append("\t");
            } else if (lastRow >= 0) {
                sb.append("\n");
            }
            sb.append(dataString);
            lastRow = row;
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(sb.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private static void pasteClipboardContentsToTable(TableView<?> table) {
        String s = Clipboard.getSystemClipboard().getString();
        if (s == null) {
            logger.warn("No text on clipboard");
            return;
        }
        ObservableList positions = table.getSelectionModel().getSelectedCells();
        if (positions.isEmpty()) {
            logger.warn("No table cells selected");
            return;
        }
        if (s.contains("\n") || s.contains("\t")) {
            Dialogs.showWarningNotification((String)"Paste contents", (String)"Cannot paste clipboard contents - only simple, single-cell text supported");
            return;
        }
        ProjectMetadataEditorCommand.setTextForSelectedCells((List<TablePosition>)positions, s);
        table.refresh();
    }

    private static void setTextForSelectedCells(List<TablePosition> positions, String text) {
        boolean containsImageNameColumns = false;
        for (TablePosition tp : positions) {
            boolean isImageNameColumn = IMAGE_NAME.equals(tp.getTableColumn().getText());
            if (isImageNameColumn) {
                containsImageNameColumns = true;
                continue;
            }
            ImageEntryWrapper wrapper = (ImageEntryWrapper)tp.getTableView().getItems().get(tp.getRow());
            String key = tp.getTableColumn().getText();
            if (text == null) {
                wrapper.removeMetadataValue(key);
                continue;
            }
            wrapper.putMetadataValue(key, text);
        }
        if (containsImageNameColumns) {
            Dialogs.showWarningNotification((String)"Project metadata table", (String)"The image name cannot be changed");
        }
    }

    static class ImageEntryWrapper {
        private ProjectImageEntry<?> entry;
        private Map<String, String> metadataMap = new TreeMap<String, String>();

        ImageEntryWrapper(ProjectImageEntry<?> entry) {
            this.entry = entry;
            this.metadataMap.putAll(entry.getMetadataMap());
        }

        public ObservableStringValue getNameBinding() {
            return Bindings.createStringBinding(() -> this.entry.getImageName(), (Observable[])new Observable[0]);
        }

        public void commitChanges() {
            if (this.metadataMap.equals(this.entry.getMetadataMap())) {
                return;
            }
            this.entry.clearMetadata();
            for (Map.Entry<String, String> mapEntry : this.metadataMap.entrySet()) {
                this.entry.putMetadataValue(mapEntry.getKey(), mapEntry.getValue());
            }
        }

        public ObservableStringValue getProperty(String columnName) {
            return Bindings.createStringBinding(() -> {
                String value = this.metadataMap.get(columnName);
                if (value == null) {
                    return "";
                }
                return value;
            }, (Observable[])new Observable[0]);
        }

        public String getMetadataValue(Object key) {
            return this.metadataMap.get(key);
        }

        public void putMetadataValue(String key, String value) {
            this.metadataMap.put(key, value);
        }

        public void removeMetadataValue(String key) {
            this.metadataMap.remove(key);
        }
    }
}

