/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.controlsfx.dialog.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.panes.ProjectBrowser;
import qupath.lib.gui.panes.ServerSelector;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.RotatedImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.servers.WrappedBufferedImageServer;
import qupath.lib.io.PathIO;
import qupath.lib.objects.PathObjectReader;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;

class ProjectImportImagesCommand {
    private static final Logger logger = LoggerFactory.getLogger(ProjectImportImagesCommand.class);
    private static final String commandName = "Import images";
    private static final BooleanProperty pyramidalizeProperty = PathPrefs.createPersistentPreference("projectImportPyramidalize", true);
    private static final BooleanProperty importObjectsProperty = PathPrefs.createPersistentPreference("projectImportObjects", false);
    private static final BooleanProperty showImageSelectorProperty = PathPrefs.createPersistentPreference("showImageSelectorProperty", false);
    private static int thumbnailWidth = 1000;
    private static int thumbnailHeight = 600;

    ProjectImportImagesCommand() {
    }

    static List<ProjectImageEntry<BufferedImage>> promptToImportImages(final QuPathGUI qupath, ImageServerBuilder<BufferedImage> builder, String ... defaultPaths) {
        String[] argsSplit;
        final Project<BufferedImage> project = qupath.getProject();
        if (project == null) {
            GuiTools.showNoProjectError(commandName);
            return Collections.emptyList();
        }
        final ListView listView = new ListView();
        listView.setPrefWidth(480.0);
        listView.setMinHeight(100.0);
        listView.getItems().addAll((Object[])defaultPaths);
        listView.setPlaceholder((Node)new Label("Drag & drop image or project files for import, \nor choose from the options below"));
        Button btnFile = new Button("Choose files");
        btnFile.setOnAction(e -> ProjectImportImagesCommand.loadFromFileChooser((List<String>)listView.getItems()));
        Button btnURL = new Button("Input URL");
        btnURL.setOnAction(e -> ProjectImportImagesCommand.loadFromSingleURL((List<String>)listView.getItems()));
        Button btnClipboard = new Button("From clipboard");
        btnClipboard.setOnAction(e -> ProjectImportImagesCommand.loadFromClipboard((List<String>)listView.getItems()));
        Button btnFileList = new Button("From path list");
        btnFileList.setOnAction(e -> ProjectImportImagesCommand.loadFromTextFile((List<String>)listView.getItems()));
        TitledPane paneList = new TitledPane("Image paths", (Node)listView);
        paneList.setCollapsible(false);
        BorderPane paneImages = new BorderPane();
        boolean requestBuilder = builder == null;
        ComboBox comboBuilder = new ComboBox();
        Label labelBuilder = new Label("Image server");
        if (requestBuilder) {
            class BuilderListCell
            extends ListCell<ImageServerBuilder<BufferedImage>> {
                BuilderListCell() {
                }

                protected void updateItem(ImageServerBuilder<BufferedImage> item, boolean empty) {
                    super.updateItem(item, empty);
                    if (empty) {
                        this.setText(null);
                    } else if (item == null) {
                        this.setText("Default (let QuPath decide)");
                    } else {
                        String name = item.getName();
                        if (name.toLowerCase().endsWith("builder")) {
                            name = name.substring(0, name.length() - "builder".length()).strip();
                        }
                        this.setText(name);
                    }
                }
            }
            comboBuilder.setCellFactory(p -> new BuilderListCell());
            comboBuilder.setButtonCell((ListCell)new BuilderListCell());
            ArrayList availableBuilders = new ArrayList(ImageServerProvider.getInstalledImageServerBuilders(BufferedImage.class));
            if (!availableBuilders.contains(null)) {
                availableBuilders.add(0, null);
            }
            comboBuilder.getItems().setAll(availableBuilders);
            comboBuilder.getSelectionModel().selectFirst();
            labelBuilder.setLabelFor((Node)comboBuilder);
            labelBuilder.setMinWidth(Double.NEGATIVE_INFINITY);
        }
        ComboBox comboType = new ComboBox();
        comboType.getItems().setAll((Object[])ImageData.ImageType.values());
        Label labelType = new Label("Set image type");
        labelType.setLabelFor((Node)comboType);
        labelType.setMinWidth(Double.NEGATIVE_INFINITY);
        ComboBox comboRotate = new ComboBox();
        comboRotate.getItems().setAll((Object[])RotatedImageServer.Rotation.values());
        Label labelRotate = new Label("Rotate image");
        labelRotate.setLabelFor((Node)comboRotate);
        labelRotate.setMinWidth(Double.NEGATIVE_INFINITY);
        TextField tfArgs = new TextField();
        Label labelArgs = new Label("Optional args");
        labelArgs.setLabelFor((Node)tfArgs);
        labelArgs.setMinWidth(Double.NEGATIVE_INFINITY);
        CheckBox cbPyramidalize = new CheckBox("Auto-generate pyramids");
        cbPyramidalize.setSelected(pyramidalizeProperty.get());
        CheckBox cbImportObjects = new CheckBox("Import objects");
        cbImportObjects.setSelected(importObjectsProperty.get());
        CheckBox cbImageSelector = new CheckBox("Show image selector");
        cbImageSelector.setSelected(showImageSelectorProperty.get());
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{comboBuilder, comboType, comboRotate, cbPyramidalize, cbImportObjects, tfArgs, cbImageSelector});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{comboBuilder, comboType, comboRotate, cbPyramidalize, cbImportObjects, tfArgs, cbImageSelector});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{comboBuilder, comboType, comboRotate, cbPyramidalize, cbImportObjects, tfArgs, cbImageSelector});
        GridPane paneType = new GridPane();
        paneType.setPadding(new Insets(5.0));
        paneType.setHgap(5.0);
        paneType.setVgap(5.0);
        int row = 0;
        if (requestBuilder) {
            GridPaneUtils.addGridRow((GridPane)paneType, (int)row++, (int)0, (String)"Specify the library used to open images", (Node[])new Node[]{labelBuilder, comboBuilder});
        }
        GridPaneUtils.addGridRow((GridPane)paneType, (int)row++, (int)0, (String)"Specify the default image type for all images being imported (required for analysis, can be changed later under the 'Image' tab)", (Node[])new Node[]{labelType, comboType});
        GridPaneUtils.addGridRow((GridPane)paneType, (int)row++, (int)0, (String)"Optionally rotate images on import", (Node[])new Node[]{labelRotate, comboRotate});
        GridPaneUtils.addGridRow((GridPane)paneType, (int)row++, (int)0, (String)"Optionally pass reader-specific arguments to the image provider.\nUsually this should just be left empty.", (Node[])new Node[]{labelArgs, tfArgs});
        GridPaneUtils.addGridRow((GridPane)paneType, (int)row++, (int)0, (String)"Dynamically create image pyramids for large, single-resolution images", (Node[])new Node[]{cbPyramidalize, cbPyramidalize});
        GridPaneUtils.addGridRow((GridPane)paneType, (int)row++, (int)0, (String)"Read and import objects (e.g. annotations) from the image file, if possible", (Node[])new Node[]{cbImportObjects, cbImportObjects});
        GridPaneUtils.addGridRow((GridPane)paneType, (int)row++, (int)0, (String)"Show the 'Image selector' window whenever the same URI contains multiple images.\nIf this is turned off, then all images will be import.", (Node[])new Node[]{cbImageSelector, cbImageSelector});
        paneImages.setCenter((Node)paneList);
        paneImages.setBottom((Node)paneType);
        GridPane paneButtons = GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnFile, btnURL, btnClipboard, btnFileList});
        paneButtons.setHgap(5.0);
        paneButtons.setPadding(new Insets(5.0));
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)paneImages);
        pane.setBottom((Node)paneButtons);
        pane.setOnDragOver(e -> {
            e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            e.consume();
        });
        pane.setOnDragDropped(e -> {
            Dragboard dragboard = e.getDragboard();
            if (dragboard.hasFiles()) {
                logger.trace("Files dragged onto project import dialog");
                try {
                    ArrayList paths = dragboard.getFiles().stream().filter(f -> f.isFile() && !f.isHidden()).map(f -> f.getAbsolutePath()).collect(Collectors.toCollection(ArrayList::new));
                    paths.removeAll((Collection<?>)listView.getItems());
                    if (!paths.isEmpty()) {
                        listView.getItems().addAll((Collection)paths);
                    }
                }
                catch (Exception ex) {
                    Dialogs.showErrorMessage((String)"Drag & Drop", (Throwable)ex);
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            e.setDropCompleted(true);
            e.consume();
        });
        Dialog dialog = new Dialog();
        dialog.setResizable(true);
        dialog.initOwner((Window)qupath.getStage());
        dialog.setTitle("Import images to project");
        ButtonType typeImport = new ButtonType("Import", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{typeImport, ButtonType.CANCEL});
        ScrollPane scroll = new ScrollPane((Node)pane);
        scroll.setFitToHeight(true);
        scroll.setFitToWidth(true);
        dialog.getDialogPane().setContent((Node)scroll);
        Optional result = dialog.showAndWait();
        if (!result.isPresent() || result.get() != typeImport) {
            return Collections.emptyList();
        }
        final ImageData.ImageType type = (ImageData.ImageType)comboType.getValue();
        RotatedImageServer.Rotation rotation = (RotatedImageServer.Rotation)comboRotate.getValue();
        final boolean pyramidalize = cbPyramidalize.isSelected();
        final boolean importObjects = cbImportObjects.isSelected();
        final boolean showSelector = cbImageSelector.isSelected();
        pyramidalizeProperty.set(pyramidalize);
        importObjectsProperty.set(importObjects);
        showImageSelectorProperty.set(showSelector);
        final ImageServerBuilder requestedBuilder = requestBuilder ? (ImageServerBuilder)comboBuilder.getSelectionModel().getSelectedItem() : builder;
        ArrayList<String> argsList = new ArrayList<String>();
        String argsString = tfArgs.getText();
        for (String a : argsSplit = argsString == null || argsString.isBlank() ? new String[]{} : argsString.split(" ")) {
            argsList.add(a);
        }
        if (rotation != null && rotation != RotatedImageServer.Rotation.ROTATE_NONE) {
            argsList.add("--rotate");
            argsList.add(rotation.toString());
        }
        if (!argsList.isEmpty()) {
            logger.debug("Args: [{}]", (Object)argsList.stream().collect(Collectors.joining(", ")));
        }
        final String[] args = (String[])argsList.toArray(String[]::new);
        ArrayList pathSucceeded = new ArrayList();
        ArrayList pathFailed = new ArrayList();
        Task<List<ProjectImageEntry<BufferedImage>>> worker = new Task<List<ProjectImageEntry<BufferedImage>>>(){

            protected List<ProjectImageEntry<BufferedImage>> call() throws Exception {
                Object entry;
                AtomicLong counter = new AtomicLong(0L);
                ArrayList items = new ArrayList(listView.getItems());
                this.updateMessage("Checking for compatible image readers...");
                ExecutorService pool = Executors.newFixedThreadPool(ThreadTools.getParallelism(), ThreadTools.createThreadFactory((String)"project-import", (boolean)true));
                ArrayList<Future<List>> results = new ArrayList<Future<List>>();
                ArrayList projectImages = new ArrayList();
                ArrayList<File> existingDataFiles = new ArrayList<File>();
                for (Object item : items) {
                    File file;
                    String lower = ((String)item).toLowerCase();
                    if (lower.endsWith("qpproj")) {
                        try {
                            Project project2 = ProjectIO.loadProject((URI)GeneralTools.toURI((String)item), BufferedImage.class);
                            projectImages.addAll(project2.getImageList());
                        }
                        catch (Exception exception) {
                            logger.error("Unable to add images from {} ({})", item, (Object)exception.getLocalizedMessage());
                        }
                        continue;
                    }
                    if (lower.endsWith(".qpdata") && (file = new File((String)item)).exists()) {
                        existingDataFiles.add(file);
                        continue;
                    }
                    results.add(pool.submit(() -> 1.lambda$call$0((String)item, requestedBuilder, args)));
                }
                List<ProjectImageEntry> failures = Collections.synchronizedList(new ArrayList());
                if (!projectImages.isEmpty()) {
                    if (projectImages.size() == 1) {
                        this.updateMessage("Importing 1 image from existing projects");
                    } else {
                        this.updateMessage("Importing " + projectImages.size() + " images from existing projects");
                    }
                    for (ProjectImageEntry temp : projectImages) {
                        try {
                            project.addDuplicate(temp, true);
                        }
                        catch (Exception exception) {
                            failures.add(temp);
                        }
                    }
                }
                ArrayList<ImageServerBuilder.ServerBuilder> builders = new ArrayList<ImageServerBuilder.ServerBuilder>();
                for (Future future : results) {
                    try {
                        builders.addAll((Collection)future.get());
                    }
                    catch (ExecutionException e) {
                        logger.error("Execution exception importing image", (Throwable)e);
                    }
                }
                long max = builders.size() + existingDataFiles.size();
                if (!existingDataFiles.isEmpty()) {
                    if (existingDataFiles.size() == 1) {
                        this.updateMessage("Importing 1 image from existing data file");
                    } else {
                        this.updateMessage("Importing " + existingDataFiles.size() + " images from existing data files");
                    }
                    for (File file : existingDataFiles) {
                        try {
                            ImageData imageData = PathIO.readImageData((File)file);
                            entry = project.addImage(imageData.getServer().getBuilder());
                            ProjectImportImagesCommand.initializeEntry((ProjectImageEntry<BufferedImage>)entry, imageData.getImageType(), false, false);
                            entry.saveImageData(imageData);
                            this.updateProgress(counter.incrementAndGet(), max);
                            imageData.getServer().close();
                        }
                        catch (Exception e) {
                            logger.warn("Unable to read image data from file: {}", (Object)file, (Object)e.getMessage());
                        }
                    }
                }
                ArrayList<ProjectImageEntry<BufferedImage>> allAddedEntries = new ArrayList<ProjectImageEntry<BufferedImage>>();
                if (!builders.isEmpty()) {
                    if (max == 1L) {
                        this.updateMessage("Preparing to add 1 image to project");
                    } else {
                        this.updateMessage("Preparing " + max + " images");
                    }
                    if (showSelector && max > 1L) {
                        ServerSelector selector = ServerSelector.createFromBuilders(builders);
                        List selected = (List)FXUtils.callOnApplicationThread(() -> selector.promptToSelectImages("Import"));
                        builders.clear();
                        if (selected != null) {
                            entry = selected.iterator();
                            while (entry.hasNext()) {
                                ImageServer s = (ImageServer)entry.next();
                                builders.add(s.getBuilder());
                                s.close();
                            }
                        }
                    }
                    ArrayList<ProjectImageEntry> entries = new ArrayList<ProjectImageEntry>();
                    for (ImageServerBuilder.ServerBuilder builder : builders) {
                        entries.add(project.addImage(builder));
                    }
                    allAddedEntries.addAll(entries);
                    int n = builders.size();
                    for (ProjectImageEntry entry2 : entries) {
                        pool.submit(() -> {
                            try {
                                ProjectImportImagesCommand.initializeEntry((ProjectImageEntry<BufferedImage>)entry2, type, pyramidalize, importObjects);
                            }
                            catch (Exception e) {
                                failures.add(entry2);
                                logger.warn("Exception adding " + String.valueOf(entry2), (Throwable)e);
                            }
                            finally {
                                long i = counter.incrementAndGet();
                                this.updateProgress(i, max);
                                String name = entry2.getImageName();
                                if (name != null) {
                                    this.updateMessage("Added " + i + "/" + n + " - " + name);
                                }
                            }
                        });
                    }
                }
                pool.shutdown();
                try {
                    pool.awaitTermination(60L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    logger.error("Exception waiting for project import to complete: " + e.getLocalizedMessage(), (Throwable)e);
                }
                Object errorMessage = null;
                if (!failures.isEmpty()) {
                    errorMessage = failures.size() == 1 ? "Failed to load one image." : "Failed to load " + failures.size() + " images.";
                    if (requestedBuilder != null) {
                        errorMessage = (String)errorMessage + "\nThe image type might not be supported by '" + requestedBuilder.getName() + "'";
                    }
                    List<ProjectImageEntry> toRemove = failures.stream().filter(p -> project.getImageList().contains(p)).toList();
                    project.removeAllImages(toRemove, true);
                } else if (max == 0L && !items.isEmpty()) {
                    errorMessage = "Unable to add images - see log for more details";
                }
                if (errorMessage != null) {
                    Dialogs.builder().error().owner((Window)qupath.getStage()).title(ProjectImportImagesCommand.commandName).contentText((String)errorMessage).show();
                }
                project.syncChanges();
                this.updateProgress(max, max);
                return allAddedEntries;
            }

            private static /* synthetic */ List lambda$call$0(String item, ImageServerBuilder requestedBuilder2, String[] args2) throws Exception {
                try {
                    ImageServerBuilder.UriImageSupport support;
                    URI uri = GeneralTools.toURI((String)item);
                    if (requestedBuilder2 == null) {
                        support = ImageServers.getImageSupport((URI)uri, (String[])args2);
                        if (support == null) {
                            logger.warn("Unable to open {} with any reader", (Object)uri);
                        }
                    } else {
                        support = ImageServers.getImageSupport((ImageServerBuilder)requestedBuilder2, (URI)uri, (String[])args2);
                        if (support == null) {
                            logger.warn("Unable to open {} with {}", (Object)uri, (Object)requestedBuilder2.getName());
                        }
                    }
                    if (support == null) {
                        return Collections.emptyList();
                    }
                    return support.getBuilders();
                }
                catch (Exception e) {
                    logger.error("Unable to add " + item, (Throwable)e);
                    return new ArrayList();
                }
            }
        };
        ProgressDialog progress = new ProgressDialog((Worker)worker);
        progress.setTitle("Project import");
        qupath.getThreadPoolManager().submitShortTask((Runnable)worker);
        progress.showAndWait();
        try {
            project.syncChanges();
        }
        catch (IOException e1) {
            Dialogs.showErrorMessage((String)"Sync project", (Throwable)e1);
            logger.error(e1.getMessage(), (Throwable)e1);
        }
        qupath.refreshProject();
        StringBuilder sb = new StringBuilder();
        if (!pathSucceeded.isEmpty()) {
            sb.append("Successfully imported " + pathSucceeded.size() + " paths:\n");
            for (String path : pathSucceeded) {
                sb.append("\t" + path + "\n");
            }
            sb.append("\n");
            qupath.refreshProject();
            ProjectBrowser.syncProject(qupath.getProject());
        }
        if (!pathFailed.isEmpty()) {
            sb.append("Unable to import " + pathFailed.size() + " paths:\n");
            for (String path : pathFailed) {
                sb.append("\t" + path + "\n");
            }
            sb.append("\n");
            TextArea textArea = new TextArea();
            textArea.setText(sb.toString());
            if (pathSucceeded.isEmpty()) {
                Dialogs.showErrorMessage((String)commandName, (Node)textArea);
            } else {
                Dialogs.showMessageDialog((String)commandName, (Node)textArea);
            }
        }
        if (sb.length() > 0) {
            logger.info(sb.toString());
        }
        List<Object> results = new ArrayList();
        try {
            results = (List)worker.get();
        }
        catch (Exception e2) {
            logger.error("Exception importing project entries", (Throwable)e2);
            results = Collections.emptyList();
        }
        return results;
    }

    public static ProjectImageEntry<BufferedImage> addSingleImageToProject(Project<BufferedImage> project, ImageServer<BufferedImage> server, ImageData.ImageType type) {
        try {
            ProjectImageEntry entry = project.addImage(server.getBuilder());
            ProjectImportImagesCommand.initializeEntry((ProjectImageEntry<BufferedImage>)entry, type, false, false);
            return entry;
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean loadFromFileChooser(List<String> list) {
        List files = FileChoosers.promptForMultipleFiles((String)commandName, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[0]);
        if (files == null) {
            return false;
        }
        boolean changes = false;
        for (File fileNew : files) {
            if (list.contains(fileNew.getAbsolutePath())) {
                Dialogs.showErrorMessage((String)commandName, (String)("List already contains " + fileNew.getName()));
                continue;
            }
            list.add(fileNew.getAbsolutePath());
            changes = true;
        }
        return changes;
    }

    static boolean loadFromSingleURL(List<String> list) {
        String path = FileChoosers.promptForFilePathOrURI((String)"Choose image path", (String)"", (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[0]);
        if (path == null) {
            return false;
        }
        if (list.contains(path)) {
            Dialogs.showErrorMessage((String)commandName, (String)("List already contains " + path));
            return false;
        }
        list.add(path);
        return true;
    }

    static int loadFromTextFile(List<String> list) {
        File file = FileChoosers.promptForFile((String)commandName, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"Text file", (String[])new String[]{"*.txt", "*.csv"})});
        if (file == null) {
            return 0;
        }
        if (file.length() / 1024L / 1024L > 5L) {
            Dialogs.showErrorMessage((String)commandName, (String)String.format("%s is too large (%.2f MB) - \nplease choose a text file containing only file paths or select another import option", file.getName(), (double)file.length() / 1024.0 / 1024.0));
            return 0;
        }
        return ProjectImportImagesCommand.loadFromTextFile(file, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int loadFromTextFile(File file, List<String> list) {
        int changes = 0;
        try (Scanner scanner = null;){
            scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                String s = scanner.nextLine().trim();
                if (ProjectImportImagesCommand.isPossiblePath(s) && !list.contains(s)) {
                    list.add(s);
                    ++changes;
                    continue;
                }
                logger.warn("Cannot find image for path {}", (Object)s.trim());
            }
        }
        return changes;
    }

    static int loadFromClipboard(List<String> list) {
        int changes = 0;
        List clipboardFiles = Clipboard.getSystemClipboard().getFiles();
        if (clipboardFiles != null) {
            for (File f : clipboardFiles) {
                if (!f.isFile() && list.contains(f.getAbsolutePath())) continue;
                list.add(f.getAbsolutePath());
                ++changes;
            }
        }
        if (changes > 0) {
            return changes;
        }
        String clipboardString = Clipboard.getSystemClipboard().getString();
        ArrayList<String> possiblePaths = new ArrayList<String>();
        if (clipboardString != null) {
            for (String s : GeneralTools.splitLines((String)clipboardString)) {
                if (ProjectImportImagesCommand.isPossiblePath(s.trim())) {
                    possiblePaths.add(s.trim());
                    continue;
                }
                logger.warn("Cannot find image for path {}", (Object)s.trim());
            }
        }
        if (possiblePaths.isEmpty()) {
            Dialogs.showErrorMessage((String)commandName, (String)"Could not find any valid paths on the clipboard!");
            return 0;
        }
        possiblePaths.removeAll(list);
        list.addAll(possiblePaths);
        return possiblePaths.size();
    }

    static boolean isPossiblePath(String path) {
        try {
            URI uri = path.toLowerCase().startsWith("http") || path.toLowerCase().startsWith("file") ? GeneralTools.toEncodedURI((String)path) : new File(path).toURI();
            if ("file".equals(uri.getScheme())) {
                if (GeneralTools.toPath((URI)uri).toFile().exists()) {
                    return true;
                }
                logger.warn("File {} does not exist!", (Object)GeneralTools.toPath((URI)uri));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.debug("Exception trying to parse path " + path + ": " + e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    static ProjectImageEntry<BufferedImage> initializeEntry(ProjectImageEntry<BufferedImage> entry, ImageData.ImageType type, boolean pyramidalizeSingleResolution, boolean importObjects) throws Exception {
        try (ImageServer server = entry.getServerBuilder().build();){
            List pathObjects;
            String name = ServerTools.getDisplayableImageName((ImageServer)server);
            entry.setImageName(name);
            ImageServer server2 = server;
            int minPyramidDimension = PathPrefs.minPyramidDimensionProperty().get();
            if (pyramidalizeSingleResolution && server.nResolutions() == 1 && Math.max(server.getWidth(), server.getHeight()) > minPyramidDimension) {
                ImageServer serverTemp = ImageServers.pyramidalize((ImageServer)server, (double[])new double[0]);
                if (serverTemp.nResolutions() > 1) {
                    logger.debug("Auto-generating image pyramid for " + name);
                    server2 = serverTemp;
                } else {
                    serverTemp.close();
                }
            }
            Collection<Object> collection = pathObjects = importObjects && server2 instanceof PathObjectReader ? ((PathObjectReader)server2).readPathObjects() : Collections.emptyList();
            if (type != null || server != server2 || !pathObjects.isEmpty()) {
                ImageData imageData = new ImageData(server2, type);
                if (!pathObjects.isEmpty()) {
                    imageData.getHierarchy().addObjects(pathObjects);
                }
                entry.saveImageData(imageData);
            }
            if (server != server2) {
                server2.close();
            }
        }
        return entry;
    }

    public static BufferedImage getThumbnailRGB(ImageServer<BufferedImage> server, ImageDisplay imageDisplay) throws IOException {
        BufferedImage img2 = (BufferedImage)server.getDefaultThumbnail(server.nZSlices() / 2, 0);
        boolean success = false;
        if (imageDisplay == null && (server.isRGB() || img2.getType() == 10)) {
            return ProjectImportImagesCommand.resizeForThumbnail(img2);
        }
        if (!success) {
            if (imageDisplay == null) {
                WrappedBufferedImageServer wrappedServer = new WrappedBufferedImageServer("Dummy", img2, server.getMetadata().getChannels());
                imageDisplay = ImageDisplay.create((ImageData<BufferedImage>)new ImageData((ImageServer)wrappedServer));
            }
            for (ChannelDisplayInfo info : imageDisplay.selectedChannels()) {
                imageDisplay.autoSetDisplayRange(info);
            }
            img2 = imageDisplay.applyTransforms(img2, null);
            return ProjectImportImagesCommand.resizeForThumbnail(img2);
        }
        return img2;
    }

    static BufferedImage resizeForThumbnail(BufferedImage imgThumbnail) {
        double scale = Math.min((double)thumbnailWidth / (double)imgThumbnail.getWidth(), (double)thumbnailHeight / (double)imgThumbnail.getHeight());
        if (scale > 1.0) {
            return imgThumbnail;
        }
        BufferedImage imgThumbnail2 = new BufferedImage((int)((double)imgThumbnail.getWidth() * scale), (int)((double)imgThumbnail.getHeight() * scale), imgThumbnail.getType());
        Graphics2D g2d = imgThumbnail2.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(imgThumbnail, 0, 0, imgThumbnail2.getWidth(), imgThumbnail2.getHeight(), null);
        g2d.dispose();
        return imgThumbnail2;
    }
}

