/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.stage.FileChooser;
import javax.imageio.ImageIO;
import org.controlsfx.dialog.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.commands.ProjectImportImagesCommand;
import qupath.lib.gui.commands.ProjectMetadataEditorCommand;
import qupath.lib.gui.commands.UpdateUrisCommand;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.io.GsonTools;
import qupath.lib.io.PathIO;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.Projects;

public class ProjectCommands {
    private static final Logger logger = LoggerFactory.getLogger(ProjectCommands.class);

    public static boolean promptToCheckURIs(Project<?> project, boolean onlyIfMissing) throws IOException {
        int n = UpdateUrisCommand.promptToUpdateUris(project.getImageList(), ProjectCommands.getProjectUriPath(project.getPreviousURI()), ProjectCommands.getProjectUriPath(project.getURI()), onlyIfMissing);
        if (n < 0) {
            return false;
        }
        if (n > 0) {
            project.syncChanges();
        }
        return true;
    }

    private static URI getProjectUriPath(URI uri) {
        int ind;
        if (uri == null) {
            return null;
        }
        String path = uri.getPath();
        if (!path.endsWith("/") && (ind = path.lastIndexOf(47)) >= 0) {
            path = path.substring(0, ind + 1);
        }
        try {
            return new URI(uri.getScheme(), uri.getHost(), path, null);
        }
        catch (URISyntaxException e) {
            logger.warn("Exception getting project base URI: {}", (Object)e.getMessage(), (Object)e);
            return uri;
        }
    }

    public static List<ProjectImageEntry<BufferedImage>> promptToImportImages(QuPathGUI qupath, String ... defaultPaths) {
        return ProjectCommands.promptToImportImages(qupath, null, defaultPaths);
    }

    public static List<ProjectImageEntry<BufferedImage>> promptToImportImages(QuPathGUI qupath, ImageServerBuilder<BufferedImage> builder, String ... defaultPaths) {
        return ProjectImportImagesCommand.promptToImportImages(qupath, builder, defaultPaths);
    }

    public static ProjectImageEntry<BufferedImage> addSingleImageToProject(Project<BufferedImage> project, ImageServer<BufferedImage> server, ImageData.ImageType type) {
        return ProjectImportImagesCommand.addSingleImageToProject(project, server, type);
    }

    public static BufferedImage getThumbnailRGB(ImageServer<BufferedImage> server) throws IOException {
        return ProjectImportImagesCommand.getThumbnailRGB(server, null);
    }

    public static void showProjectMetadataEditor(Project<?> project) {
        ProjectMetadataEditorCommand.showProjectMetadataEditor(project);
    }

    public static void promptToExportImageList(Project<?> project) {
        String title = "Export image list";
        if (project == null) {
            GuiTools.showNoProjectError(title);
            return;
        }
        File dirBase = Projects.getBaseDirectory(project);
        File fileOutput = FileChoosers.promptToSaveFile((String)title, (File)dirBase, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"Text files", (String[])new String[]{".txt"})});
        if (fileOutput == null) {
            return;
        }
        TreeSet keys = new TreeSet();
        for (ProjectImageEntry entry : project.getImageList()) {
            keys.addAll(entry.getMetadataKeys());
        }
        String delim = (String)PathPrefs.tableDelimiterProperty().get();
        long startTime = System.currentTimeMillis();
        int n = 0;
        try (PrintWriter writer = new PrintWriter(fileOutput, StandardCharsets.UTF_8);){
            writer.print("Name");
            writer.print(delim);
            writer.print("ID");
            writer.print(delim);
            writer.print("URIs");
            for (String key : keys) {
                writer.print(delim);
                writer.print(key);
            }
            writer.println();
            for (ProjectImageEntry entry : project.getImageList()) {
                try {
                    Collection uris = entry.getURIs();
                    String path = String.join((CharSequence)" ", uris.stream().map(u -> u.toString()).toList());
                    writer.print(entry.getImageName());
                    writer.print(delim);
                    writer.print(entry.getID());
                    writer.print(delim);
                    writer.print(path);
                    for (String key : keys) {
                        writer.print(delim);
                        String value = entry.getMetadataValue(key);
                        if (value == null) continue;
                        writer.print(value);
                    }
                    writer.println();
                    ++n;
                    logger.debug(path);
                }
                catch (IOException e) {
                    logger.error("Error reading URIs from " + String.valueOf(entry), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)title, (String)(fileOutput.getAbsolutePath() + " not found!"));
        }
        long endTime = System.currentTimeMillis();
        logger.debug("Exported {} images in {} ms", (Object)n, (Object)(endTime - startTime));
    }

    public static boolean promptToImportLegacyProject(QuPathGUI qupath) {
        LegacyProject oldProject;
        Project<BufferedImage> project = qupath.getProject();
        String title = "Import legacy project";
        if (project == null) {
            GuiTools.showNoProjectError(title);
            return false;
        }
        File file = FileChoosers.promptForFile((String)title, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"Project (v0.1.2)", (String[])new String[]{"*.qpproj"})});
        if (file == null) {
            return false;
        }
        try (FileReader reader = new FileReader(file);){
            oldProject = (LegacyProject)GsonTools.getInstance().fromJson((Reader)reader, LegacyProject.class);
        }
        catch (IOException e) {
            logger.error("Error reading file: " + e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
        if (oldProject.getEntries().isEmpty()) {
            logger.warn("No images found in project {}", (Object)file.getAbsolutePath());
            return false;
        }
        File dirData = new File(file.getParent(), "data");
        if (!dirData.exists()) {
            Dialogs.showErrorMessage((String)title, (String)"No data directory found for the legacy project!");
            return false;
        }
        LegacyProjectTask task = new LegacyProjectTask(project, oldProject.getEntries(), file.getParentFile());
        int nImages = oldProject.getEntries().size();
        ProgressDialog dialog = new ProgressDialog((Worker)task);
        dialog.setTitle(title);
        if (nImages == 1) {
            dialog.setContentText("Importing 1 image...");
        } else {
            dialog.setContentText("Importing " + nImages + " images...");
        }
        qupath.getThreadPoolManager().submitShortTask((Runnable)((Object)task));
        dialog.showAndWait();
        Integer nCompleted = (Integer)task.getValue();
        if (nCompleted == null) {
            nCompleted = 0;
        }
        if (nCompleted < nImages) {
            Dialogs.showWarningNotification((String)title, (String)(nCompleted + "/" + nImages + " imported successfully"));
        }
        try {
            project.syncChanges();
        }
        catch (Exception e) {
            logger.error("Error syncing project: " + e.getLocalizedMessage(), (Throwable)e);
        }
        qupath.refreshProject();
        return true;
    }

    private static class LegacyProject {
        private List<LegacyProjectEntry> images;

        private LegacyProject() {
        }

        List<LegacyProjectEntry> getEntries() {
            return this.images;
        }
    }

    private static class LegacyProjectTask
    extends Task<Integer> {
        private Project<BufferedImage> project;
        private File dirLegacy;
        private List<LegacyProjectEntry> legacyEntries;

        LegacyProjectTask(Project<BufferedImage> project, List<LegacyProjectEntry> legacyEntries, File dirLegacy) {
            this.project = project;
            this.legacyEntries = legacyEntries;
            this.dirLegacy = dirLegacy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer call() throws Exception {
            File dirThumbnails = new File(this.dirLegacy, "thumbnails");
            File dirData = new File(this.dirLegacy, "data");
            int count = 0;
            int max = this.legacyEntries.size();
            ArrayList<LegacyProjectEntry> failed = new ArrayList<LegacyProjectEntry>();
            for (LegacyProjectEntry oldEntry : this.legacyEntries) {
                try {
                    String name = oldEntry.getName();
                    File fileData = new File(dirData, name + ".qpdata");
                    String[] split = oldEntry.getPath().split("::");
                    String path = split[0];
                    ImageServer server = split.length > 1 ? ImageServerProvider.buildServer((String)path, BufferedImage.class, (String[])new String[]{"--name", split[1]}) : ImageServerProvider.buildServer((String)path, BufferedImage.class, (String[])new String[0]);
                    ProjectImageEntry entry = this.project.addImage(server.getBuilder());
                    entry.setImageName(name);
                    if (fileData.exists()) {
                        logger.debug("Reading image data found for {}", (Object)name);
                        ImageData imageData = PathIO.readImageData((File)fileData, (ImageServer)server);
                        entry.saveImageData(imageData);
                    } else {
                        logger.warn("No image data found for {}", (Object)name);
                    }
                    File fileThumbnail = new File(dirThumbnails, "thumbnails");
                    BufferedImage imgThumbnail = null;
                    if (fileThumbnail.exists()) {
                        imgThumbnail = ImageIO.read(fileThumbnail);
                    }
                    if (imgThumbnail == null) {
                        imgThumbnail = ProjectCommands.getThumbnailRGB((ImageServer<BufferedImage>)server);
                    }
                    entry.setThumbnail((Object)imgThumbnail);
                    ++count;
                }
                catch (Exception e) {
                    failed.add(oldEntry);
                    logger.error("Error adding entry: {}", (Object)e.getLocalizedMessage());
                }
                finally {
                    this.updateProgress(count, max);
                }
            }
            if (!failed.isEmpty()) {
                logger.error("Unable to import the following image(s):\n  {}", (Object)failed.stream().map(LegacyProjectEntry::toString).collect(Collectors.joining("\n  ")));
            }
            return count;
        }
    }

    private class LegacyProjectEntry {
        private String path;
        private String name;

        private LegacyProjectEntry(ProjectCommands projectCommands) {
        }

        String getPath() {
            return this.path;
        }

        String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + " (" + this.path + ")";
        }
    }
}

