/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.animation.Interpolator;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.controlsfx.control.CheckComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.PathObjectImageViewers;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.roi.interfaces.ROI;

public class PathObjectGridView
implements ChangeListener<ImageData<BufferedImage>>,
PathObjectHierarchyListener {
    private static final Logger logger = LoggerFactory.getLogger(PathObjectGridView.class);
    private final QuPathGUI qupath;
    private Stage stage;
    private final StringProperty title = new SimpleStringProperty(QuPathResources.getString("GridView.title"));
    private final QuPathGridView grid = new QuPathGridView();
    private ComboBox<String> comboSortBy;
    private final ObservableList<PathObject> backingList = FXCollections.observableArrayList();
    private final FilteredList<PathObject> filteredList = new FilteredList(this.backingList);
    private final ObservableMeasurementTableData model = new ObservableMeasurementTableData();
    private final ObjectProperty<ImageData<BufferedImage>> imageDataProperty = new SimpleObjectProperty();
    private final StringProperty measurement = new SimpleStringProperty();
    private final BooleanProperty showMeasurement = new SimpleBooleanProperty(true);
    private final BooleanProperty descending = new SimpleBooleanProperty(false);
    private final BooleanProperty doAnimate = new SimpleBooleanProperty(true);
    private final Function<PathObjectHierarchy, Collection<? extends PathObject>> objectExtractor;
    private ObservableList<PathClass> selectedClasses;
    private boolean requestUpdate = false;

    private PathObjectGridView(QuPathGUI qupath, Function<PathObjectHierarchy, Collection<? extends PathObject>> extractor) {
        this.qupath = qupath;
        this.objectExtractor = extractor;
        this.imageDataProperty().bind(qupath.imageDataProperty());
        this.imageDataProperty().addListener((ChangeListener)this);
    }

    public static PathObjectGridView createGridView(QuPathGUI qupath, Function<PathObjectHierarchy, Collection<? extends PathObject>> objectExtractor) {
        return new PathObjectGridView(qupath, objectExtractor);
    }

    public static PathObjectGridView createTmaCoreView(QuPathGUI qupath) {
        PathObjectGridView view = PathObjectGridView.createGridView(qupath, PathObjectGridView::getTmaCores);
        view.title.set((Object)QuPathResources.getString("GridView.TMAGridView"));
        return view;
    }

    public static PathObjectGridView createAnnotationView(QuPathGUI qupath) {
        PathObjectGridView view = PathObjectGridView.createGridView(qupath, PathObjectGridView::getAnnotations);
        view.title.set((Object)QuPathResources.getString("GridView.AnnotationGridView"));
        return view;
    }

    private static List<PathObject> getTmaCores(PathObjectHierarchy hierarchy) {
        TMAGrid grid;
        TMAGrid tMAGrid = grid = hierarchy == null ? null : hierarchy.getTMAGrid();
        if (grid != null) {
            return new ArrayList<PathObject>(grid.getTMACoreList());
        }
        return Collections.emptyList();
    }

    private static List<PathObject> getAnnotations(PathObjectHierarchy hierarchy) {
        if (hierarchy != null) {
            return new ArrayList<PathObject>(hierarchy.getAnnotationObjects());
        }
        return Collections.emptyList();
    }

    public Stage getStage() {
        if (this.stage == null) {
            Screen screen;
            this.initializeGUI();
            Window owner = this.stage.getOwner();
            if (owner != null && (screen = FXUtils.getScreen((Window)owner)) != null) {
                this.stage.setWidth(Math.min(850.0, screen.getVisualBounds().getWidth() * 0.8));
                this.stage.centerOnScreen();
            }
        }
        return this.stage;
    }

    public void show() {
        Stage stage = this.getStage();
        if (!stage.isShowing()) {
            stage.show();
        }
    }

    public void refresh() {
        this.initializeData(this.qupath.getImageData());
    }

    public ObjectProperty<ImageData<BufferedImage>> imageDataProperty() {
        return this.imageDataProperty;
    }

    private static void sortPathObjects(ObservableList<? extends PathObject> cores, ObservableMeasurementTableData model, String measurementName, boolean doDescending) {
        if (measurementName == null) {
            return;
        }
        if (measurementName.equals(QuPathResources.getString("GridView.name"))) {
            GeneralTools.smartStringSort(cores, PathObject::getDisplayedName);
            if (!doDescending) {
                Collections.reverse(cores);
            }
            return;
        }
        Comparator sorter = measurementName.equals(QuPathResources.getString("GridView.classification")) ? (po1, po2) -> {
            Comparator<PathObject> comp = Comparator.comparing(po -> po.getPathClass() == null ? "Unclassified" : po.getPathClass().toString());
            return comp.compare((PathObject)po1, (PathObject)po2);
        } : (po1, po2) -> {
            double m2;
            double m1 = model.getNumericValue((PathObject)po1, measurementName);
            int comp = Double.compare(m1, m2 = model.getNumericValue((PathObject)po2, measurementName));
            if (comp == 0) {
                if (Double.isNaN(m1) && !Double.isNaN(m2)) {
                    return 1;
                }
                if (Double.isNaN(m2) && !Double.isNaN(m1)) {
                    return -1;
                }
                comp = po1.getDisplayedName().compareTo(po2.getDisplayedName());
            }
            return comp;
        };
        if (doDescending) {
            sorter = sorter.reversed();
        }
        cores.sort(sorter);
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        ImageData currentImageData = (ImageData)this.imageDataProperty.get();
        if (currentImageData != null) {
            currentImageData.getHierarchy().removeListener((PathObjectHierarchyListener)this);
            currentImageData = null;
        }
        this.grid.getItems().clear();
        if (imageDataNew != null) {
            imageDataNew.getHierarchy().addListener((PathObjectHierarchyListener)this);
        }
        if (imageDataNew == null || this.stage == null || !this.stage.isShowing()) {
            return;
        }
        Platform.runLater(() -> this.initializeData(imageDataNew));
    }

    private void initializeData(ImageData<BufferedImage> imageData) {
        ArrayList<? extends PathObject> pathObjects;
        ArrayList<? extends PathObject> arrayList = pathObjects = imageData == null ? Collections.emptyList() : new ArrayList<PathObject>(this.objectExtractor.apply(imageData.getHierarchy()));
        if (imageData == null || pathObjects.isEmpty()) {
            this.model.setImageData(null, Collections.emptyList());
            this.grid.getItems().clear();
            return;
        }
        this.model.setImageData(imageData, pathObjects);
        this.backingList.setAll(pathObjects);
        String m = this.measurement.getValue();
        this.sortAndFilter();
        ReadOnlyListWrapper<String> names = this.model.getMeasurementNames();
        if (!(m != null && names.contains((Object)m) || this.comboSortBy.getItems().isEmpty())) {
            this.comboSortBy.getSelectionModel().selectFirst();
        }
    }

    private void initializeGUI() {
        ComboBox comboDisplaySize = new ComboBox();
        comboDisplaySize.getItems().setAll((Object[])GridDisplaySize.values());
        comboDisplaySize.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.grid.imageSize.set(n.getSize()));
        comboDisplaySize.getSelectionModel().select((Object)GridDisplaySize.SMALL);
        ComboBox comboOrder = new ComboBox();
        comboOrder.getItems().setAll((Object[])new String[]{QuPathResources.getString("GridView.ascending"), QuPathResources.getString("GridView.descending")});
        comboOrder.getSelectionModel().select((Object)QuPathResources.getString("GridView.descending"));
        this.descending.bind((ObservableValue)Bindings.createBooleanBinding(() -> QuPathResources.getString("GridView.descending").equals(comboOrder.getSelectionModel().getSelectedItem()), (Observable[])new Observable[]{comboOrder.getSelectionModel().selectedItemProperty()}));
        this.descending.addListener((v, o, n) -> this.sortAndFilter());
        comboOrder.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.sortAndFilter());
        this.comboSortBy = new ComboBox();
        this.comboSortBy.setPlaceholder((Node)PathObjectGridView.createPlaceholderText(QuPathResources.getString("GridView.noMeasurements")));
        this.comboSortBy.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.sortAndFilter());
        ReadOnlyListWrapper<String> measureNames = this.model.getMeasurementNames();
        ObservableList measureList = FXCollections.observableArrayList(measureNames);
        measureNames.addListener(c -> {
            measureList.clear();
            measureList.add((Object)QuPathResources.getString("GridView.classification"));
            measureList.addAll((Collection)measureNames);
        });
        measureList.add((Object)QuPathResources.getString("GridView.classification"));
        measureList.add((Object)QuPathResources.getString("GridView.name"));
        this.comboSortBy.setItems(measureList);
        if (!this.comboSortBy.getItems().isEmpty()) {
            this.comboSortBy.getSelectionModel().select(0);
        }
        this.measurement.bind((ObservableValue)this.comboSortBy.getSelectionModel().selectedItemProperty());
        CheckBox cbShowMeasurement = new CheckBox(QuPathResources.getString("GridView.showValue"));
        this.showMeasurement.bind((ObservableValue)cbShowMeasurement.selectedProperty());
        this.showMeasurement.addListener(c -> this.updateMeasurement());
        CheckBox cbAnimation = new CheckBox(QuPathResources.getString("GridView.animate"));
        cbAnimation.setSelected(this.doAnimate.get());
        this.doAnimate.bindBidirectional((Property)cbAnimation.selectedProperty());
        CheckComboBox classComboBox = new CheckComboBox();
        this.selectedClasses = classComboBox.getCheckModel().getCheckedItems();
        this.selectedClasses.addListener(c -> this.sortAndFilter());
        FXUtils.installSelectAllOrNoneMenu((CheckComboBox)classComboBox);
        classComboBox.getCheckModel().getCheckedItems().addListener(c -> classComboBox.setTitle(PathObjectGridView.getCheckComboBoxText((CheckComboBox<PathClass>)classComboBox)));
        this.updateClasses((CheckComboBox<PathClass>)classComboBox);
        this.qupath.getImageData().getHierarchy().addListener(event -> this.updateClasses((CheckComboBox<PathClass>)classComboBox));
        classComboBox.getCheckModel().checkAll();
        BorderPane pane = new BorderPane();
        ToolBar paneTop = new ToolBar();
        paneTop.getItems().add((Object)new Label(QuPathResources.getString("GridView.sortBy")));
        paneTop.getItems().add(this.comboSortBy);
        paneTop.getItems().add((Object)new Separator(Orientation.VERTICAL));
        paneTop.getItems().add((Object)new Label(QuPathResources.getString("GridView.order")));
        paneTop.getItems().add((Object)comboOrder);
        paneTop.getItems().add((Object)new Separator(Orientation.VERTICAL));
        paneTop.getItems().add((Object)cbShowMeasurement);
        paneTop.getItems().add((Object)new Separator(Orientation.VERTICAL));
        paneTop.getItems().add((Object)new Label(QuPathResources.getString("GridView.size")));
        paneTop.getItems().add((Object)comboDisplaySize);
        paneTop.getItems().add((Object)new Separator(Orientation.VERTICAL));
        paneTop.getItems().add((Object)new Label(QuPathResources.getString("GridView.classes")));
        paneTop.getItems().add((Object)classComboBox);
        paneTop.getItems().add((Object)new Separator(Orientation.VERTICAL));
        paneTop.getItems().add((Object)cbAnimation);
        paneTop.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        for (Node item : paneTop.getItems()) {
            if (!(item instanceof Label)) continue;
            ((Label)item).setMinWidth(Double.NEGATIVE_INFINITY);
        }
        this.comboSortBy.setMaxWidth(Double.MAX_VALUE);
        comboOrder.setMaxWidth(Double.MAX_VALUE);
        pane.setTop((Node)paneTop);
        ScrollPane scrollPane = new ScrollPane((Node)this.grid);
        scrollPane.setFitToWidth(true);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        pane.setCenter((Node)scrollPane);
        Scene scene = new Scene((Parent)pane, 640.0, 480.0);
        this.stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        this.stage.initOwner((Window)this.qupath.getStage());
        this.stage.titleProperty().bindBidirectional((Property)this.title);
        this.stage.setScene(scene);
        this.stage.setOnShowing(e -> this.refresh());
        this.stage.show();
    }

    private void updateClasses(CheckComboBox<PathClass> classComboBox) {
        ArrayList previouslyChecked = new ArrayList(classComboBox.getCheckModel().getCheckedItems());
        List representedClasses = this.qupath.getImageData().getHierarchy().getFlattenedObjectList(null).stream().filter(p -> !p.isRootObject()).map(PathObject::getPathClass).filter(p -> p != null && p != PathClass.NULL_CLASS).distinct().collect(Collectors.toList());
        representedClasses.add(PathClass.NULL_CLASS);
        classComboBox.getItems().clear();
        classComboBox.getItems().addAll(representedClasses);
        classComboBox.getCheckModel().clearChecks();
        int[] inds = previouslyChecked.stream().mapToInt(representedClasses::indexOf).toArray();
        classComboBox.getCheckModel().checkIndices(inds);
    }

    private static String getCheckComboBoxText(CheckComboBox<PathClass> comboBox) {
        int n = comboBox.getCheckModel().getCheckedItems().stream().filter(Objects::nonNull).toList().size();
        if (n == 0) {
            return QuPathResources.getString("GridView.noClassSelected");
        }
        if (n == 1) {
            return ((PathClass)comboBox.getCheckModel().getCheckedItems().getFirst()).toString();
        }
        return String.format(QuPathResources.getString("GridView.nClassSelected"), n);
    }

    private void updateMeasurement() {
        this.sortAndFilter();
    }

    private void sortAndFilter() {
        String m = this.measurement.getValue();
        PathObjectGridView.sortPathObjects(this.backingList, this.model, m, this.descending.get());
        this.filteredList.setPredicate(p -> (m == null || m.equals(QuPathResources.getString("GridView.classification")) || m.equals(QuPathResources.getString("GridView.name")) || !PathObjectGridView.isMissingCore(p)) && (this.selectedClasses.contains((Object)p.getPathClass()) || p.getPathClass() == null && this.selectedClasses.contains((Object)PathClass.NULL_CLASS)));
        Runnable r = () -> this.grid.getItems().setAll(this.filteredList);
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }

    private static boolean isMissingCore(PathObject pathObject) {
        if (pathObject instanceof TMACoreObject) {
            return ((TMACoreObject)pathObject).isMissing();
        }
        return false;
    }

    private void requestUpdate(ImageData<BufferedImage> imageData) {
        this.requestUpdate = true;
        Platform.runLater(() -> this.processUpdateRequest(imageData));
    }

    private void processUpdateRequest(ImageData<BufferedImage> imageData) {
        if (!this.requestUpdate) {
            return;
        }
        Platform.runLater(() -> {
            this.requestUpdate = false;
            this.initializeData(imageData);
        });
    }

    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        ImageData imageData = (ImageData)this.imageDataProperty.get();
        if (!event.isChanging() && imageData != null && imageData.getHierarchy() == event.getHierarchy() && this.stage != null && this.stage.isShowing()) {
            this.requestUpdate((ImageData<BufferedImage>)imageData);
        }
    }

    private static Text createPlaceholderText(String text) {
        return GuiTools.createPlaceholderText(text);
    }

    class QuPathGridView
    extends StackPane {
        private final ObservableList<PathObject> list = FXCollections.observableArrayList();
        private final WeakHashMap<Node, TranslateTransition> translationMap = new WeakHashMap();
        private final WeakHashMap<PathObject, Label> nodeMap = new WeakHashMap();
        private final IntegerProperty imageSize = new SimpleIntegerProperty();
        private final Text textEmpty = PathObjectGridView.createPlaceholderText(QuPathResources.getString("GridView.noObjectsAvailable"));

        QuPathGridView() {
            this.imageSize.addListener(v -> this.updateChildren());
            this.list.addListener(c -> this.updateChildren());
            this.updateChildren();
            StackPane.setAlignment((Node)this.textEmpty, (Pos)Pos.CENTER);
        }

        public ObservableList<PathObject> getItems() {
            return this.list;
        }

        private void updateChildren() {
            if (this.list.isEmpty()) {
                this.getChildren().setAll((Object[])new Node[]{this.textEmpty});
                return;
            }
            ArrayList<Label> images = new ArrayList<Label>();
            for (PathObject pathObject : this.list) {
                Label viewNode = this.nodeMap.computeIfAbsent(pathObject, po -> this.getLabel(pathObject));
                images.add(viewNode);
            }
            this.updateMeasurementText();
            this.getChildren().setAll(images);
        }

        private Label getLabel(PathObject pathObject) {
            PathObjectImageViewers.ItemViewer<PathObject, ImageView> painter = PathObjectImageViewers.createImageViewer(PathObjectGridView.this.qupath.getViewer(), (ImageServer<BufferedImage>)((ImageData)PathObjectGridView.this.imageDataProperty.get()).getServer(), true);
            ImageView imageView = painter.getNode();
            imageView.fitWidthProperty().bind((ObservableValue)this.imageSize);
            imageView.fitHeightProperty().bind((ObservableValue)this.imageSize);
            painter.setItem(pathObject);
            Label out = new Label("", (Node)imageView);
            StackPane.setAlignment((Node)out, (Pos)Pos.TOP_LEFT);
            Tooltip.install((Node)out, (Tooltip)new Tooltip(pathObject.getName()));
            out.setOnMouseClicked(e -> {
                ImageData imageData = (ImageData)PathObjectGridView.this.imageDataProperty.get();
                if (imageData != null) {
                    ROI roi;
                    imageData.getHierarchy().getSelectionModel().setSelectedObject(pathObject);
                    if (e.getClickCount() > 1 && pathObject.hasROI() && (roi = pathObject.getROI()) != null && PathObjectGridView.this.qupath.getViewer().getImageData() == imageData) {
                        PathObjectGridView.this.qupath.getViewer().setCenterPixelLocation(roi.getCentroidX(), roi.getCentroidY());
                    }
                }
            });
            return out;
        }

        void updateMeasurementText() {
            String m = PathObjectGridView.this.measurement == null ? null : (String)PathObjectGridView.this.measurement.get();
            for (Map.Entry<PathObject, Label> entry : this.nodeMap.entrySet()) {
                if (m == null || !PathObjectGridView.this.showMeasurement.get()) {
                    entry.getValue().setText(" ");
                } else if (m.equals(QuPathResources.getString("GridView.classification"))) {
                    PathClass pc = entry.getKey().getPathClass();
                    String text = pc == null ? PathClass.getNullClass().toString() : pc.toString();
                    entry.getValue().setText(text);
                } else if (m.equals(QuPathResources.getString("GridView.name"))) {
                    entry.getValue().setText(entry.getKey().getDisplayedName());
                } else {
                    double val = PathObjectGridView.this.model.getNumericValue(entry.getKey(), m);
                    entry.getValue().setText(GeneralTools.formatNumber((double)val, (int)3));
                }
                entry.getValue().setContentDisplay(ContentDisplay.TOP);
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            if (this.list.isEmpty()) {
                this.setHeight(200.0);
                this.setPrefHeight(200.0);
                return;
            }
            int padding = 5;
            int dxy = this.imageSize.get() + padding;
            int w = Math.max(dxy, (int)this.getWidth());
            int nx = (int)((double)(w / dxy));
            nx = Math.max(1, nx);
            int spaceX = (w - dxy * nx) / nx;
            int x = spaceX / 2;
            int y = padding;
            double h = this.imageSize.get();
            for (Node node : this.getChildren()) {
                if (node instanceof Label) {
                    Label label = (Label)node;
                    h = label.getHeight();
                }
                if (x + dxy > w) {
                    x = spaceX / 2;
                    y += (int)(h + (double)spaceX + 2.0);
                }
                if (PathObjectGridView.this.doAnimate.get()) {
                    TranslateTransition translate = this.translationMap.get(node);
                    boolean doChanges = false;
                    if (translate == null) {
                        translate = new TranslateTransition(Duration.seconds((double)0.25));
                        translate.setNode(node);
                        this.translationMap.put(node, translate);
                        doChanges = true;
                    } else if (!GeneralTools.almostTheSame((double)x, (double)translate.getToX(), (double)0.001) || !GeneralTools.almostTheSame((double)y, (double)translate.getToY(), (double)0.001)) {
                        translate.stop();
                        translate.setDuration(Duration.seconds((double)0.25));
                        doChanges = true;
                    }
                    if (doChanges) {
                        translate.setInterpolator(Interpolator.EASE_BOTH);
                        translate.setFromX(node.getTranslateX());
                        translate.setFromY(node.getTranslateY());
                        translate.setToX((double)x);
                        translate.setToY((double)y);
                        translate.playFromStart();
                    }
                } else {
                    node.setTranslateX((double)x);
                    node.setTranslateY((double)y);
                }
                x += dxy + spaceX;
            }
            this.setHeight((double)y + h + (double)padding);
            this.setPrefHeight((double)y + h + (double)padding);
        }
    }

    public static enum GridDisplaySize {
        TINY("Tiny", 60),
        SMALL("Small", 100),
        MEDIUM("Medium", 200),
        LARGE("Large", 300);

        private final String name;
        private final int size;

        private GridDisplaySize(String name, int size) {
            this.name = name;
            this.size = size;
        }

        public String toString() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }
    }
}

