/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.ColorTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.images.stores.AbstractImageRenderer;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.regions.ImageRegion;

public class MiniViewers {
    private static final Logger logger = LoggerFactory.getLogger(MiniViewers.class);
    private static BooleanProperty showAllChannels = PathPrefs.createPersistentPreference("channelViewerAllChannels", false);
    private static ObservableStringValue style = Bindings.createStringBinding(() -> {
        int rgb = PathPrefs.viewerBackgroundColorProperty().get();
        return String.format("-fx-background-color: rgb(%d, %d, %d)", ColorTools.red((int)rgb), ColorTools.green((int)rgb), ColorTools.blue((int)rgb));
    }, (Observable[])new Observable[]{PathPrefs.viewerBackgroundColorProperty()});

    static Stage createDialog(final QuPathViewer viewer, boolean channelViewer) {
        if (channelViewer) {
            logger.debug("Creating channel viewer for {}", (Object)viewer);
        } else {
            logger.debug("Creating mini viewer for {}", (Object)viewer);
        }
        Stage dialog = new Stage();
        dialog.initOwner(viewer.getView().getScene().getWindow());
        FXUtils.addCloseWindowShortcuts((Stage)dialog);
        List<ChannelDisplayInfo> channels = MiniViewers.getChannels(viewer.getImageDisplay());
        final MiniViewerManager manager = MiniViewers.createManager(viewer, channelViewer ? channels : Collections.emptyList());
        manager.getPane().styleProperty().bind((ObservableValue)style);
        if (channelViewer) {
            dialog.setTitle("Channel viewer");
            final Scene scene = new Scene((Parent)manager.getPane(), 400.0, 400.0);
            ObservableList<ChannelDisplayInfo> allChannels = viewer.getImageDisplay().availableChannels();
            ObservableList<ChannelDisplayInfo> selectedChannels = viewer.getImageDisplay().selectedChannels();
            ListChangeListener<ChannelDisplayInfo> listChangeListener = new ListChangeListener<ChannelDisplayInfo>(){

                public void onChanged(ListChangeListener.Change<? extends ChannelDisplayInfo> c) {
                    MiniViewers.updateChannels(viewer, manager, scene);
                }
            };
            allChannels.addListener((ListChangeListener)listChangeListener);
            selectedChannels.addListener((ListChangeListener)listChangeListener);
            ChangeListener showAllListener = (v, o, n) -> MiniViewers.updateChannels(viewer, manager, scene);
            showAllChannels.addListener(showAllListener);
            dialog.setOnHiding(arg_0 -> MiniViewers.lambda$createDialog$2(allChannels, (ListChangeListener)listChangeListener, selectedChannels, showAllListener, manager, arg_0));
            dialog.setScene(scene);
        } else {
            dialog.setTitle("Mini viewer");
            Scene scene = new Scene((Parent)manager.getPane(), 400.0, 400.0);
            dialog.setScene(scene);
            dialog.setOnHiding(e -> {
                manager.close();
                manager.getPane().styleProperty().unbind();
            });
        }
        MiniViewers.createPopup(manager, channelViewer);
        return dialog;
    }

    private static void updateChannels(QuPathViewer viewer, MiniViewerManager manager, Scene scene) {
        List<ChannelDisplayInfo> newChannels = MiniViewers.getChannels(viewer.getImageDisplay());
        if (newChannels.equals(manager.channels)) {
            return;
        }
        manager.setChannels(newChannels);
        scene.setRoot((Parent)manager.getPane());
    }

    private static boolean isColorDeconvolutionChannel(ChannelDisplayInfo c) {
        ColorTransformer.ColorTransformMethod method = c.getMethod();
        if (method == null) {
            return false;
        }
        switch (method) {
            case Stain_1: 
            case Stain_2: 
            case Stain_3: 
            case Optical_density_sum: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRGBChannel(ChannelDisplayInfo c) {
        ColorTransformer.ColorTransformMethod method = c.getMethod();
        if (method == null) {
            return false;
        }
        switch (method) {
            case Red: 
            case Green: 
            case Blue: {
                return true;
            }
        }
        return false;
    }

    private static List<ChannelDisplayInfo> getChannels(ImageDisplay display) {
        return MiniViewers.getChannels(display, showAllChannels.get());
    }

    private static List<ChannelDisplayInfo> getChannels(ImageDisplay display, boolean allChannels) {
        ImageData<BufferedImage> imageData;
        ImageData<BufferedImage> imageData2 = imageData = display == null ? null : display.getImageData();
        if (allChannels || imageData == null) {
            return display.availableChannels();
        }
        if (imageData.getServer().isRGB()) {
            if (imageData.getColorDeconvolutionStains() != null) {
                return display.availableChannels().stream().filter(MiniViewers::isColorDeconvolutionChannel).toList();
            }
            return display.availableChannels().stream().filter(MiniViewers::isRGBChannel).toList();
        }
        HashSet<ChannelDisplayInfo> selected = new HashSet<ChannelDisplayInfo>((Collection<ChannelDisplayInfo>)display.selectedChannels());
        return display.availableChannels().stream().filter(c -> selected.contains(c)).toList();
    }

    static ContextMenu createPopup(MiniViewerManager manager, boolean isChannelViewer) {
        List<RadioMenuItem> radioItems = Arrays.asList(ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("400 %", manager.downsample, 0.25)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("200 %", manager.downsample, 0.5)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("100 %", manager.downsample, 1.0)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("50 %", manager.downsample, 2.0)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("25 %", manager.downsample, 4.0)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("20 %", manager.downsample, 5.0)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("10 %", manager.downsample, 10.0)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("5 %", manager.downsample, 20.0)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("2 %", manager.downsample, 50.0)), ActionUtils.createRadioMenuItem((Action)MiniViewers.createDownsampleAction("1 %", manager.downsample, 100.0)));
        ToggleGroup group = new ToggleGroup();
        for (RadioMenuItem item : radioItems) {
            item.setToggleGroup(group);
        }
        Menu menuZoom = new Menu("Zoom...");
        menuZoom.getItems().addAll(radioItems);
        ContextMenu popup = new ContextMenu();
        if (isChannelViewer) {
            popup.getItems().add((Object)ActionUtils.createCheckMenuItem((Action)ActionTools.createSelectableAction((ObservableValue<Boolean>)showAllChannels, "Show all channels")));
        }
        popup.getItems().addAll((Object[])new MenuItem[]{ActionUtils.createCheckMenuItem((Action)ActionTools.createSelectableAction((ObservableValue<Boolean>)manager.synchronizeToMainViewer, "Synchronize to main viewer")), menuZoom, new SeparatorMenuItem(), ActionUtils.createCheckMenuItem((Action)ActionTools.createSelectableAction((ObservableValue<Boolean>)manager.showCursor, "Show cursor")), ActionUtils.createCheckMenuItem((Action)ActionTools.createSelectableAction((ObservableValue<Boolean>)manager.showChannelNames, "Show channel names")), ActionUtils.createCheckMenuItem((Action)ActionTools.createSelectableAction((ObservableValue<Boolean>)manager.showOverlays, "Show overlays"))});
        group.selectToggle((Toggle)radioItems.get(2));
        GridPane pane = manager.getPane();
        pane.setOnContextMenuRequested(arg_0 -> MiniViewers.lambda$createPopup$5(popup, (Pane)pane, arg_0));
        return popup;
    }

    static Action createDownsampleAction(String text, DoubleProperty downsampleValue, double downsample) {
        return new Action(text, e -> downsampleValue.set(downsample));
    }

    public static MiniViewerManager createManager(QuPathViewer viewer) {
        return new MiniViewerManager(viewer, Collections.emptyList());
    }

    public static MiniViewerManager createManager(QuPathViewer viewer, Collection<? extends ChannelDisplayInfo> channels) {
        return new MiniViewerManager(viewer, channels);
    }

    private static /* synthetic */ void lambda$createPopup$5(ContextMenu popup, Pane pane, ContextMenuEvent e) {
        popup.show((Node)pane, e.getScreenX(), e.getScreenY());
    }

    private static /* synthetic */ void lambda$createDialog$2(ObservableList allChannels, ListChangeListener listChangeListener, ObservableList selectedChannels, ChangeListener showAllListener, MiniViewerManager manager, WindowEvent e) {
        allChannels.removeListener(listChangeListener);
        selectedChannels.removeListener(listChangeListener);
        showAllChannels.removeListener(showAllListener);
        manager.close();
        manager.getPane().styleProperty().unbind();
    }

    public static class MiniViewerManager
    implements EventHandler<MouseEvent> {
        private GridPane pane = new GridPane();
        private List<MiniViewer> miniViewers = new ArrayList<MiniViewer>();
        private BooleanProperty showChannelNames = new SimpleBooleanProperty(true);
        private BooleanProperty showCursor = new SimpleBooleanProperty(true);
        private BooleanProperty showOverlays = new SimpleBooleanProperty(true);
        private BooleanProperty synchronizeToMainViewer = new SimpleBooleanProperty(true);
        private BooleanProperty shiftDown = new SimpleBooleanProperty(false);
        private DoubleProperty downsample = new SimpleDoubleProperty(1.0);
        private boolean requestUpdate = false;
        private QuPathViewer mainViewer;
        private List<ChannelDisplayInfo> channels = new ArrayList<ChannelDisplayInfo>();
        private Point2D centerPosition = new Point2D.Double();
        private Point2D mousePosition;
        private ExecutorService pool = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"mini-viewer", (boolean)true));
        private ChangeListener<Number> changeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                pool.submit(() -> this.requestFullUpdate());
            }
        };
        private ChangeListener<Number> fastChangeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                pool.submit(() -> this.requestUpdate());
            }
        };
        private InvalidationListener invalidationListener = new InvalidationListener(){

            public void invalidated(Observable observable) {
                pool.submit(() -> this.requestUpdate());
            }
        };

        @Deprecated
        public MiniViewerManager(QuPathViewer mainViewer, Collection<? extends ChannelDisplayInfo> channels) {
            this.mainViewer = mainViewer;
            this.setChannels(channels);
            mainViewer.zPositionProperty().addListener(this.changeListener);
            mainViewer.tPositionProperty().addListener(this.changeListener);
            mainViewer.repaintTimestamp().addListener(this.fastChangeListener);
            mainViewer.getImageDisplay().eventCountProperty().addListener(this.changeListener);
            this.showCursor.addListener(this.invalidationListener);
            this.showOverlays.addListener(this.invalidationListener);
            this.showChannelNames.addListener(this.invalidationListener);
            this.synchronizeToMainViewer.addListener(this.invalidationListener);
            this.downsample.addListener(this.invalidationListener);
            mainViewer.getView().addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)this);
            this.requestFullUpdate();
        }

        void close() {
            this.mainViewer.zPositionProperty().removeListener(this.changeListener);
            this.mainViewer.tPositionProperty().removeListener(this.changeListener);
            this.mainViewer.repaintTimestamp().removeListener(this.fastChangeListener);
            this.mainViewer.getImageDisplay().eventCountProperty().removeListener(this.changeListener);
            this.showCursor.removeListener(this.invalidationListener);
            this.showOverlays.removeListener(this.invalidationListener);
            this.showChannelNames.removeListener(this.invalidationListener);
            this.synchronizeToMainViewer.removeListener(this.invalidationListener);
            this.downsample.removeListener(this.invalidationListener);
            this.mainViewer.getView().removeEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)this);
        }

        void setChannels(Collection<? extends ChannelDisplayInfo> channels) {
            ObservableList colConstraints;
            this.miniViewers.stream().forEach(v -> v.close());
            this.miniViewers.clear();
            int nChannels = channels.size();
            int nCols = (int)Math.ceil(Math.sqrt(nChannels + 1));
            int nRows = (int)Math.ceil((double)(nChannels + 1) / (double)nCols);
            this.channels.clear();
            this.channels.addAll(channels);
            ArrayList<Pane> nodes = new ArrayList<Pane>();
            for (int c = 0; c < nChannels; ++c) {
                MiniViewer canvas = new MiniViewer(new ImageDisplaySingleChannelRenderer(c));
                this.miniViewers.add(canvas);
                nodes.add(this.createPane(canvas, c % nCols, c / nCols, 1, 1));
            }
            MiniViewer mainCanvas = new MiniViewer(this.mainViewer.getImageDisplay());
            this.miniViewers.add(mainCanvas);
            nodes.add(this.createPane(mainCanvas, nChannels % nCols, nChannels / nCols, nRows * nCols - nChannels, 1));
            this.pane.setVgap(5.0);
            this.pane.setHgap(5.0);
            ObservableList rowConstraints = this.pane.getRowConstraints();
            if (rowConstraints.size() != nRows) {
                rowConstraints.clear();
                for (int r = 0; r < nRows; ++r) {
                    RowConstraints rc = new RowConstraints();
                    rc.setPercentHeight(100.0 / (double)nRows);
                    rowConstraints.add((Object)rc);
                }
            }
            if ((colConstraints = this.pane.getColumnConstraints()).size() != nCols) {
                colConstraints.clear();
                for (int c = 0; c < nCols; ++c) {
                    ColumnConstraints cc = new ColumnConstraints();
                    cc.setPrefWidth(100.0 / (double)nCols);
                    colConstraints.add((Object)cc);
                }
            }
            this.pane.getChildren().setAll(nodes);
        }

        Pane createPane(MiniViewer canvas, int col, int row, int colSpan, int rowSpan) {
            AnchorPane tempPane = new AnchorPane();
            tempPane.setMinSize(0.0, 0.0);
            tempPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            tempPane.getChildren().add((Object)canvas);
            canvas.widthProperty().bind((ObservableValue)tempPane.widthProperty());
            canvas.heightProperty().bind((ObservableValue)tempPane.heightProperty());
            GridPane.setConstraints((Node)tempPane, (int)col, (int)row, (int)colSpan, (int)rowSpan, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
            GridPane.setFillHeight((Node)tempPane, (Boolean)Boolean.TRUE);
            GridPane.setFillWidth((Node)tempPane, (Boolean)Boolean.TRUE);
            Label label = new Label();
            label.textProperty().bind((ObservableValue)canvas.nameBinding);
            label.setStyle("-fx-background-color: rgba(0, 0, 0, 0.6)");
            label.setTextFill((Paint)Color.WHITE);
            label.setAlignment(Pos.CENTER);
            double height = 50.0;
            label.setPrefHeight(height);
            label.setMinWidth(0.0);
            label.setMaxWidth(Double.MAX_VALUE);
            AnchorPane.setBottomAnchor((Node)label, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)label, (Double)0.0);
            AnchorPane.setRightAnchor((Node)label, (Double)0.0);
            label.prefWidthProperty().bind((ObservableValue)this.pane.prefWidthProperty());
            label.visibleProperty().bind((ObservableValue)canvas.heightProperty().greaterThan(height * 1.2).and((ObservableBooleanValue)label.textProperty().isNotEmpty()).and((ObservableBooleanValue)this.showChannelNames));
            tempPane.getChildren().add((Object)label);
            Tooltip tooltip = new Tooltip();
            tooltip.textProperty().bind((ObservableValue)canvas.nameBinding);
            Tooltip.install((Node)canvas, (Tooltip)tooltip);
            return tempPane;
        }

        public double getDownsample() {
            return this.downsample.get();
        }

        public void setDownsample(double downsample) {
            this.downsample.set(downsample);
        }

        public GridPane getPane() {
            return this.pane;
        }

        void requestFullUpdate() {
            for (MiniViewer viewer : this.miniViewers) {
                if (Thread.interrupted()) {
                    return;
                }
                viewer.updateThumbnail();
            }
            this.requestUpdate();
        }

        void requestUpdate() {
            if (this.requestUpdate) {
                return;
            }
            this.requestUpdate = true;
            Platform.runLater(() -> this.updateViewers());
        }

        void updateViewers() {
            if (!this.requestUpdate) {
                return;
            }
            if (this.pane != null && this.pane.isVisible()) {
                this.mousePosition = this.mainViewer.getMousePosition();
                if (this.mousePosition != null) {
                    this.mainViewer.componentPointToImagePoint(this.mousePosition, this.mousePosition, false);
                    if (this.synchronizeToMainViewer.get() && !this.shiftDown.get()) {
                        this.centerPosition.setLocation(this.mousePosition);
                    }
                }
                for (MiniViewer viewer : this.miniViewers) {
                    viewer.repaint();
                }
            }
            this.requestUpdate = false;
        }

        public void handle(MouseEvent event) {
            this.shiftDown.set(event.isShiftDown());
            this.requestUpdate();
        }

        class MiniViewer
        extends Canvas {
            private ImageRenderer renderer;
            private StringProperty nameBinding = new SimpleStringProperty();
            private BufferedImage imgRGB;
            private BufferedImage img;
            private WritableImage imgFX;
            private Point2D localCursorPosition = null;
            private AffineTransform transform = new AffineTransform();

            public MiniViewer(ImageRenderer renderer) {
                this.renderer = renderer;
                this.widthProperty().addListener(v -> MiniViewerManager.this.requestUpdate());
                this.heightProperty().addListener(v -> MiniViewerManager.this.requestUpdate());
                this.nameBinding.bind((ObservableValue)Bindings.createStringBinding(() -> {
                    if (renderer instanceof ImageDisplaySingleChannelRenderer) {
                        ImageDisplaySingleChannelRenderer channelRenderer = (ImageDisplaySingleChannelRenderer)renderer;
                        int channel = channelRenderer.channel;
                        if (channel < 0 || channel >= MiniViewerManager.this.channels.size()) {
                            return null;
                        }
                        return MiniViewerManager.this.channels.get(channel).getName();
                    }
                    return null;
                }, (Observable[])new Observable[]{MiniViewerManager.this.mainViewer.imageDataProperty(), MiniViewerManager.this.mainViewer.getImageDisplay().eventCountProperty()}));
            }

            void close() {
                this.nameBinding.unbind();
                this.imgRGB = null;
                this.img = null;
                this.imgFX = null;
            }

            public boolean isResizable() {
                return true;
            }

            public double prefHeight(double height) {
                return height;
            }

            public double prefWidth(double width) {
                return width;
            }

            double getDownsampleFactor() {
                return MiniViewerManager.this.downsample.get();
            }

            void updateThumbnail() {
                BufferedImage imgThumbnail;
                this.imgRGB = this.renderer == null ? MiniViewerManager.this.mainViewer.getRGBThumbnail() : ((imgThumbnail = MiniViewerManager.this.mainViewer.getThumbnail()) == null ? null : this.renderer.applyTransforms(MiniViewerManager.this.mainViewer.getThumbnail(), this.imgRGB));
            }

            void repaint() {
                int w = (int)Math.ceil(this.getWidth());
                int h = (int)Math.ceil(this.getHeight());
                if (w <= 0 || h <= 0) {
                    return;
                }
                if (this.img == null || this.img.getWidth() != w || this.img.getHeight() != h) {
                    this.img = new BufferedImage(w, h, 2);
                }
                Graphics2D g2d = this.img.createGraphics();
                g2d.setColor(ColorToolsAwt.getCachedColor((Integer)PathPrefs.viewerBackgroundColorProperty().get()));
                g2d.fillRect(0, 0, w, h);
                g2d.setClip(0, 0, w, h);
                this.transform.setToIdentity();
                this.transform.translate(this.getWidth() * 0.5, this.getHeight() * 0.5);
                double downsample = this.getDownsampleFactor();
                this.transform.scale(1.0 / downsample, 1.0 / downsample);
                this.transform.translate(-MiniViewerManager.this.centerPosition.getX(), -MiniViewerManager.this.centerPosition.getY());
                double rotation = MiniViewerManager.this.mainViewer.getRotation();
                if (rotation != 0.0) {
                    this.transform.rotate(rotation, MiniViewerManager.this.centerPosition.getX(), MiniViewerManager.this.centerPosition.getY());
                }
                g2d.transform(this.transform);
                this.localCursorPosition = MiniViewerManager.this.mousePosition == null ? null : this.transform.transform(MiniViewerManager.this.mousePosition, this.localCursorPosition);
                MiniViewerManager.this.mainViewer.getImageRegionStore().paintRegion(MiniViewerManager.this.mainViewer.getServer(), g2d, g2d.getClip(), MiniViewerManager.this.mainViewer.getZPosition(), MiniViewerManager.this.mainViewer.getTPosition(), downsample, MiniViewerManager.this.mainViewer.getThumbnail(), null, this.renderer);
                LookupOp gammaOp = MiniViewerManager.this.mainViewer.getGammaOp();
                if (gammaOp != null) {
                    gammaOp.filter(this.img.getRaster(), this.img.getRaster());
                }
                float opacity = MiniViewerManager.this.mainViewer.getOverlayOptions().getOpacity();
                if (MiniViewerManager.this.showOverlays.get() && opacity > 0.0f) {
                    if (opacity < 1.0f) {
                        g2d.setComposite(AlphaComposite.getInstance(3, opacity));
                    }
                    ImageRegion region = AwtTools.getImageRegion((Rectangle)g2d.getClipBounds(), (int)MiniViewerManager.this.mainViewer.getZPosition(), (int)MiniViewerManager.this.mainViewer.getTPosition());
                    MiniViewerManager.this.mainViewer.getOverlayLayers().stream().forEach(o -> o.paintOverlay(g2d, region, downsample, MiniViewerManager.this.mainViewer.getImageData(), false));
                }
                g2d.dispose();
                this.imgFX = this.imgFX == null || (double)this.img.getWidth() != this.imgFX.getWidth() || (double)this.img.getHeight() != this.imgFX.getHeight() ? SwingFXUtils.toFXImage((BufferedImage)this.img, null) : SwingFXUtils.toFXImage((BufferedImage)this.img, (WritableImage)this.imgFX);
                this.blitter((Image)this.imgFX);
            }

            void blitter(Image imgFX) {
                if (!Platform.isFxApplicationThread()) {
                    Platform.runLater(() -> this.blitter(imgFX));
                    return;
                }
                GraphicsContext context = this.getGraphicsContext2D();
                context.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
                if (imgFX != null) {
                    context.drawImage(imgFX, 0.0, 0.0);
                }
                if (MiniViewerManager.this.showCursor.get() && this.localCursorPosition != null) {
                    context.setLineWidth(4.0);
                    context.setStroke((Paint)Color.BLACK);
                    double len = 4.0;
                    double x = this.localCursorPosition.getX();
                    double y = this.localCursorPosition.getY();
                    context.strokeLine(x, y - len, x, y + len);
                    context.strokeLine(x - len, y, x + len, y);
                    context.setLineWidth(2.0);
                    context.setStroke((Paint)Color.WHITE);
                    context.strokeLine(x, y - len, x, y + len);
                    context.strokeLine(x - len, y, x + len, y);
                }
            }
        }

        class ImageDisplaySingleChannelRenderer
        extends AbstractImageRenderer {
            private final int channel;

            ImageDisplaySingleChannelRenderer(int channel) {
                this.channel = channel;
            }

            @Override
            public long getLastChangeTimestamp() {
                return MiniViewerManager.this.mainViewer.getImageDisplay().getLastChangeTimestamp();
            }

            @Override
            public BufferedImage applyTransforms(BufferedImage imgInput, BufferedImage imgOutput) {
                ImageDisplay imageDisplay = MiniViewerManager.this.mainViewer.getImageDisplay();
                if (this.channel >= 0 && this.channel < MiniViewerManager.this.channels.size()) {
                    return ImageDisplay.applyTransforms(imgInput, imgOutput, Collections.singletonList(MiniViewerManager.this.channels.get(this.channel)), (ChannelDisplayMode)((Object)imageDisplay.displayMode().getValue()));
                }
                return imageDisplay.applyTransforms(imgInput, imgOutput);
            }
        }
    }
}

